/* serverlib.h
 *
 * Copyright (c) 1999 Scott Manley
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License  
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>   
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>



/* blocking/non blocking flags */

#define S_DELAY 0
#define S_NDELAY 1

#define S_RESET 0
#define S_SET 1
#define S_NAMLEN 256


/* socket data structure */
typedef struct{
	struct sockaddr_in sin;
	int sinlen;
	int bindflag;
	int sd;
} sckt;

/* finally all the functions we support */

int sserver(sckt *sp, int port, int sync);
int sclient(sckt *sp, char *name, int port);
sckt *sopen(void);
int sclose(sckt *sp);

