   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*             CLIPS Version 6.20  01/31/02            */
   /*                                                     */
   /*       DEFTEMPLATE BASIC COMMANDS HEADER FILE        */
   /*******************************************************/

/*************************************************************/
/* Purpose: Implements core commands for the deftemplate     */
/*   construct such as clear, reset, save, undeftemplate,    */
/*   ppdeftemplate, list-deftemplates, and                   */
/*   get-deftemplate-list.                                   */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*      Brian L. Donnell                                     */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/

#ifndef _H_tmpltbsc
#define _H_tmpltbsc

#ifndef _H_evaluatn
#include "evaluatn.h"
#endif

#ifdef LOCALE
#undef LOCALE
#endif

#ifdef _TMPLTBSC_SOURCE_
#define LOCALE
#else
#define LOCALE extern
#endif

#if ENVIRONMENT_API_ONLY
#define GetDeftemplateList(theEnv,a,b) EnvGetDeftemplateList(theEnv,a,b)
#define ListDeftemplates(theEnv,a,b) EnvListDeftemplates(theEnv,a,b)
#define Undeftemplate(theEnv,a) EnvUndeftemplate(theEnv,a)
#define GetDeftemplateWatch(theEnv,a) EnvGetDeftemplateWatch(theEnv,a)
#define SetDeftemplateWatch(theEnv,a,b) EnvSetDeftemplateWatch(theEnv,a,b)
#else
#define GetDeftemplateList(a,b) EnvGetDeftemplateList(GetCurrentEnvironment(),a,b)
#define ListDeftemplates(a,b) EnvListDeftemplates(GetCurrentEnvironment(),a,b)
#define Undeftemplate(a) EnvUndeftemplate(GetCurrentEnvironment(),a)
#define GetDeftemplateWatch(a) EnvGetDeftemplateWatch(GetCurrentEnvironment(),a)
#define SetDeftemplateWatch(a,b) EnvSetDeftemplateWatch(GetCurrentEnvironment(),a,b)
#endif

   LOCALE void                           DeftemplateBasicCommands(void *);
   LOCALE void                           UndeftemplateCommand(void *);
   LOCALE BOOLEAN                        EnvUndeftemplate(void *,void *);
   LOCALE void                           GetDeftemplateListFunction(void *,DATA_OBJECT_PTR);
   LOCALE void                           EnvGetDeftemplateList(void *,DATA_OBJECT_PTR,void *);
   LOCALE SYMBOL_HN                     *DeftemplateModuleFunction(void *);
#if DEBUGGING_FUNCTIONS
   LOCALE void                           PPDeftemplateCommand(void *);
   LOCALE int                            PPDeftemplate(void *,char *,char *);
   LOCALE void                           ListDeftemplatesCommand(void *);
   LOCALE void                           EnvListDeftemplates(void *,char *,void *);
   LOCALE unsigned                       EnvGetDeftemplateWatch(void *,void *);
   LOCALE void                           EnvSetDeftemplateWatch(void *,unsigned,void *);
   LOCALE unsigned                       DeftemplateWatchAccess(void *,int,unsigned,struct expr *);
   LOCALE unsigned                       DeftemplateWatchPrint(void *,char *,int,struct expr *);
#endif

#endif


