/* $Id: netwatch.h,v 1.4 2000/02/20 21:45:35 bergo Exp $ */

#ifndef NETWATCH_H
#define NETWATCH_H

#include <netinet/in.h>
#include "netpolling.h"

#define RGPSP_PORT   "24374"

#define WARN_INCLUDE_SELF "You have included the local machine as a NetWatch'ed\n"\
                          "host. This is not a good idea, you'll get doubled\n"\
			  "process entries and gPS may act strangely on these\n"\
			  "processes. Your machine may also become slow by polling\n"\
			  "itself."

#define INFO_NONE_REMOTE  "There are no remote hosts configured to be polled via\n"\
			  "Network Watch, and thus there is no connection to be\n"\
			  "restarted. To setup the Network Watch feature use the\n"\
			  "\"Network | Network watch...\" command."

#define ASK_CLEAR_HISTORY "To apply the changes (if any) it is needed to reset\n"\
			  "the CPU and memory histories, currently open. Do you\n"\
			  "want to apply the changes and reset the histories ?"

#define ASK_CLEAR_HISTORY2 "To restart the network connections it is needed to reset\n"\
			   "the CPU and memory histories, currently open. Do you\n"\
			   "want to apply the changes and reset the histories ?"

void netwatch_init();
void netwatch_update();
void netwatch_destroy();

void netwatch_config(GtkWidget * widget,gpointer data);
void netwatch_restart(GtkWidget *widget,gpointer data);

void netwatch_add_host(GtkWidget *widget, gpointer data);

void netwatch_select(GtkWidget *widget,gint row,gint column,
		     GdkEventButton *event,gpointer data);
void netwatch_deselect(GtkWidget *widget,gint row,gint column,
		       GdkEventButton *event,gpointer data);
void update_netwatch_hostlist();

/* button handlers */
void ok_netwatch(GtkWidget *wid,gpointer data);
void cancel_netwatch(GtkWidget *wid,gpointer data);
void help_netwatch(GtkWidget *wid, gpointer data);

void toggle_netwatch(GtkWidget *wid,gpointer data);
void enable_all_netwatch(GtkWidget *wid,gpointer data);
void disable_all_netwatch(GtkWidget *wid,gpointer data);
void remove_all_netwatch(GtkWidget *wid,gpointer data);
void remove_netwatch(GtkWidget *wid,gpointer data);

void netwatch_addhost_ok(GtkWidget *widget,gpointer data);
void netwatch_addhost_cancel(GtkWidget *widget,gpointer data);

void netwatch_help_dismiss(GtkWidget *widget,gpointer data);

/// an entry in the netwatch host list
class WatchedHost {
 public:

  /// constructor, creates a null-filled item
  WatchedHost();

  /// constructor, creates an item with host hn, given port and enable en
  WatchedHost(char *hn,int port,int en);

  /// constructor, reads an entry from a file (in gPS, ~/.gpsrc)
  WatchedHost(FILE *f);

  /// writes this object info into a file.
  void write(FILE *f);

  /// copies this object into c.
  void copy(WatchedHost *c);

  /// the hostname in a way gethostbyname() can understand.
  char hostname[128];

  /// the tcp port. default is 24374.
  int  tcpport;

  /// the attached poller, if any
  NetworkListPoller *attached_poller;

  /// positive if enabled, 0 otherwise.
  int enable;
};

#define PRE_NETWATCHHELP \
   "The Network Watch feature allows gPS to poll process information\n"\
   "from computers networked with the one gPS is running on. You must\n"\
   "have shell access to the machines you want to watch remotely and\n"\
   "run a gPS poller locally on each watched computer\n \n"\
   "These pollers should be accessible as rgpsp, which will usually\n"\
   "be a symbolic link to the real poller (which depends on each\n"\
   "computer's architecture and operating system). The pollers are\n"\
   "included with gPS and also distributed separatedly for each\n"\
   "platform.\n \n"\
   "The rgpsp man page contains information on running and configuring\n"\
   "a poller. For further information read the file\n \n    "

#define MID_NETWATCHHELP "/gps-"

#define POS_NETWATCHHELP "/README.NetWatch\n \n"

#endif
