/* $Id: PolyBarriers.cpp,v 1.7 2005/04/05 11:32:54 ellson Exp $ $Revision: 1.7 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include <assert.h>
#include "PathPlan.h"

void PathPlan::PolyBarriers(const LineV &polygons, SegmentV &out) {
	unsigned n = 0,i;
	for(i = 0; i < polygons.size(); i++)
		n += polygons[i].size();

	out.reserve(n);
	for(i = 0; i < polygons.size(); i++) {
		const Line &pp = polygons[i];
		for(unsigned j = 0; j < pp.size(); j++) {
			int k = (j + 1)%pp.size();
			out.push_back(Segment(pp[j],pp[k]));
		}
	}
	assert(out.size() == n);
}
