/* $Id: SetYs.cpp,v 1.6 2005/04/05 11:32:55 ellson Exp $ $Revision: 1.6 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "dynadag/DynaDAG.h"

namespace DynaDAG {

void Config::resetRankBox(Rank *rank) {
#ifdef FLEXIRANKS
	Ranks::index r = ranking.y2r(rank->yBase);
	Ranks::iterator i = ranking.GetIter(r);
	rank->deltaAbove = 0;
	if(i!=ranking.begin())
		rank->deltaAbove = ((*--i)->yBase-rank->yBase)/2.0;
	i = ranking.GetIter(r);
	rank->deltaBelow = 0;
	if(++i!=ranking.end())
		rank->deltaBelow = (rank->yBase-(*i)->yBase)/2.0;
	if(!rank->deltaAbove)
		rank->deltaAbove = rank->deltaBelow;
	if(!rank->deltaBelow)
		rank->deltaBelow = rank->deltaAbove;
	rank->spaceBelow = 0;
	//rank->deltaBelow -= rank->spaceBelow = rank->deltaBelow/10.0;
#else
	double maxTop = nodeSep.y / 20.0,
		maxBottom = nodeSep.y / 20.0;
	for(NodeV::iterator ni = rank->order.begin(); ni!=rank->order.end(); ++ni) {
		if(DDd(*ni).amEdgePart()) 
			continue;
		double nt = TopExtent(*ni);
		if(maxTop < nt) 
			maxTop = nt;
		double nb = BottomExtent(*ni);
		if(maxBottom > nb) 
			maxBottom = nb;
	}

	rank->deltaAbove = maxTop;
	rank->deltaBelow = maxBottom;
	rank->spaceBelow = nodeSep.y;
#endif
}

void Config::resetBaselines() {
#ifndef FLEXIRANKS
	if(ranking.empty())
		return;
	if(prevLow == INT_MAX)
		prevLow = ranking.Low();
	Rank *base = ranking.GetRank(prevLow);
	Ranks::iterator start = ranking.GetIter(prevLow);

	/* work upward from prevLow rank */
	Rank *prev = base;
	// (Note reverse_iterator::operator* returns *(fwdIt-1))
	for(Ranks::reverse_iterator rri(start); rri!=ranking.rend(); ++rri) {
		Rank *rank = *rri;
#ifndef DOWN_GREATER
		rank->yBase = prev->yAbove(1.0) + rank->deltaBelow;
#else
		rank->yBase = prev->yAbove(1.0) - rank->deltaBelow;
#endif
		prev = rank;
	}

	prev = base;
	for(Ranks::iterator ri = start+1; ri!=ranking.end(); ++ri) {
		Rank *rank = *ri;
#ifndef DOWN_GREATER
		rank->yBase = prev->yBelow(1.0) - rank->deltaAbove;
#else
		rank->yBase = prev->yBelow(1.0) + rank->deltaAbove;
#endif
		prev = rank;
	}
	prevLow = ranking.Low();
#endif
}

void Config::SetYs() {
  Ranks::iterator ri;
	for(ri = ranking.begin(); ri!=ranking.end(); ++ri) 
		resetRankBox(*ri);

	resetBaselines();

	for(ri = ranking.begin(); ri!=ranking.end(); ++ri) 
		for(NodeV::iterator ni = (*ri)->order.begin(); ni!=(*ri)->order.end(); ++ni) {
			DDNode &ddn = DDd(*ni);
			double newY = (*ri)->yBase;
			ddn.cur.y = newY;
		}
}

} // namespace DynaDAG
