/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: Object.h,v 1.6 2004/01/26 11:16:58 comix Exp $
 *
 */

#ifndef H2_OBJECT_H
#define H2_OBJECT_H


#include <iostream>
#include <map>
#include <string>
using std::string;
using std::map;


class Object;

//----------------------------------------------------------------------------
/**
 * Class for writing logs to the console
 */
class Logger {
	private:

	public:
		/** Constructor */
		Logger();

		/** Destructor */
		~Logger();

		/** Simple log */
		void log(string logMsg);

		/** Information Log*/
		void info(Object *obj, string logMsg);

		/** Warning Log*/
		void warning(Object *obj, string logMsg);

		/** Error Log*/
		void error(Object *obj, string errorMsg);

};


//----------------------------------------------------------------------------
/**
 * Base class.
 */
class Object
{
	public:
		/** Constructor */
		Object( string sClassName );
		Object( const Object& obj );

		/** Destructor */
		virtual ~Object();

		/** Return the class name */
		string getClassName() {	return m_sClassName;	}

		static uint getNObjects();
		static void printObjectMap();

		void infoLog(string msg);
		void warningLog(string msg);
		void errorLog(string msg);

		static void useVerboseLog( bool bUse );
		static bool isUsingVerboseLog();

	private:
		static uint nObjects;
		static map<string, int> m_ObjectMap;
		Logger logger;
		static bool m_bUseLog;
		string m_sClassName;
};




#include <sstream>
template <class T>
inline std::string toString(const T& t)
{
	std::ostringstream osstream;
	osstream << t;
	return osstream.str();
}


inline int stringToInt( string str )
{
	std::istringstream isstream(str);
	int t;
	isstream >> t;
	return t;
}
inline float stringToFloat( string str )
{
	std::istringstream isstream(str);
	float t;
	isstream >> t;
	return t;
}



#endif
