/*
 *  - Roof Tile editor menu tab
 */

// NOTE!
// RTlist[0] does not exist and should NEVER BE ACCESSED
// It is a special case for no-roof-in-this-square
// The first one is RTlist[1]

#include <stdio.h>
#include "../ithelib.h"
#include "../gui/igui.hpp"
#include "../loadfile.h"
#include "../console.h"
#include "../core.hpp"
#include "../gamedata.h"
#include "../init.h"
#include "../gui/menusys.h"

// defines

#define VIEWX 64
#define VIEWY 112
#define STR_LEN 32
#define OVL_LEN 24

// variables

extern int focus,RT_Id,spr_total;
extern char **sprites;

static int curtil=1,offset=1,standunder=0;

static int Img_Id,Stu_Id;
static char ImgName[256];

static char str32[STR_LEN+1];

// functions

extern void Toolbar();
extern void Snap();
extern short exist(char *fname);


static void Nothing();
static void RftUpdate();                       // Update the displays
static void AddTile();
static void DelTile();
static void PickTile();

static void Img();
static void ToggleStandUnder();

static void TLBl();
static void TLBr();
static void TLBll();
static void TLBrr();

// GoFocal - The menu tab function.  This is called from the toolbar

void RT_GoFocal()
{
if(focus==8)            // Make sure we don't redraw if the user clicks again
	return;

memset(str32,' ',STR_LEN); str32[STR_LEN]=0;
memset(ImgName,' ',STR_LEN); ImgName[STR_LEN]=0;
//memset(behave_str,' ',STR_LEN); behave_str[STR_LEN]=0;

focus=8;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(RT_Id);     // And make the button stick inwards

IG_TextButton(32,80, " Add tile to end ",AddTile,NULL,NULL);
IG_AddKey(KEY_A,AddTile);

IG_TextButton(32,112," Delete from end ",DelTile,NULL,NULL);
IG_AddKey(KEY_D,DelTile);

DrawScreenText(224,104,"Roof tile image:");
Img_Id = IG_InputButton(320,96,str32,Img,NULL,NULL);

DrawScreenText(32,288,"Draw roof when the player stands underneath:");
Stu_Id = IG_ToggleButton(392,280," Yes ",ToggleStandUnder,NULL,NULL,&standunder);
IG_SetInText(Stu_Id," No  ");

IG_Region(32,400,576,32,PickTile,NULL,NULL);        // Tile selector

// Draw the VCR buttons on the Tile selector

IG_TextButton(8,410,__left,TLBl,NULL,NULL);     // Normal speed
IG_TextButton(616,410,__right,TLBr,NULL,NULL);

IG_TextButton(8,440,__left2,TLBll,NULL,NULL);   // Fast Forward
IG_TextButton(608,440,__right2,TLBrr,NULL,NULL);

RftUpdate();
}

void AddTile()
{
char fnbuf[1024];
BITMAP *b;
if(RTtot == 255)
    {
    Notify(-1,-1,"There is a maximum of 255 roof tiles.",NULL);
    return;
    }

RTlist[RTtot].fname = (char *)M_get(1,256);
strcpy(RTlist[RTtot].fname,RTlist[RTtot-1].fname);
RTlist[RTtot].name = RTlist[RTtot-1].name;
RTlist[RTtot].flags = RTlist[RTtot-1].flags;

loadfile(RTlist[RTtot].fname,fnbuf);
b = iload_bitmap(fnbuf);
destroy_rle_sprite(RTlist[RTtot-1].image);
RTlist[RTtot-1].image = get_rle_sprite(b);
RTlist[RTtot].image = get_rle_sprite(b);
destroy_bitmap(b);
//RTlist[RTtot].image.allocate(32,32);
//memcpy(RTlist[RTtot].image.spr,RTlist[RTtot-1].image.spr,2048);
RTtot++;

RftUpdate();
IG_WaitForRelease();
}

void DelTile()
{
if(RTtot == 1)
    {
    Notify(-1,-1,"You must have at least one tile.",NULL);
    return;
    }

RTtot--;
//RTlist[RTtot].image.free();
if(RTlist[RTtot].image)
	{
	destroy_rle_sprite(RTlist[RTtot].image);
    RTlist[RTtot].image=NULL;
	}
RTlist[RTtot].fname = NULL;
RTlist[RTtot].name = NULL;
RTlist[RTtot].flags = 0;

// If it's onscreen, make it go away

curtil=RTtot-1;
if(offset>(RTtot-17))
    offset=(RTtot-17);
if(offset<1) offset=1;

RftUpdate();
IG_WaitForRelease();
}

// Callback for a null event

void Nothing()
{
return;
}


// Function for updating the display

void RftUpdate()
{
int co,ctr;

standunder = (int)RTlist[curtil].flags&1;

draw_button(Stu_Id);

strcpy(ImgName,RTlist[curtil].fname);
for(ctr=strlen(ImgName);ctr<32;ctr++)
    ImgName[ctr]=' ';
ImgName[32]=0;
IG_UpdateText(Img_Id,ImgName);

co=17;
if(RTtot<17)
    co=RTtot;
IG_BlackPanel(31,399,578,34);
for(ctr=0;ctr<co;ctr++)
    {
//    RTlist[ctr+offset].image.block_put_sprite(33+(34*ctr),401,swapscreen);
    draw_rle_sprite(swapscreen,RTlist[ctr+offset].image,33+(34*ctr),401);
    if(curtil == ctr+offset)
        rect(swapscreen,33+(34*ctr),401,65+(34*ctr),432,ITG_WHITE);
    }
}

void Img()
{
char oldpath[256];

strcpy(oldpath,RTlist[curtil].fname);
InputNameFromListWithFunc(-1,-1,"Choose an image file:",spr_total-1,sprites,5,RTlist[curtil].fname,0,0,NULL);
if(!RTlist[curtil].fname[0])
    strcpy(RTlist[curtil].fname,oldpath);
else
    {
//    RTlist[curtil].image.free();
	destroy_rle_sprite(RTlist[curtil].image);
    Init_RoofTile(curtil);
    }

//        if(!Confirm(-1,-1,"This object is not 32x32 and may crash the program.","Are you sure you want to use it?"))
//            return;
RftUpdate();
}

void ToggleStandUnder()
{
RftUpdate();
standunder = !standunder;
RTlist[curtil].flags &= 0xfe; // strip bit 1
if(!standunder)
	RTlist[curtil].flags |= 1; // Set bit 1 as necessary
IG_WaitForRelease();
}

void TLBr()
{
offset++;
if(offset>(RTtot-17))
    offset=(RTtot-17);
if(offset<1) offset=1;
RftUpdate();
}

void TLBl()
{
offset--;
if(offset<1) offset=1;
RftUpdate();
}

void TLBrr()
{
offset+=10;
if(offset>(RTtot-17))
    offset=(RTtot-17);
if(offset<1) offset=1;
RftUpdate();
}

void TLBll()
{
offset-=10;
if(offset<1) offset=1;
RftUpdate();
}

void PickTile()
{
int co;
co=17;
if(RTtot<17) co=RTtot;
for(int ctr=0;ctr<co;ctr++)
	if(x>33+(34*ctr) && x<65+(34*ctr))
		{
		curtil=ctr+offset;
                RftUpdate();
		return;
		}
}

