// buffer.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Buffer is a first-in first-out circular array.  It and its subclasses are
// used as input and output queues in the QueuedOutputFunction and
// InputOutputFunction classes.

#ifndef BUFFER_H
#ifdef __GNUG__
#pragma interface
#endif
#define BUFFER_H

#include "localdefs.h"

class Buffer {
protected:
	Buffer(int size);
	virtual ~Buffer();
	void setSize(int);
	virtual void reset();
	void incrementInput();
	void incrementOutput();

	double* buffer;
	double* inputPointer;
	double* outputPointer;
	double* bufferEnd;	// cache end for quick comparison
	int maxQueue;
};

inline void
Buffer::incrementInput() {
	inputPointer++;
	inputPointer = (inputPointer > bufferEnd) ? buffer : inputPointer;
}

inline void
Buffer::incrementOutput() {
	outputPointer++;
	outputPointer = (outputPointer > bufferEnd) ? buffer : outputPointer;
}

#endif
