// editcommand.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
// EditCommand is the base class for classes which perform some editing or
// processing operation within one of the DataEditor classes or subclasses.

#ifndef EDITCOMMAND_H
#ifdef __GNUG__
#pragma interface
#endif
#define EDITCOMMAND_H

#include "localdefs.h"
#include "modifier.h"
#include "MyString.h"

class EditCommand : public Modifier {
	typedef Modifier Super;
public:
	EditCommand() : theController(nil) {}
	redefined Status configure(Controller *);
protected:
	virtual Controller* controller();
private:
	Controller* theController;
};

class DataEditor;

class SpecialEditCommand : public EditCommand {
	typedef EditCommand Super;
public:
	SpecialEditCommand(DataEditor* de) : theEditor(de) {}
protected:
	virtual int doApply() = 0;
	DataEditor* editor() { return theEditor; }
private:
	DataEditor* theEditor;
};

#endif
