/***************************************************************************
                          masterdisplay.cpp  -  description
                             -------------------
    begin                : Sun Sep 19 1999
    copyright            : (C) 1999 by Edson Pereira
    email                : edson_pereira@harvard.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "masterdisplay.h"
#include <qpainter.h>
#include <qpixmap.h>

MasterDisplay::MasterDisplay( QWidget *parent, const char *name )
             : QWidget( parent, name )
{
    setBackgroundColor( QColor( 50, 60, 60 ) );
	rxDisplay  = new RxFreqDisplay( this, "rxDisplay" );
	txDisplay  = new TxFreqDisplay( this, "txDisplay" );
    dcdDisplay = new ChildDisplay( this, "dcdDisplay" );
    afcDisplay = new ChildDisplay( this, "afcDisplay" );
    netDisplay = new ChildDisplay( this, "netDisplay" );
    confidenceDisplay = new ChildDisplay( this, "ConfidenceDisplay" );
    inputLevelDisplay = new ChildDisplay( this, "InputLevelDisplay" );
    modeDisplay = new ChildDisplay( this, "ModeDisplay");
    beaconDisplay = new ChildDisplay( this, "BeaconDisplay" );
    voxDisplay = new ChildDisplay( this, "VoxDisplay" );

	rxDisplay->setGeometry( 3, 3, 95, 13 );
	txDisplay->setGeometry( 3, 16, 95, 13 );
    dcdDisplay->setGeometry( 130, 3, 35, 13);
    afcDisplay->setGeometry( 95, 3, 35, 13);
    netDisplay->setGeometry( 95, 16, 35, 13);
    confidenceDisplay->setGeometry( 165, 3, 30, 13 );
    confidenceDisplay->setFontColor( 255, 255, 255 );
    inputLevelDisplay->setGeometry( 3, 42, 75, 13 );
    inputLevelDisplay->setFontColor( 255, 250, 205 );
    modeDisplay->setGeometry( 165, 42, 30, 13 );
    modeDisplay->setFontColor( 0, 255, 0 );
    beaconDisplay->setGeometry( 130, 16, 45, 13 );
    beaconDisplay->setFontColor( 0, 191, 255 );
    voxDisplay->setGeometry( 95, 42, 60, 13 );

    setDCD( false );
    setAFC( true );
    setNET( false );
    setMode( false ); // bpsk
    setBeacon( false );
    setVox( false );
    setConfidence( 0 );
	repaint();
}

MasterDisplay::~MasterDisplay()
{

}

void MasterDisplay::paintEvent( QPaintEvent *e )
{
	QRect    r = e->rect();
	QPixmap  pix( r.size());
	QPainter p;
	QPainter tmp;

  	static QPen     pen1( QColor( 240, 240, 240 ), 1 );
	
	pix.fill( this, r.topLeft() );
	
    static QFont font( "Fixed", 10, 50, 0 );
    font.setFixedPitch( TRUE );
    font.setStyleHint( (QFont::StyleHint)0 );
    font.setCharSet( (QFont::CharSet)0 );

	tmp.begin( &pix );
    tmp.setPen( pen1 );
    tmp.drawLine(   0, 58, 199, 58 );
    tmp.drawLine(   0,  0, 198,  0 );
    tmp.drawLine(   0,  0,  0,  58 );
    tmp.drawLine( 198,  0, 198, 58 );	
	tmp.end();

	p.begin( this );
	p.drawPixmap( r.topLeft(), pix );
	p.end();
}

/** Sets the Rx frequency */
void MasterDisplay::setRxFreq( float f )
{
    rxDisplay->setFrequency( f );	
}

void MasterDisplay::setTxFreq( float f )
{
    txDisplay->setFrequency( f );	
}

void MasterDisplay::setDCD( bool state )
{
    static bool oldState = true;

    // prevent unecessary updates
    if ( state == oldState ) return;
    oldState = state;

    QString s;

    s.sprintf("DCD");

    if ( state )
    {
        dcdDisplay->setFontColor( 255, 255, 0 );
        dcdDisplay->setText( s );
    }
    else
    {
        dcdDisplay->setFontColor( 100, 100, 100 );
        dcdDisplay->setText( s );
    }
}

void MasterDisplay::setAFC( bool state )
{
    static bool oldState = false;

    // prevent unecessary updates
    if ( state == oldState ) return;
    oldState = state;

    QString s;

    s.sprintf("AFC");

    if ( state )
    {
        afcDisplay->setFontColor( 0, 250, 154 );
        afcDisplay->setText( s );
    }
    else
    {
        afcDisplay->setFontColor( 100, 100, 100 );
        afcDisplay->setText( s );
    }
}

void MasterDisplay::setNET( bool state )
{
    static bool oldState = true;

    // prevent unecessary updates
    if ( state == oldState ) return;
    oldState = state;

    QString s;

    s.sprintf("NET");

    if ( state )
    {
        netDisplay->setFontColor( 255, 200, 200 );
        netDisplay->setText( s );
    }
    else
    {
        netDisplay->setFontColor( 100, 100, 100 );
        netDisplay->setText( s );
    }
}

void MasterDisplay::setConfidence( int confidence )
{
    static int oldConfidence = -1;
    QString s;

    if ( oldConfidence != confidence )
    {
        if ( confidence < 10 ) s.sprintf("  %d%%", confidence );
        else if ( confidence == 100 ) s.sprintf("%d%%", confidence );
        else s.sprintf(" %d%%", confidence );

        confidenceDisplay->setText( s );
    }
    oldConfidence = confidence;
}

void MasterDisplay::setInputLevel( double level )
{
    QString s;

    s.sprintf("ADC: %d%%", (int)(level / 0x7fff * 100.0) );
    inputLevelDisplay->setText( s );
}

void MasterDisplay::setMode( bool qpsk )
{
    QString s;

    if ( qpsk ) s.sprintf("QPSK");
    else s.sprintf("BPSK");
    modeDisplay->setText( s );
}

/** toggles the Beacon display */
void MasterDisplay::setBeacon( bool state )
{
    QString s;

    s.sprintf("BEACON");

    if ( state )
    {
        beaconDisplay->setFontColor( 0, 191, 255 );
        beaconDisplay->setText( s );
    }
    else
    {
        beaconDisplay->setFontColor( 100, 100, 100 );
        beaconDisplay->setText( s );
    }
}

void MasterDisplay::setVox( bool state )
{
    QString s;

    s.sprintf("Break-in");

    if ( state )
    {
        voxDisplay->setFontColor( 0, 191, 255 );
        voxDisplay->setText( s );
    }
    else
    {
        voxDisplay->setFontColor( 100, 100, 100 );
        voxDisplay->setText( s );
    }
}