/* 
 * Prospect: a developer's system profiler.
 *
 * COPYRIGHT (C) 2001-2002 Hewlett-Packard Company
 *
 * Author: Alex Tsariounov, HP
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: pthread.c,v 1.1 2002/05/15 21:44:58 type2 Exp $ */

#include <pthread.h>
#include <stdlib.h>
#include <stdio.h>

/*
 * This stuff is shared by all threads.
 */
int my_compare(const void *el1, const void *el2)
{
   return((*(int*)el1 > *(int*)el2) ? 1 : ((*(int*)el1 < *(int*)el2) ? -1 : 0));
}

/*
 * Thread 1 stuff.
 */
void* tid1_start(void *arg)
{
    int size, i, *array;

    printf("\nHello from thread 1, arg:%d", *(int*)arg);

    if (*(int*)arg > 1)
        size = *(int*)arg;
    else
        size = 1000000;

    printf("\n1: Allocating array - of %d integers.", size);
    array = malloc(size*sizeof(int));

    printf("\n1: Filling array.");
    for (i=0; i<size; i++) {
        array[i] = random();
    }

    printf("\n1: Sorting array.");
    qsort((void*) array, size, sizeof(int), my_compare);
    
    printf("\n1: Thread done.");
}


/*
 * Thread 2 stuff.
 */
void* tid2_start(void *arg)
{
    int size, i, *array;
    printf("\nHello from thread 2, arg:%d", *(int*)arg);

    if (*(int*)arg > 1)
        size = *(int*)arg;
    else
        size = 2000000;

    printf("\n2: Allocating array - of %d integers.", size);
    array = malloc(size*sizeof(int));

    printf("\n2: Filling array.");
    for (i=0; i<size; i++) {
        array[i] = random();
    }

    printf("\n2: Sorting array.");
    qsort((void*) array, size, sizeof(int), my_compare);
    
    printf("\n2: Thread done.");
}

/*
 * Thread 3 stuff.
 */
void* tid3_start(void *arg)
{
    int size, i, *array;

    printf("\nHello from thread 3, arg:%d", *(int*)arg);

    if (*(int*)arg > 1)
        size = *(int*)arg;
    else
        size = 1000000;

    printf("\n3: Allocating array - of %d integers.", size);
    array = malloc(size*sizeof(int));

    printf("\n3: Filling array.");
    for (i=0; i<size; i++) {
        array[i] = random();
    }

    printf("\n3: Sorting array.");
    qsort((void*) array, size, sizeof(int), my_compare);
    
    printf("\n3: Thread done.");
}

/* 
 * The orchestrater.
 */
main()
{
    pthread_t id1, id2, id3;
    int res;
    int arg1=0, arg2=0, arg3=0;

    printf("\nMain, creating thread 1...");
    res = pthread_create(&id1, NULL, tid1_start, (void*)&arg1);
    printf("\nMain: thread 1 is tid=%d", id1);

    printf("\nMain, creating thread 2...");
    res = pthread_create(&id2, NULL, tid2_start, (void*)&arg2);
    printf("\nMain: thread 2 is tid=%d", id2);

    printf("\nMain, creating thread 3...");
    res = pthread_create(&id3, NULL, tid3_start, (void*)&arg3);
    printf("\nMain: thread 3 is tid=%d", id3);

    printf("\nMain, waiting on 1");
    pthread_join(id1, NULL);

    printf("\nMain, waiting on 2");
    pthread_join(id2, NULL);

    printf("\nMain, 2 done, waiting on 3");
    pthread_join(id3, NULL);

    printf("\nMain, that's all\n");
}
