#ifndef MALLOC_DEBUG_H_INCLUDED
#define MALLOC_DEBUG_H_INCLUDED /* allow multiple inclusions */

/* 
 * Prospect: a developer's system profiler.
 *
 * COPYRIGHT (C) 2001-2004 Hewlett-Packard Company
 *
 * Author: Alex Tsariounov, HP
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: malloc_debug.h,v 1.4 2004/01/09 20:29:28 type2 Exp $ */

/* system include files */
#ifdef MALLOC_DEBUG
#include <sys/types.h>
#include <stdio.h>
#endif /* MALLOC_DEBUG */
#include <stdlib.h>

/* malloc_debug defines */
#ifdef MALLOC_DEBUG

#define MALLOC(A)   DebugMalloc((A), __LINE__, __FILE__);
#define CALLOC(A,B) DebugCalloc((A), (B), __LINE__, __FILE__)
#define FREE(A)     { DebugFree((A), __LINE__, __FILE__); (A) = NULL; }
#define FREE_ALL()   DebugFreeAll()

#else   /* ! MALLOC_DEBUG */

#define MALLOC(A)    malloc(A)
#define CALLOC(A,B)  calloc((A),(B))
#define FREE(A)      { free(A); (A) = NULL; }
#define FREE_ALL()

#endif /* MALLOC_DEBUG */

/* malloc_debug prototypes */

#ifdef MALLOC_DEBUG

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifdef _PROTOTYPES
void  DebugFree(void *Buf, int Line, char *pFileName);
void *DebugMalloc(size_t Size, int Line, char *pFileName);
void *DebugCalloc(size_t Size1, size_t Size2, int Line, char *pFileName);
void  DebugFreeAll();

#else /* not _PROTOTYPES */

void  DebugFree();
void *DebugMalloc();
void *DebugCalloc();
void  DebugFreeAll();

#endif /* _PROTOTYPES */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* MALLOC_DEBUG */

#endif  /* MALLOC_DEBUG_H_INCLUDED */
