/* ************************************************************************
  Module:        attributes.c
  Author:        Matt Simpson
                 Arlington, TX
                 matthewsimpson@home.com
  Date:          August, 2000

  Description:
                 Allocates and sets styles for colors & fonts and
                 sets pixmaps.

  Changes:

****************************************************************************
                 COPYRIGHT (C) 1999, 2000 Matt Simpson
                 GNU General Public License
                 See lexgui.c for full notice.
**************************************************************************** */
#include <stdio.h>
#include <gtk/gtk.h>
#include "lexgui.h"
#include "icons.h"
#include "logo.h"
#include "pbkgnd.h"

/* -------------------------------------------------------------------------
        get_color() Returns a color.
   ------------------------------------------------------------------------- */
GdkColor get_color(int color)
{
  static int init = 0;
  GdkColor pick;
  static GdkColor white = {0, 0xffff, 0xffff, 0xffff};
  static GdkColor black  = {0, 0x0000, 0x0000, 0x0000};
  static GdkColor red = {0, 0xc8c8, 0x0000, 0x0000};
  static GdkColor green = {0, 0x0000, 0x5a5a, 0x0000};
  static GdkColor yellow = {0, 0xffff, 0xffff, 0x0000};
  static GdkColor beige = {0, 0xffff, 0xf8f8, 0xf2f2};
  static GdkColor brown1 = {0, 0xcccc, 0xc1c1, 0xb2b2};
  static GdkColor brown2 = {0, 0xb5b5, 0xa7a7, 0x9999};
  static GdkColor brown3 = {0, 0xf7f7, 0xe9e9, 0xdcdc};
  static GdkColor brown4 = {0, 0xadad, 0xa0a0, 0x9393};
  static GdkColor grey = {0, 0xcccc, 0xcccc, 0xcccc};

  if(!init)
  {
    init = 1;
    gdk_color_alloc(gdk_colormap_get_system(), &white);
    gdk_color_alloc(gdk_colormap_get_system(), &black);
    gdk_color_alloc(gdk_colormap_get_system(), &red);
    gdk_color_alloc(gdk_colormap_get_system(), &green);
    gdk_color_alloc(gdk_colormap_get_system(), &yellow);
    gdk_color_alloc(gdk_colormap_get_system(), &brown1);
    gdk_color_alloc(gdk_colormap_get_system(), &brown2);
    gdk_color_alloc(gdk_colormap_get_system(), &brown3);
    gdk_color_alloc(gdk_colormap_get_system(), &brown4);
    gdk_color_alloc(gdk_colormap_get_system(), &grey);
  }
  switch (color)
  {
    case WHITE:
      pick = white;
      break;
    case BLACK:
      pick = black;
      break;
    case RED:
      pick = red;
      break;
    case GREEN:
      pick = green;
      break;
    case YELLOW:
      pick = yellow;
      break;
    case BEIGE:
      pick = beige;
      break;
    case BROWN1:
      pick = brown1;
      break;
    case BROWN2:
      pick = brown2;
      break;
    case BROWN3:
      pick = brown3;
      break;
    case BROWN4:
      pick = brown4;
      break;
    case GREY:
      pick = grey;
      break;
    default:
      pick = black;
  }
  return(pick);
}
/* -------------------------------------------------------------------------
        set_color() Sets color of specified part in widget. Note the
                    default colors are set in main().
   ------------------------------------------------------------------------- */
void set_color(GtkWidget **w, int color, int section, int mode)
{
  GtkStyle *newstyle;

  newstyle = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(*w)));

  switch (section)
  {
    case FG:
      newstyle->fg[mode] = get_color(color);
      break;
    case BG:
      newstyle->bg[mode] = get_color(color);
      break;
    case LIGHT:
      newstyle->light[mode] = get_color(color);
      break;
    case DARK:
      newstyle->dark[mode] = get_color(color);
      break;
    case MID:
      newstyle->mid[mode] = get_color(color);
      break;
    case TEXT:
      newstyle->text[mode] = get_color(color);
      break;
    case BASE:
      newstyle->base[mode] = get_color(color);
      break;  
  }
  gtk_widget_set_style(GTK_WIDGET(*w), newstyle);
}
/* -------------------------------------------------------------------------
        set_font() Sets font in widget. See below for predefined
                    fonts, selected by passing in the assigned int.
   ------------------------------------------------------------------------- */
void set_font(GtkWidget **w, int font_num)
{
  GtkStyle *newstyle;
  GdkFont *font;
  gchar *szFont;
  static gchar *font0 =
    "-adobe-helvetica-medium-r-normal--12-120-75-75-p-67-iso8859-1";
  static gchar *font1 =
    "-adobe-helvetica-medium-r-normal--8-80-75-75-p-46-iso8859-1";
  static gchar *font2 =
    "-adobe-courier-medium-r-normal--10-100-75-75-m-60-iso8859-1";
  static gchar *font3 =
    "-adobe-helvetica-bold-r-normal--14-140-75-75-p-82-iso8859-1";
  static gchar *font4 =
    "-adobe-helvetica-medium-r-normal--14-100-100-100-p-76-iso8859-1";
  static gchar *font5 =
    "-adobe-courier-medium-r-normal--17-120-100-100-m-100-iso8859-1";
  static gchar *font6 =
    "-adobe-courier-bold-r-normal--18-180-75-75-m-110-iso8859-1";
  static gchar *font7 =
    "-adobe-courier-medium-r-normal--14-100-100-100-m-90-iso8859-1";
  static gchar *font8 =
    "-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1";

  switch(font_num)
  {
    case 1:
      szFont = font1;
      break;
    case 2:
      szFont = font2;
      break;
    case 3:
      szFont = font3;
      break;
    case 4:
      szFont = font4;
      break;
    case 5:
      szFont = font5;
      break;
    case 6:
      szFont = font6;
      break;
    case 7:
      szFont = font7;
      break;
    case 8:
      szFont = font8;
      break;
    default:
      szFont = font0;
  }
  font = gdk_font_load(szFont);
  newstyle = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(*w)));
  newstyle->font = font;
  gtk_widget_set_style(*w, newstyle);
} 
/* -------------------------------------------------------------------------
        create_nbpix() For creating pixmap widgets for the notebook pages
                       and popup windows the notebook buttons bring up.
   ------------------------------------------------------------------------- */
GtkWidget *create_nbpix(GtkWidget **topwin, int p)
{
  GtkWidget *pixmapwidget = NULL;
  gchar **xpm_ptr;
  switch(p)
  {
    case 0:
      xpm_ptr = (gchar **)printink_xpm; /* Install cartridges window */
      break;
    case 1:
      xpm_ptr = (gchar **)car_xpm;      /* Park cartridges */
      break;
    case 2:
      xpm_ptr = (gchar **)drafting_xpm; /* Align window */
      break;
    case 3:
      xpm_ptr = (gchar **)thermometer_xpm; /* Reset gauges window */
      break;
    case 4:
      xpm_ptr = (gchar **)info_xpm;     /* Print info */
      break;
    case 5:
      xpm_ptr = (gchar **)paperoll_xpm; /* Clean cartridges */
      break;
    case 6:
      xpm_ptr = (gchar **)info2_xpm;    /* Query printer settings. */ 
      break;
    case 7:
      xpm_ptr = (gchar **)qd_xpm;       /* Set printer defaults -- dynamic. */
      break;
    case 8:
      xpm_ptr = (gchar **)qf_xpm;       /* Set printer defaults -- fixed. */
      break;
    case 9:
      xpm_ptr = (gchar **)check_xpm;    /* Printer Status. */
      break;
    case 10:
      xpm_ptr = (gchar **)tp_xpm;       /* Print test page. */
      break;
    case 11:
      xpm_ptr = (gchar **)ps_xpm;       /* Print Postscript font listing. */
      break;
    case 12:
      xpm_ptr = (gchar **)pcl_xpm;      /* Print PCL font listing. */
      break;
    case 13:
      xpm_ptr = (gchar **)info_xpm;     /* Print the settings page. */
      break;
    case 14:
      xpm_ptr = (gchar **)pdemo_xpm;    /* Print demo page. */
      break;
    case 15:
      xpm_ptr = (gchar **)ttf_xpm;      /* Print TTF test page. */
      break;
    default:
      xpm_ptr = NULL;
  }
  if(xpm_ptr)
    pixmapwidget = CreateWidgetFromXpm(*topwin, xpm_ptr);
  return(pixmapwidget);
} 
/* -------------------------------------------------------------------------
        create_pix() For creating some other pixmap widgets.
   ------------------------------------------------------------------------- */
GtkWidget *create_pix(GtkWidget **topwin, int p)
{
  GtkWidget *pixmapwidget = NULL;
  gchar **xpm_ptr;
  switch(p)
  {
    case 0:
      xpm_ptr = (gchar **)hand_xpm;
      break;
    case 1:
      xpm_ptr = (gchar **)t_xpm;
      break;
    case 2:
      xpm_ptr = (gchar **)logo_xpm;
      break;
    case 3:
      xpm_ptr = (gchar **)output_xpm;
      break;
    case 4:
      xpm_ptr = (gchar **)printer_xpm;
      break;
    case 5:
      xpm_ptr = (gchar **)disks_xpm;
      break;
    case 6:
      xpm_ptr = (gchar **)pbkgnd_xpm;
      break;
    default:
      xpm_ptr = NULL;
  }
  if(xpm_ptr)
    pixmapwidget = CreateWidgetFromXpm(*topwin, xpm_ptr);
  return(pixmapwidget);
}
