
#ifndef IIRSCRAM_ASSOCIATION_ELEMENT_BY_EXPRESSION_HH
#define IIRSCRAM_ASSOCIATION_ELEMENT_BY_EXPRESSION_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam

#include "savant.hh"
#include "IIRBase_AssociationElementByExpression.hh"

template <class type> class set;
class IIR_TypeDefinition;
class IIR_DesignatorList;
class IIR_List;
class IIR_AboveAttribute;

class IIRScram_AssociationElementByExpression : public IIRBase_AssociationElementByExpression {
public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_vhdl_without_formals(ostream &);
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_elaborate( published_file &_cc_out );
  void _publish_cc_subprogram_arguments( published_file &_cc_out );
  void _publish_cc_state_object_init( published_file &_cc_out );
  void _get_signal_source_info( set<IIR> *siginfo );
  IIR_Int32 _get_number_of_element_associations();
  void _publish_cc_aggregate_iterator( published_file &_cc_out );
  const string _publish_cc_magic_prefix( published_file &_cc_out );
  void _publish_cc_generic_map_aspect( published_file &_cc_out );
  void _publish_cc_generic_map_aspect_for_conc_stmts( published_file &_cc_out );
  IIR* _get_actual();
  void _set_actual( IIR * );

  // This function is implemented recursively in different nodes to handle
  // type conversion in procedure calls. The actual can be nest function
  // calls and the actual nested with them is extracted and published
  
  void _publish_cc_first_objectParameter( published_file &_cc_out );
  
  void _type_check( set<IIR_TypeDefinition> * );
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);
  IIR *_semantic_transform( set<IIR_TypeDefinition> * );
  IIR *_rval_to_decl( IIR_TypeDefinition * );
  ostream &_print( ostream & );
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);
  void _add_decl_into_cgen_symbol_table();
  IIR *_clone();

  IIR_Boolean _is_resolved();
  IIR_Boolean _is_signal();
  IIR_Boolean _is_variable();
  IIR_Boolean _is_readable();
  IIR_Boolean _is_writable();
  IIR_Boolean _is_above_attribute_found();

  IIR_Boolean _is_globally_static_for_array();
  IIR_Boolean _is_globally_static_for_record();
  IIR_Boolean _is_globally_static_for_function();
  void _build_above_attribute_set(set<IIR_AboveAttribute> *);

protected:
  IIRScram_AssociationElementByExpression() {}
  virtual ~IIRScram_AssociationElementByExpression() = 0;
 
private:
  //This function is to get rid of the confusion in the usage of
  //_publish_cc_state_object_init( published_file &_cc_out )
  //Initially, _publish_cc_state_object_init( published_file &_cc_out ) is used to publish in the
  //process's state, but now it is used everywhere. 
  //The _publish_state_object_init() calls _publish_cc_state_object_init( published_file &_cc_out )
  //on its sub-objects. This should stop if the object is not of type 
  //IIR_OthersInitialization or IIR_Aggregates. 
  //_publish_cc_non_aggregate_object_init( published_file &_cc_out ) performs this
  void _publish_cc_non_aggregate_object_init( published_file &_cc_out );
};

#endif
