
/* Main header file for Sherman's aquarium */
#ifndef AQUARIUM_H_
#define AQUARIUM_H_

#include <time.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "defines.h"



typedef struct{
  int eat;
  int explode;
  int clock;
  int thermo;
  int leds;
  int doublewh;
  int matrix;
  int scale;
  int fishes;
  int bubbles;
  int choose;
  int fish1;
  int fish2;
  int fish3;
  int fish4;
  int fish5;
  int fish6;
  int swordfish;
  int blowfish;
  int fillmore;
  int sherman;
  int prey;
  int hunter;
  int lori;
  int ernest;
  int squid;

  int solidcolour;
  int shadedblue;
  int wateralike;
  int r,g,b;
  int yourown;
  char *imagename;

} Settings;




/* structure describing each fish */
typedef struct {

    float tx;			/* current x position */
    int y;			/* current y position */
    int travel;			/* how far to move beyond the screen */
    int rev;			/* going left or right? */
    int frame;			/* current animation frame */
    float delay;		/* how quick we swap frames */
    int updown;			/* Was last moment up or down? - Larger chance to do it again. */
    int type;			/* Kind of fish */
    int width;
    int height;
    unsigned char *pic;
    int *animation;
    int num_animation;
    float *speed;
    float speed_mul;
    float fast_frame_change;
} Fish;


typedef struct {
  char *file;
  int pics;
  int frames;
  int *animation;
  float *speed;
} Fish_animation;


typedef struct {
    int x;			/* x position */
    float y;			/* y position */
    float speed;		/* The speed upwards the bubble has.
				   Is this physically wrong? Does all bubble
				   rise to the surface with the same speed? */
} Bubble;

typedef struct {
    unsigned char *image;
    unsigned char *rev;
    int width;
    int height;
    GdkPixbuf *pixbuf;
} Fish_buffer;

typedef struct {
  char *image;
  int flags;
} Bottom;


/* main dockapp info structure.  windows, buffers, etc */
typedef struct {

    GdkWindow *win;		/* main window */
#ifndef GTK2
    GdkWindow *iconwin;
#endif

#ifdef GNOME
    GtkWidget *about_box;
    GtkWidget *applet;
    GtkWidget *drawingarea;
    int oldwidth;
    int oldheight;
    int oldbg;
#endif
    GdkGC *gc;			/* drawing GC */


    /* main image buffer */
    unsigned char *rgb;

    /* back buffer - stores things we dont want to redraw all the time */
    unsigned char *bgr;

    Fish *fishes;

} AquariumData;


/* Declare functions */

char *filename(char *);
int aquarium_update(gpointer);
int entering_aquarium(void);
int leaving_aquarium(void);
void prepare_backbuffer(void);
void prepare_graphics(void);
#ifdef GNOME
void reload_all(void);
void free_all(void);
#endif
#ifdef GTK2
void display_file_error(char *, char *, GError *);
#else
void display_file_error(char *, char *);
#endif

/* Returns a pointer to the static struct in aquarium.c */
AquariumData *get_ad(void);




extern Fish *fishes;
extern Settings mys;

extern Fish_buffer blowup_data;
extern Fish_buffer prey_hunter_data;
extern Fish_buffer fish_buffer[];
extern Fish_animation fish_animation[];

extern int xmax;
extern int ymax;
extern int xmin;
extern int ymin;
extern int windowsize_x;
extern int windowsize_y;
extern int virtual_aquarium_x;
extern int virtual_aquarium_y;
extern int bubble_state_change;

extern Display *display;

#ifdef FULLSCREEN
extern int xscreensaver;
extern int keep_resolution;
extern int escape_only;
#endif


/* Command line options variable */
extern int posx;
extern int posy;
extern int brokenwm;
extern int force_es;

extern int bubble_state_change;
extern int goad_server;
#endif
