/* $Id: udp.h,v 1.4 2003/05/30 00:42:40 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _UDP_H
#define _UDP_H

#include "port.h"
#include "mbuf.h"

/* 
 * UDP protocol declarations 
 */

/*
 * Send the packet in mbuf to the given destination with the given ip flags 
 */
void udp_send_packet(mbuf_t *mbuf, uint32_t src_ip, uint32_t dest_ip, uint8_t ip_flags, uint16_t src_port, uint16_t dest_port);

/* 
 * Add a udp protocol handler for packets on the passed src_ip, dest_ip, src_port, and dest_port
 * tuple.  
 * 
 * If any of the tuple arguments is 0, then matching is ignored for that argument.
 * For matching packets, the handler is called with an mbuf stripped of all header data up
 * to and including the udp header.  The tuple is passed to the handler so that handlers
 * which specify '0' for a tuple filter argument can determine the full tuple information
 * of the packet.
 * 
 * The data argument is saved and passed to the handler on callbacks 
 */

void udp_add_handler(int (*handler)(mbuf_t *mbuf, void *data, uint32_t src_ip, uint32_t dest_ip, uint16_t src_port, uint16_t dest_port), 
		     void *data, uint32_t src_ip, uint32_t dest_ip, uint16_t src_port, uint16_t dest_port);

/*
 * Uninstall a handler.  All tuple arguments and the "data" argument
 * must match the previous "add" call.  
 *
 * It is an error to call this function if a matching handler was not previously installed 
 */

void udp_del_handler(int (*handler)(mbuf_t *mbuf, void *data, uint32_t src_ip, uint32_t dest_ip, uint16_t src_port, uint16_t dest_port), 
		     void *data, uint32_t src_ip, uint32_t dest_ip, uint16_t src_port, uint16_t dest_port);

#endif
