/* # skkinput (Simple Kana-Kanji Input)
 * skkmain.c --- 
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>
#include <signal.h>
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/ShellP.h>

#include "skkmain.h"
#include "skkproto.h"
#include "SkkInput.h"
#include "config.h"
#include "version.h"

/*
 * main Ѥѿη
 */
struct skkinputOptionDef {
  char *chara ;
  int  function_no ;
  int  need_argument ;
} ;

/*
 * ᥤѤ
 */
enum {
  OPTION_HOST = 0, OPTION_PORT, OPTION_USERDIC, OPTION_BAKDIC,
  OPTION_SKKDIC, OPTION_SKKREC, OPTION_HELP, OPTION_VERSION,
  OPTION_CONFIG,
} ;


/*
 * ץȥ
 */
/* skkmain.c local */
static int skkinput_GlobalsInitialize( Widget parent ) ;
static void skkinput_StopConversion
( Widget w, XEvent *xevent, String *params, Cardinal *num_params ) ;
static void skkinput_SelectionClear
( Widget w, XEvent *xevent, String *params, Cardinal *num_params ) ;
static void skkinput_SelectionRequest
( Widget w, XEvent *xevent, String *params, Cardinal *num_params ) ;
static void skkinput_Quit( void ) ;
static void skkinput_CheckEvent( XEvent *xevent ) ;
static int skkinput_usage( void ) ;
static int skkinput_checkOptions( int argc, char *argv[] ) ;
static void skkinput_redraw_allskkinputs( void ) ;

/* skksvect.c */
extern void initVectorHashTable( void ) ;
/* skkkip.c */
extern int KIP_initialize( XtAppContext app_context, Widget gw ) ;
#if 0
/* skkximp.c */
extern int XIMP_initialize( XtAppContext app_context, Widget gw ) ;
#endif
/* skksoc.c */
int skkinput_StartCommunication( char *server_name, int port_num ) ;
int skkinput_CloseCommunication( void ) ;
/* skkldic.c */
int set_localjisyo
( char *jisyo_path, char *jisyobak_path, char *record_path,
  char *skklocaljisyo ) ;
int close_localjisyo( void ) ;
void skkinput_updateLocalJisyo( void ) ;
/* skkldrec.c */
void initHenkanKakuteiHashTable( void ) ;
void clearHenkanKakuteiHash( void ) ;
/* skkconfig.c */
int skkinput_readConfigFile( char *config_file ) ;
void initSkkinputDousaketteiVariables( void ) ;

/*
 * Хѿ
 */
/* X Tool Kit  ץꥱ󥳥ƥȡ*/
static XtAppContext app_context ;
#if 0
static XContext xcontext ;
#endif

/* X Tool Kit ɬפȤƤ Option ꡣ*/
static XrmOptionDescRec options[] = {
  { "-fk",	"*kanjiFont",	XrmoptionSepArg,	NULL },
  { "-fr",	"*font",	XrmoptionSepArg,	NULL },
  { "-rv",	"*reverseVideo",XrmoptionNoArg,		"TRUE" },
  { "+rv",	"*reverseVideo",XrmoptionNoArg,		"FALSE" },
  { "-fg",	"*foreground",	XrmoptionSepArg,	NULL },
  { "-bg",	"*background",	XrmoptionSepArg,	NULL },
  { "-bd",	"*borderColor",	XrmoptionSepArg,	NULL },
  { "-geometry","*Geometry",	XrmoptionSepArg,	NULL },
  { "-ccsk",	"*compatibleCloseSkkinputKey", XrmoptionNoArg, "TRUE" },
  { "+ccsk",	"*compatibleCloseSkkinputKey", XrmoptionNoArg, "FALSE" },
};

/* SkkInput  TOPLEVEL ǼȤɬפΤ XEVENT */
/* ϥץȥ Widget ٤ Ĥޤ,kip ѤȤ xim ѤȤ*/
static XtActionsRec toplevelActions[] = {
  { "stopConversion",	skkinput_StopConversion },
  { "selectionClear",	skkinput_SelectionClear },
  { "selectionRequest",	skkinput_SelectionRequest },
} ;

static char defaultToplevelTranslations[] = 
"<SelClr>:	selectionClear()\n\
 <SelReq>:	selectionRequest()\n" ;

/* WM_PROTOCOL 뤿ɬפ ATOM */
Atom wm_delete_window ;
/* skkinput λɬפʽԤѤ longjmp δĶ*/
static jmp_buf skkinputQuitEnv ;

/* ¾skkinput ɬפȤskkInputWidget ˤɬפȤʤ*/
char *skkserv_host ;
int  skkserv_portnum ;
char *skkinput_local_jisyo_name ;
char *skkinput_backup_jisyo_name ;
char *skk_local_jisyo_name ;
char *skkinput_record_name ;
int  skk_egg_like_newline ;
int  skkinput_chatadaptermode ;
int  skkinput_search_skk_jisyo ;
int  skkinput_keep_record ;
int  skkinput_date_ad ;
int  skkinput_number_style ;
int  skkinput_delete_implies_kakutei ;
int  skkinput_use_numeric_conversion ;
static char *skkinput_config_name ;

int skkinput_jisyo_dirty ;
int skkinput_prev_jisyo_dirty ;

/*
 * ᥤؿ
 *-------
 * ΥåǤ⤦ˤ䤫ˤʤĤꡣ
 */
int main( int argc, char *argv[] )
{
  Display *display ;
  XtTranslations trans ;
  Widget toplevel ;
  Arg arg[ 20 ] ;
  Cardinal i ;

  /* skkinput ưѿƤ*/
  initSkkinputDousaketteiVariables() ;
  /* ϤޤäǤ롣*/
  skkinput_jisyo_dirty = skkinput_prev_jisyo_dirty = False ;
  /* ѴκݤѤϥåơ֥Ƥ*/
  initVectorHashTable() ;
  /* κݤѤϥåơ֥Ƥ*/
  initHenkanKakuteiHashTable() ;

  /* ޤTool Kit ν롣*/
  toplevel = XtAppInitialize
    ( &app_context, "Skkinput", options, XtNumber(options), &argc, argv,
      NULL, arg, ( Cardinal ) 0);

  /* ĤäƤ顢å롣 ToolKit ǤϻȤʤ *
   * 뤫顣*/
  skkinput_config_name = DEFAULT_CONFIGFILE ;
  if( argc > 1 ){
    /* ˥ץ򥹥󤷤ơեΥѥ˽ʤ *
     * Ĵ٤롣*/
    if( !skkinput_checkOptions( argc, argv ) ){
      /* ѤƤ񸻤Ʋ롣*/
      XtDestroyApplicationContext
	( XtWidgetToApplicationContext( toplevel ) ) ;
      return 1 ;
    }
  }
  /* config file ɤǤ餦*/
  skkinput_readConfigFile( skkinput_config_name ) ;

  /* ץ꤬ͥˤʤ褦ˡֺǸɤࡣ*/
  /*  prescan ˤäơǤΰåǥ顼֤뤳 *
   * Ϥʤ*/
  skkinput_checkOptions( argc, argv ) ;

  /* socket Ƥ*/
  skkinput_StartCommunication( skkserv_host, skkserv_portnum ) ;
  /* ɽ꼭ξƤ*/
  set_localjisyo
    ( skkinput_local_jisyo_name, skkinput_backup_jisyo_name,
      skkinput_record_name, skk_local_jisyo_name ) ;

#if 0
  xcontext = XUniqueContext() ;
#endif
  /* 륤٥ȤȤνؿ롣*/
  XtAppAddActions( app_context, toplevelActions,
		   XtNumber( toplevelActions ) ) ;

  trans = XtParseTranslationTable( defaultToplevelTranslations ) ;
  XtOverrideTranslations( toplevel, trans ) ;

  /* ϤȤ褦ˤ롣*/
  i = 0 ;
  XtSetArg( arg[ i ], XtNinput,  True ) ;
  i ++ ;  
  XtSetArg( arg[ i ], XtNwidth,  10 ) ;
  i ++ ;
  XtSetArg( arg[ i ], XtNheight, 10 ) ;
  i ++ ;
#if 0
  XtSetArg( arg[ i ], XtNtranslations, trans ) ;
  i ++ ;
#endif
  XtSetArg( arg[ i ], XtNmappedWhenManaged, False ) ;
  i ++ ;
  XtSetValues( toplevel, arg, i ) ;

  /* Хѿν*/
  skkinput_GlobalsInitialize( toplevel ) ;

  /* Widget ޤǤϼΤϤʤΤǡǼΤ *
   * ΤǤ*/
  XtRealizeWidget( toplevel ) ;

  display = XtDisplay( toplevel ) ;

  /* Window Manager  delete message 褦 atom 롣*/
  wm_delete_window = XInternAtom( XtDisplay( toplevel ),
				  "WM_DELETE_WINDOW", False ) ;

  /* Kinput Protocol Ѥ뤿νԤ*/
  KIP_initialize( app_context, toplevel ) ;
#if 0
  /* XIM Protocol Ѥ뤿νԤ*/
  XIMP_initialize( app_context, toplevel ) ;
#endif

  signal( SIGINT,  ( void * )skkinput_Quit ) ;
  signal( SIGQUIT, ( void * )skkinput_Quit ) ;
  signal( SIGTERM, ( void * )skkinput_Quit ) ;
  signal( SIGPIPE, ( void * )skkinput_Quit ) ;

  if( !setjmp( skkinputQuitEnv ) ){
    XEvent xevent ;
    /* XtAppMainLoop( app_context ) ; */
    while( 1 ){
      XtAppNextEvent( app_context, &xevent ) ;
      skkinput_CheckEvent( &xevent ) ;
      XFlush( XtDisplay( toplevel ) ) ;
    }
  }
  signal( SIGINT,  SIG_IGN ) ;
  signal( SIGQUIT, SIG_IGN ) ;
  signal( SIGTERM, SIG_IGN ) ;
  signal( SIGPIPE, SIG_IGN ) ;

  /* ѤƤ񸻤Ʋ롣*/
  XtDestroyApplicationContext
    ( XtWidgetToApplicationContext( toplevel ) ) ;
  /* skkserv Ȥ communication Ĥ롣*/
  skkinput_CloseCommunication() ;
  /* 񤬱ʤä */
  if( skkinput_jisyo_dirty ){
    fprintf( stderr, "Saving Jisyo..." ) ;
    /* ߤޤǤ˳ѴƤ򥻡֤롣*/
    skkinput_updateLocalJisyo() ;
    fprintf( stderr, "done\n" ) ;
  }
  /* malloc Ƥβ*/
  close_localjisyo() ;
  /* ϥå򥯥ꥢ롣*/
  clearHenkanKakuteiHash() ;
  return 0 ;
}

/*
 * ˡ򼨤ؿ
 */
static int skkinput_usage( void )
{
  char **ptr ;
  char *syntaxtable[] = {
    "-\\?           or -help",		  "show this help",
    "-v            or -version",	  "show version",
    "-h <hostname> or -host <hostname>",  "specifies skkserv host",
    "-p <port_num> or -port <port_num>",  "specifies port number",
    "-uj <jisyo>   or -userjisyo <jisyo>","specifies skkinput-local-jisyo",
    "-bj <jisyo>   or -backjisyo <jisyo>","specifies skkinput-local-jisyo\'s backup",
    "-sj <jisyo>   or -skkjisyo <jisyo>", "specifies skk-local-jisyo",
    "-rc <jisyo>   or -record <record>",  "specifies skkinput-record",
    "-fk <kanji fontname>",		  "specifies kanji font",
    "-fr <fontname>",			  "specifies normal text font",
    "-fg <color>",			  "specifies foreground color",
    "-bg <color>",			  "specifies background color",
    "-bd <color>",			  "specifies border color",
    "-geometry <height>x<width>",         "specifies skkinput window geometry",
    "-/+rv",				  "reverse video mode on/off",
    "-/+ccsk",			"<shift>+<space> close skkinput on/off",
    NULL, NULL,
  } ;
  ptr = syntaxtable ;
  while( *ptr != NULL ){
    fprintf( stderr, "%-35s ", *ptr ++ ) ;
    fprintf( stderr, "%s\n", *ptr ++ ) ;
  }
  return 0 ;
}

/*
 * ץΥå򤹤ؿ
 */
static int skkinput_checkOptions( int argc, char *argv[] )
{
  int i, j ;
  struct skkinputOptionDef local_options[] = {
    { "-h",		OPTION_HOST,	True },
    { "-host",		OPTION_HOST,	True },
    { "-p",		OPTION_PORT,	True },
    { "-port",		OPTION_PORT,	True },
    { "-uj",		OPTION_USERDIC,	True },
    { "-userjisyo",	OPTION_USERDIC,	True },
    { "-bj",		OPTION_BAKDIC,	True },
    { "-backjisyo",	OPTION_BAKDIC,	True },
    { "-sj",		OPTION_SKKDIC,	True },
    { "-skkjisyo",	OPTION_SKKDIC,	True },
    { "-rc",		OPTION_SKKREC,	True },
    { "-record",	OPTION_SKKREC,	True },
    { "-config",	OPTION_CONFIG,	True },
    { "-cnf",		OPTION_CONFIG,	True },
    { "-?",		OPTION_HELP,	False },
    { "-help",		OPTION_HELP,	False },
    { "-v",		OPTION_VERSION,	False },
    { "-version",	OPTION_VERSION,	False },
    { NULL,             0,              False },
  } ;
  for( i = 1 ; i < argc ; i ++ ){
    /* ɤ˰פ뤫򸫤롣*/
    for( j = 0 ; local_options[ j ].chara != NULL ; j ++ ){
      if( !strcmp( argv[ i ], local_options[ j ].chara ) )
	break ;
    }
#if 0
    printf( "option : %d\n", j ) ;
#endif
    /* ɤˤפʤä硣*/
    if( local_options[ j ].chara == NULL ){
      fprintf( stderr, "Unknown argument: \"%s\" exists.\n", argv[ i ] ) ;
      goto checkoption_errorreturn ;
    }
    /* ˰ɬפȤƤΤ */
    if( local_options[ j ].need_argument ){
      i ++ ;
      if( i >= argc ){
	fprintf( stderr, "Lack of argument: \"%s\".\n", argv[ i - 1 ] ) ;
	goto checkoption_errorreturn ;
      }
    }
#if 0
    printf( "option accept: %d\n", j ) ;
#endif
    /* ץν*/
    switch( local_options[ j ].function_no ){
      /* skkserv εƤۥ̾ꤹ롣*/
    case OPTION_HOST :
#if 0
      printf( "option host : %s\n", argv[ i ] ) ;
#endif
      skkserv_host = argv[ i ] ;
      break ;
      /* skkserv ̿Ѥݡֹꤹ롣*/
    case OPTION_PORT :
      skkserv_portnum = atoi( argv[ i ] ) ;
      break ;
      /* ɽ꼭̾ꤹ롣*/
    case OPTION_USERDIC :
      skkinput_local_jisyo_name = argv[ i ] ;
      break ;
    case OPTION_BAKDIC :
      skkinput_backup_jisyo_name = argv[ i ] ;
      break ;
      /* إפɽ롣*/
    case OPTION_SKKREC :
      skkinput_record_name = argv[ i ] ;
      break ;
      /* եνߤꤹ롣*/
    case OPTION_CONFIG :
      skkinput_config_name = argv[ i ] ;
      break ;
    case OPTION_HELP :
      goto checkoption_errorreturn ;
      /* Сɽ롣*/
    case OPTION_VERSION :
      fprintf( stderr, "skkinput version %s\n\n", skkinput_version ) ;
      fprintf( stderr, "This is free software. Skkinput can be copied only under the terms of\nthe GNU General Public license. There is NO warranty; not even for \nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n" ) ;
      return False ;
    default :
      goto checkoption_errorreturn ;
    }
  }
  return True ;

checkoption_errorreturn:
  skkinput_usage() ;
  return False ;
}

/*
 * SKKINPUT ΥХѿν
 */
static int skkinput_GlobalsInitialize( Widget parent )
{
  Arg arg[ 2 ] ;
  int i ;
  for( i = 0 ; i < MAX_SKKINPUTS ; i ++ ){
    skkinputs[ i ].probe        = False ;
    skkinputs[ i ].req_window   = None ;
    skkinputs[ i ].focus_window = None ;
    skkinputs[ i ].chat_adapter = False ;
    skkinputs[ i ].eggnl        = False ;
    XtSetArg( arg[ 0 ], XtNinput, True ) ;
    skkinputs[ i ].popup = XtCreatePopupShell
      ( "skkinput", transientShellWidgetClass, parent, arg, 1 ) ;
  }
  return 0 ;
}

/*
 * ξ֤ѲƤܸФƥ֥ɥ㥹Ȥ
 * 
 *------
 * main -> widget ؤ̿ˤϡXtSetValues ȤΤȻפ
 * ϡ
 */
static void skkinput_redraw_allskkinputs( void )
{
  Arg arg[ 2 ] ;
  int i ;
  for( i = 0 ; i < MAX_SKKINPUTS ; i ++ ){
    /* Ƥ⤤ʤФ*/
    if( !skkinputs[ i ].probe )
      continue ;
#if 0
    if( !XtIsManaged( skkinputs[ i ].skkinp ) )
      continue ;
#endif
    XtSetArg( arg[ 0 ], XtNjisyoDirty, skkinput_jisyo_dirty ) ;
    XtSetValues( skkinputs[ i ].skkinp, arg, 1 ) ;
  }
  return ;
}

static void skkinput_StopConversion
( Widget w, XEvent *xevent, String *params, Cardinal *num_params )
{
  int i ;
  XClientMessageEvent *cev = &( xevent->xclient ) ;

#if 0
  fprintf( stderr, "Stop Conversion\n" ) ;
  fflush( stderr ) ;
#endif
  /* ɤΥ饤ȤФ줿׵ʤΤĴ٤       *
   * SkkInputWidget ˤΥåή줿ΤʤñʤΤˡġ*/
  for( i = 0 ; i < MAX_SKKINPUTS ; i ++ ){
    /* Probe ƤʤΤ̵뤹롣*/
    if( !skkinputs[ i ].probe )
      continue ;
    /* PopUp Window ФƤ̿Τǡɤ PopUp Ĵ٤롣*/
    if( w == skkinputs[ i ].popup ){
      if( cev->data.l[ 0 ] != wm_delete_window ){
	/* Window Manager  delete Ȥ׵ᤸʤäΤ̵롣*/
	XBell( XtDisplay( w ), 0 ) ;
      } else {
	/*  Window Manager Υå SkkInputWidget  *
	 * Ф*/
	XtDestroyWidget( skkinputs[ i ].skkinp ) ;
      }
      /* Ȥ⤢졢Event νϤǤΤǡȴ롣*/
      break ;
    }
  }
  return ;
}

/*
 * ܸϼԤȤƤΩ򼺤äƤޤäν򤹤ؿ
 */
static void skkinput_SelectionClear
( Widget w, XEvent *xevent, String *params, Cardinal *num_params )
{
  int i ;
  /* Ƥ뤬ä顢Ĥ롣*/
  for( i = 0 ; i < MAX_SKKINPUTS ; i ++ ){
    if( skkinputs[ i ].probe ){
      XtDestroyWidget( skkinputs[ i ].skkinp ) ;
      skkinputs[ i ].probe   = False ;
      skkinputs[ i ].reserve = False ;
    }
  }
  fprintf( stderr, "I lost selection owner.\n" ) ;
  /* ᥤؿνλؤ֡*/
  longjmp( skkinputQuitEnv, 1 ) ;
}

/*
 * ɤʬʤ򤹤ؿɡĤɤ顢Ѥ׵᤬褿Ϥ
 * Ȥ򤷤Ƥߤ
 */
static void skkinput_SelectionRequest
( Widget w, XEvent *xevent, String *params, Cardinal *num_params )
{
  XSelectionRequestEvent *xsrev = &( xevent->xselectionrequest ) ;
  XEvent reply ;

  reply.xselection.type      = SelectionNotify ;
  reply.xselection.requestor = xsrev->requestor ;
  reply.xselection.selection = xsrev->selection ;
  reply.xselection.target    = xsrev->target ;
  reply.xselection.property  = None ;
  reply.xselection.time      = xsrev->time ;

  XSendEvent( xsrev->display, xsrev->requestor, False, NoEventMask, &reply ) ;
}

/*
 * ä褿٥Ȥåؿ
 */
static void skkinput_CheckEvent( XEvent *xevent )
{
  int i, willBeDestroyed ;
  Arg arg[ 2 ] ;
  SKKInputRootNode *rNode ;

#if 0
  fprintf( stderr, "Type(%d), Serial(%ld), Window(%ld)\n", 
	   xevent->type, xevent->xany.serial, xevent->xany.window ) ;
#endif

  /* ⤷˲׵äꤷƤޤ󤫡 */
  if( xevent->type == DestroyNotify ){
    /* ʬȤ׵ԤФ륤٥Ȥäν*/
    XDestroyWindowEvent *xdwe = ( XDestroyWindowEvent *)xevent ;

    rNode = skkinputs ;
    for( i = 0 ; i < MAX_SKKINPUTS ; i ++, rNode ++ ){
      /* Ƥʤ̵ͤ뤹롣*/
      if( !rNode->probe )
	continue ;
      /* ơɤ줫ҥåȤޤʡ */
      if( rNode->xevent.xclient.data.l[ 1 ] == xdwe->window ){
	rNode->req_window = rNode->focus_window = None ;
	/* 㤢Ĥޤ礦*/
	XtDestroyWidget( rNode->skkinp ) ;
	return ;
      }
    }
  }
  XtDispatchEvent( xevent ) ;

  /* ȤʤФʤʤɤĴ٤롣*/
  rNode = skkinputs ;
  for( i = 0 ; i < MAX_SKKINPUTS ; i ++, rNode ++ ){
    if( !rNode->probe )
      continue ;
    XtSetArg( arg[ 0 ], XtNwillBeDestroyed, &willBeDestroyed ) ;
    XtGetValues( rNode->skkinp, arg, 1 ) ;
    if( willBeDestroyed ){
      XtDestroyWidget( rNode->skkinp ) ;
    }
  }
  /* ѹäˤƤФƽľ׵᤬ɬ *
   * פǤ롣줬¹ԤǤΤϡᥤ*/
  if( skkinput_jisyo_dirty != skkinput_prev_jisyo_dirty ){
    skkinput_redraw_allskkinputs() ;
    skkinput_prev_jisyo_dirty = skkinput_jisyo_dirty ;
  }
  return ;
}

/*
 * skkinput λνԤؿ
 *-----
 * ȤäƤ⡢main ؿνλʬǤǤɡ
 * λˤ application context ʤܤʤΤǡä
 * ؿǤ Selection Owner ǤޤΤǡΤҤä
 * 뤳ȤϾʤȻפΤǤɡ
 */
static void skkinput_Quit( void )
{
  int i ;
  /* Ƥ뤬ä顢Ĥ롣*/
  for( i = 0 ; i < MAX_SKKINPUTS ; i ++ ){
    if( skkinputs[ i ].probe ){
      XtDestroyWidget( skkinputs[ i ].skkinp ) ;
      skkinputs[ i ].probe   = False ;
      skkinputs[ i ].reserve = False ;
    }
  }
  /* ᥤؿνλؤ֡*/
  longjmp( skkinputQuitEnv, 1 ) ;
}

#define CS96	0x100	/* 96chars CS */
#define MBCS	0x200	/* Multibyte CS */

/* convJWStoCT -- Japanese Wide Character String -> COMPOUND_TEXT */
int convJWStoCT( char *str, unsigned char *xstr, int jisroman )
{
  int	g0, g1 ;
  int	n ;
  int	g0cs ;
	
  g0cs = jisroman ? 'J' : 'B';
  g0 = 'B' ;
  g1 = CS96|'A' ;
	
  /*
   * G0, G1 ϼΤ褦˻Ȥʬ
   *  G0: ASCII / JIS-ROMAN
   *  G1:  / 
   */
#ifdef DEBUG
  fprintf( stderr, "CONV : " ) ;
#endif
  n = 0 ;
  while( *str != '\0' ){
#ifdef DEBUG
    fprintf( stderr, "( %d )->", n ) ;
#endif
    if( ( *str ) & 0x80 ){
      /*  */
      if( g1 != ( MBCS|'B' ) ){
	if( xstr != NULL ){
	  *xstr++ = 0x1b ;
	  *xstr++ = 0x24 ;
	  *xstr++ = ')';
	  *xstr++ = 0x42 ;
	}
	n += 4 ;
	g1 = MBCS|'B' ;
      }
      if( xstr != NULL ){
	*xstr++ = ( *str ++ ) & 0xff ;
	*xstr++ = *( str ++ ) & 0xff ;
	n += 2 ;
	continue ;
      }
      str ++ ;
      str ++ ;
      n += 2 ;
      continue ;
    } else {
      /* ASCII or C0 */
      if( *str < ' '){
	/* C0 */
	if( *str == '\t' || *str == '\n') {
	  if ( xstr != NULL ){
	    *xstr++ = *str ;
	  }
	  n++ ;
	}
	str ++ ;
	continue ;
      }
      if( g0 != g0cs ){
	if( xstr != NULL ){
	  *xstr++ = 0x1b ;
	  *xstr++ = '(' ;
	  *xstr++ = g0cs ;
	}
	n += 3 ;
	g0 = g0cs ;
      }
      if ( xstr != NULL ){
	*xstr++ = ( *str ) & 0x7f ;
      }
      str ++ ;
      n++ ;
      continue ;
    }
  }
  if ( xstr != NULL )
    *xstr = '\0' ;
#ifdef DEBUG
  fprintf( stderr, "\n" ) ;
#endif
  return n ;
}
