/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef __MODES_MENU_H__
#define __MODES_MENU_H__

#include <gnome.h>


#define AG_OPTION_MENU_FUNC(func)       (void(*)(gpointer))(func)


/* 
 * ag_create_option_menu
 * @labels   : an arry of pointers of the labels for the menu  
 * @def_item : the label of the item to be set as default 
 * @func     : the function that will be called when an item is activated 
 * create an option menu, this is where we will select 
 * the calculator modes
 */ 
GtkWidget *
ag_create_option_menu(gchar         *labels[],
		      gchar         *def_item,
		      void         (* func)(gpointer));



/*
 * ag_mode_size_choosen
 * @data : the selected mode
 *
 * Set the format size to @data, and save it to the config file
 */
void 
ag_mode_size_choosen(gpointer data);


/*
 * ag_mode_format_choosen
 * @data : the selected mode
 *
 * Set the format to @data, and save it to the config file
 */
void 
ag_mode_format_choosen(gpointer data);


/*
 * ag_mode_angle_choosen
 * @data : the selected mode
 *
 * Set the angle messure to @data, and save it to the config file
 */
void 
ag_mode_angle_choosen(gpointer data);


#endif /* __MODES_MENU_H__ */
