#ifndef _FECTABLE_H
#define _FECTABLE_H

/*
 * FEC and interleave related tables.
 */

int InterleavePattern[] =
{
#if 1				/* scrambled interleave */
	1,			/* 000000000000001 */
	16,			/* 000000000010000 */
	256,			/* 000000100000000 */
	4096,			/* 001000000000000 */
	2,			/* 000000000000010 */
	32,			/* 000000000100000 */
	512,			/* 000001000000000 */
	8192,			/* 010000000000000 */
	4,			/* 000000000000100 */
	64,			/* 000000001000000 */
	1024,			/* 000010000000000 */
	16384,			/* 100000000000000 */
	8,			/* 000000000001000 */
	128,			/* 000000010000000 */
	2048			/* 000100000000000 */
#else				/* linear interleave */
	1,			/* 000000000000001 */
	2,			/* 000000000000010 */
	4,			/* 000000000000100 */
	8,			/* 000000000001000 */
	16,			/* 000000000010000 */
	32,			/* 000000000100000 */
	64,			/* 000000001000000 */
	128,			/* 000000010000000 */
	256,			/* 000000100000000 */
	512,			/* 000001000000000 */
	1024,			/* 000010000000000 */
	2048,			/* 000100000000000 */
	4096,			/* 001000000000000 */
	8192,			/* 010000000000000 */
	16384			/* 100000000000000 */
#endif
};

unsigned int WalshTable[] =
{
	0x0000, 0x007F, 0x0787, 0x07F8, 0x1999, 0x19E6, 0x1E1E, 0x1E61,
	0x2AAA, 0x2AD5, 0x2D2D, 0x2D52, 0x3333, 0x334C, 0x34B4, 0x34CB,
	0x4B34, 0x4B4B, 0x4CB3, 0x4CCC, 0x52AD, 0x52D2, 0x552A, 0x5555,
	0x619E, 0x61E1, 0x6619, 0x6666, 0x7807, 0x7878, 0x7F80, 0x7FFF
};

unsigned int WHTable[] =
{
	0x3FFFFFFF, 0x15555555, 0x26666666, 0x0CCCCCCC,
	0x38787878, 0x12D2D2D2, 0x21E1E1E1, 0x0B4B4B4B,
	0x3F807F80, 0x152AD52A, 0x2619E619, 0x0CB34CB3,
	0x3807F807, 0x12AD52AD, 0x219E619E, 0x0B34CB34,
	0x3FFF8000, 0x15552AAA, 0x26661999, 0x0CCCB333,
	0x38780787, 0x12D2AD2D, 0x21E19E1E, 0x0B4B34B4,
	0x3F80007F, 0x152AAAD5, 0x261999E6, 0x0CB3334C,
	0x380787F8, 0x12AD2D52, 0x219E1E61, 0x0B34B4CB
};

int FEC1511EncodeTable[] =
{
	0x1800,			/* 001100000000000 */
	0x2800,			/* 010100000000000 */
	0x3000,			/* 011000000000000 */
	0x3800,			/* 011100000000000 */
	0x4800,			/* 100100000000000 */
	0x5000,			/* 101000000000000 */
	0x5800,			/* 101100000000000 */
	0x6000,			/* 110000000000000 */
	0x6800,			/* 110100000000000 */
	0x7000,			/* 111000000000000 */
	0x7800			/* 111100000000000 */
};

int FEC1511DecodeTable[] =
{
	0x0000,			/* 000000000000000 */
	0x0800,			/* 000100000000000 */
	0x1000,			/* 001000000000000 */
	0x0001,			/* 000000000000001 */
	0x2000,			/* 010000000000000 */
	0x0002,			/* 000000000000010 */
	0x0004,			/* 000000000000100 */
	0x0008,			/* 000000000001000 */
	0x4000,			/* 100000000000000 */
	0x0010,			/* 000000000010000 */
	0x0020,			/* 000000000100000 */
	0x0040,			/* 000000001000000 */
	0x0080,			/* 000000010000000 */
	0x0100,			/* 000000100000000 */
	0x0200,			/* 000001000000000 */
	0x0400			/* 000010000000000 */
};

#endif
