#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "conf.h"
#include "stardict.h"

// Notice: once you changed this file, try to change src/win32/winconf.cpp too.

AppConf::AppConf()
{	
	gconf_client = gconf_client_get_default ();
	if (gconf_client == NULL) {
		g_warning (_("Cannot connect to gconf."));
	}
	else {
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/dictionary/scan_selection", dictionary_scan_selection_changed_cb, NULL, NULL, NULL);
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/dictionary/only_scan_while_modifier_key", dictionary_only_scan_while_modifier_key_changed_cb, NULL, NULL, NULL);
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/dictionary/hide_floatwin_when_modifier_key_released", dictionary_hide_floatwin_when_modifier_key_released_changed_cb, NULL, NULL, NULL);
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/dictionary/scan_modifier_key", dictionary_scan_modifier_key_changed_cb, NULL, NULL, NULL);
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/dictionary/enable_sound_event", dictionary_enable_sound_event_changed_cb, NULL, NULL, NULL);
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/main_window/search_website_list", main_window_searchwebsite_list_changed_cb, NULL, NULL, NULL);
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/main_window/hide_list", main_window_hide_list_changed_cb, NULL, NULL, NULL);
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/notification_area_icon/query_in_floatwin", notification_area_icon_show_in_floatwin_changed_cb, NULL, NULL, NULL);
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/floating_window/pronounce_when_popup", floatwin_pronounce_when_popup_changed_cb, NULL, NULL, NULL);
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/floating_window/max_window_width", floatwin_max_window_width_changed_cb, NULL, NULL, NULL);
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/floating_window/max_window_height", floatwin_max_window_height_changed_cb, NULL, NULL, NULL);
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/floating_window/lock", floatwin_lock_changed_cb, NULL, NULL, NULL);
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/floating_window/lock_x", floatwin_lock_x_changed_cb, NULL, NULL, NULL);
		gconf_client_notify_add (gconf_client, "/apps/stardict/preferences/floating_window/lock_y", floatwin_lock_y_changed_cb, NULL, NULL, NULL);
	}
}

AppConf::~AppConf()
{
	if (!gconf_client)
		return;	
	g_object_unref (gconf_client);
}

void AppConf::EnableNotify()
{
	if (!gconf_client)
		return;
	gconf_client_add_dir(gconf_client, "/apps/stardict", GCONF_CLIENT_PRELOAD_RECURSIVE, NULL);
}

void AppConf::DisableNotify()
{
	if (!gconf_client)
		return;
	gconf_client_remove_dir(gconf_client, "/apps/stardict", NULL);
}

void AppConf::read_bool(const gchar *key, gboolean *val, gboolean def)
{
	if (!gconf_client)
		*val = def;
	else
		*val = gconf_client_get_bool(gconf_client, key, NULL);
}

void AppConf::write_bool(const gchar *key, gboolean val)
{
	if (!gconf_client)
		return;
	gconf_client_set_bool (gconf_client, key, val, NULL);
}

void AppConf::read_int(const gchar *key, gint *val ,gint def)
{
	if (!gconf_client)
		*val = def;
	else
		*val = gconf_client_get_int(gconf_client, key, NULL);
}

void AppConf::write_int(const gchar *key, gint val)
{
	if (!gconf_client)
		return;
	gconf_client_set_int (gconf_client, key, val, NULL);
}

void AppConf::read_string(const gchar *key, gchar **str)
{
	if (!gconf_client)
		*str = NULL;
	else
		*str = gconf_client_get_string(gconf_client, key, NULL);
}

void AppConf::write_string(const gchar *key, const gchar *str)
{
	if (!gconf_client)
		return;
	gconf_client_set_string (gconf_client, key, str, NULL);
}

void AppConf::read_list(const gchar *key, GConfValueType list_type, GSList **list)
{
	if (!gconf_client)
		*list = NULL;
	else
		*list = gconf_client_get_list(gconf_client, key, list_type, NULL);
}

void AppConf::write_list(const gchar *key, GConfValueType list_type, GSList *list)
{
	if (!gconf_client)
		return;
	gconf_client_set_list(gconf_client, key, list_type, list, NULL);
}

void AppConf::dictionary_scan_selection_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	GConfValue *value = gconf_entry_get_value (entry);
    
	gboolean scan = gconf_value_get_bool (value);
	gpAppFrame->oAppCore.oSelection.bEnable = scan;	
	gtk_widget_set_sensitive(gpAppFrame->oAppCore.oFloatWin.StopButton, scan);
	if 	(scan != gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gpAppFrame->oAppCore.oBottomWin.ScanSelectionCheckButton))) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gpAppFrame->oAppCore.oBottomWin.ScanSelectionCheckButton),scan);
		//although this make check button's callback func write to Gconf again,this callback will not be called again.
	}		
	if (scan) {
		if (!GTK_WIDGET_VISIBLE(gpAppFrame->oAppCore.window))
			gpAppFrame->oAppCore.oDockLet.SetIcon(DOCKLET_SCAN_ICON);
		if (gpAppFrame->oAppCore.oFloatWin.bIsLocked && (gpAppFrame->oAppCore.oFloatWin.QueryingWord.c_str())[0]!='\0')
			gpAppFrame->oAppCore.oFloatWin.Show();
	}
	else {
		if (!GTK_WIDGET_VISIBLE(gpAppFrame->oAppCore.window))
			gpAppFrame->oAppCore.oDockLet.SetIcon(DOCKLET_STOP_ICON);
		gpAppFrame->oAppCore.oFloatWin.Hide();
		gpAppFrame->oAppCore.oSelection.LastClipWord.clear();
	}
}

void AppConf::dictionary_only_scan_while_modifier_key_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	GConfValue *value = gconf_entry_get_value (entry);
    
	gpAppFrame->oAppCore.oSelection.only_scan_while_modifier_key = gconf_value_get_bool (value);
}

void AppConf::dictionary_hide_floatwin_when_modifier_key_released_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	GConfValue *value = gconf_entry_get_value (entry);
    
	gpAppFrame->oAppCore.oFloatWin.hide_floatwin_when_modifier_key_released = gconf_value_get_bool (value);
}

void AppConf::dictionary_scan_modifier_key_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	GConfValue *value = gconf_entry_get_value (entry);
    
	gpAppFrame->oAppCore.oSelection.scan_modifier_key = gconf_value_get_int (value);
}

void AppConf::dictionary_enable_sound_event_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	GConfValue *value = gconf_entry_get_value (entry);
    
	gpAppFrame->enable_sound_event = gconf_value_get_bool (value);
}

void AppConf::main_window_searchwebsite_list_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	g_slist_foreach (gpAppFrame->oAppCore.oBottomWin.searchwebsite_list, (GFunc)g_free, NULL);
	g_slist_free (gpAppFrame->oAppCore.oBottomWin.searchwebsite_list);
	gpAppFrame->oAppCore.oBottomWin.searchwebsite_list = NULL;
	GConfValue *value = gconf_entry_get_value (entry);
	GSList *list = gconf_value_get_list(value);
	while (list) {
		gpAppFrame->oAppCore.oBottomWin.searchwebsite_list = g_slist_append(gpAppFrame->oAppCore.oBottomWin.searchwebsite_list, g_strdup(gconf_value_get_string((GConfValue *)(list->data))));
		list = g_slist_next(list);
	}
}

void AppConf::main_window_hide_list_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	GConfValue *value = gconf_entry_get_value (entry);
    
	gboolean hide = gconf_value_get_bool (value);
	if (hide) {
		gtk_widget_hide(gpAppFrame->oAppCore.oMidWin.oToolWin.HideListButton);
		gtk_widget_show(gpAppFrame->oAppCore.oMidWin.oToolWin.ShowListButton);
		gtk_widget_hide(gpAppFrame->oAppCore.oMidWin.oIndexWin.vbox);
	}
	else {
		gtk_widget_hide(gpAppFrame->oAppCore.oMidWin.oToolWin.ShowListButton);
		gtk_widget_show(gpAppFrame->oAppCore.oMidWin.oToolWin.HideListButton);
		gtk_widget_show(gpAppFrame->oAppCore.oMidWin.oIndexWin.vbox);
	}
}

void AppConf::notification_area_icon_show_in_floatwin_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	GConfValue *value = gconf_entry_get_value (entry);
    
	gpAppFrame->oAppCore.oDockLet.query_in_floatwin = gconf_value_get_bool (value);
}

void AppConf::floatwin_max_window_width_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	GConfValue *value = gconf_entry_get_value (entry);
    
	gint width = gconf_value_get_int (value);
	gpAppFrame->oAppCore.oFloatWin.Window_max_width = width;
	// need to resize floating window when it is locked?
}

void AppConf::floatwin_pronounce_when_popup_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	GConfValue *value = gconf_entry_get_value (entry);
    
	gpAppFrame->oAppCore.oFloatWin.pronounce_when_popup = gconf_value_get_bool (value);
}

void AppConf::floatwin_max_window_height_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	GConfValue *value = gconf_entry_get_value (entry);
    
	gint height = gconf_value_get_int (value);
	gpAppFrame->oAppCore.oFloatWin.Window_max_height = height;
}

void AppConf::floatwin_lock_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	GConfValue *value = gconf_entry_get_value (entry);
    
	gboolean lock = gconf_value_get_bool (value);
	gpAppFrame->oAppCore.oFloatWin.bIsLocked = lock;
	if (lock)
		gtk_image_set_from_stock(GTK_IMAGE(gpAppFrame->oAppCore.oFloatWin.lock_image),GTK_STOCK_GOTO_LAST,GTK_ICON_SIZE_MENU);
	else
		gtk_image_set_from_stock(GTK_IMAGE(gpAppFrame->oAppCore.oFloatWin.lock_image),GTK_STOCK_GO_FORWARD,GTK_ICON_SIZE_MENU);
}

void AppConf::floatwin_lock_x_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	if (gpAppFrame->oAppCore.oFloatWin.bIsLocked)
	{
		GConfValue *value = gconf_entry_get_value (entry);    
		gint lock_x = gconf_value_get_int (value);

		gint old_x,old_y;
		gtk_window_get_position(GTK_WINDOW(gpAppFrame->oAppCore.oFloatWin.FloatWindow),&old_x,&old_y);
		if (lock_x!=old_x)
			gtk_window_move(GTK_WINDOW(gpAppFrame->oAppCore.oFloatWin.FloatWindow),lock_x,old_y);
	}
}

void AppConf::floatwin_lock_y_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data)
{
	if (gpAppFrame->oAppCore.oFloatWin.bIsLocked)
	{
		GConfValue *value = gconf_entry_get_value (entry);    
		gint lock_y = gconf_value_get_int (value);

		gint old_x,old_y;
		gtk_window_get_position(GTK_WINDOW(gpAppFrame->oAppCore.oFloatWin.FloatWindow),&old_x,&old_y);
		if (lock_y!=old_y)
			gtk_window_move(GTK_WINDOW(gpAppFrame->oAppCore.oFloatWin.FloatWindow),old_x,lock_y);
	}
}
