/*
Copyright (C) 2000 Liam Girdwood
Copyright (C) 2003 Fabien Chreau

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 

Some functions in this file use the VSOP87 solution by
Messrs. Bretagnon and Francou.

*/

#include <math.h>
#include "vsop87.h"
#include "misc_stellplanet.h"

#define LONG_L0 1409
#define LONG_L1 891
#define LONG_L2 442
#define LONG_L3 194
#define LONG_L4 75
#define LONG_L5 24
#define LAT_B0 441
#define LAT_B1 291
#define LAT_B2 161
#define LAT_B3 64
#define LAT_B4 18
#define LAT_B5 9
#define RADIUS_R0 1107
#define RADIUS_R1 672
#define RADIUS_R2 368
#define RADIUS_R3 160
#define RADIUS_R4 57
#define RADIUS_R5 17

static const struct vsop mars_longitude_l0[LONG_L0] = {
    {     6.20347711581,  0.00000000000,        0.00000000000}, 
    {     0.18656368093,  5.05037100270,     3340.61242669980}, 
    {     0.01108216816,  5.40099836344,     6681.22485339960}, 
    {     0.00091798406,  5.75478744667,    10021.83728009940}, 
    {     0.00027744987,  5.97049513147,        3.52311834900}, 
    {     0.00010610235,  2.93958560338,     2281.23049651060}, 
    {     0.00012315897,  0.84956094002,     2810.92146160520}, 
    {     0.00008926784,  4.15697846427,        0.01725365220}, 
    {     0.00008715691,  6.11005153139,    13362.44970679920}, 
    {     0.00006797556,  0.36462229657,      398.14900340820}, 
    {     0.00007774872,  3.33968761376,     5621.84292321040}, 
    {     0.00003575078,  1.66186505710,     2544.31441988340}, 
    {     0.00004161108,  0.22814971327,     2942.46342329160}, 
    {     0.00003075252,  0.85696614132,      191.44826611160}, 
    {     0.00002628117,  0.64806124465,     3337.08930835080}, 
    {     0.00002937546,  6.07893711402,        0.06731030280}, 
    {     0.00002389414,  5.03896442664,      796.29800681640}, 
    {     0.00002579844,  0.02996736156,     3344.13554504880}, 
    {     0.00001528141,  1.14979301996,     6151.53388830500}, 
    {     0.00001798806,  0.65634057445,      529.69096509460}, 
    {     0.00001264357,  3.62275122593,     5092.15195811580}, 
    {     0.00001286228,  3.06796065034,     2146.16541647520}, 
    {     0.00001546404,  2.91579701718,     1751.53953141600}, 
    {     0.00001024902,  3.69334099279,     8962.45534991020}, 
    {     0.00000891566,  0.18293837498,    16703.06213349900}, 
    {     0.00000858759,  2.40093811940,     2914.01423582380}, 
    {     0.00000832715,  2.46418619474,     3340.59517304760}, 
    {     0.00000832720,  4.49495782139,     3340.62968035200}, 
    {     0.00000712902,  3.66335473479,     1059.38193018920}, 
    {     0.00000748723,  3.82248614017,      155.42039943420}, 
    {     0.00000723861,  0.67497311481,     3738.76143010800}, 
    {     0.00000635548,  2.92182225127,     8432.76438481560}, 
    {     0.00000655162,  0.48864064125,     3127.31333126180}, 
    {     0.00000550474,  3.81001042328,        0.98032106820}, 
    {     0.00000552750,  4.47479317037,     1748.01641306700}, 
    {     0.00000425966,  0.55364317304,     6283.07584999140}, 
    {     0.00000415131,  0.49662285038,      213.29909543800}, 
    {     0.00000472167,  3.62547124025,     1194.44701022460}, 
    {     0.00000306551,  0.38052848348,     6684.74797174860}, 
    {     0.00000312141,  0.99853944405,     6677.70173505060}, 
    {     0.00000293198,  4.22131299634,       20.77539549240}, 
    {     0.00000302375,  4.48618007156,     3532.06069281140}, 
    {     0.00000274027,  0.54222167059,     3340.54511639700}, 
    {     0.00000281079,  5.88163521788,     1349.86740965880}, 
    {     0.00000231183,  1.28242156993,     3870.30339179440}, 
    {     0.00000283602,  5.76885434940,     3149.16416058820}, 
    {     0.00000236117,  5.75503217933,     3333.49887969900}, 
    {     0.00000274033,  0.13372524985,     3340.67973700260}, 
    {     0.00000299395,  2.78323740866,     6254.62666252360}, 
    {     0.00000204162,  2.82133445874,     1221.84856632140}, 
    {     0.00000238866,  5.37153646326,     4136.91043351620}, 
    {     0.00000188648,  1.49104066040,     9492.14631500480}, 
    {     0.00000221228,  3.50466812198,      382.89653222320}, 
    {     0.00000179196,  1.00561962003,      951.71840625060}, 
    {     0.00000172117,  0.43943649536,     5486.77784317500}, 
    {     0.00000193118,  3.35716641911,        3.59042865180}, 
    {     0.00000144304,  1.41874112114,      135.06508003540}, 
    {     0.00000160016,  3.94857092451,     4562.46099302120}, 
    {     0.00000174072,  2.41361337725,      553.56940284240}, 
    {     0.00000130989,  4.04491134956,    12303.06777661000}, 
    {     0.00000138243,  4.30145122848,        7.11354700080}, 
    {     0.00000128062,  1.80665816220,     5088.62883976680}, 
    {     0.00000139898,  3.32595559208,     2700.71514038580}, 
    {     0.00000128105,  2.20807538189,     1592.59601363280}, 
    {     0.00000116944,  3.12806863456,     7903.07341972100}, 
    {     0.00000110378,  1.05194545948,      242.72860397400}, 
    {     0.00000113481,  3.70070432339,     1589.07289528380}, 
    {     0.00000100099,  3.24340223714,    11773.37681151540}, 
    {     0.00000095594,  0.53950648295,    20043.67456019880}, 
    {     0.00000098947,  4.84558326403,     6681.24210705180}, 
    {     0.00000104542,  0.78532737699,     8827.39026987480}, 
    {     0.00000084186,  3.98971116025,     4399.99435688900}, 
    {     0.00000086928,  2.20183965407,    11243.68584642080}, 
    {     0.00000071438,  2.80307223477,     3185.19202726560}, 
    {     0.00000072095,  5.84669532401,     5884.92684658320}, 
    {     0.00000073482,  2.18421190324,     8429.24126646660}, 
    {     0.00000098946,  2.81481171439,     6681.20759974740}, 
    {     0.00000068413,  2.73834597183,     2288.34404351140}, 
    {     0.00000086747,  1.02091867465,     7079.37385680780}, 
    {     0.00000065316,  2.68114882713,       28.44918746780}, 
    {     0.00000083745,  3.20254912006,     4690.47983635860}, 
    {     0.00000075031,  0.76647765061,     6467.92575796160}, 
    {     0.00000068983,  3.76403440528,     6041.32756708560}, 
    {     0.00000066706,  0.73630288873,     3723.50895892300}, 
    {     0.00000063313,  4.52771850220,      426.59819087600}, 
    {     0.00000061684,  6.16831461502,     2274.11694950980}, 
    {     0.00000052260,  0.89938935091,     9623.68827669120}, 
    {     0.00000055485,  4.60622447136,     4292.33083295040}, 
    {     0.00000051331,  4.14823934301,     3341.59274776800}, 
    {     0.00000056633,  5.06250402329,       15.25247118500}, 
    {     0.00000063376,  0.91293637746,     3553.91152213780}, 
    {     0.00000045822,  0.78790300125,     1990.74501704100}, 
    {     0.00000048553,  3.95677994023,     4535.05943692440}, 
    {     0.00000041223,  6.02013764154,     3894.18182954220}, 
    {     0.00000041941,  3.58309124437,     8031.09226305840}, 
    {     0.00000056395,  1.68727941626,     6872.67311951120}, 
    {     0.00000055907,  3.46261441099,      263.08392337280}, 
    {     0.00000051677,  2.81307639242,     3339.63210563160}, 
    {     0.00000040669,  3.13838566327,     9595.23908922340}, 
    {     0.00000038111,  0.73396370751,    10025.36039844840}, 
    {     0.00000039498,  5.63225741360,     3097.88382272579}, 
    {     0.00000044175,  3.19530118759,     5628.95647021120}, 
    {     0.00000036718,  2.63750919104,      692.15760122680}, 
    {     0.00000045905,  0.28717581576,     5614.72937620960}, 
    {     0.00000038351,  5.82880639987,     3191.04922956520}, 
    {     0.00000038198,  2.34832438823,      162.46663613220}, 
    {     0.00000032561,  0.48401318272,     6681.29216370240}, 
    {     0.00000037135,  0.68510839331,     2818.03500860600}, 
    {     0.00000031169,  3.98160436995,       20.35531939880}, 
    {     0.00000032561,  0.89250965753,     6681.15754309680}, 
    {     0.00000037749,  4.15481250779,     2803.80791460440}, 
    {     0.00000033626,  6.11997987693,     6489.77658728800}, 
    {     0.00000029007,  2.42707198395,     3319.83703120740}, 
    {     0.00000038794,  1.35194224244,    10018.31416175040}, 
    {     0.00000033149,  1.14024195200,        5.52292430740}, 
    {     0.00000027583,  1.59721760699,     7210.91581849420}, 
    {     0.00000028699,  5.72047550940,     7477.52286021600}, 
    {     0.00000034039,  2.59525636978,    11769.85369316640}, 
    {     0.00000025380,  0.52092092633,       10.63666534980}, 
    {     0.00000026355,  1.34519007001,     3496.03282613400}, 
    {     0.00000024555,  4.00321315879,    11371.70468975820}, 
    {     0.00000025637,  0.24963503109,      522.57741809380}, 
    {     0.00000027275,  4.55649766071,     3361.38782219220}, 
    {     0.00000023766,  1.84063759173,    12832.75874170460}, 
    {     0.00000022814,  3.52628452806,     1648.44675719740}, 
    {     0.00000022272,  0.72111173236,      266.60704172180}, 
    {     0.00000021201,  3.11823578369,     2957.71589447660}, 
    {     0.00000020156,  3.67147308710,     1758.65307841680}, 
    {     0.00000021530,  6.15388673691,     3264.34635542420}, 
    {     0.00000020090,  1.08241387913,     7064.12138562280}, 
    {     0.00000021344,  4.28178434496,     4032.77002792660}, 
    {     0.00000027541,  6.08386421472,     6674.11130639880}, 
    {     0.00000019842,  2.37674123073,    10713.99488132620}, 
    {     0.00000025518,  3.43241978555,     3443.70520091840}, 
    {     0.00000022542,  5.64861441506,     2388.89402044920}, 
    {     0.00000024376,  0.97006548518,      632.78373931320}, 
    {     0.00000023079,  4.74990771219,     3347.72597370060}, 
    {     0.00000017708,  3.69743280195,     3344.20285535160}, 
    {     0.00000022658,  3.95447568336,     4989.05918389720}, 
    {     0.00000022600,  5.24085203262,     3205.54734666440}, 
    {     0.00000016811,  5.48619684184,        3.88133535800}, 
    {     0.00000018422,  4.22550249103,     2787.04302385740}, 
    {     0.00000022735,  4.98523942294,     7632.94325965020}, 
    {     0.00000016638,  2.52822534159,    14584.29827312060}, 
    {     0.00000020963,  4.27879531719,     5099.26550511660}, 
    {     0.00000016033,  1.76789519365,     3475.67750673520}, 
    {     0.00000015814,  3.13241857680,       59.37386191360}, 
    {     0.00000018113,  3.25756742113,     3337.02199804800}, 
    {     0.00000019295,  3.23912725911,        7.04623669800}, 
    {     0.00000016777,  4.39731653353,    15643.68020330980}, 
    {     0.00000017554,  4.09198247074,       74.78159856730}, 
    {     0.00000013713,  2.54103541653,     4933.20844033260}, 
    {     0.00000016007,  1.54673981973,    14054.60730802600}, 
    {     0.00000014603,  3.45689862899,     7373.38245462640}, 
    {     0.00000013547,  4.04141743525,     4929.68532198360}, 
    {     0.00000014222,  0.59967781578,       23.87843774780}, 
    {     0.00000013876,  5.40880274251,    10973.55568635000}, 
    {     0.00000014026,  1.44210504015,    10404.73381232260}, 
    {     0.00000016055,  3.79399064336,     2118.76386037840}, 
    {     0.00000013717,  3.59037690181,    15113.98923821520}, 
    {     0.00000018040,  4.25416134565,     2487.41604494780}, 
    {     0.00000015846,  0.56902641445,      103.09277421860}, 
    {     0.00000013402,  5.16918481175,    10213.28554621100}, 
    {     0.00000016068,  2.36894092837,     3265.83082813250}, 
    {     0.00000012773,  0.10474161940,     7234.79425624200}, 
    {     0.00000012197,  1.73028863618,       36.02786667740}, 
    {     0.00000012283,  5.19941258642,    10021.85453375160}, 
    {     0.00000011947,  5.47980574430,     2921.12778282460}, 
    {     0.00000011890,  4.76587196145,     5828.02847164760}, 
    {     0.00000012283,  3.16864076359,    10021.82002644720}, 
    {     0.00000013269,  6.17851484916,     1744.42598441520}, 
    {     0.00000011749,  5.72731481869,        0.42007609361}, 
    {     0.00000012340,  2.52148348822,     2906.90068882300}, 
    {     0.00000014458,  4.38011275876,      316.39186965660}, 
    {     0.00000010640,  3.44997335322,      639.89728631400}, 
    {     0.00000010925,  0.60402475795,     5085.03841111500}, 
    {     0.00000010646,  5.47663096745,      419.48464387520}, 
    {     0.00000010795,  1.37204952026,    10419.98628350760}, 
    {     0.00000010573,  1.09027262515,    12168.00269657460}, 
    {     0.00000009578,  4.89483638811,     3230.40610548040}, 
    {     0.00000009805,  5.83614893022,    14314.16811304980}, 
    {     0.00000009718,  0.00011311901,     9225.53927328300}, 
    {     0.00000009146,  1.10288559040,     9808.53818466140}, 
    {     0.00000009779,  3.60055224203,      206.18554843720}, 
    {     0.00000012732,  1.79880344270,    13745.34623902240}, 
    {     0.00000012156,  4.42292535673,    14712.31711645800}, 
    {     0.00000008805,  3.97132756722,      170.67287061920}, 
    {     0.00000010682,  4.33907151559,     7740.60678358880}, 
    {     0.00000010040,  1.38291942087,     3583.34103067380}, 
    {     0.00000009961,  2.69116597350,       36.60536530420}, 
    {     0.00000008473,  4.29275471153,        0.42988312670}, 
    {     0.00000010584,  0.89643083679,    23384.28698689860}, 
    {     0.00000009597,  4.33289499954,      131.54196168640}, 
    {     0.00000008477,  2.86885079661,     9381.93999378540}, 
    {     0.00000008436,  3.15234316178,     6525.80445396540}, 
    {     0.00000007518,  1.24474332957,     6894.52394883760}, 
    {     0.00000006746,  1.58828730801,     6836.64525283380}, 
    {     0.00000006722,  4.38897665506,       66.48740891440}, 
    {     0.00000006738,  5.77292945138,     5202.35827933520}, 
    {     0.00000006243,  1.57847357313,     3325.35995551480}, 
    {     0.00000008446,  2.90692880268,       43.71891230500}, 
    {     0.00000006482,  6.03333628981,      574.34479833480}, 
    {     0.00000006348,  0.06986409522,     1964.83862685400}, 
    {     0.00000006193,  5.43709781754,     1861.74585263540}, 
    {     0.00000008246,  0.44145777409,     2707.82868738660}, 
    {     0.00000005987,  4.22748552841,     4459.36821880260}, 
    {     0.00000006530,  1.24945509771,    12964.30070339100}, 
    {     0.00000005949,  0.77228459543,     2699.73481931760}, 
    {     0.00000007339,  4.95735130126,     3767.21061757580}, 
    {     0.00000006135,  3.16322568315,     6680.24453233140}, 
    {     0.00000006027,  3.01298246255,     3369.06161416760}, 
    {     0.00000005857,  4.30341888951,     7875.67186362420}, 
    {     0.00000006360,  1.77803516211,     2178.13772229200}, 
    {     0.00000005771,  0.96116030741,    13916.01910964160}, 
    {     0.00000006100,  4.49881794524,     6682.20517446780}, 
    {     0.00000005777,  4.92993290350,     2384.32327072920}, 
    {     0.00000007647,  6.16291591270,     6531.66165626500}, 
    {     0.00000007242,  0.52885257496,    10575.40668294180}, 
    {     0.00000005311,  4.51564606382,     6144.42034130420}, 
    {     0.00000005212,  3.49017198482,    12935.85151592320}, 
    {     0.00000006680,  3.48192412858,     1118.75579210280}, 
    {     0.00000005226,  3.25464016223,     2391.43681773000}, 
    {     0.00000005215,  0.01031380055,      533.21408344360}, 
    {     0.00000005534,  3.42311181658,     3134.42687826260}, 
    {     0.00000005437,  6.18510783147,     8425.65083781480}, 
    {     0.00000005774,  3.55189251089,     8969.56889691100}, 
    {     0.00000005093,  0.60862188744,     8955.34180290940}, 
    {     0.00000004840,  4.63233532160,     4569.57454002200}, 
    {     0.00000005828,  5.92311700172,      640.87760738220}, 
    {     0.00000005686,  0.76212811066,     3120.19978426100}, 
    {     0.00000004912,  1.70752765226,    13358.92658845020}, 
    {     0.00000005490,  4.29423846802,     3503.07906283200}, 
    {     0.00000004676,  3.34239248969,     3116.26763099790}, 
    {     0.00000005858,  2.38460385828,     3302.47939106200}, 
    {     0.00000005098,  1.12472834482,     5331.35744374080}, 
    {     0.00000004412,  1.38574902846,    17256.63153634140}, 
    {     0.00000004261,  1.69359026235,    13524.91634293140}, 
    {     0.00000004191,  0.19115182648,     9830.38901398780}, 
    {     0.00000004164,  0.43810126153,     1066.49547719000}, 
    {     0.00000005192,  3.63498024808,      536.80451209540}, 
    {     0.00000005664,  0.50444427941,     5305.45105355380}, 
    {     0.00000005477,  5.96812391483,     3074.00538497800}, 
    {     0.00000005303,  5.40010329848,     3355.86489788480}, 
    {     0.00000004043,  0.83846792979,    10021.90459040220}, 
    {     0.00000004153,  3.14489443759,     8439.87793181640}, 
    {     0.00000004818,  1.08987352671,    13365.97282514820}, 
    {     0.00000004906,  3.73076098617,     1228.96211332220}, 
    {     0.00000004577,  0.99356399425,     6158.64743530580}, 
    {     0.00000004244,  3.87048930395,     3312.16323923200}, 
    {     0.00000004895,  6.24828800623,    17654.78053974960}, 
    {     0.00000003595,  6.07310183986,    10818.13528691580}, 
    {     0.00000003756,  1.37897245496,     3973.39616601300}, 
    {     0.00000003550,  1.87497578775,    17395.21973472580}, 
    {     0.00000004422,  2.89970459985,     6247.51311552280}, 
    {     0.00000003974,  4.03444710872,     1052.26838318840}, 
    {     0.00000003488,  4.27354225380,     3178.14579056760}, 
    {     0.00000004466,  4.59168154738,     5518.75014899180}, 
    {     0.00000003504,  1.95078768847,    10177.25767953360}, 
    {     0.00000003545,  4.24640764495,     8329.67161059700}, 
    {     0.00000003300,  0.68858529246,      149.56319713460}, 
    {     0.00000003991,  5.80869405128,     6261.74020952440}, 
    {     0.00000003226,  3.90164588465,       27.40155609680}, 
    {     0.00000003390,  0.14332355443,    10014.72373309860}, 
    {     0.00000003375,  0.74696081381,     6048.44111408640}, 
    {     0.00000003093,  3.98501630391,     2648.45482547300}, 
    {     0.00000003822,  5.23989334866,     5724.93569742900}, 
    {     0.00000003026,  0.34307994694,      220.41264243880}, 
    {     0.00000004049,  1.24692090820,    10021.76996979660}, 
    {     0.00000002937,  0.73100893561,        2.75151061100}, 
    {     0.00000003084,  3.79912966727,      169.58018313300}, 
    {     0.00000004040,  2.91258206660,    22747.29071487440}, 
    {     0.00000003225,  0.92584522637,    16865.52876963120}, 
    {     0.00000003243,  4.90809670862,     6702.00024889200}, 
    {     0.00000002875,  1.47258377214,     3346.13535100720}, 
    {     0.00000003723,  0.49976277066,        1.48447270830}, 
    {     0.00000002799,  3.26685863564,     9168.64089834740}, 
    {     0.00000003345,  0.68842924327,     3863.18984479360}, 
    {     0.00000003441,  2.77691833127,     6660.44945790720}, 
    {     0.00000002795,  2.79655682319,    16858.48253293320}, 
    {     0.00000002706,  0.19204297927,     3237.51965248120}, 
    {     0.00000002719,  3.26623695003,     3914.95722503460}, 
    {     0.00000002941,  3.76174799212,     6784.31762761820}, 
    {     0.00000002703,  4.40716851372,     3415.39402526710}, 
    {     0.00000003071,  5.48172683108,     3335.08950239240}, 
    {     0.00000002706,  5.08478774948,     6688.33840040040}, 
    {     0.00000002606,  4.83038014027,     4672.66731424060}, 
    {     0.00000002892,  2.64043893512,     3320.25710730100}, 
    {     0.00000003089,  4.39622402117,     1332.05488754080}, 
    {     0.00000003440,  1.93696278155,    10551.52824519400}, 
    {     0.00000002744,  3.68787946756,     3603.69635007260}, 
    {     0.00000003424,  0.20932047468,     6604.95878212400}, 
    {     0.00000002507,  2.87961885832,    17924.91069982040}, 
    {     0.00000002697,  2.66891004390,    10184.30391623160}, 
    {     0.00000002454,  3.46791398294,     6298.32832117640}, 
    {     0.00000002379,  1.05700925037,     3607.21946842160}, 
    {     0.00000002377,  0.86177958347,     3351.24909204960}, 
    {     0.00000002568,  5.55935655242,     6546.15977336420}, 
    {     0.00000002303,  6.07222464974,     1214.73501932060}, 
    {     0.00000002381,  4.30392652519,     3360.96774609859}, 
    {     0.00000002907,  3.43885474942,     2693.60159338500}, 
    {     0.00000003097,  2.18292873348,    16173.37116840440}, 
    {     0.00000002547,  4.18352013454,     3546.79797513700}, 
    {     0.00000002990,  2.37498622349,    13517.87010623340}, 
    {     0.00000002512,  5.99302970150,     5729.50644714900}, 
    {     0.00000002193,  5.58483652772,      664.75604513000}, 
    {     0.00000002469,  2.81007799544,    15110.46611986620}, 
    {     0.00000002151,  3.59887716883,     6677.63442474780}, 
    {     0.00000002116,  4.57150032138,     6127.65545055720}, 
    {     0.00000002156,  3.35980735750,      589.06482700820}, 
    {     0.00000002260,  3.62776312745,     7799.98064550240}, 
    {     0.00000002155,  3.21566530565,    20199.09495963300}, 
    {     0.00000002708,  5.89397867482,     6438.49624942560}, 
    {     0.00000002202,  4.69968998758,    17277.40693183380}, 
    {     0.00000002130,  2.51819515600,     1545.35398297880}, 
    {     0.00000002103,  4.03662691701,     6684.81528205140}, 
    {     0.00000002248,  5.26146259988,     5618.31980486140}, 
    {     0.00000002112,  4.80366454046,     3657.00429635640}, 
    {     0.00000002265,  3.87400399340,      110.20632121940}, 
    {     0.00000002521,  4.21232150896,     2494.52959194860}, 
    {     0.00000002152,  4.59125527293,     5625.36604155940}, 
    {     0.00000002479,  6.10418212957,     3329.97576135000}, 
    {     0.00000001914,  1.21905589060,       21.85082932640}, 
    {     0.00000002334,  0.90610189054,      227.47613278900}, 
    {     0.00000001855,  2.03707389061,       56.89837493560}, 
    {     0.00000001886,  4.12578456390,     3399.98628861340}, 
    {     0.00000002271,  3.78991888381,     7910.18696672180}, 
    {     0.00000001868,  3.01921987575,     4885.96640967860}, 
    {     0.00000002137,  4.75111320702,    18984.29263000960}, 
    {     0.00000002035,  2.75110313856,      128.01884333740}, 
    {     0.00000001771,  2.73481849789,     6606.44325483230}, 
    {     0.00000001726,  1.70571826110,        6.68366387410}, 
    {     0.00000001723,  1.98182886520,      735.87651353180}, 
    {     0.00000001814,  0.92396194325,     4555.34744602040}, 
    {     0.00000001660,  3.07308780443,     1692.16566950240}, 
    {     0.00000002333,  5.05185695660,    20618.01935853360}, 
    {     0.00000001652,  3.86410092229,      699.27114822760}, 
    {     0.00000001891,  4.14097641151,     5459.37628707820}, 
    {     0.00000001686,  2.22936981446,    17085.95866572220}, 
    {     0.00000001687,  3.49824840147,     3347.65866339780}, 
    {     0.00000001910,  2.11485342979,     6816.28993343500}, 
    {     0.00000001921,  3.31155620445,     3333.56619000180}, 
    {     0.00000001613,  2.11892940835,      661.23292678100}, 
    {     0.00000001694,  4.88311110257,     3407.09983561420}, 
    {     0.00000001559,  3.51992273792,    13362.43245314700}, 
    {     0.00000002097,  1.78993763390,    20597.24396304120}, 
    {     0.00000001825,  1.14388611553,     2807.39834325620}, 
    {     0.00000001561,  0.80245519404,     3017.10701004240}, 
    {     0.00000001552,  2.66876908822,     3024.22055704320}, 
    {     0.00000002109,  1.48726552054,     2679.37949991880}, 
    {     0.00000001663,  4.39270692852,     8270.29774868340}, 
    {     0.00000001696,  2.09755814323,     2814.44457995420}, 
    {     0.00000001559,  5.55071673320,    13362.46696045140}, 
    {     0.00000001754,  5.90484178405,     3326.38533269820}, 
    {     0.00000001502,  4.34390071395,    13936.79450513400}, 
    {     0.00000001504,  0.83348536217,     4775.76008845920}, 
    {     0.00000001543,  5.82417981947,     3344.49376205780}, 
    {     0.00000001478,  2.50126974641,     2597.62236616720}, 
    {     0.00000001461,  1.42535404773,    15508.61512327440}, 
    {     0.00000001643,  2.88886926628,     8273.82086703240}, 
    {     0.00000001800,  5.17128754633,       38.13303563780}, 
    {     0.00000001526,  1.10269009104,     2675.85638156980}, 
    {     0.00000001439,  0.48780100962,       76.26607127560}, 
    {     0.00000001769,  2.18317522727,     2301.58581590939}, 
    {     0.00000001463,  4.62895146956,    19800.94595622480}, 
    {     0.00000001705,  2.60291826247,       29.42950853600}, 
    {     0.00000001834,  3.93003054205,     6843.69148953180}, 
    {     0.00000001444,  3.48342169961,     3281.23856478620}, 
    {     0.00000001480,  3.88768281039,     6034.21402008480}, 
    {     0.00000001466,  2.91823533164,    12722.55242048520}, 
    {     0.00000001822,  3.94166947995,    18454.60166491500}, 
    {     0.00000001353,  4.15009794282,     2284.75361485960}, 
    {     0.00000001351,  1.72199149037,    13760.59871020740}, 
    {     0.00000001399,  2.42873799629,      853.19638175200}, 
    {     0.00000001366,  4.69601766792,    11081.21921028860}, 
    {     0.00000001538,  3.23251536595,      156.40072050240}, 
    {     0.00000001353,  4.90776327224,     3304.58456002240}, 
    {     0.00000001500,  4.67389761397,      394.62588505920}, 
    {     0.00000001543,  1.13497135654,     3336.73109134180}, 
    {     0.00000001384,  2.90231400362,     1581.95934828300}, 
    {     0.00000001311,  6.21755182412,     2547.83753823240}, 
    {     0.00000001382,  2.56516714885,      568.82187402740}, 
    {     0.00000001618,  0.07569084986,     1435.14766175940}, 
    {     0.00000001369,  0.09025190060,     7895.95987272020}, 
    {     0.00000001333,  3.80019637725,    13119.72110282519}, 
    {     0.00000001261,  5.84659079053,       21.33564046700}, 
    {     0.00000001193,  5.90765698297,      187.92514776260}, 
    {     0.00000001275,  5.30143252989,     6571.01853218020}, 
    {     0.00000001497,  2.57685971474,      151.89728108520}, 
    {     0.00000001276,  4.09135399430,     4356.27544458400}, 
    {     0.00000001453,  5.91531419193,     3339.12795399150}, 
    {     0.00000001162,  0.00487534972,      799.82112516540}, 
    {     0.00000001349,  0.39390567783,     2540.79130153440}, 
    {     0.00000001150,  1.81037054423,      158.94351778320}, 
    {     0.00000001403,  4.89947045977,     4039.88357492740}, 
    {     0.00000001158,  4.15466681767,       14.22709400160}, 
    {     0.00000001176,  3.46488514917,     1015.66301788420}, 
    {     0.00000001134,  5.53830534094,    13553.89797291080}, 
    {     0.00000001114,  5.66112424924,     3760.09707057500}, 
    {     0.00000001281,  4.52342704978,     3929.67725370800}, 
    {     0.00000001497,  4.20879135724,    16460.33352952499}, 
    {     0.00000001123,  1.40353152800,    13149.15061136120}, 
    {     0.00000001250,  3.84843607877,     3980.50971301380}, 
    {     0.00000001077,  0.89381735251,     3340.19235060619}, 
    {     0.00000001103,  5.04474024110,    23141.55838292460}, 
    {     0.00000001189,  1.25182126092,    26724.89941359840}, 
    {     0.00000001248,  5.83629907704,     3344.54457996290}, 
    {     0.00000001044,  4.34142489533,     2277.70737816160}, 
    {     0.00000001453,  2.27428225289,      369.69981594040}, 
    {     0.00000001059,  6.24742453183,       17.81252211800}, 
    {     0.00000001148,  0.42674577851,      949.17560896980}, 
    {     0.00000001112,  4.31734784819,      107.66352393860}, 
    {     0.00000001125,  3.46005579971,     5732.04924442980}, 
    {     0.00000001084,  4.08902342726,      802.36392244620}, 
    {     0.00000001172,  0.31355227662,     1162.47470440780}, 
    {     0.00000001058,  1.34066539658,     2149.68853482420}, 
    {     0.00000000981,  3.44358391452,     9779.10867612540}, 
    {     0.00000001119,  5.22899579707,      194.97138446060}, 
    {     0.00000001134,  0.13581107839,    12566.15169998280}, 
    {     0.00000001173,  1.73082205622,     6923.95345737360}, 
    {     0.00000000962,  4.84602947327,     3510.19260983280}, 
    {     0.00000000985,  1.05143904982,    16335.83780453660}, 
    {     0.00000001181,  3.65780947036,     6456.88005769770}, 
    {     0.00000001299,  6.02281348454,     3316.73398895200}, 
    {     0.00000001015,  2.47380728164,       31.97230581680}, 
    {     0.00000000948,  5.10561095893,     8013.27974094040}, 
    {     0.00000000919,  1.56671162926,      111.18664228760}, 
    {     0.00000001029,  2.76318185375,     5938.23479286700}, 
    {     0.00000000998,  5.48784840152,    11236.57229942000}, 
    {     0.00000000914,  0.82061678315,     3364.49086444760}, 
    {     0.00000001106,  2.06839415041,     3376.64029337720}, 
    {     0.00000000945,  4.41350387633,      433.71173787680}, 
    {     0.00000000910,  1.70993881458,     2067.93140107260}, 
    {     0.00000000910,  1.91587519691,      401.67212175720}, 
    {     0.00000001044,  1.93180343226,       87.30820453981}, 
    {     0.00000000912,  1.58460936983,    10235.13637553740}, 
    {     0.00000000926,  4.61111147529,     5415.65737477320}, 
    {     0.00000001033,  3.98504680420,    10596.18207843420}, 
    {     0.00000000946,  0.21615391832,     9872.27408296480}, 
    {     0.00000000899,  5.27959763891,     7107.82304427560}, 
    {     0.00000000873,  1.86205822992,     2142.64229812620}, 
    {     0.00000000890,  1.81033031287,     2409.24933984800}, 
    {     0.00000001058,  3.63297698461,     7255.56965173440}, 
    {     0.00000000909,  4.37280779135,     1854.63230563460}, 
    {     0.00000000844,  3.82388337842,      272.67295735160}, 
    {     0.00000000836,  0.20464914442,    11766.26326451460}, 
    {     0.00000000827,  1.25878772256,    20206.14119633100}, 
    {     0.00000000821,  0.78875420945,     5621.82566955820}, 
    {     0.00000000819,  2.82232063108,     5621.86017686260}, 
    {     0.00000000828,  2.42897194573,       11.04570026390}, 
    {     0.00000000981,  0.44031295515,     1596.18644228460}, 
    {     0.00000000817,  4.64314240547,      127.95153303460}, 
    {     0.00000001022,  3.50167625373,     9866.41688066520}, 
    {     0.00000001074,  2.80026140417,     3077.52850332700}, 
    {     0.00000001080,  6.06529825187,     3341.03250279340}, 
    {     0.00000000802,  1.17242625138,     6460.81221096080}, 
    {     0.00000000798,  4.56887810023,     5223.69391980220}, 
    {     0.00000000791,  5.03144430516,        2.54279728080}, 
    {     0.00000000884,  1.71001393326,        3.93215326310}, 
    {     0.00000000817,  0.90060731147,     8646.06348025360}, 
    {     0.00000000799,  0.17886471821,    22743.40937951640}, 
    {     0.00000000849,  1.24576847048,    12295.95422960920}, 
    {     0.00000000773,  2.53367626112,     2295.45759051220}, 
    {     0.00000000916,  3.02582005756,     3377.21779200400}, 
    {     0.00000000780,  1.97862043128,     5408.54382777240}, 
    {     0.00000000956,  6.16353911929,     8542.97070603500}, 
    {     0.00000000779,  4.63070288733,     3341.04230982650}, 
    {     0.00000000738,  3.51171014997,    10020.85695903120}, 
    {     0.00000000957,  4.86437348833,      931.36308685180}, 
    {     0.00000000796,  4.54021772912,     1039.02661079040}, 
    {     0.00000000724,  3.92157470450,    12310.18132361080}, 
    {     0.00000000718,  3.34736041949,    11780.49035851620}, 
    {     0.00000000941,  3.58969556791,    23539.70738633280}, 
    {     0.00000000748,  5.61102387118,    16062.18452611680}, 
    {     0.00000000767,  3.25531932262,     3384.33133900480}, 
    {     0.00000000855,  1.12465641537,      206.70073729660}, 
    {     0.00000000815,  2.65362307845,     3169.93955608060}, 
    {     0.00000000734,  2.20279215450,      146.81168652360}, 
    {     0.00000000779,  2.32837877145,     3340.18254357310}, 
    {     0.00000000686,  1.51086318028,      792.77488846740}, 
    {     0.00000000740,  2.89753701512,     3296.89351439480}, 
    {     0.00000000677,  4.34039986096,     3877.41693879520}, 
    {     0.00000000673,  2.34948834397,        1.18064265210}, 
    {     0.00000000723,  3.56709112306,      485.97205278960}, 
    {     0.00000000669,  5.16867827323,    12721.57209941700}, 
    {     0.00000000719,  4.79573724239,     4142.97634914600}, 
    {     0.00000000699,  1.91837645169,     6665.97238221460}, 
    {     0.00000000684,  3.88501682634,      846.08283475120}, 
    {     0.00000000641,  2.07794469578,    16699.53901514999}, 
    {     0.00000000697,  0.30723442310,    19676.45023123640}, 
    {     0.00000000828,  1.59417806122,    16304.91313009080}, 
    {     0.00000000689,  4.64826053460,    11216.28429032400}, 
    {     0.00000000709,  5.04539574527,     3329.56672643590}, 
    {     0.00000000729,  2.24679589436,    11250.79939342160}, 
    {     0.00000000681,  2.72108869682,     6643.09181776180}, 
    {     0.00000000682,  1.76706935146,       51.28033786241}, 
    {     0.00000000635,  0.07420048628,       52.26031491280}, 
    {     0.00000000645,  4.31172593504,     3826.58447948940}, 
    {     0.00000000673,  3.60492040158,     1903.43681250120}, 
    {     0.00000000673,  0.13337381670,     8116.37251515900}, 
    {     0.00000000674,  1.26391848214,      142.17862703620}, 
    {     0.00000000816,  6.04643402652,    19402.79695281660}, 
    {     0.00000000625,  3.84990828302,        6.06591562980}, 
    {     0.00000000624,  1.64078988493,    24150.08005134500}, 
    {     0.00000000613,  5.74440327477,     6696.47732458460}, 
    {     0.00000000604,  3.24898351527,     9588.12554222260}, 
    {     0.00000000601,  4.99376091794,     8859.36257569160}, 
    {     0.00000000678,  1.94781152560,    12995.22537783680}, 
    {     0.00000000615,  4.95500687617,     9485.03276800400}, 
    {     0.00000000781,  2.85075231730,       29.49181830340}, 
    {     0.00000000601,  2.24121047241,    20735.83216142559}, 
    {     0.00000000589,  5.72063241021,     3113.13629391080}, 
    {     0.00000000759,  0.42525161329,     3873.82651014340}, 
    {     0.00000000652,  5.53661885979,     9065.54812412880}, 
    {     0.00000000605,  0.77544347078,     3342.09689940810}, 
    {     0.00000000703,  3.36009149285,     6709.67404086740}, 
    {     0.00000000626,  1.46111605834,    16706.58525184800}, 
    {     0.00000000568,  1.08932960976,     6357.71943674220}, 
    {     0.00000000568,  1.30798891510,     9499.25986200560}, 
    {     0.00000000582,  5.65932024956,     2171.02417529120}, 
    {     0.00000000737,  4.84794933747,    10022.81760116760}, 
    {     0.00000000565,  0.58744605626,    26084.02180621620}, 
    {     0.00000000549,  4.18021120562,      382.87927857100}, 
    {     0.00000000570,  0.04051046860,     6414.61781167780}, 
    {     0.00000000618,  3.84921117898,    16276.46394262300}, 
    {     0.00000000767,  1.15181496342,      377.37360791580}, 
    {     0.00000000562,  2.57704345512,       35.56273446860}, 
    {     0.00000000676,  5.60413511268,      155.35308913140}, 
    {     0.00000000554,  0.62822360284,     3189.56475685690}, 
    {     0.00000000626,  2.21709498761,     3274.12501778540}, 
    {     0.00000000683,  1.15851465970,      966.97087743560}, 
    {     0.00000000549,  0.54244199194,    13171.00144068760}, 
    {     0.00000000565,  1.60353804455,     3192.53370227350}, 
    {     0.00000000563,  0.10642400254,     5511.63660199100}, 
    {     0.00000000562,  2.66906118595,    19406.67828817460}, 
    {     0.00000000566,  3.11777455500,     2221.85663459700}, 
    {     0.00000000532,  3.77784810168,     7270.28968040780}, 
    {     0.00000000537,  0.41844932397,     1641.33321019660}, 
    {     0.00000000575,  5.48957773192,     2075.04494807340}, 
    {     0.00000000512,  1.61990907670,    13362.38239649640}, 
    {     0.00000000509,  4.21362121644,     7380.49600162720}, 
    {     0.00000000494,  2.13716209261,     2604.73591316800}, 
    {     0.00000000529,  1.03105540203,     1478.86657406440}, 
    {     0.00000000559,  1.47744587005,     8671.96987044060}, 
    {     0.00000000475,  2.07645966138,     5835.14201864840}, 
    {     0.00000000507,  3.25453549986,     1744.49329471800}, 
    {     0.00000000475,  1.46221578984,    12509.25332504720}, 
    {     0.00000000501,  5.92139594122,      685.04405422600}, 
    {     0.00000000463,  4.59237414506,    11670.28403729680}, 
    {     0.00000000461,  1.95536373356,     2412.77245819700}, 
    {     0.00000000463,  3.80428769716,    11140.59307220220}, 
    {     0.00000000519,  6.19362117590,     9602.35263622420}, 
    {     0.00000000461,  2.92759117395,     2277.29834324750}, 
    {     0.00000000457,  0.83633915073,     3041.48603243060}, 
    {     0.00000000496,  4.62773695339,     3723.49170527080}, 
    {     0.00000000521,  6.27578678705,     3981.49003408200}, 
    {     0.00000000631,  3.69227976878,     6475.03930496240}, 
    {     0.00000000488,  0.17334637032,    14158.74771361560}, 
    {     0.00000000467,  6.13582230228,     4825.54491639400}, 
    {     0.00000000516,  0.73887961022,     1265.56747862640}, 
    {     0.00000000484,  0.75989848136,     4407.10790388980}, 
    {     0.00000000573,  4.77672282988,     9380.95967271720}, 
    {     0.00000000441,  5.67433891123,     8958.93223156120}, 
    {     0.00000000503,  4.27904008262,     3472.15438838620}, 
    {     0.00000000441,  1.95128375492,     3226.21331978640}, 
    {     0.00000000571,  5.10229499953,     8564.30634650200}, 
    {     0.00000000571,  0.58988272178,     2766.26762836500}, 
    {     0.00000000487,  6.10031395897,     2285.16264977370}, 
    {     0.00000000446,  1.98916479068,    25685.87280280800}, 
    {     0.00000000430,  4.12851356192,       13.24177239800}, 
    {     0.00000000599,  2.01891079118,    27490.69247804480}, 
    {     0.00000000545,  0.84640347857,     4981.94563689640}, 
    {     0.00000000499,  4.26030358053,     6652.77566593180}, 
    {     0.00000000425,  3.83675473694,     1765.76662541760}, 
    {     0.00000000459,  3.04380861065,     5636.07001721200}, 
    {     0.00000000438,  0.55519461040,     9945.57120882380}, 
    {     0.00000000409,  3.25101264756,    18451.07854656599}, 
    {     0.00000000410,  1.71233327642,     7314.00859271280}, 
    {     0.00000000417,  1.76252798792,      956.28915597060}, 
    {     0.00000000426,  1.16443702315,    19004.64794940840}, 
    {     0.00000000405,  0.29370514941,     2810.93871525740}, 
    {     0.00000000405,  4.54611874389,     2810.90420795300}, 
    {     0.00000000512,  1.21144751675,    13362.51701710200}, 
    {     0.00000000417,  3.49097054443,     1655.56030419820}, 
    {     0.00000000406,  0.28183528199,     1375.77379984580}, 
    {     0.00000000415,  5.67120343816,       99.56965586960}, 
    {     0.00000000398,  1.32137621034,    20809.46762464520}, 
    {     0.00000000396,  0.51833007867,    13355.33615979840}, 
    {     0.00000000405,  5.63206130990,     3450.81874791920}, 
    {     0.00000000472,  5.94522815549,    48835.19385644859}, 
    {     0.00000000415,  3.61904227317,     2089.78223039900}, 
    {     0.00000000409,  4.59663901922,     6518.75821726740}, 
    {     0.00000000490,  4.38317065520,     2480.30249794700}, 
    {     0.00000000506,  4.89031028030,     8965.97846825920}, 
    {     0.00000000492,  1.65780779630,    22345.26037610820}, 
    {     0.00000000417,  3.45088938093,      279.78650435240}, 
    {     0.00000000381,  4.06210739923,    10124.93005431800}, 
    {     0.00000000431,  2.11881719623,       56.80326216980}, 
    {     0.00000000377,  0.05679239280,      905.45669666480}, 
    {     0.00000000373,  3.16212047027,      224.34479570190}, 
    {     0.00000000426,  2.66441427364,     4076.48894023160}, 
    {     0.00000000399,  5.15292207975,     5195.24473233440}, 
    {     0.00000000369,  5.28832560053,    10042.61267559180}, 
    {     0.00000000393,  2.28211201589,    13892.14067189380}, 
    {     0.00000000440,  0.33473783423,      515.46387109300}, 
    {     0.00000000489,  0.75769248875,     3561.02506913860}, 
    {     0.00000000389,  0.50283826584,     2825.14855560680}, 
    {     0.00000000366,  5.86243765418,     6675.70192909220}, 
    {     0.00000000433,  0.25560773454,     5625.77507647350}, 
    {     0.00000000455,  3.79309503535,     4996.17273089800}, 
    {     0.00000000437,  3.32741963621,     5617.91076994730}, 
    {     0.00000000496,  5.02750066477,       73.29712585900}, 
    {     0.00000000424,  3.60506282980,     8226.57883637840}, 
    {     0.00000000393,  3.15777926177,    10001.06188460700}, 
    {     0.00000000369,  2.84562486856,     2111.65031337760}, 
    {     0.00000000396,  4.52525609133,     4392.88080988820}, 
    {     0.00000000349,  5.02184920945,     5820.91492464680}, 
    {     0.00000000439,  4.25128498480,    18052.92954315780}, 
    {     0.00000000347,  0.75032574592,    15664.03552270859}, 
    {     0.00000000459,  3.22461221371,     2011.10033643980}, 
    {     0.00000000341,  3.22071023671,     4253.18267036540}, 
    {     0.00000000340,  4.12059603652,     6944.30877677240}, 
    {     0.00000000410,  4.83846706479,     8535.85715903420}, 
    {     0.00000000417,  2.58262243077,     5753.38488489680}, 
    {     0.00000000345,  1.85392358161,     6686.74777770700}, 
    {     0.00000000356,  2.35639379021,        4.57074972000}, 
    {     0.00000000454,  2.90957957919,      418.92439890060}, 
    {     0.00000000435,  5.42291154764,    26482.17080962440}, 
    {     0.00000000383,  4.06026489467,     1062.90504853820}, 
    {     0.00000000330,  4.04831945983,        3.10304225540}, 
    {     0.00000000458,  4.28564096349,      367.22432896240}, 
    {     0.00000000325,  3.98178390124,     1353.39052800780}, 
    {     0.00000000418,  3.22886388747,    21265.52312652020}, 
    {     0.00000000449,  4.37716659898,     5106.37905211740}, 
    {     0.00000000375,  1.09226403307,     4246.06912336460}, 
    {     0.00000000394,  2.27820129074,     3209.07046501340}, 
    {     0.00000000318,  4.97772911232,     5095.67507646480}, 
    {     0.00000000410,  2.45431083471,     6155.05700665400}, 
    {     0.00000000319,  4.05707815795,     5430.39465709880}, 
    {     0.00000000323,  0.90022769547,     7203.80227149340}, 
    {     0.00000000310,  5.46505496103,     6019.99192661860}, 
    {     0.00000000409,  6.07568936266,       50.83245930580}, 
    {     0.00000000337,  2.87052725998,    10610.90210710760}, 
    {     0.00000000377,  5.42225357427,     1190.92389187560}, 
    {     0.00000000301,  4.66690363477,     6756.00645196690}, 
    {     0.00000000343,  2.67442328942,     6148.01076995600}, 
    {     0.00000000309,  4.56269108847,     7483.58877584580}, 
    {     0.00000000310,  2.84658769828,     9654.61295113700}, 
    {     0.00000000296,  4.27095606776,     6740.59871531320}, 
    {     0.00000000310,  3.26584547245,      596.17837400900}, 
    {     0.00000000293,  2.76946559406,     3171.03224356680}, 
    {     0.00000000367,  3.93640995629,     1879.55837475340}, 
    {     0.00000000330,  3.29725079066,      286.96236112060}, 
    {     0.00000000305,  2.54608802445,    19513.98359510420}, 
    {     0.00000000312,  1.05107476595,     3490.17562383440}, 
    {     0.00000000294,  0.01906732590,      202.25339517410}, 
    {     0.00000000310,  4.37565854379,     2796.69436760360}, 
    {     0.00000000285,  3.43575683476,     6418.14093002680}, 
    {     0.00000000292,  4.39525256758,     6887.41040183680}, 
    {     0.00000000288,  5.43913988801,    10028.95082710020}, 
    {     0.00000000286,  5.76540114951,     5642.19824260920}, 
    {     0.00000000312,  4.12958202119,     1883.08149310240}, 
    {     0.00000000290,  4.07993947141,     5355.23588148860}, 
    {     0.00000000393,  3.01257302196,    10721.10842832700}, 
    {     0.00000000287,  2.36631839942,    29026.48522950779}, 
    {     0.00000000361,  0.54380501625,      290.48547946960}, 
    {     0.00000000318,  4.93375879729,     1197.97012857360}, 
    {     0.00000000299,  1.18299169304,      550.04628449340}, 
    {     0.00000000294,  6.16372005552,     8982.81066930900}, 
    {     0.00000000300,  4.29609104099,    21795.21409161479}, 
    {     0.00000000315,  2.67347587719,     3313.21087060300}, 
    {     0.00000000281,  0.27497384989,     8166.15734309380}, 
    {     0.00000000272,  5.94366381829,     9886.77220006400}, 
    {     0.00000000330,  3.11968019451,       41.55079098480}, 
    {     0.00000000275,  5.89019272375,     3337.86091608880}, 
    {     0.00000000275,  4.00268079943,     3620.39893105220}, 
    {     0.00000000329,  4.31857973778,     5989.06725217280}, 
    {     0.00000000292,  3.06830662617,        4.36203638980}, 
    {     0.00000000272,  5.11995514837,    22324.90505670940}, 
    {     0.00000000318,  0.02070112786,     2267.00340250900}, 
    {     0.00000000286,  0.46156470579,     5401.43028077160}, 
    {     0.00000000303,  0.59188658282,     9389.05354078620}, 
    {     0.00000000265,  0.63293390575,    23017.06265793620}, 
    {     0.00000000265,  2.08409828499,     3735.23831175900}, 
    {     0.00000000267,  1.69664388221,     3742.28454845700}, 
    {     0.00000000308,  3.03379923440,     6660.86953400080}, 
    {     0.00000000312,  3.62016422039,      255.97037637200}, 
    {     0.00000000264,  3.85932054425,    28628.33622609960}, 
    {     0.00000000278,  5.62033151570,     3378.74546233760}, 
    {     0.00000000257,  1.23480561014,       95.97922721780}, 
    {     0.00000000301,  0.83275594655,     2806.98930834210}, 
    {     0.00000000282,  2.29141606787,     2008.55753915900}, 
    {     0.00000000264,  3.78635346392,     3936.79080070880}, 
    {     0.00000000265,  0.50417611532,     6578.13207918100}, 
    {     0.00000000250,  5.58493858560,      412.37109687440}, 
    {     0.00000000284,  4.71065466690,     5621.91023351320}, 
    {     0.00000000289,  1.43840673306,     6947.83189512140}, 
    {     0.00000000286,  5.11854342112,     5621.77561290760}, 
    {     0.00000000311,  2.67810141537,      912.57024366560}, 
    {     0.00000000252,  4.19548440341,       24.85875881600}, 
    {     0.00000000247,  2.94199704738,      310.84079886840}, 
    {     0.00000000251,  0.32785126115,    19146.75926614180}, 
    {     0.00000000251,  5.76992035280,     5813.29118932200}, 
    {     0.00000000268,  0.19876672098,     6670.58818804980}, 
    {     0.00000000247,  2.28207487665,      246.25172232300}, 
    {     0.00000000283,  1.28593304651,     4025.65648092580}, 
    {     0.00000000257,  5.64140283929,    10706.88133432540}, 
    {     0.00000000252,  4.46420322691,     5490.30096152400}, 
    {     0.00000000246,  0.26910281348,       22.76849660940}, 
    {     0.00000000256,  5.68448606955,     3133.91168940320}, 
    {     0.00000000272,  1.28516397838,     1442.26120876020}, 
    {     0.00000000294,  4.02082336381,     2814.85361486830}, 
    {     0.00000000245,  2.94750517862,    21947.11137270000}, 
    {     0.00000000237,  4.99903725526,     1505.28780909299}, 
    {     0.00000000236,  6.05766331289,      948.19528790160}, 
    {     0.00000000238,  1.85846033178,     3193.80074017620}, 
    {     0.00000000237,  0.90339496046,        8.09386806900}, 
    {     0.00000000249,  6.05356563432,     2060.81785407180}, 
    {     0.00000000230,  1.40262306909,    23546.75362303080}, 
    {     0.00000000281,  0.30407184379,     5607.61582920880}, 
    {     0.00000000299,  2.73533927971,      176.69373013380}, 
    {     0.00000000237,  4.63093114141,     1612.95133303160}, 
    {     0.00000000263,  2.15420401346,     2973.38809773740}, 
    {     0.00000000275,  1.06902528779,     3343.36393731080}, 
    {     0.00000000277,  0.19619249083,      270.19747037360}, 
    {     0.00000000241,  4.97677402625,    31022.75317085620}, 
    {     0.00000000218,  0.03471394521,     9070.11887384880}, 
    {     0.00000000241,  2.53528698623,     3710.31224264020}, 
    {     0.00000000218,  5.17762855931,     6997.61672305620}, 
    {     0.00000000267,  4.64729465561,     1346.34429130980}, 
    {     0.00000000230,  5.16357138714,      721.13923120620}, 
    {     0.00000000214,  3.38620394418,      647.01083331480}, 
    {     0.00000000289,  3.43566105724,    25287.72379939980}, 
    {     0.00000000248,  3.03186441088,     3304.00706139560}, 
    {     0.00000000282,  0.29227105071,    12323.42309600880}, 
    {     0.00000000226,  5.75263123291,      604.84974070480}, 
    {     0.00000000213,  4.80572776287,     8830.91338822380}, 
    {     0.00000000259,  1.24817153777,     6691.86151874940}, 
    {     0.00000000216,  5.85803012117,     1971.95217385480}, 
    {     0.00000000214,  1.35475765206,      184.84990797020}, 
    {     0.00000000222,  3.47406655321,     6674.17861670160}, 
    {     0.00000000250,  4.55620402555,     6040.34724601740}, 
    {     0.00000000241,  0.94761695794,    17468.85519794540}, 
    {     0.00000000273,  1.89943168433,      270.13016007080}, 
    {     0.00000000205,  5.94913715412,     2942.48067694380}, 
    {     0.00000000214,  0.22905754741,        5.19919116580}, 
    {     0.00000000205,  3.91836540376,     2942.44616963940}, 
    {     0.00000000241,  5.92842548896,     4005.36847182980}, 
    {     0.00000000216,  3.20098680120,      362.12113673080}, 
    {     0.00000000204,  3.09570712832,     9947.05568153210}, 
    {     0.00000000219,  1.85183257276,     4782.87363546000}, 
    {     0.00000000210,  0.45868949920,    15106.87569121440}, 
    {     0.00000000271,  3.49210901141,     3436.59165391760}, 
    {     0.00000000226,  0.42945734871,      557.09252119140}, 
    {     0.00000000198,  5.62942060976,     5209.47182633600}, 
    {     0.00000000269,  5.03865822380,     2938.94030494260}, 
    {     0.00000000208,  6.03373357398,    22487.37169284160}, 
    {     0.00000000216,  4.28876710821,     2970.91261075940}, 
    {     0.00000000222,  1.25214260478,     3568.08855948880}, 
    {     0.00000000197,  4.80962358853,     6850.80503653260}, 
    {     0.00000000211,  1.05961421058,     6382.09845913040}, 
    {     0.00000000199,  3.49804400305,    15121.10278521600}, 
    {     0.00000000275,  4.22084628914,     8436.28750316460}, 
    {     0.00000000202,  0.88670673933,      767.84881934860}, 
    {     0.00000000245,  3.14677467834,    16063.16484718500}, 
    {     0.00000000192,  0.51567014493,      323.50541665740}, 
    {     0.00000000209,  4.79733900333,    14047.49376102520}, 
    {     0.00000000262,  4.69178300342,     6701.58017279840}, 
    {     0.00000000209,  1.46088434217,        5.85720229960}, 
    {     0.00000000188,  0.61341221354,     7366.26890762560}, 
    {     0.00000000192,  2.09213913721,      765.79306444640}, 
    {     0.00000000196,  4.08789826861,     3262.86188271590}, 
    {     0.00000000213,  2.31887239509,     2281.24775016280}, 
    {     0.00000000214,  5.33581887315,      955.24152459960}, 
    {     0.00000000251,  5.57906426342,      138.58819838440}, 
    {     0.00000000231,  1.11098737686,      625.67019231240}, 
    {     0.00000000208,  4.11481366408,     1755.06264976500}, 
    {     0.00000000210,  2.30499661227,       53.30794628380}, 
    {     0.00000000253,  1.27099771143,      309.27832265580}, 
    {     0.00000000186,  2.50511660467,    18606.49894600020}, 
    {     0.00000000242,  3.71426781541,     3212.59358336240}, 
    {     0.00000000185,  2.86917904253,     9374.82644678460}, 
    {     0.00000000198,  0.43937087541,     7586.68155006440}, 
    {     0.00000000178,  3.07093814833,     1437.17561419860}, 
    {     0.00000000231,  3.34379060819,     6364.83298374300}, 
    {     0.00000000203,  0.28410497046,      582.99891137840}, 
    {     0.00000000190,  0.10448075233,    26087.90314157420}, 
    {     0.00000000197,  3.57105788857,    24606.13555322000}, 
    {     0.00000000229,  2.56006283860,    24076.44458812540}, 
    {     0.00000000187,  3.45251088913,     1329.51209026000}, 
    {     0.00000000212,  0.29488451926,     2281.21324285840}, 
    {     0.00000000176,  5.81536979652,    12406.16055082860}, 
    {     0.00000000199,  0.07164714815,      375.76573157020}, 
    {     0.00000000191,  0.51430468358,     2125.87740737920}, 
    {     0.00000000184,  3.99855915315,    10018.24685144760}, 
    {     0.00000000231,  1.28492299616,     4427.39591298580}, 
    {     0.00000000173,  1.46081396432,     3362.46325602620}, 
    {     0.00000000174,  4.58412775833,     3283.71405176420}, 
    {     0.00000000182,  2.57146189845,      418.50432280700}, 
    {     0.00000000184,  4.63917400617,    10824.20120254560}, 
    {     0.00000000169,  5.12437031125,     3223.29255847960}, 
    {     0.00000000190,  3.43828283608,     5032.77809620220}, 
    {     0.00000000165,  1.47527516736,      249.90446074220}, 
    {     0.00000000202,  6.21085923485,     3909.43430072720}, 
    {     0.00000000164,  4.47908418685,     8799.98871377800}, 
    {     0.00000000171,  5.86158194602,      625.62513619720}, 
    {     0.00000000195,  3.22480570158,     2751.54759969160}, 
    {     0.00000000193,  1.20656620982,    15806.14683944200}, 
    {     0.00000000164,  4.23188531108,    31968.94865279940}, 
    {     0.00000000163,  2.04373367471,     3347.29609057390}, 
    {     0.00000000212,  2.32801113866,     3232.94890276120}, 
    {     0.00000000224,  2.39759251371,     8749.15625447220}, 
    {     0.00000000161,  2.94093367609,     3370.04193523580}, 
    {     0.00000000192,  4.62592622822,     3336.68027343670}, 
    {     0.00000000164,  1.59200641542,      386.41965057220}, 
    {     0.00000000169,  5.45784867095,      259.56080502380}, 
    {     0.00000000184,  3.30360346480,    11247.20896476980}, 
    {     0.00000000163,  1.16581070899,     4289.78803566960}, 
    {     0.00000000158,  0.91153814636,     4503.08713110760}, 
    {     0.00000000156,  5.57718582558,     1442.27846241240}, 
    {     0.00000000155,  2.48395345852,    20426.57109242200}, 
    {     0.00000000215,  3.82353334618,     1954.71715036360}, 
    {     0.00000000158,  4.12087712262,    11240.16272807180}, 
    {     0.00000000154,  4.56812026693,    27682.14074415640}, 
    {     0.00000000182,  1.47936413209,     6677.34351804160}, 
    {     0.00000000153,  5.85211234828,    23937.85638974100}, 
    {     0.00000000197,  1.43125106161,    14061.72085502680}, 
    {     0.00000000168,  5.27712266355,     3318.76159737340}, 
    {     0.00000000170,  4.32431856577,      742.99006053260}, 
    {     0.00000000156,  3.24340991358,     3002.36972771680}, 
    {     0.00000000154,  4.76648574446,    24889.57479599160}, 
    {     0.00000000184,  0.87903035084,     5244.04923920100}, 
    {     0.00000000160,  2.79762777586,     1461.05405194640}, 
    {     0.00000000157,  1.01090226288,    24336.00539314920}, 
    {     0.00000000151,  4.23962231229,     3368.01398279660}, 
    {     0.00000000149,  2.50000320687,    14591.41182012140}, 
    {     0.00000000149,  5.69212810600,    31570.79964939120}, 
    {     0.00000000154,  5.28504381510,     1481.40937134520}, 
    {     0.00000000145,  1.49366638853,     2619.47319549360}, 
    {     0.00000000146,  1.28090193252,     8584.66166590080}, 
    {     0.00000000145,  3.57053081019,     3497.01314720220}, 
    {     0.00000000201,  3.91480386992,     9638.94074787620}, 
    {     0.00000000144,  0.56695947743,    13212.88650966460}, 
    {     0.00000000156,  0.08293278006,     6657.34641565180}, 
    {     0.00000000150,  0.82077874373,    11456.98494185880}, 
    {     0.00000000146,  1.16474224600,      526.16784674560}, 
    {     0.00000000144,  4.19229336491,     2771.79055267240}, 
    {     0.00000000182,  4.43067332626,    10025.42770875120}, 
    {     0.00000000169,  3.10771037057,      239.20548562500}, 
    {     0.00000000144,  6.26624990824,     6679.74038069130}, 
    {     0.00000000174,  2.37509025321,     3397.51080163540}, 
    {     0.00000000142,  4.00086864568,    14481.20549890200}, 
    {     0.00000000165,  1.70220353716,     2185.25126929280}, 
    {     0.00000000192,  4.47709998867,       57.87869600380}, 
    {     0.00000000151,  5.49709199511,    11904.91877320180}, 
    {     0.00000000182,  6.16857594370,     6685.10618875760}, 
    {     0.00000000152,  4.93270110350,     9468.26787725700}, 
    {     0.00000000151,  3.06451266512,      838.96928775040}, 
    {     0.00000000141,  0.91584492689,    15636.56665630900}, 
    {     0.00000000160,  5.66327007211,    10927.29397676420}, 
    {     0.00000000187,  5.62698863872,    11353.89216764020}, 
    {     0.00000000159,  0.53628107560,    15906.76412668260}, 
    {     0.00000000165,  5.86999409810,    16703.07938715119}, 
    {     0.00000000136,  1.61461175096,    30065.51184029820}, 
    {     0.00000000157,  0.63167452131,     1538.24043597800}, 
    {     0.00000000173,  3.83431713222,     6621.85099148600}, 
    {     0.00000000169,  2.27408583150,      379.37341387420}, 
    {     0.00000000136,  2.80098629030,     4193.80880845180}, 
    {     0.00000000134,  5.77553038910,    14577.18472611980}, 
    {     0.00000000177,  5.21396471572,    34363.36559755600}, 
    {     0.00000000156,  0.81046067961,    29424.63423291600}, 
    {     0.00000000135,  5.88117502698,     2945.98654164060}, 
    {     0.00000000142,  1.70782247018,    11925.27409260060}, 
    {     0.00000000132,  3.74649075697,     6688.27109009760}, 
    {     0.00000000154,  4.78392600044,     3613.28538405140}, 
    {     0.00000000181,  3.31978654659,      139.69813952280}, 
    {     0.00000000133,  3.70318330169,    13635.12266415080}, 
    {     0.00000000147,  2.08632199273,    17101.21113690720}, 
    {     0.00000000132,  0.40901506100,     1083.26036793700}, 
    {     0.00000000178,  5.18401849357,    28230.18722269139}, 
    {     0.00000000156,  0.12304144640,     1107.13880568480}, 
    {     0.00000000158,  6.25020094434,     6666.99775939800}, 
    {     0.00000000148,  0.07274942285,     6283.09310364360}, 
    {     0.00000000138,  1.09470451313,     8962.43809625800}, 
    {     0.00000000130,  6.03956113045,     1214.80232962340}, 
    {     0.00000000145,  3.84248010172,    16703.04487984680}, 
    {     0.00000000129,  4.65674750252,     1957.72507985320}, 
    {     0.00000000127,  5.03662769208,    28109.21461605200}, 
    {     0.00000000146,  1.54074391924,     8219.46528937760}, 
    {     0.00000000145,  4.08755206418,     6684.73071809641}, 
    {     0.00000000137,  3.62229198429,     3511.28529731900}, 
    {     0.00000000126,  3.92743226458,        3.45580804620}, 
    {     0.00000000125,  3.20445201519,       29.88204361020}, 
    {     0.00000000125,  3.58832781647,     7696.88787128380}, 
    {     0.00000000138,  5.31757011300,    23958.63178523340}, 
    {     0.00000000149,  3.29977271138,    11614.43329373220}, 
    {     0.00000000172,  5.21222240408,     6747.71226231400}, 
    {     0.00000000138,  3.12547614420,     8962.47260356240}, 
    {     0.00000000127,  3.96217734145,     6314.00052443720}, 
    {     0.00000000133,  4.32704616146,     6283.05859633920}, 
    {     0.00000000156,  5.24742627708,     6645.19698672220}, 
    {     0.00000000137,  4.95496224789,    20995.39296644940}, 
    {     0.00000000123,  5.41075942033,      688.63448287780}, 
    {     0.00000000122,  0.61281570628,     5085.10572141780}, 
    {     0.00000000139,  1.85119959381,    18849.22754997420}, 
    {     0.00000000155,  5.47145482987,        2.96894541660}, 
    {     0.00000000161,  2.11502590852,    15265.88651930040}, 
    {     0.00000000157,  4.61532322282,     3354.83952070140}, 
    {     0.00000000155,  4.15655698197,       56.38318607620}, 
    {     0.00000000128,  6.24233081625,    10016.31435579200}, 
    {     0.00000000134,  1.53268827347,      708.98980227659}, 
    {     0.00000000121,  5.44493287062,    25665.51748340920}, 
    {     0.00000000120,  3.74478260598,    10294.51023745100}, 
    {     0.00000000144,  5.06033016445,    15010.89646399660}, 
    {     0.00000000122,  5.07352485901,    14421.83163698840}, 
    {     0.00000000152,  1.82416311596,    11560.07771607740}, 
    {     0.00000000118,  1.62305764022,    15849.86575174700}, 
    {     0.00000000145,  6.11832368347,     6684.76522540080}, 
    {     0.00000000120,  4.83459976273,     4403.51747523800}, 
    {     0.00000000122,  0.13513985090,     8322.55806359620}, 
    {     0.00000000128,  0.12650369318,     6681.64492949320}, 
    {     0.00000000142,  0.39408197652,     1111.64224510200}, 
    {     0.00000000119,  1.29925856056,    10544.41469819320}, 
    {     0.00000000147,  1.81590279650,      685.11136452880}, 
    {     0.00000000135,  5.17868224908,     8962.52266021300}, 
    {     0.00000000123,  2.42353206298,        6.13322593260}, 
    {     0.00000000149,  1.47957439553,     9698.33186344200}, 
    {     0.00000000116,  3.40455553212,    10001.48196070061}, 
    {     0.00000000115,  0.90208741613,    13286.18363552360}, 
    {     0.00000000119,  4.63501260300,    11776.89992986440}, 
    {     0.00000000137,  1.46004012882,     4819.47900076420}, 
    {     0.00000000116,  1.43745128638,     3547.31316399640}, 
    {     0.00000000117,  0.72489390402,       27.46886639960}, 
    {     0.00000000154,  5.62745874023,     9911.63095888000}, 
    {     0.00000000113,  1.29183528916,    26880.31981303260}, 
    {     0.00000000157,  0.09791378159,      138.51749687070}, 
    {     0.00000000113,  5.43102427558,      422.02744115600}, 
    {     0.00000000130,  2.13493506322,      117.81280289200}, 
    {     0.00000000140,  2.51194591630,       28.98162997940}, 
    {     0.00000000115,  1.17961745351,     4452.25467180180}, 
    {     0.00000000128,  1.23824324271,     6680.80477730600}, 
    {     0.00000000129,  2.41330294586,     6717.25272007700}, 
    {     0.00000000116,  4.93525830889,    13517.80279593060}, 
    {     0.00000000121,  2.20434813319,     3334.54651107000}, 
    {     0.00000000110,  0.69968732644,    18977.17908300880}, 
    {     0.00000000118,  4.93757907461,    12825.64519470380}, 
    {     0.00000000110,  4.11390197578,     6321.11407143800}, 
    {     0.00000000114,  4.30646265831,    21548.96236929180}, 
    {     0.00000000117,  0.03006245187,        7.67379197540}, 
    {     0.00000000132,  1.53814046048,     3391.89276456221}, 
    {     0.00000000123,  4.70578504377,     9329.67967887260}, 
    {     0.00000000140,  3.87360904038,     7167.19690618920}, 
    {     0.00000000110,  4.12727119156,     3188.71514561460}, 
    {     0.00000000131,  1.04432313302,     3482.79105373600}, 
    {     0.00000000114,  2.45724347193,     3351.65812696370}, 
    {     0.00000000108,  0.72637519191,       10.56935504700}, 
    {     0.00000000119,  4.19681704458,    12979.55317457600}, 
    {     0.00000000109,  5.22550826337,    21393.54196985760}, 
    {     0.00000000146,  5.31993935182,     2472.67876262220}, 
    {     0.00000000111,  3.28808788953,      257.01800774300}, 
    {     0.00000000109,  3.47791497885,     3305.04969223120}, 
    {     0.00000000134,  1.82746080392,    26887.36604973060}, 
    {     0.00000000149,  4.91688353237,      277.03499374140}, 
    {     0.00000000117,  1.20050006732,     6705.10329114740}, 
    {     0.00000000108,  3.37124346436,     6717.83021870380}, 
    {     0.00000000113,  4.04247516598,     6953.89781075120}, 
    {     0.00000000106,  4.69114208822,    25135.82651831460}, 
    {     0.00000000105,  5.59252457052,     8962.38803960740}, 
    {     0.00000000106,  0.75378922686,      149.89747512680}, 
    {     0.00000000136,  1.47344871836,     6830.78805053420}, 
    {     0.00000000146,  4.99523777859,     9859.37064396720}, 
    {     0.00000000115,  2.00719238904,    10654.62101941260}, 
    {     0.00000000108,  5.22204692781,     1556.56814695540}, 
    {     0.00000000104,  5.49558246627,     3344.15279870100}, 
    {     0.00000000120,  3.90242035384,     9758.75335672660}, 
    {     0.00000000111,  5.06419066567,    10042.19259949820}, 
    {     0.00000000133,  1.15811543786,      816.65332621520}, 
    {     0.00000000103,  0.57055162058,    10011.20061474960}, 
    {     0.00000000134,  1.69834857217,      183.86958690200}, 
    {     0.00000000104,  3.97743567679,    11567.19126307820}, 
    {     0.00000000104,  3.46480859433,     3344.11829139661}, 
    {     0.00000000103,  1.05016194417,     6682.70932610790}, 
    {     0.00000000122,  2.08787803990,     6533.14612897330}, 
    {     0.00000000107,  4.42117075795,        7.13080065300}, 
    {     0.00000000137,  4.91348844962,     3413.90955255880}, 
    {     0.00000000115,  0.02308044664,    13227.38462676380}, 
    {     0.00000000109,  1.17311653219,     6901.63749583840}, 
    {     0.00000000102,  1.20680146001,    11986.67590695340}, 
    {     0.00000000126,  0.03750399181,       16.83220104979}, 
    {     0.00000000102,  1.47123461557,    34513.26307268280}, 
    {     0.00000000130,  4.10484632841,       35.60779058380}, 
    {     0.00000000127,  2.51583917642,    12465.53441274220}, 
    {     0.00000000113,  3.69200525056,       44.65383324020}, 
    {     0.00000000111,  5.12900291511,      146.79443287140}, 
    {     0.00000000116,  5.24145745878,     8742.04270747140}, 
    {     0.00000000102,  2.41492657376,     3487.42411322340}, 
    {     0.00000000102,  0.15807862411,    27832.03821928320}, 
    {     0.00000000122,  6.08232879666,     7100.70949727480}, 
    {     0.00000000102,  3.19982560601,     5452.26274007740}, 
    {     0.00000000125,  2.16444546829,    13532.02988993220}, 
    {     0.00000000105,  2.07688407099,     4686.95671800959}, 
    {     0.00000000119,  0.56634104835,    31172.65064598300}, 
    {     0.00000000105,  6.16677691518,     9175.75444534820}, 
    {     0.00000000115,  1.08500262319,     4133.38731516720}, 
    {     0.00000000112,  0.20425429722,    11883.58313273480}, 
    {     0.00000000104,  0.51055185396,     7792.86709850160}, 
    {     0.00000000099,  1.81931026200,    20047.19767854780}, 
    {     0.00000000107,  4.86099911940,     7899.55030137200}, 
    {     0.00000000117,  0.62856768429,     4716.38622654560}, 
    {     0.00000000130,  2.23045717800,    10027.36020440680}, 
    {     0.00000000099,  0.25622969112,     8432.74713116340}, 
    {     0.00000000129,  4.77711241452,    11610.91017538320}, 
    {     0.00000000107,  5.25025570307,       63.73589830340}, 
    {     0.00000000100,  2.29065214131,     8432.78163846780}, 
    {     0.00000000114,  2.47914779702,    10156.90236013480}, 
    {     0.00000000126,  5.50643625731,     5483.25472482600}, 
    {     0.00000000110,  2.77977105247,    16066.06586147480}, 
    {     0.00000000109,  2.34881658192,     3376.17516116840}, 
    {     0.00000000097,  4.23431879636,     4186.69526145100}, 
    {     0.00000000112,  1.43537110436,    16232.74503031800}, 
    {     0.00000000117,  3.14652328036,     2921.68802779920}, 
    {     0.00000000104,  4.09017482677,     3337.07205469860}, 
    {     0.00000000102,  5.32025350615,     1868.85939963620}, 
    {     0.00000000105,  2.43029345740,     5888.44996493220}, 
    {     0.00000000112,  6.19134041529,     6685.15700666270}, 
    {     0.00000000097,  4.25558254516,     7906.59653807000}, 
    {     0.00000000131,  2.84046796960,     3370.10424500320}, 
    {     0.00000000104,  2.26093518585,     4845.90023579280}, 
    {     0.00000000114,  0.03194846170,    12729.66596748600}, 
    {     0.00000000095,  2.57050539743,    12715.43887348440}, 
    {     0.00000000096,  0.19715808883,    48429.28218232440}, 
    {     0.00000000095,  0.92069745429,     3338.06962941900}, 
    {     0.00000000105,  0.78873946610,     3416.87849797540}, 
    {     0.00000000096,  3.08847844722,     3468.63127003720}, 
    {     0.00000000096,  3.64475101106,    19669.33668423559}, 
    {     0.00000000099,  1.88513067598,    37895.42629036740}, 
    {     0.00000000126,  3.93261698226,    11346.77862063940}, 
    {     0.00000000095,  1.29341559946,     4878.85286267780}, 
    {     0.00000000122,  4.21983150256,     3308.64012088300}, 
    {     0.00000000099,  4.28251731179,    16328.72425753579}, 
    {     0.00000000127,  3.00977146208,     1250.83019630080}, 
    {     0.00000000120,  1.10081471750,     6530.17718355670}, 
    {     0.00000000117,  2.78340734359,     7075.85073845880}, 
    {     0.00000000119,  3.82073518708,     9072.66167112960}, 
    {     0.00000000095,  1.08015473076,     3590.51688744200}, 
    {     0.00000000104,  6.12094869404,     3337.10656200300}, 
    {     0.00000000091,  2.51770714335,     3535.58381116040}, 
    {     0.00000000095,  4.69142853355,     5298.33750655300}, 
    {     0.00000000095,  1.51222875950,     9801.42463766060}, 
    {     0.00000000102,  3.11721207691,     1125.86933910360}, 
    {     0.00000000122,  5.18912588487,     3181.66890891660}, 
    {     0.00000000099,  1.86991802881,       72.05573335480}, 
    {     0.00000000093,  1.46980370953,     3966.28261901220}, 
    {     0.00000000091,  4.93994845429,     8756.26980147300}, 
    {     0.00000000091,  2.11778022918,     6566.82574648620}, 
    {     0.00000000104,  2.01597245478,     4296.90158267040}, 
    {     0.00000000090,  4.19650336439,     3031.33410404400}, 
    {     0.00000000090,  5.86117667759,    17917.79715281959}, 
    {     0.00000000091,  6.19589151073,    24491.42579258340}, 
    {     0.00000000093,  0.66092443320,       30.99198474860}, 
    {     0.00000000090,  4.60989668841,     3253.30422216000}, 
    {     0.00000000111,  4.43458709473,     8771.00708379860}, 
    {     0.00000000088,  1.20181460611,     4606.17990532620}, 
    {     0.00000000101,  1.61358478291,    10032.47394544920}, 
    {     0.00000000094,  0.61277732908,       73.63546321960}, 
    {     0.00000000091,  6.04139177526,      153.92523352440}, 
    {     0.00000000096,  3.00553509047,     3528.53757446240}, 
    {     0.00000000093,  2.55257560859,    11663.17049029600}, 
    {     0.00000000087,  3.23609121022,    10191.41746323240}, 
    {     0.00000000092,  0.40307254912,    12410.73130054860}, 
    {     0.00000000091,  0.72417545511,     3152.68727893721}, 
    {     0.00000000090,  5.40526592844,     5749.86176654780}, 
    {     0.00000000086,  3.07517979536,     9983.70424446160}, 
    {     0.00000000114,  4.15078942938,     1795.25844372100}, 
    {     0.00000000096,  4.49946425864,    13465.54248101780}, 
    {     0.00000000095,  4.92419886101,    11876.46958573400}, 
    {     0.00000000086,  3.94463425808,       16.76489074700}, 
    {     0.00000000088,  4.79020600339,    10228.02282853660}, 
    {     0.00000000117,  3.33978190557,    14157.70008224460}, 
    {     0.00000000087,  0.65289292644,    44933.24935619040}, 
    {     0.00000000112,  1.79986032250,    16489.76303806100}, 
    {     0.00000000101,  2.99759769519,     6510.55198278040}, 
    {     0.00000000098,  2.43903528074,    20040.15144184979}, 
    {     0.00000000085,  5.85834792405,     4531.53631857540}, 
    {     0.00000000118,  6.10625309129,      454.90936652730}, 
    {     0.00000000085,  1.13150581276,     3185.25933756840}, 
    {     0.00000000084,  3.03267975707,    29822.78323632420}, 
    {     0.00000000087,  1.94797272973,    19645.52555679060}, 
    {     0.00000000086,  1.67944270491,    12839.87228870540}, 
    {     0.00000000087,  0.29179554470,     1008.54947088340}, 
    {     0.00000000090,  6.12668943416,     4106.40549114620}, 
    {     0.00000000091,  0.30519839929,    29168.59654624120}, 
    {     0.00000000098,  4.96605731070,    13738.21543836940}, 
    {     0.00000000108,  3.24595015647,     8976.68244391180}, 
    {     0.00000000087,  2.19665405981,    30774.50164257480}, 
    {     0.00000000083,  0.37254540738,     9755.23023837760}, 
    {     0.00000000084,  2.79617391142,    17932.02424682120}, 
    {     0.00000000082,  5.39440314476,     8034.61538140740}, 
    {     0.00000000087,  4.25461508452,        8.16813658240}, 
    {     0.00000000083,  3.59056707325,    12928.73796892240}, 
    {     0.00000000103,  5.10956502639,    10096.61887866670}, 
    {     0.00000000087,  2.90507350729,       36.99559061100}, 
    {     0.00000000086,  2.46839611271,      113.72943956840}, 
    {     0.00000000086,  5.94383601123,    12299.54465826100}, 
    {     0.00000000081,  4.34691999939,     7218.02936549500}, 
    {     0.00000000100,  2.70908218218,     8186.51266249260}, 
    {     0.00000000083,  4.79763505745,     4576.68808702280}, 
    {     0.00000000087,  3.71852499272,     4466.48176580340}, 
    {     0.00000000087,  2.22767593110,     7082.89697515680}, 
    {     0.00000000095,  0.02613500045,        2.90101428980}, 
    {     0.00000000098,  3.01731646220,     7417.10136693140}, 
    {     0.00000000103,  2.02932898904,    13575.74880223720}, 
    {     0.00000000112,  3.51920419851,    10081.21114201300}, 
    {     0.00000000081,  5.27347932531,    12306.59089495900}, 
    {     0.00000000080,  5.30097809145,    12199.97500239140}, 
    {     0.00000000085,  3.48487631448,    12082.65513417120}, 
    {     0.00000000081,  3.12811545216,     3517.30615683360}, 
    {     0.00000000083,  4.04362899636,     9815.65173166220}, 
    {     0.00000000105,  1.20537424840,      987.74627292800}, 
    {     0.00000000080,  2.75350306236,     4555.41475632320}, 
    {     0.00000000080,  5.76214145580,     2233.47362101500}, 
    {     0.00000000085,  0.77891047651,     7214.43893684320}, 
    {     0.00000000078,  5.77285430206,    10397.60301166960}, 
    {     0.00000000093,  5.04819365736,     4271.97551355160}, 
    {     0.00000000080,  1.47742659857,     4307.58330413540}, 
    {     0.00000000088,  3.84681925437,     3738.74417645580}, 
    {     0.00000000104,  3.22519800674,     4922.57177498280}, 
    {     0.00000000078,  5.05074461881,     8006.16619393960}, 
    {     0.00000000080,  4.13191548311,    30376.35263916660}, 
    {     0.00000000084,  2.20622406791,    13421.82356871280}, 
    {     0.00000000082,  3.11747431441,     8446.99147881720}, 
    {     0.00000000080,  0.71562475799,    33561.54466643220}, 
    {     0.00000000100,  3.58742182292,    45884.96776244100}, 
    {     0.00000000080,  2.55223452516,     3866.78027344540}, 
    {     0.00000000075,  0.83023725236,     4936.79886898440}, 
    {     0.00000000092,  5.55183329656,    21150.81336588360}, 
    {     0.00000000105,  1.74376904536,       36.64856292950}, 
    {     0.00000000078,  4.23158542581,    16858.41522263039}, 
    {     0.00000000092,  2.67278833504,     6680.79497027290}, 
    {     0.00000000084,  4.21345200999,    12032.93761653920}, 
    {     0.00000000079,  3.55634560374,    14867.73751589219}, 
    {     0.00000000077,  0.10707484151,     1371.41176345600}, 
    {     0.00000000099,  3.94316594852,    18208.34994259200}, 
    {     0.00000000074,  5.76839140325,    34911.41207609100}, 
    {     0.00000000079,  0.45356515278,     6677.71898870279}, 
    {     0.00000000086,  0.54257145537,    14128.24277124560}, 
    {     0.00000000073,  3.43102571889,    11037.50029798360}, 
    {     0.00000000073,  0.23508569170,    12942.96506292400}, 
    {     0.00000000081,  3.50070907013,     6637.50594109460}, 
    {     0.00000000073,  5.80611062016,     6791.43117461900}, 
    {     0.00000000079,  3.78666386040,        7.57867920960}, 
    {     0.00000000096,  0.94977866466,     2735.76268599500}, 
    {     0.00000000092,  5.05270450333,     7064.10413197060}, 
    {     0.00000000080,  1.94954501782,    19190.47817844680}, 
    {     0.00000000093,  4.61161625562,    11375.22780810720}, 
    {     0.00000000091,  0.62128517647,     1859.20305535460}, 
    {     0.00000000073,  4.42902162523,       14.73728232560}, 
    {     0.00000000091,  5.90153724443,     3738.77868376020}, 
    {     0.00000000085,  0.92387511094,     8425.71814811760}, 
    {     0.00000000094,  3.41238195399,     1596.11913198180}, 
    {     0.00000000084,  1.35940497722,     1727.66109366820}, 
    {     0.00000000073,  2.87019851630,     2854.64037391020}, 
    {     0.00000000078,  4.35635552621,    15650.79375031060}, 
    {     0.00000000077,  2.71108340360,    12089.76868117200}, 
    {     0.00000000081,  2.92874448709,     9093.99731159660}, 
    {     0.00000000077,  3.69143222544,     2961.23901282560}, 
    {     0.00000000079,  4.70597882671,     6677.68448139840}, 
    {     0.00000000078,  2.21525148730,     2810.98877190800}, 
    {     0.00000000085,  5.81355746707,    13369.56325380000}, 
    {     0.00000000088,  1.38044467337,     3145.64104223920}, 
    {     0.00000000071,  4.04186021414,      259.49349472100}, 
    {     0.00000000071,  5.32626176411,     6670.17915313570}, 
    {     0.00000000073,  4.81618807315,    12140.60114047780}, 
    {     0.00000000090,  5.84168246420,     3492.50970778500}, 
    {     0.00000000072,  1.58795997168,     3738.69411980520}, 
    {     0.00000000071,  3.73621908569,    35309.56107949920}, 
    {     0.00000000081,  2.48353174238,       73.60095591520}, 
    {     0.00000000070,  3.89351336867,    10014.79104340140}, 
    {     0.00000000075,  6.00708764619,     3288.35211178700}, 
    {     0.00000000078,  4.75144277168,    13366.04013545100}, 
    {     0.00000000070,  1.16428742272,     5220.17080145320}, 
    {     0.00000000084,  5.83220387910,       22.37827130260}, 
    {     0.00000000076,  3.61279198710,    21791.69097326579}, 
    {     0.00000000074,  5.66626331970,     9360.60435331840}, 
    {     0.00000000070,  4.40324083193,     3890.65871119319}, 
    {     0.00000000071,  4.00935897397,     5525.86369599260}, 
    {     0.00000000068,  4.88746021930,     4379.63903749020}, 
    {     0.00000000080,  4.01817623709,     3311.18291816379}, 
    {     0.00000000089,  5.76998389711,     1484.93248969420}, 
    {     0.00000000068,  3.48229080099,     5562.46906129680}, 
    {     0.00000000071,  2.51223960753,     1747.60737815290}, 
    {     0.00000000070,  5.68783910757,    10448.43547097540}, 
    {     0.00000000092,  4.97511245092,     6681.65473652630}, 
    {     0.00000000082,  1.81441052191,    10288.44432182120}, 
    {     0.00000000070,  5.21095521076,    13363.43002786740}, 
    {     0.00000000078,  2.62374787415,     2810.85415130240}, 
    {     0.00000000068,  2.09958151441,    10264.56588407340}, 
    {     0.00000000067,  4.76413431634,     6812.76681508600}, 
    {     0.00000000068,  3.88516811058,    13207.02930736500}, 
    {     0.00000000069,  3.25036054417,     3564.95722240170}, 
    {     0.00000000067,  1.84261705009,    27433.88921587499}, 
    {     0.00000000066,  0.33678070136,     7322.10246078180}, 
    {     0.00000000081,  4.91537623846,     3333.92876282570}, 
    {     0.00000000078,  4.25365984833,    19617.07636932279}, 
    {     0.00000000073,  5.81831824202,     8823.86715152580}, 
    {     0.00000000074,  0.86013387580,    16695.94858649819}, 
    {     0.00000000088,  2.96961623260,     9278.84721956680}, 
    {     0.00000000065,  3.50464480159,     9161.52735134660}, 
    {     0.00000000071,  0.93609590112,     6106.88005506480}, 
    {     0.00000000065,  4.90073827871,     3468.56395973440}, 
    {     0.00000000087,  3.82266177250,     1236.07566032300}, 
    {     0.00000000065,  6.18524090914,     7447.01791784600}, 
    {     0.00000000075,  2.55878565800,     6614.73744448520}, 
    {     0.00000000074,  5.71066387461,    10177.19036923080}, 
    {     0.00000000068,  5.87307358517,    25827.98411954140}, 
    {     0.00000000069,  1.10040460862,     2544.33167353560}, 
    {     0.00000000063,  6.05841287869,     6453.74872061060}, 
    {     0.00000000063,  5.33982712678,    21427.98976265240}, 
    {     0.00000000066,  0.61216028778,     7636.46637799920}, 
    {     0.00000000062,  2.80917285403,    13497.51478683460}, 
    {     0.00000000069,  2.67029728661,     2641.34127847220}, 
    {     0.00000000068,  2.81149937170,    11527.12508919240}, 
    {     0.00000000073,  3.87202159748,    13361.46938573100}, 
    {     0.00000000061,  4.18998708823,    16547.64173406480}, 
    {     0.00000000060,  2.68408219587,     5349.16996585880}, 
    {     0.00000000070,  2.35679546987,    34115.11406927460}, 
    {     0.00000000062,  5.49002675720,     4957.08687808040}, 
    {     0.00000000059,  5.80950485486,   104351.61256629678}, 
    {     0.00000000069,  2.30347059296,    97670.38771289718}, 
    {     0.00000000069,  6.04860680134,     1755.47168467910}, 
    {     0.00000000072,  3.38857910365,     3184.21170619740}, 
    {     0.00000000071,  4.22665032671,     7321.12213971360}, 
    {     0.00000000068,  5.51088021361,    10338.22914975600}, 
    {     0.00000000069,  5.35281824747,     2544.29716623120}, 
    {     0.00000000058,  4.61544075896,     9993.38809263160}, 
    {     0.00000000063,  1.78218487848,     3212.66089366520}, 
    {     0.00000000062,  1.91794313526,    33406.12426699800}, 
    {     0.00000000059,  2.33104573300,    16762.43599541260}, 
    {     0.00000000060,  6.18449904435,     3361.94806716680}, 
    {     0.00000000071,  2.67980129538,    37455.72649597440}, 
    {     0.00000000057,  4.30790872161,     2281.29780681340}, 
    {     0.00000000061,  4.47177526691,    14164.81362924540}, 
    {     0.00000000070,  5.09917701225,    14556.89671702380}, 
    {     0.00000000057,  6.03596769323,     9153.90361602180}, 
    {     0.00000000068,  3.42411140913,    13287.66810823190}, 
    {     0.00000000065,  4.21643739347,    24341.52831745660}, 
    {     0.00000000061,  3.70644708708,    27299.24421193320}, 
    {     0.00000000064,  3.44679554408,     9705.44541044280}, 
    {     0.00000000059,  4.29916130935,     6851.89772401880}, 
    {     0.00000000071,  0.81330027413,     3495.96551583120}, 
    {     0.00000000055,  2.02448369373,    12012.58229714040}, 
    {     0.00000000064,  6.21854445626,    20043.69181385099}, 
    {     0.00000000057,  1.65488419713,     7768.00833968560}, 
    {     0.00000000071,  0.81484322638,     9918.74450588080}, 
    {     0.00000000056,  1.69730662572,     6534.41316687600}, 
    {     0.00000000056,  2.10021276669,    16702.99482319620}, 
    {     0.00000000054,  4.52069302724,     9797.49248439750}, 
    {     0.00000000054,  3.66018591555,     2917.53735417280}, 
    {     0.00000000054,  3.61023908440,     6724.94376570460}, 
    {     0.00000000065,  3.83143101879,     8373.39052290200}, 
    {     0.00000000055,  4.76564251752,     7733.49323658800}, 
    {     0.00000000061,  0.71894031750,    27873.58901026800}, 
    {     0.00000000060,  4.47151385540,    10284.92120347220}, 
    {     0.00000000059,  5.00684013554,      299.12639426920}, 
    {     0.00000000055,  4.47014622234,    10661.73456641340}, 
    {     0.00000000060,  4.79529219015,     8638.94993325280}, 
    {     0.00000000057,  0.60812343267,     4665.55376723980}, 
    {     0.00000000055,  4.98558072531,     4061.75165790600}, 
    {     0.00000000053,  3.30259294876,     9683.59458111640}, 
    {     0.00000000053,  4.65521663752,     3448.27595063840}, 
    {     0.00000000054,  5.25292379440,     8550.08425303580}, 
    {     0.00000000062,  2.59467816822,     8852.24902869080}, 
    {     0.00000000067,  1.52249437123,    16342.95135153740}, 
    {     0.00000000056,  1.69180472887,    16703.12944380180}, 
    {     0.00000000068,  3.15995596850,     7807.09419250320}, 
    {     0.00000000052,  2.92990649723,     9495.66943335380}, 
    {     0.00000000062,  5.25598366940,     2963.23881878400}, 
    {     0.00000000057,  0.28187782188,     4558.93787467220}, 
    {     0.00000000059,  0.28351688317,     4565.98411137020}, 
    {     0.00000000058,  0.47150770624,     4140.43355186520}, 
    {     0.00000000052,  2.67305259324,    19247.37655338240}, 
    {     0.00000000061,  4.33806308874,     8695.84830818840}, 
    {     0.00000000071,  1.01873280870,     7668.97112632760}, 
    {     0.00000000056,  2.06509121766,    12502.13977804640}, 
    {     0.00000000051,  6.03668121035,     6719.35788903740}, 
    {     0.00000000060,  0.77450277046,     3319.27678623280}, 
    {     0.00000000051,  3.92795812352,     3353.85419909779}, 
    {     0.00000000051,  2.89873872410,    22854.59602180400}, 
    {     0.00000000051,  2.00779962852,     2957.73314812880}, 
    {     0.00000000053,  5.07857417426,    14951.52260208300}, 
    {     0.00000000064,  1.36079827459,    23024.17620493700}, 
    {     0.00000000053,  3.57183813569,     6836.57794253100}, 
    {     0.00000000051,  1.95411630686,     3327.37065430180}, 
    {     0.00000000050,  0.37366902916,     3322.79990458180}, 
    {     0.00000000053,  0.26142839753,    41990.78593289880}, 
    {     0.00000000054,  6.27949370995,    35707.71008290740}, 
    {     0.00000000049,  0.06709673316,    10787.63034454580}, 
    {     0.00000000051,  2.54863900486,     4001.84535348080}, 
    {     0.00000000053,  1.18631858606,    34554.81386366760}, 
    {     0.00000000048,  4.04972593744,      114.39910691340}, 
    {     0.00000000049,  0.32920934850,    41748.05732892480}, 
    {     0.00000000048,  2.81171553545,     3372.58473251660}, 
    {     0.00000000061,  1.00871506195,    16511.61386738740}, 
    {     0.00000000053,  3.71538403834,    10050.28646756720}, 
    {     0.00000000047,  4.46160440369,     6151.51663465280}, 
    {     0.00000000048,  1.63487940392,    20213.25474333179}, 
    {     0.00000000051,  3.56556636385,    19403.77727388480}, 
    {     0.00000000054,  0.78070691021,    41194.48792608240}, 
    {     0.00000000047,  6.10253848179,    10037.08975128440}, 
    {     0.00000000050,  1.45609883704,     3717.98603461560}, 
    {     0.00000000050,  5.05658775146,     4694.00295470760}, 
    {     0.00000000063,  5.78355830951,     9090.47419324760}, 
    {     0.00000000050,  3.75626474913,     3987.62326001460}, 
    {     0.00000000047,  2.91658062679,     9488.62319665580}, 
    {     0.00000000046,  2.69392312363,    17232.75309859360}, 
    {     0.00000000055,  5.61673764413,    45494.58142974879}, 
    {     0.00000000046,  3.66390779389,    14955.04572043200}, 
    {     0.00000000046,  4.56516015922,    20199.02764933019}, 
    {     0.00000000054,  4.71237273616,     2281.16318620780}, 
    {     0.00000000047,  1.67898138956,     3130.83644961080}, 
    {     0.00000000054,  4.28556627685,     2910.49111747480}, 
    {     0.00000000048,  0.72250964740,    18617.06830104720}, 
    {     0.00000000045,  2.28393936160,    22986.13798349040}, 
    {     0.00000000049,  2.14605615000,    19830.37546476080}, 
    {     0.00000000047,  4.12536462391,    23009.94911093539}, 
    {     0.00000000049,  5.16525026592,     3774.32416457660}, 
    {     0.00000000045,  3.89882558892,    12988.11183083600}, 
    {     0.00000000048,  4.74927850843,      529.67371144240}, 
    {     0.00000000055,  4.19502260708,    20043.65730654660}, 
    {     0.00000000057,  1.14903860224,     7747.72033058960}, 
    {     0.00000000044,  0.79186614799,    26357.67508463600}, 
    {     0.00000000044,  3.13459824792,    13951.51453380740}, 
    {     0.00000000043,  2.23439626313,     1987.22189869200}, 
    {     0.00000000058,  2.28159262648,    10006.58480891440}, 
    {     0.00000000046,  0.16036583144,    18763.87998757080}, 
    {     0.00000000045,  1.72302046270,    17402.33328172660}, 
    {     0.00000000043,  5.75831854990,    25298.29315444680}, 
    {     0.00000000047,  5.27437932280,      423.07507252700}, 
    {     0.00000000060,  3.50233382826,     6511.64467026660}, 
    {     0.00000000043,  1.82217346876,    10017.95594474140}, 
    {     0.00000000049,  4.64906795465,     6251.10354417460}, 
    {     0.00000000042,  5.31789294983,    11368.18157140920}, 
    {     0.00000000048,  0.49685981802,      529.70821874680}, 
    {     0.00000000051,  0.63985050945,    17499.36014031540}, 
    {     0.00000000048,  0.19901251387,     1905.46476494040}, 
    {     0.00000000055,  1.08536866814,     1059.36467653700}, 
    {     0.00000000056,  4.31837960167,    13358.85927814740}, 
    {     0.00000000046,  3.71161153699,     8958.52319664710}, 
    {     0.00000000042,  3.41202446638,     7788.36365908440}, 
    {     0.00000000050,  2.27112469625,     3427.92063123960}, 
    {     0.00000000055,  5.25814691818,    12808.88030395680}, 
    {     0.00000000048,  0.28684868478,    11935.84344764760}, 
    {     0.00000000050,  0.30214747846,     3358.42494881780}, 
    {     0.00000000043,  5.05297177364,     3229.42578441220}, 
    {     0.00000000041,  4.11754654123,     6553.20601006220}, 
    {     0.00000000043,  1.90603004116,     3451.79906898740}, 
    {     0.00000000046,  4.45432031146,     3707.83675566220}, 
    {     0.00000000041,  2.88427064230,      927.83996850280}, 
    {     0.00000000040,  5.10715968924,    14715.84023480700}, 
    {     0.00000000050,  5.23088101452,     2373.64154926420}, 
    {     0.00000000039,  3.58038785427,     9124.92198604240}, 
    {     0.00000000052,  4.06208791228,    17660.30346405700}, 
    {     0.00000000043,  0.22819734412,    10025.71861545740}, 
    {     0.00000000040,  2.65434458508,     3341.79306935190}, 
    {     0.00000000049,  5.40078097720,    17762.44406368820}, 
    {     0.00000000039,  0.41453755531,     5096.08411137890}, 
    {     0.00000000052,  2.59285184666,     2538.24850425360}, 
    {     0.00000000045,  4.19179574727,    37057.57749256620}, 
    {     0.00000000043,  4.02858922778,     6258.14978087260}, 
    {     0.00000000041,  1.71920640714,    10507.80933288900}, 
    {     0.00000000038,  2.11769718484,     8123.48606215980}, 
    {     0.00000000049,  2.41908302484,    20441.82356360700}, 
    {     0.00000000046,  3.05701386187,     2324.94940881560}, 
    {     0.00000000045,  5.57751456016,    15423.26756087100}, 
    {     0.00000000040,  2.80315795515,     7520.19414115000}, 
    {     0.00000000050,  3.42753416123,    52566.19261584059}, 
    {     0.00000000049,  2.11653605140,    22189.83997667400}, 
    {     0.00000000043,  3.04326197275,    41592.63692949060}, 
    {     0.00000000039,  3.58098532394,      867.93366407760}, 
    {     0.00000000040,  3.20381465754,    29428.51556827400}, 
    {     0.00000000038,  3.65843764774,    13341.67431130680}, 
    {     0.00000000037,  3.99759212306,    12725.45343477500}, 
    {     0.00000000042,  4.13817253189,     8336.78515759780}, 
    {     0.00000000038,  0.58099499580,     8966.38750317330}, 
    {     0.00000000049,  2.27415271613,     3123.79021291280}, 
    {     0.00000000037,  3.14802303104,     5466.42252377620}, 
    {     0.00000000046,  1.23573182695,    11787.60390551700}, 
    {     0.00000000037,  5.60013944614,     8123.50331581200}, 
    {     0.00000000039,  2.12359970883,    23387.81010524760}, 
    {     0.00000000037,  5.00181395644,    17810.20093918380}, 
    {     0.00000000038,  6.00950016545,     4295.85395129940}, 
    {     0.00000000040,  6.05295156557,     6151.55114195720}, 
    {     0.00000000036,  0.42674900890,     9997.95884235160}, 
    {     0.00000000044,  4.13342515647,    12192.86145539060}, 
    {     0.00000000037,  2.57249437155,     9815.13654280280}, 
    {     0.00000000036,  0.30459710615,    10618.01565410840}, 
    {     0.00000000039,  1.53352233747,     6683.97636401060}, 
    {     0.00000000050,  5.87136225569,     4396.47123854000}, 
    {     0.00000000040,  4.58209614492,     8294.17618643120}, 
    {     0.00000000036,  3.26497387820,    16269.35039562219}, 
    {     0.00000000040,  4.17543231683,     9962.46341818580}, 
    {     0.00000000036,  1.95918123970,      360.11078196160}, 
    {     0.00000000038,  2.38454082948,    24093.27678917520}, 
    {     0.00000000036,  2.85429847882,     6549.68289171320}, 
    {     0.00000000038,  3.54096291728,    19683.56377823720}, 
    {     0.00000000037,  3.74762124247,     1045.15483618760}, 
    {     0.00000000043,  5.45850357191,    17608.51883016380}, 
    {     0.00000000039,  5.88001746710,     4709.27267954480}, 
    {     0.00000000040,  4.23855320433,     3339.43178404770}, 
    {     0.00000000042,  3.73781410726,     7593.79509706520}, 
};


static const struct vsop mars_longitude_l1[LONG_L1] = {
    {  3340.61242700512,  0.00000000000,        0.00000000000}, 
    {     0.01457554523,  3.60433733236,     3340.61242669980}, 
    {     0.00168414711,  3.92318567804,     6681.22485339960}, 
    {     0.00020622975,  4.26108844583,    10021.83728009940}, 
    {     0.00003452392,  4.73210393190,        3.52311834900}, 
    {     0.00002586332,  4.60670058555,    13362.44970679920}, 
    {     0.00000841535,  4.45864030426,     2281.23049651060}, 
    {     0.00000537567,  5.01581256923,      398.14900340820}, 
    {     0.00000520948,  4.99428054039,     3344.13554504880}, 
    {     0.00000432635,  2.56070853083,      191.44826611160}, 
    {     0.00000429655,  5.31645299471,      155.42039943420}, 
    {     0.00000381751,  3.53878166043,      796.29800681640}, 
    {     0.00000328530,  4.95632685192,    16703.06213349900}, 
    {     0.00000282795,  3.15966768785,     2544.31441988340}, 
    {     0.00000205657,  4.56889279932,     2146.16541647520}, 
    {     0.00000168866,  1.32936559060,     3337.08930835080}, 
    {     0.00000157593,  4.18519540728,     1751.53953141600}, 
    {     0.00000133686,  2.23327245555,        0.98032106820}, 
    {     0.00000116965,  2.21414273762,     1059.38193018920}, 
    {     0.00000117503,  6.02411290806,     6151.53388830500}, 
    {     0.00000113718,  5.42753341019,     3738.76143010800}, 
    {     0.00000133565,  5.97420357518,     1748.01641306700}, 
    {     0.00000091099,  1.09626613064,     1349.86740965880}, 
    {     0.00000084256,  5.29330740437,     6684.74797174860}, 
    {     0.00000113886,  2.12863726524,     1194.44701022460}, 
    {     0.00000080823,  4.42818326716,      529.69096509460}, 
    {     0.00000079847,  2.24822372859,     8962.45534991020}, 
    {     0.00000072505,  5.84203374239,      242.72860397400}, 
    {     0.00000072945,  2.50193599662,      951.71840625060}, 
    {     0.00000071490,  3.85645759558,     2914.01423582380}, 
    {     0.00000085340,  3.90856932983,      553.56940284240}, 
    {     0.00000067580,  5.02334895070,      382.89653222320}, 
    {     0.00000065060,  1.01810963274,     3340.59517304760}, 
    {     0.00000065061,  3.04888114328,     3340.62968035200}, 
    {     0.00000061478,  4.15185188249,     3149.16416058820}, 
    {     0.00000048482,  4.87339233007,      213.29909543800}, 
    {     0.00000046581,  1.31461442691,     3185.19202726560}, 
    {     0.00000056642,  3.88772102421,     4136.91043351620}, 
    {     0.00000047615,  1.18228660215,     3333.49887969900}, 
    {     0.00000042052,  5.30826745759,    20043.67456019880}, 
    {     0.00000041330,  0.71392238704,     1592.59601363280}, 
    {     0.00000040280,  2.72571311592,        7.11354700080}, 
    {     0.00000033040,  5.40823104809,     6283.07584999140}, 
    {     0.00000028676,  0.04305323493,     9492.14631500480}, 
    {     0.00000022322,  5.86718681699,     3870.30339179440}, 
    {     0.00000022432,  5.46596961275,       20.35531939880}, 
    {     0.00000022606,  0.83782540818,     3097.88382272579}, 
    {     0.00000021416,  5.37936489667,     3340.54511639700}, 
    {     0.00000023347,  6.16774433900,     3532.06069281140}, 
    {     0.00000026573,  3.89000631130,     1221.84856632140}, 
    {     0.00000022800,  1.54501542908,     2274.11694950980}, 
    {     0.00000020474,  2.36236861670,     1589.07289528380}, 
    {     0.00000020179,  3.36390759347,     5088.62883976680}, 
    {     0.00000020013,  2.57546546037,    12303.06777661000}, 
    {     0.00000019920,  0.44761063096,     6677.70173505060}, 
    {     0.00000026550,  5.11303525089,     2700.71514038580}, 
    {     0.00000021104,  3.52541056271,       15.25247118500}, 
    {     0.00000021424,  4.97083417225,     3340.67973700260}, 
    {     0.00000018502,  5.57854926842,     1990.74501704100}, 
    {     0.00000017805,  6.12513609945,     4292.33083295040}, 
    {     0.00000016463,  2.60307709195,     3341.59274776800}, 
    {     0.00000016592,  1.25515357212,     3894.18182954220}, 
    {     0.00000019864,  2.52765519587,     4399.99435688900}, 
    {     0.00000015002,  1.03518790208,     2288.34404351140}, 
    {     0.00000020011,  4.73112374598,     4690.47983635860}, 
    {     0.00000015431,  2.46932776517,     4535.05943692440}, 
    {     0.00000020193,  5.78561467842,     7079.37385680780}, 
    {     0.00000015298,  2.26504738206,     3723.50895892300}, 
    {     0.00000015019,  3.36690751539,     6681.24210705180}, 
    {     0.00000013219,  5.61412860968,    10025.36039844840}, 
    {     0.00000013517,  2.12392880454,     5486.77784317500}, 
    {     0.00000015019,  1.33613594479,     6681.20759974740}, 
    {     0.00000012676,  2.95036175206,     3496.03282613400}, 
    {     0.00000013644,  1.97710249337,     5614.72937620960}, 
    {     0.00000013011,  1.51458564766,     5628.95647021120}, 
    {     0.00000011353,  6.23411904718,      135.06508003540}, 
    {     0.00000013508,  3.42721826602,     5621.84292321040}, 
    {     0.00000010866,  5.28165480979,     2818.03500860600}, 
    {     0.00000011880,  3.12847055823,      426.59819087600}, 
    {     0.00000010467,  2.73598607050,     2787.04302385740}, 
    {     0.00000011131,  5.84122566289,     2803.80791460440}, 
    {     0.00000011770,  2.58277425311,     8432.76438481560}, 
    {     0.00000011861,  5.47552055459,     3553.91152213780}, 
    {     0.00000008540,  1.91739325491,    11773.37681151540}, 
    {     0.00000009819,  4.52958330672,     6489.77658728800}, 
    {     0.00000008552,  3.16147568714,      162.46663613220}, 
    {     0.00000010957,  4.15775327007,     2388.89402044920}, 
    {     0.00000008948,  4.23164385777,     7477.52286021600}, 
    {     0.00000008131,  1.61308074119,     2957.71589447660}, 
    {     0.00000008352,  2.18475645206,       23.87843774780}, 
    {     0.00000008030,  5.69889507906,     6041.32756708560}, 
    {     0.00000007878,  5.71359767892,     9623.68827669120}, 
    {     0.00000008713,  4.43300582398,     5092.15195811580}, 
    {     0.00000008421,  3.16355067250,     3347.72597370060}, 
    {     0.00000006670,  5.07423317095,     8031.09226305840}, 
    {     0.00000008656,  4.33239148117,     3339.63210563160}, 
    {     0.00000007354,  6.17934256606,     3583.34103067380}, 
    {     0.00000005749,  3.67719823582,     8429.24126646660}, 
    {     0.00000006235,  3.54003325209,      692.15760122680}, 
    {     0.00000005458,  1.05139431657,     4933.20844033260}, 
    {     0.00000006132,  1.66182646558,     6525.80445396540}, 
    {     0.00000005197,  1.14841109166,       28.44918746780}, 
    {     0.00000004950,  5.28919125231,     6681.29216370240}, 
    {     0.00000005516,  6.12492946392,     2487.41604494780}, 
    {     0.00000004890,  3.10255139433,        5.52292430740}, 
    {     0.00000005354,  0.37154896863,    12832.75874170460}, 
    {     0.00000004751,  0.23374681550,       36.02786667740}, 
    {     0.00000006362,  2.11339432269,     5884.92684658320}, 
    {     0.00000004996,  2.44835744792,     5099.26550511660}, 
    {     0.00000004952,  5.69770765577,     6681.15754309680}, 
    {     0.00000004678,  0.27799012787,    10018.31416175040}, 
    {     0.00000004746,  0.00950199989,     7210.91581849420}, 
    {     0.00000004862,  5.60331599025,     6467.92575796160}, 
    {     0.00000005544,  2.00929051393,      522.57741809380}, 
    {     0.00000004998,  1.51094959078,     1744.42598441520}, 
    {     0.00000005397,  0.18842154970,     2942.46342329160}, 
    {     0.00000004098,  3.95776844736,        3.88133535800}, 
    {     0.00000005414,  5.66147396313,    23384.28698689860}, 
    {     0.00000005467,  0.19258681316,     7632.94325965020}, 
    {     0.00000004305,  2.89452294830,     2810.92146160520}, 
    {     0.00000004118,  1.59475420886,     7234.79425624200}, 
    {     0.00000004489,  4.16951490492,     2906.90068882300}, 
    {     0.00000005277,  2.22681020305,     3127.31333126180}, 
    {     0.00000003882,  2.26433789475,     2699.73481931760}, 
    {     0.00000003544,  1.76658498504,     1758.65307841680}, 
    {     0.00000003408,  2.65743533541,     4929.68532198360}, 
    {     0.00000004336,  4.43081904792,      640.87760738220}, 
    {     0.00000003804,  2.91373968131,    15643.68020330980}, 
    {     0.00000003176,  1.75893480952,     9595.23908922340}, 
    {     0.00000003309,  6.13831291678,    10419.98628350760}, 
    {     0.00000003077,  2.56194751001,     7064.12138562280}, 
    {     0.00000003236,  2.32387839882,     5085.03841111500}, 
    {     0.00000003284,  2.86216479710,     7740.60678358880}, 
    {     0.00000002958,  1.27767445188,      574.34479833480}, 
    {     0.00000002805,  0.43144651568,     5828.02847164760}, 
    {     0.00000002851,  0.98625869565,     3191.04922956520}, 
    {     0.00000003324,  2.59010987850,     2118.76386037840}, 
    {     0.00000003039,  1.86739127757,        7.04623669800}, 
    {     0.00000002738,  1.76460911547,      639.89728631400}, 
    {     0.00000002757,  3.70511041849,    10021.85453375160}, 
    {     0.00000003376,  1.53123149565,     6674.11130639880}, 
    {     0.00000002757,  1.67433972403,    10021.82002644720}, 
    {     0.00000002670,  3.11556212899,     6836.64525283380}, 
    {     0.00000002583,  3.77302627584,     2921.12778282460}, 
    {     0.00000002510,  0.30461555756,     3475.67750673520}, 
    {     0.00000002288,  2.81266012379,     7875.67186362420}, 
    {     0.00000002411,  0.97123911611,     3319.83703120740}, 
    {     0.00000002410,  2.95969382172,     6682.20517446780}, 
    {     0.00000002211,  0.61268074323,    10973.55568635000}, 
    {     0.00000002246,  4.12573972297,       59.37386191360}, 
    {     0.00000002183,  2.17530786579,    15113.98923821520}, 
    {     0.00000002445,  5.91435376684,     5331.35744374080}, 
    {     0.00000001944,  5.47623245699,    11371.70468975820}, 
    {     0.00000002390,  3.87952069289,     3355.86489788480}, 
    {     0.00000001904,  5.11178589044,     1066.49547719000}, 
    {     0.00000002302,  1.15940039520,     3320.25710730100}, 
    {     0.00000001955,  5.88703346758,     6894.52394883760}, 
    {     0.00000001837,  3.07635198966,     3325.35995551480}, 
    {     0.00000002131,  2.99610007510,     6254.62666252360}, 
    {     0.00000001807,  4.98332871905,     1648.44675719740}, 
    {     0.00000002133,  1.91321292871,     8969.56889691100}, 
    {     0.00000001936,  3.55090266368,     3767.21061757580}, 
    {     0.00000001989,  5.37314833955,      206.18554843720}, 
    {     0.00000001674,  5.49537183178,      266.60704172180}, 
    {     0.00000001732,  1.81246269542,      536.80451209540}, 
    {     0.00000001645,  1.32190162152,     3264.34635542420}, 
    {     0.00000001715,  3.25682611470,     7903.07341972100}, 
    {     0.00000001560,  5.75414697537,     3360.96774609859}, 
    {     0.00000001581,  1.72981711161,     3134.42687826260}, 
    {     0.00000001498,  4.89621878281,     9830.38901398780}, 
    {     0.00000001549,  5.85472144829,       20.77539549240}, 
    {     0.00000001685,  2.43562432843,     3120.19978426100}, 
    {     0.00000001548,  1.54152974975,     8425.65083781480}, 
    {     0.00000002012,  5.94532644656,    13365.97282514820}, 
    {     0.00000001972,  3.11534406510,     3361.38782219220}, 
    {     0.00000001391,  2.24268252285,     3344.20285535160}, 
    {     0.00000001369,  3.07997599503,     6127.65545055720}, 
    {     0.00000001365,  4.57979419810,    10818.13528691580}, 
    {     0.00000001361,  1.18605362322,    14584.29827312060}, 
    {     0.00000001376,  5.49004047305,      170.67287061920}, 
    {     0.00000001739,  2.01930737454,    10575.40668294180}, 
    {     0.00000001699,  5.63673097080,     6158.64743530580}, 
    {     0.00000001291,  5.91024520902,     9808.53818466140}, 
    {     0.00000001399,  1.81907706393,     3337.02199804800}, 
    {     0.00000001413,  4.50285394080,     5729.50644714900}, 
    {     0.00000001481,  6.04716796278,    12964.30070339100}, 
    {     0.00000001218,  0.82624604661,      419.48464387520}, 
    {     0.00000001406,  1.05089075450,     6438.49624942560}, 
    {     0.00000001190,  3.52559223977,     6688.33840040040}, 
    {     0.00000001263,  1.48624507606,     8439.87793181640}, 
    {     0.00000001145,  4.89771219093,      220.41264243880}, 
    {     0.00000001131,  6.19294401266,     6144.42034130420}, 
    {     0.00000001156,  2.23033209084,     8955.34180290940}, 
    {     0.00000001128,  3.44445874016,    10177.25767953360}, 
    {     0.00000001144,  5.29922202930,       27.40155609680}, 
    {     0.00000001098,  2.82106200873,     4569.57454002200}, 
    {     0.00000001271,  4.58458799479,     6247.51311552280}, 
    {     0.00000001352,  2.14065534125,    11243.68584642080}, 
    {     0.00000001297,  0.44389550166,       87.30820453981}, 
    {     0.00000001118,  1.96366629239,     6298.32832117640}, 
    {     0.00000001065,  2.89853673240,    10404.73381232260}, 
    {     0.00000001027,  4.79279924388,     3914.95722503460}, 
    {     0.00000001034,  3.73200738994,    10213.28554621100}, 
    {     0.00000001152,  4.14340380812,     6261.74020952440}, 
    {     0.00000000993,  0.22568223151,     3230.40610548040}, 
    {     0.00000001305,  3.67646278246,     2301.58581590939}, 
    {     0.00000001138,  5.11767079744,     4562.46099302120}, 
    {     0.00000000922,  0.46241803393,    13358.92658845020}, 
    {     0.00000001275,  5.14327521504,     2693.60159338500}, 
    {     0.00000000912,  1.23133665160,      103.09277421860}, 
    {     0.00000000953,  1.52860938585,     3369.06161416760}, 
    {     0.00000001009,  3.29653387473,     3178.14579056760}, 
    {     0.00000000893,  1.35062914664,     1214.73501932060}, 
    {     0.00000000918,  2.45577302887,    13916.01910964160}, 
    {     0.00000000969,  1.69080418858,       43.71891230500}, 
    {     0.00000000896,  5.62906563965,    10021.90459040220}, 
    {     0.00000000853,  5.94370893753,    12168.00269657460}, 
    {     0.00000000931,  0.24120697444,     6923.95345737360}, 
    {     0.00000000912,  1.10368236991,       29.42950853600}, 
    {     0.00000000816,  4.65205672982,     2707.82868738660}, 
    {     0.00000000801,  4.81849322003,      533.21408344360}, 
    {     0.00000000764,  6.08667124637,     2384.32327072920}, 
    {     0.00000000753,  1.03238937619,    14314.16811304980}, 
    {     0.00000000757,  2.06149804917,    12935.85151592320}, 
    {     0.00000000924,  0.69558587744,    16173.37116840440}, 
    {     0.00000000786,  3.91108639997,     9225.53927328300}, 
    {     0.00000000697,  4.07135509749,     5202.35827933520}, 
    {     0.00000000894,  6.03747462616,    10021.76996979660}, 
    {     0.00000000814,  2.01020002407,     9866.41688066520}, 
    {     0.00000000871,  4.45409720021,     3316.73398895200}, 
    {     0.00000000694,  6.01416161518,    26724.89941359840}, 
    {     0.00000000744,  1.39400789085,     8273.82086703240}, 
    {     0.00000000666,  3.02544526662,     1039.02661079040}, 
    {     0.00000000727,  3.27505135694,    18984.29263000960}, 
    {     0.00000000654,  2.83655009806,      107.66352393860}, 
    {     0.00000000680,  1.98065653254,     1228.96211332220}, 
    {     0.00000000829,  0.36839516637,    10551.52824519400}, 
    {     0.00000000585,  0.10314990118,      111.18664228760}, 
    {     0.00000000566,  1.59185176054,     2391.43681773000}, 
    {     0.00000000555,  2.70920251256,     4555.34744602040}, 
    {     0.00000000696,  2.89495274268,     2648.45482547300}, 
    {     0.00000000532,  5.65094737994,     6034.21402008480}, 
    {     0.00000000557,  5.08729863960,     1903.43681250120}, 
    {     0.00000000570,  4.59896697040,     6680.24453233140}, 
    {     0.00000000519,  0.20293365239,    13760.59871020740}, 
    {     0.00000000697,  3.87262209056,    13517.87010623340}, 
    {     0.00000000506,  3.20689286673,    11081.21921028860}, 
    {     0.00000000518,  2.85627321259,     5459.37628707820}, 
    {     0.00000000642,  5.19540766185,     6048.44111408640}, 
    {     0.00000000490,  2.42075152031,     3364.49086444760}, 
    {     0.00000000671,  3.69379654960,     3335.08950239240}, 
    {     0.00000000526,  0.23465052151,       51.28033786241}, 
    {     0.00000000483,  1.56485227643,     1964.83862685400}, 
    {     0.00000000496,  4.31353927165,     3344.49376205780}, 
    {     0.00000000491,  2.51033279488,     3863.18984479360}, 
    {     0.00000000480,  0.13049600948,       66.48740891440}, 
    {     0.00000000466,  2.03124918036,    13362.43245314700}, 
    {     0.00000000515,  0.65638901827,      853.19638175200}, 
    {     0.00000000469,  4.06128608413,    13362.46696045140}, 
    {     0.00000000527,  2.98225968203,     8270.29774868340}, 
    {     0.00000000521,  2.76200215969,     3503.07906283200}, 
    {     0.00000000444,  5.59711849258,      149.56319713460}, 
    {     0.00000000533,  4.77159034151,     1118.75579210280}, 
    {     0.00000000472,  3.43923570864,     6702.00024889200}, 
    {     0.00000000438,  4.83084543348,     3116.26763099790}, 
    {     0.00000000548,  2.01123370738,     7910.18696672180}, 
    {     0.00000000556,  5.67119913446,      227.47613278900}, 
    {     0.00000000431,  4.30019479176,    16858.48253293320}, 
    {     0.00000000419,  2.79762011157,      433.71173787680}, 
    {     0.00000000401,  0.05451452688,     3304.58456002240}, 
    {     0.00000000412,  5.30912686850,    13119.72110282519}, 
    {     0.00000000425,  5.70380839964,       21.85082932640}, 
    {     0.00000000533,  1.30269896597,     6660.44945790720}, 
    {     0.00000000388,  2.06108898302,     3347.65866339780}, 
    {     0.00000000384,  4.98893020891,     9779.10867612540}, 
    {     0.00000000457,  2.53527558609,       74.78159856730}, 
    {     0.00000000380,  2.30167509056,    12310.18132361080}, 
    {     0.00000000514,  5.84621491771,     1052.26838318840}, 
    {     0.00000000462,  5.12519318874,     1596.18644228460}, 
    {     0.00000000415,  4.75348299971,     3981.49003408200}, 
    {     0.00000000364,  3.73442995257,     5518.75014899180}, 
    {     0.00000000363,  0.13266829080,       56.89837493560}, 
    {     0.00000000390,  1.46647444308,    17924.91069982040}, 
    {     0.00000000361,  5.86612779191,     3607.21946842160}, 
    {     0.00000000487,  0.65743461993,     3376.64029337720}, 
    {     0.00000000351,  2.12025274391,     6677.63442474780}, 
    {     0.00000000353,  2.90104988988,    17256.63153634140}, 
    {     0.00000000388,  2.23321423606,     3980.50971301380}, 
    {     0.00000000398,  1.78984684395,     7895.95987272020}, 
    {     0.00000000442,  0.18839686258,     9381.93999378540}, 
    {     0.00000000433,  0.64407497214,     6816.28993343500}, 
    {     0.00000000337,  6.13758619135,     5724.93569742900}, 
    {     0.00000000334,  4.08486685558,      664.75604513000}, 
    {     0.00000000342,  5.95706448244,     3546.79797513700}, 
    {     0.00000000323,  5.05251614034,     3237.51965248120}, 
    {     0.00000000428,  2.50147052863,    18454.60166491500}, 
    {     0.00000000324,  2.91824505937,     8329.67161059700}, 
    {     0.00000000324,  5.04026639944,       36.60536530420}, 
    {     0.00000000354,  0.00835534987,     8671.96987044060}, 
    {     0.00000000312,  6.23345945902,    10235.13637553740}, 
    {     0.00000000313,  4.22789830697,     6696.47732458460}, 
    {     0.00000000318,  2.57296798825,     6684.81528205140}, 
    {     0.00000000292,  3.86555731990,     7107.82304427560}, 
    {     0.00000000291,  0.56944609230,    17395.21973472580}, 
    {     0.00000000337,  5.13820375946,     7255.56965173440}, 
    {     0.00000000302,  0.01244709750,    16706.58525184800}, 
    {     0.00000000321,  3.15062035676,    11216.28429032400}, 
    {     0.00000000282,  2.94441896021,     3415.39402526710}, 
    {     0.00000000284,  2.67994400271,     3877.41693879520}, 
    {     0.00000000284,  4.30043162266,     6872.67311951120}, 
    {     0.00000000294,  0.79614923862,    11236.57229942000}, 
    {     0.00000000283,  6.16331963812,     3973.39616601300}, 
    {     0.00000000271,  1.75726306886,    11780.49035851620}, 
    {     0.00000000277,  1.66035763583,     1692.16566950240}, 
    {     0.00000000347,  3.31414555314,    10022.81760116760}, 
    {     0.00000000266,  4.42395281214,      310.84079886840}, 
    {     0.00000000275,  2.22690392814,     3017.10701004240}, 
    {     0.00000000271,  3.58728506623,      128.01884333740}, 
    {     0.00000000297,  0.72303002154,      155.35308913140}, 
    {     0.00000000336,  0.16930486161,     5618.31980486140}, 
    {     0.00000000337,  5.68300242250,    16460.33352952499}, 
    {     0.00000000291,  1.50442579957,     6660.86953400080}, 
    {     0.00000000259,  5.95159516658,     9499.25986200560}, 
    {     0.00000000335,  3.36336210503,     5625.36604155940}, 
    {     0.00000000254,  0.39614279218,    12721.57209941700}, 
    {     0.00000000288,  5.47663257768,     9168.64089834740}, 
    {     0.00000000307,  2.33271870436,     3281.23856478620}, 
    {     0.00000000239,  3.70517047494,     7373.38245462640}, 
    {     0.00000000321,  4.53899078143,     2178.13772229200}, 
    {     0.00000000261,  2.58831740384,     3336.73109134180}, 
    {     0.00000000236,  6.23036203287,    15508.61512327440}, 
    {     0.00000000279,  0.14319124816,    16304.91313009080}, 
    {     0.00000000236,  0.79175835640,    16062.18452611680}, 
    {     0.00000000258,  6.10999116266,     2480.30249794700}, 
    {     0.00000000243,  5.45663643819,     4407.10790388980}, 
    {     0.00000000231,  5.38613602278,       76.26607127560}, 
    {     0.00000000233,  6.15567163053,    19800.94595622480}, 
    {     0.00000000303,  5.35509551879,     2766.26762836500}, 
    {     0.00000000233,  5.25492090129,    13171.00144068760}, 
    {     0.00000000219,  5.84025523264,    13936.79450513400}, 
    {     0.00000000223,  1.46266096304,    15110.46611986620}, 
    {     0.00000000226,  2.27377580587,     6784.31762761820}, 
    {     0.00000000247,  2.27156183441,      110.20632121940}, 
    {     0.00000000213,  0.21404637687,     1505.28780909299}, 
    {     0.00000000265,  5.18121091844,     3205.54734666440}, 
    {     0.00000000209,  6.21251768752,     3253.30422216000}, 
    {     0.00000000272,  2.89521727496,    10713.99488132620}, 
    {     0.00000000231,  3.72569036661,     3346.13535100720}, 
    {     0.00000000238,  4.55410082039,     9602.35263622420}, 
    {     0.00000000272,  0.00364811322,     9380.95967271720}, 
    {     0.00000000224,  3.08775924389,      401.67212175720}, 
    {     0.00000000201,  3.36695295492,        6.68366387410}, 
    {     0.00000000263,  1.39193044768,    14054.60730802600}, 
    {     0.00000000206,  6.19734429375,    13149.15061136120}, 
    {     0.00000000232,  5.50578916585,    10596.18207843420}, 
    {     0.00000000198,  3.32452831163,     3657.00429635640}, 
    {     0.00000000195,  0.99412287440,     5642.19824260920}, 
    {     0.00000000211,  2.85375232515,     5415.65737477320}, 
    {     0.00000000193,  4.26912883997,     6546.15977336420}, 
    {     0.00000000226,  5.32794817315,     3561.02506913860}, 
    {     0.00000000199,  4.59761896582,    12566.15169998280}, 
    {     0.00000000198,  1.12349271227,      685.04405422600}, 
    {     0.00000000221,  0.64659560722,    11250.79939342160}, 
    {     0.00000000184,  1.10571356803,    12722.55242048520}, 
    {     0.00000000253,  2.11492151988,     6475.03930496240}, 
    {     0.00000000225,  4.49528012077,      589.06482700820}, 
    {     0.00000000190,  1.45410333749,     4885.96640967860}, 
    {     0.00000000181,  1.29030762994,     6606.44325483230}, 
    {     0.00000000177,  2.86991818914,     6460.81221096080}, 
    {     0.00000000184,  5.69456453371,     3351.24909204960}, 
    {     0.00000000204,  6.20934241396,      394.62588505920}, 
    {     0.00000000176,  2.43571632942,     3603.69635007260}, 
    {     0.00000000225,  0.81972180876,     3265.83082813250}, 
    {     0.00000000175,  4.65571344916,    20199.09495963300}, 
    {     0.00000000174,  3.67069603032,      735.87651353180}, 
    {     0.00000000173,  1.93062911477,    11766.26326451460}, 
    {     0.00000000184,  4.77203925989,      286.96236112060}, 
    {     0.00000000168,  5.10734096993,     1332.05488754080}, 
    {     0.00000000166,  1.59679231445,     1437.17561419860}, 
    {     0.00000000174,  6.26980383875,    17277.40693183380}, 
    {     0.00000000191,  0.60250751218,       56.80326216980}, 
    {     0.00000000169,  1.38625780562,     8982.81066930900}, 
    {     0.00000000161,  0.43339852368,     5820.91492464680}, 
    {     0.00000000210,  3.10717635656,     4039.88357492740}, 
    {     0.00000000187,  4.52578270109,     8542.97070603500}, 
    {     0.00000000155,  1.41249963094,       22.76849660940}, 
    {     0.00000000207,  3.41041134401,      931.36308685180}, 
    {     0.00000000158,  0.58219487339,      158.94351778320}, 
    {     0.00000000153,  5.14168081601,      156.40072050240}, 
    {     0.00000000151,  1.93803423293,     3384.33133900480}, 
    {     0.00000000180,  3.25442053419,      263.08392337280}, 
    {     0.00000000158,  3.64357924476,     8013.27974094040}, 
    {     0.00000000162,  4.89316364970,    14158.74771361560}, 
    {     0.00000000174,  2.72388906334,     2807.39834325620}, 
    {     0.00000000150,  3.87897267873,    10028.95082710020}, 
    {     0.00000000186,  1.15738945572,     3169.93955608060}, 
    {     0.00000000148,  4.90520004562,     9588.12554222260}, 
    {     0.00000000167,  4.39427844033,     3333.56619000180}, 
    {     0.00000000193,  5.73713102378,      206.70073729660}, 
    {     0.00000000165,  1.93680960064,     5732.04924442980}, 
    {     0.00000000186,  1.22089903563,    19402.79695281660}, 
    {     0.00000000146,  3.36648330663,     6665.97238221460}, 
    {     0.00000000142,  4.04273809081,    13553.89797291080}, 
    {     0.00000000140,  4.81861092474,     9070.11887384880}, 
    {     0.00000000145,  0.73128989010,    16699.53901514999}, 
    {     0.00000000138,  5.73205642078,     2277.70737816160}, 
    {     0.00000000161,  2.92764155222,        5.85720229960}, 
    {     0.00000000169,  2.41111037995,    16276.46394262300}, 
    {     0.00000000152,  3.41680582541,     9468.26787725700}, 
    {     0.00000000179,  5.27310548931,     3873.82651014340}, 
    {     0.00000000135,  2.58996373843,    19004.64794940840}, 
    {     0.00000000182,  4.60114226427,     3329.97576135000}, 
    {     0.00000000144,  3.02314051168,      708.98980227659}, 
    {     0.00000000137,  2.20453530733,    15664.03552270859}, 
    {     0.00000000131,  3.48156082643,      367.22432896240}, 
    {     0.00000000131,  2.00232689987,    10014.72373309860}, 
    {     0.00000000136,  2.82958453689,    21795.21409161479}, 
    {     0.00000000145,  0.85073795840,    20735.83216142559}, 
    {     0.00000000158,  1.48909254724,       29.49181830340}, 
    {     0.00000000154,  6.13080655647,     6701.58017279840}, 
    {     0.00000000127,  1.78210744074,    22743.40937951640}, 
    {     0.00000000135,  0.48019080933,    17085.95866572220}, 
    {     0.00000000160,  4.24420830253,     4672.66731424060}, 
    {     0.00000000165,  2.02795177586,      290.48547946960}, 
    {     0.00000000125,  0.52718806317,     2604.73591316800}, 
    {     0.00000000126,  3.81076672136,      765.79306444640}, 
    {     0.00000000151,  6.21793740910,     6040.34724601740}, 
    {     0.00000000152,  0.26011322033,     3443.70520091840}, 
    {     0.00000000116,  1.79531662513,      647.01083331480}, 
    {     0.00000000150,  3.38665233039,     1861.74585263540}, 
    {     0.00000000117,  5.77698467349,     1854.63230563460}, 
    {     0.00000000151,  1.57283975707,     1107.13880568480}, 
    {     0.00000000126,  2.00332867825,      699.27114822760}, 
    {     0.00000000115,  2.46396002289,     7380.49600162720}, 
    {     0.00000000118,  4.07281676691,      418.50432280700}, 
    {     0.00000000157,  0.85719532138,     2814.44457995420}, 
    {     0.00000000131,  0.77898483290,     3427.92063123960}, 
    {     0.00000000155,  1.76656404152,    21265.52312652020}, 
    {     0.00000000143,  2.39402347563,     5244.04923920100}, 
    {     0.00000000119,  4.81260561532,     6657.34641565180}, 
    {     0.00000000109,  1.09172723256,    14577.18472611980}, 
    {     0.00000000111,  1.07296455077,    19513.98359510420}, 
    {     0.00000000146,  1.88093561859,     6709.67404086740}, 
    {     0.00000000119,  3.19461525393,     2409.24933984800}, 
    {     0.00000000140,  4.47370193096,     3326.38533269820}, 
    {     0.00000000110,  0.56397435615,      661.23292678100}, 
    {     0.00000000151,  1.80007988242,    12323.42309600880}, 
    {     0.00000000111,  4.05380946072,      568.82187402740}, 
    {     0.00000000145,  3.19579249832,    12295.95422960920}, 
    {     0.00000000106,  5.69308130144,       14.22709400160}, 
    {     0.00000000109,  0.08987794346,    13362.38239649640}, 
    {     0.00000000104,  0.59705862733,    10264.56588407340}, 
    {     0.00000000108,  0.75325958553,    13892.14067189380}, 
    {     0.00000000105,  0.76776300263,     3024.22055704320}, 
    {     0.00000000104,  2.77572446625,       38.13303563780}, 
    {     0.00000000134,  5.88513782564,     5835.14201864840}, 
    {     0.00000000104,  6.02722901204,     8827.39026987480}, 
    {     0.00000000117,  0.45962302033,     9485.03276800400}, 
    {     0.00000000116,  2.37241500836,    11769.85369316640}, 
    {     0.00000000103,  4.09779389857,     6675.70192909220}, 
    {     0.00000000100,  3.59422313940,    22324.90505670940}, 
    {     0.00000000100,  2.78600587468,     8584.66166590080}, 
    {     0.00000000098,  1.44873204724,     3370.04193523580}, 
    {     0.00000000131,  1.31335473392,     3313.21087060300}, 
    {     0.00000000111,  3.12463539337,      309.27832265580}, 
    {     0.00000000125,  1.59601169758,    16063.16484718500}, 
    {     0.00000000106,  3.31839457231,     3399.98628861340}, 
    {     0.00000000134,  2.91637947295,       57.87869600380}, 
    {     0.00000000126,  3.59123240877,     6518.75821726740}, 
    {     0.00000000107,  4.92626332372,      802.36392244620}, 
    {     0.00000000094,  3.42567049862,     3510.19260983280}, 
    {     0.00000000093,  0.08710545839,    30065.51184029820}, 
    {     0.00000000095,  4.48318184985,    21947.11137270000}, 
    {     0.00000000100,  0.94442247285,     3209.07046501340}, 
    {     0.00000000092,  2.37657622081,    11140.59307220220}, 
    {     0.00000000102,  0.43593025607,      956.28915597060}, 
    {     0.00000000113,  3.77204238785,     4989.05918389720}, 
    {     0.00000000091,  1.83925462893,     2221.85663459700}, 
    {     0.00000000118,  3.04735119564,    22345.26037610820}, 
    {     0.00000000125,  1.54875495543,     1435.14766175940}, 
    {     0.00000000092,  3.21938096550,    11670.28403729680}, 
    {     0.00000000103,  0.11157075549,       11.04570026390}, 
    {     0.00000000089,  1.89954430876,    15121.10278521600}, 
    {     0.00000000118,  0.29325451400,     2945.98654164060}, 
    {     0.00000000109,  1.23224539875,    10706.88133432540}, 
    {     0.00000000090,  4.06237471202,    18606.49894600020}, 
    {     0.00000000086,  3.71580666913,     8859.36257569160}, 
    {     0.00000000087,  3.39266299009,     6843.69148953180}, 
    {     0.00000000116,  4.67476277278,      272.67295735160}, 
    {     0.00000000086,  4.99543708984,     2494.52959194860}, 
    {     0.00000000114,  3.37332197024,     2938.94030494260}, 
    {     0.00000000085,  5.55531696679,     3368.01398279660}, 
    {     0.00000000103,  1.37911448870,     4032.77002792660}, 
    {     0.00000000092,  2.92389765785,     2067.93140107260}, 
    {     0.00000000093,  0.34335553468,    13517.80279593060}, 
    {     0.00000000104,  0.33551732210,    23546.75362303080}, 
    {     0.00000000085,  5.73127362522,     3340.19235060619}, 
    {     0.00000000095,  1.14586741202,    10721.10842832700}, 
    {     0.00000000086,  3.17511720396,    11925.27409260060}, 
    {     0.00000000101,  3.09349019068,     5989.06725217280}, 
    {     0.00000000084,  2.30320956174,    13207.02930736500}, 
    {     0.00000000086,  5.87459621301,       73.60095591520}, 
    {     0.00000000097,  2.04984064598,     8226.57883637840}, 
    {     0.00000000084,  0.78729386249,      146.81168652360}, 
    {     0.00000000085,  0.06405464192,    24889.57479599160}, 
    {     0.00000000082,  4.29548487571,     9374.82644678460}, 
    {     0.00000000090,  0.50928046454,     3274.12501778540}, 
    {     0.00000000083,  5.16862755373,     6578.13207918100}, 
    {     0.00000000082,  0.45318265916,    16702.99482319620}, 
    {     0.00000000085,  3.76125083061,     4845.90023579280}, 
    {     0.00000000088,  2.39227137305,     1062.90504853820}, 
    {     0.00000000104,  4.99513842450,     1581.95934828300}, 
    {     0.00000000081,  5.89798943131,    16858.41522263039}, 
    {     0.00000000082,  0.44163602941,     4782.87363546000}, 
    {     0.00000000106,  2.50029020488,     5401.43028077160}, 
    {     0.00000000086,  3.61631911304,     8965.97846825920}, 
    {     0.00000000087,  5.68212398189,     1883.08149310240}, 
    {     0.00000000095,  5.35237938692,     4996.17273089800}, 
    {     0.00000000079,  2.01092788145,     1329.51209026000}, 
    {     0.00000000078,  0.88224980818,     2171.02417529120}, 
    {     0.00000000105,  2.37775757409,     9638.94074787620}, 
    {     0.00000000089,  5.33260517891,     2125.87740737920}, 
    {     0.00000000076,  5.20798256417,     9872.27408296480}, 
    {     0.00000000083,  0.03796627991,    16703.12944380180}, 
    {     0.00000000075,  6.26330392154,    27682.14074415640}, 
    {     0.00000000090,  4.84737761448,    14071.43950907579}, 
    {     0.00000000094,  4.89545753204,     9389.05354078620}, 
    {     0.00000000077,  0.03584521510,    20206.14119633100}, 
    {     0.00000000095,  5.93429183368,    13362.51701710200}, 
    {     0.00000000081,  1.00694559686,    16865.52876963120}, 
    {     0.00000000077,  4.12929175062,     4005.36847182980}, 
    {     0.00000000082,  1.47379060963,       16.83220104979}, 
    {     0.00000000073,  4.59130182630,      362.12113673080}, 
    {     0.00000000074,  3.60955612323,    25685.87280280800}, 
    {     0.00000000084,  2.71424539413,    19617.07636932279}, 
    {     0.00000000072,  0.01101776823,     3568.08855948880}, 
    {     0.00000000071,  1.71603072644,     2060.81785407180}, 
    {     0.00000000072,  1.89061725205,    18451.07854656599}, 
    {     0.00000000071,  3.22816907346,     3472.15438838620}, 
    {     0.00000000076,  0.30413402871,       72.05573335480}, 
    {     0.00000000070,  3.17652165983,     3448.27595063840}, 
    {     0.00000000077,  3.14666622167,    39601.89191244960}, 
    {     0.00000000071,  0.33254450188,    23141.55838292460}, 
    {     0.00000000074,  0.10153043438,    17402.33328172660}, 
    {     0.00000000090,  0.67485041721,      949.17560896980}, 
    {     0.00000000096,  1.02302727880,     4106.40549114620}, 
    {     0.00000000095,  5.15356240747,        1.48447270830}, 
    {     0.00000000067,  1.00856695957,    17232.75309859360}, 
    {     0.00000000068,  1.78474324075,      224.34479570190}, 
    {     0.00000000077,  0.15786375115,    16066.06586147480}, 
    {     0.00000000066,  1.10881345668,     4459.36821880260}, 
    {     0.00000000067,  2.14790314493,     6357.71943674220}, 
    {     0.00000000090,  4.95003467215,    25287.72379939980}, 
    {     0.00000000064,  6.11245648995,     3362.46325602620}, 
    {     0.00000000077,  5.57405321128,    16872.64231663200}, 
    {     0.00000000086,  5.95683236658,    37057.57749256620}, 
    {     0.00000000066,  4.52950779766,    37455.72649597440}, 
    {     0.00000000063,  0.23107890951,     7314.00859271280}, 
    {     0.00000000062,  0.01491667995,    41427.48698317880}, 
    {     0.00000000062,  1.40819002140,    22854.59602180400}, 
    {     0.00000000063,  0.89352294357,    14591.41182012140}, 
    {     0.00000000061,  4.89984611912,    14867.73751589219}, 
    {     0.00000000064,  0.16730566121,    14047.49376102520}, 
    {     0.00000000061,  1.82636377879,     3077.52850332700}, 
    {     0.00000000063,  5.51152998906,    13212.88650966460}, 
    {     0.00000000062,  4.90444445022,    12082.65513417120}, 
    {     0.00000000066,  3.88662460547,    45494.58142974879}, 
    {     0.00000000068,  4.45499690607,     9175.75444534820}, 
    {     0.00000000082,  3.65822046905,    15265.88651930040}, 
    {     0.00000000060,  2.78933980763,    20809.46762464520}, 
    {     0.00000000061,  6.15977712775,    12509.25332504720}, 
    {     0.00000000068,  5.59792852411,      377.37360791580}, 
    {     0.00000000069,  3.36380060407,    11610.91017538320}, 
    {     0.00000000082,  1.06617356055,    24076.44458812540}, 
    {     0.00000000060,  5.92063607531,    21548.96236929180}, 
    {     0.00000000062,  5.57785540179,     7214.43893684320}, 
    {     0.00000000058,  3.37236634010,     4379.63903749020}, 
    {     0.00000000078,  4.18565643954,     8186.51266249260}, 
    {     0.00000000059,  1.29208473566,     1214.80232962340}, 
    {     0.00000000061,  3.57279066469,    14421.83163698840}, 
    {     0.00000000058,  1.69306371945,      632.78373931320}, 
    {     0.00000000058,  2.64427715516,    10124.93005431800}, 
    {     0.00000000058,  1.20882508221,    17932.02424682120}, 
    {     0.00000000072,  3.39739853142,      685.11136452880}, 
    {     0.00000000058,  0.09532796666,    15849.86575174700}, 
    {     0.00000000057,  2.16099709156,     7366.26890762560}, 
    {     0.00000000057,  4.31819630987,       95.97922721780}, 
    {     0.00000000072,  2.28455924531,     9072.66167112960}, 
    {     0.00000000058,  5.63540437140,     8535.85715903420}, 
    {     0.00000000078,  1.52916624615,    40000.04091585779}, 
    {     0.00000000062,  4.14045391856,      604.84974070480}, 
    {     0.00000000056,  0.36387670928,    20047.19767854780}, 
    {     0.00000000056,  3.66119573845,    12199.97500239140}, 
    {     0.00000000062,  3.59357123692,    10184.30391623160}, 
    {     0.00000000059,  5.91890694566,     6901.63749583840}, 
    {     0.00000000058,  2.64199428538,    15650.79375031060}, 
    {     0.00000000075,  0.74459766103,     8742.04270747140}, 
    {     0.00000000056,  3.45704487970,    38805.59390563319}, 
    {     0.00000000058,  2.52293214253,     9815.65173166220}, 
    {     0.00000000069,  6.00335080872,     6531.66165626500}, 
    {     0.00000000060,  5.17254836751,    12410.73130054860}, 
    {     0.00000000057,  0.16619208391,    40398.18991926600}, 
    {     0.00000000059,  2.26838742711,    10050.28646756720}, 
    {     0.00000000064,  0.57865576666,    17101.21113690720}, 
    {     0.00000000066,  6.21390160216,     6947.83189512140}, 
    {     0.00000000066,  2.37798108787,    16703.04487984680}, 
    {     0.00000000060,  2.63886719940,    12979.55317457600}, 
    {     0.00000000055,  3.68795284246,    21393.54196985760}, 
    {     0.00000000057,  5.04754187725,     4140.43355186520}, 
    {     0.00000000056,  5.01714749908,      485.97205278960}, 
    {     0.00000000065,  1.51615820934,     5511.63660199100}, 
    {     0.00000000053,  2.87682182133,     7203.80227149340}, 
    {     0.00000000054,  5.51196184505,       44.65383324020}, 
    {     0.00000000060,  0.05566921393,    14061.72085502680}, 
    {     0.00000000074,  3.09019916148,     4025.65648092580}, 
    {     0.00000000053,  1.21861820918,     4193.80880845180}, 
    {     0.00000000053,  0.36617711595,     6571.01853218020}, 
    {     0.00000000056,  0.31114481144,    13532.02988993220}, 
    {     0.00000000073,  4.66466848719,     6685.10618875760}, 
    {     0.00000000069,  3.37092084432,       41.55079098480}, 
    {     0.00000000059,  0.21062650044,    10042.19259949820}, 
    {     0.00000000063,  4.79535338902,    11883.58313273480}, 
    {     0.00000000059,  6.14382672737,     8958.93223156120}, 
    {     0.00000000054,  3.29479602829,     6756.00645196690}, 
    {     0.00000000053,  6.10868413472,     1612.95133303160}, 
    {     0.00000000052,  1.96782086064,     1083.26036793700}, 
    {     0.00000000057,  2.10329690885,    27832.03821928320}, 
    {     0.00000000068,  3.32674804341,    42942.50433914939}, 
    {     0.00000000071,  6.10818428959,     6691.86151874940}, 
    {     0.00000000051,  1.61052181458,     3029.77162783140}, 
    {     0.00000000052,  4.21598878412,     3651.45322556820}, 
    {     0.00000000050,  3.75658895780,    10042.61267559180}, 
    {     0.00000000066,  4.40947505590,    16703.07938715119}, 
    {     0.00000000059,  0.39936411804,     6286.59896834040}, 
    {     0.00000000059,  5.94433755684,      625.67019231240}, 
    {     0.00000000064,  3.75824458984,    12808.88030395680}, 
    {     0.00000000054,  5.28005670295,    28628.33622609960}, 
    {     0.00000000055,  1.56969289868,     6510.55198278040}, 
    {     0.00000000069,  4.72581931789,     2011.10033643980}, 
    {     0.00000000068,  2.65372686040,      816.65332621520}, 
    {     0.00000000051,  5.11023233159,     9161.52735134660}, 
    {     0.00000000069,  5.05705760339,     3342.09689940810}, 
    {     0.00000000062,  0.99909328902,      151.89728108520}, 
    {     0.00000000053,  2.77399864915,     6705.10329114740}, 
    {     0.00000000049,  5.16996015474,     4447.75123238460}, 
    {     0.00000000048,  1.30926541331,     6549.68289171320}, 
    {     0.00000000066,  4.17738409918,    10020.85695903120}, 
    {     0.00000000049,  4.86456754827,    12942.96506292400}, 
    {     0.00000000051,  0.55899924741,     1481.40937134520}, 
    {     0.00000000053,  1.58015179319,    10001.06188460700}, 
    {     0.00000000049,  3.39901522617,     8756.26980147300}, 
    {     0.00000000048,  0.68184984908,      688.63448287780}, 
    {     0.00000000047,  5.37677881629,    23017.06265793620}, 
    {     0.00000000048,  3.21020023226,     8799.98871377800}, 
    {     0.00000000055,  0.66677211662,     3318.76159737340}, 
    {     0.00000000051,  5.74626065807,     1015.66301788420}, 
    {     0.00000000047,  5.14609845058,     9997.95884235160}, 
    {     0.00000000050,  3.20917726298,    18052.92954315780}, 
    {     0.00000000047,  0.74215475102,      422.02744115600}, 
    {     0.00000000047,  3.04095823655,     5408.54382777240}, 
    {     0.00000000046,  2.71758135355,    10824.20120254560}, 
    {     0.00000000050,  1.03543551128,    10156.90236013480}, 
    {     0.00000000050,  0.61655594931,      270.13016007080}, 
    {     0.00000000051,  2.90067614488,     7799.98064550240}, 
    {     0.00000000052,  5.31852836645,    21000.91589075680}, 
    {     0.00000000051,  1.35064191100,     3760.09707057500}, 
    {     0.00000000045,  0.31849208255,    14469.58851248400}, 
    {     0.00000000050,  1.65024254407,     4356.27544458400}, 
    {     0.00000000045,  5.58923636699,     4936.79886898440}, 
    {     0.00000000047,  1.79752124051,    13524.91634293140}, 
    {     0.00000000058,  1.10099067701,    21150.81336588360}, 
    {     0.00000000052,  2.49167635685,    17468.85519794540}, 
    {     0.00000000045,  4.38265710724,      625.62513619720}, 
    {     0.00000000046,  2.28559740262,     6724.94376570460}, 
    {     0.00000000045,  4.61645404010,       29.88204361020}, 
    {     0.00000000044,  4.94032142325,     6414.61781167780}, 
    {     0.00000000055,  0.07919297482,     6604.95878212400}, 
    {     0.00000000043,  5.65628778837,    16342.95135153740}, 
    {     0.00000000043,  4.92008276380,    11527.12508919240}, 
    {     0.00000000043,  3.30986033214,     3468.63127003720}, 
    {     0.00000000053,  5.43299582587,     9065.54812412880}, 
    {     0.00000000046,  1.03226923951,     6717.25272007700}, 
    {     0.00000000049,  5.80384883795,    26357.67508463600}, 
    {     0.00000000044,  0.42903574980,    19645.52555679060}, 
    {     0.00000000045,  3.87298872071,     9859.37064396720}, 
    {     0.00000000043,  6.05242607837,      382.87927857100}, 
    {     0.00000000045,  0.40077432891,     4133.38731516720}, 
    {     0.00000000050,  2.59711133278,     6621.85099148600}, 
    {     0.00000000055,  3.37488322634,     4271.97551355160}, 
    {     0.00000000044,  5.17169605979,     1375.77379984580}, 
    {     0.00000000047,  5.87192135999,     3490.17562383440}, 
    {     0.00000000041,  0.46061458225,    12012.58229714040}, 
    {     0.00000000042,  4.91358277243,    45088.66975562460}, 
    {     0.00000000044,  5.44858386338,    39048.32250960720}, 
    {     0.00000000056,  0.32998671067,    16489.76303806100}, 
    {     0.00000000042,  3.68136039137,    13363.43002786740}, 
    {     0.00000000041,  4.18351878948,      239.20548562500}, 
    {     0.00000000043,  4.97675015615,     6670.58818804980}, 
    {     0.00000000041,  0.16747184847,    29181.90562894200}, 
    {     0.00000000055,  4.41207846373,    14712.31711645800}, 
    {     0.00000000043,  1.28825253886,     6643.09181776180}, 
    {     0.00000000047,  4.72697589436,     6666.99775939800}, 
    {     0.00000000041,  1.62359144351,    24491.42579258340}, 
    {     0.00000000041,  0.08345338645,    12839.87228870540}, 
    {     0.00000000043,  3.96439822837,     7696.88787128380}, 
    {     0.00000000044,  0.86899972844,    17388.10618772499}, 
    {     0.00000000040,  3.10894579374,    34554.81386366760}, 
    {     0.00000000056,  5.61583520495,    16511.61386738740}, 
    {     0.00000000052,  3.11577112744,     1162.47470440780}, 
    {     0.00000000055,  5.48941084697,    18208.34994259200}, 
    {     0.00000000050,  1.65058020951,    11614.43329373220}, 
    {     0.00000000039,  4.21787836291,     4186.69526145100}, 
    {     0.00000000039,  2.66514604756,     7218.02936549500}, 
    {     0.00000000046,  0.66730374401,     3113.13629391080}, 
    {     0.00000000039,  0.15854793246,    48300.16010269000}, 
    {     0.00000000041,  5.70248947899,     6106.88005506480}, 
    {     0.00000000040,  4.05255896019,    19406.67828817460}, 
    {     0.00000000040,  4.77396367544,    42544.35533574120}, 
    {     0.00000000053,  3.15301214737,      183.86958690200}, 
    {     0.00000000039,  0.51075209632,    17810.20093918380}, 
    {     0.00000000039,  1.62656815590,     9947.05568153210}, 
    {     0.00000000040,  5.62692686678,    26880.31981303260}, 
    {     0.00000000038,  4.59191939331,    10037.08975128440}, 
    {     0.00000000038,  3.66575761860,     6997.61672305620}, 
    {     0.00000000045,  6.15994065455,     3289.33208883739}, 
    {     0.00000000041,  2.77511547733,    16328.72425753579}, 
    {     0.00000000038,  1.43009196037,    10787.63034454580}, 
    {     0.00000000044,  3.57766817797,    14556.89671702380}, 
    {     0.00000000042,  2.92470448863,     4025.72379122860}, 
    {     0.00000000036,  5.66533524812,     3511.28529731900}, 
    {     0.00000000046,  5.30655793995,    17499.36014031540}, 
    {     0.00000000045,  4.15997441733,       36.99559061100}, 
    {     0.00000000037,  3.97235274323,        7.76267071600}, 
    {     0.00000000042,  2.12026198801,    14128.24277124560}, 
    {     0.00000000036,  2.75306774319,     3450.81874791920}, 
    {     0.00000000039,  1.63389094852,     1545.35398297880}, 
    {     0.00000000042,  5.03809379637,    31968.94865279940}, 
    {     0.00000000037,  1.41975087808,     7447.01791784600}, 
    {     0.00000000039,  5.00412653703,     2540.79130153440}, 
    {     0.00000000043,  4.22348706116,    13369.56325380000}, 
    {     0.00000000036,  0.53048140495,      176.69373013380}, 
    {     0.00000000035,  2.25519417749,    19669.33668423559}, 
    {     0.00000000041,  0.69504492745,     3495.96551583120}, 
    {     0.00000000036,  5.24607321878,     2679.37949991880}, 
    {     0.00000000038,  3.14212980126,    30220.93223973240}, 
    {     0.00000000037,  5.40231426955,     3152.68727893721}, 
    {     0.00000000036,  1.04457226935,    20426.57109242200}, 
    {     0.00000000035,  0.32478189872,     3499.55594448300}, 
    {     0.00000000048,  2.09368659974,    32920.66705904999}, 
    {     0.00000000036,  2.63906375223,     8948.22825590860}, 
    {     0.00000000036,  5.56218018463,     7788.36365908440}, 
    {     0.00000000041,  0.34392346712,    13575.74880223720}, 
    {     0.00000000035,  5.11595749110,     7322.10246078180}, 
    {     0.00000000035,  5.54490491000,     9945.57120882380}, 
    {     0.00000000041,  2.83917412143,     3347.29609057390}, 
    {     0.00000000041,  4.06132121378,     3929.67725370800}, 
    {     0.00000000043,  4.03006170081,    38086.87455647900}, 
    {     0.00000000035,  3.14536502087,    24150.08005134500}, 
    {     0.00000000036,  3.31106643723,     9329.67967887260}, 
    {     0.00000000035,  4.64515512748,     9886.77220006400}, 
    {     0.00000000044,  1.03765557298,    20040.15144184979}, 
    {     0.00000000046,  0.52431064900,    28230.18722269139}, 
    {     0.00000000044,  4.61169478741,     3341.03250279340}, 
    {     0.00000000034,  2.95014695560,     6652.77566593180}, 
    {     0.00000000033,  2.51023857323,     2675.85638156980}, 
    {     0.00000000033,  3.62122540203,     6674.17861670160}, 
    {     0.00000000033,  3.87873599689,    25665.51748340920}, 
    {     0.00000000035,  0.31892534784,     6645.19698672220}, 
    {     0.00000000039,  0.38844155951,    18849.22754997420}, 
    {     0.00000000031,  3.42450440874,     4403.51747523800}, 
    {     0.00000000032,  1.28727861900,     9495.66943335380}, 
    {     0.00000000037,  2.68901627056,     7321.12213971360}, 
    {     0.00000000030,  3.11091269619,     9993.38809263160}, 
    {     0.00000000032,  3.56378902470,     6148.01076995600}, 
    {     0.00000000032,  4.23069713034,    10448.43547097540}, 
    {     0.00000000038,  4.21359344480,     3312.16323923200}, 
    {     0.00000000036,  0.26736453929,    36659.42848915800}, 
    {     0.00000000031,  1.91001170906,    31172.65064598300}, 
    {     0.00000000030,  1.79692038909,    10001.48196070061}, 
    {     0.00000000037,  5.48379757539,     3311.18291816379}, 
    {     0.00000000038,  2.88322299393,    10025.42770875120}, 
    {     0.00000000035,  5.38142679524,     3185.25933756840}, 
    {     0.00000000031,  0.35494900654,    10177.19036923080}, 
    {     0.00000000029,  1.34098342476,    29822.78323632420}, 
    {     0.00000000030,  1.39448996174,     4825.54491639400}, 
    {     0.00000000031,  2.46180759992,    10018.24685144760}, 
    {     0.00000000032,  0.41003961929,     3451.79906898740}, 
    {     0.00000000028,  4.68714611901,     2111.65031337760}, 
    {     0.00000000029,  3.94252949224,    23958.63178523340}, 
    {     0.00000000028,  3.38078853114,    32124.36905223359}, 
    {     0.00000000031,  3.18465833136,     3341.04230982650}, 
    {     0.00000000029,  2.25225231358,    26084.02180621620}, 
    {     0.00000000033,  3.49105794187,     3774.32416457660}, 
    {     0.00000000033,  1.71768192600,    34911.41207609100}, 
    {     0.00000000037,  5.42512626922,    31022.75317085620}, 
    {     0.00000000027,  0.98751632143,    16335.83780453660}, 
    {     0.00000000027,  5.29268187817,    29698.28751133580}, 
    {     0.00000000030,  5.45398309970,     8646.06348025360}, 
    {     0.00000000029,  0.21596596499,    20213.25474333179}, 
    {     0.00000000027,  2.67440637509,    16547.64173406480}, 
    {     0.00000000027,  2.31773999101,     6688.27109009760}, 
    {     0.00000000026,  2.05025380662,     5562.46906129680}, 
    {     0.00000000026,  3.28284041047,     2075.04494807340}, 
    {     0.00000000026,  5.00342153930,    48429.28218232440}, 
    {     0.00000000026,  3.79854522408,    12306.59089495900}, 
    {     0.00000000026,  1.89599447067,    13341.67431130680}, 
    {     0.00000000035,  1.72244330701,    24606.13555322000}, 
    {     0.00000000026,  4.44769438876,    10016.31435579200}, 
    {     0.00000000027,  0.93597359176,    13605.17831077320}, 
    {     0.00000000026,  5.00365698783,    13355.33615979840}, 
    {     0.00000000031,  6.27193804892,     1485.98012106520}, 
    {     0.00000000035,  0.76911517486,     6155.05700665400}, 
    {     0.00000000027,  1.27122182637,     6364.83298374300}, 
    {     0.00000000026,  5.55897683200,    20597.24396304120}, 
    {     0.00000000025,  6.22235600230,     5223.69391980220}, 
    {     0.00000000034,  3.38467726966,     2284.75361485960}, 
    {     0.00000000031,  0.88233421548,     3340.18254357310}, 
    {     0.00000000025,  0.83746118261,    12725.45343477500}, 
    {     0.00000000027,  5.67024059955,     1478.86657406440}, 
    {     0.00000000027,  0.42473501075,    33406.12426699800}, 
    {     0.00000000026,  2.15914082099,     3987.62326001460}, 
    {     0.00000000025,  2.91073064727,     3212.59358336240}, 
    {     0.00000000027,  4.12996350734,    13383.22510229160}, 
    {     0.00000000027,  6.05316799952,    13286.18363552360}, 
    {     0.00000000027,  5.81931319013,    24341.52831745660}, 
    {     0.00000000029,  4.41519700273,    16894.51039961060}, 
    {     0.00000000024,  0.20360604382,     3229.42578441220}, 
    {     0.00000000024,  2.10152754634,    14955.04572043200}, 
    {     0.00000000031,  5.90226054729,    11128.97608578420}, 
    {     0.00000000023,  3.37817298437,     6850.80503653260}, 
    {     0.00000000031,  0.35678160238,    31570.79964939120}, 
    {     0.00000000023,  2.38961518808,    23024.17620493700}, 
    {     0.00000000029,  3.03470840975,    22747.29071487440}, 
    {     0.00000000026,  0.51379054479,    29978.20363575840}, 
    {     0.00000000023,  4.26635202793,     3296.89351439480}, 
    {     0.00000000027,  2.64320191197,    24093.27678917520}, 
    {     0.00000000023,  4.96777735461,      799.82112516540}, 
    {     0.00000000024,  3.32945091041,    12140.60114047780}, 
    {     0.00000000025,  3.30212831704,     6740.59871531320}, 
    {     0.00000000023,  5.51381740402,    33561.54466643220}, 
    {     0.00000000023,  0.28172423109,     6593.91664885980}, 
    {     0.00000000022,  5.48861732897,    30376.35263916660}, 
    {     0.00000000023,  2.40580065766,     3344.11829139661}, 
    {     0.00000000028,  5.87506884260,     7747.72033058960}, 
    {     0.00000000021,  2.40354177453,     3304.00706139560}, 
    {     0.00000000024,  1.63482389429,     7483.58877584580}, 
    {     0.00000000028,  1.56312692708,    43340.65334255760}, 
    {     0.00000000022,  5.32476938106,    12928.73796892240}, 
    {     0.00000000026,  3.86983068409,    11353.89216764020}, 
    {     0.00000000023,  4.43657224846,     3344.15279870100}, 
    {     0.00000000021,  3.66824260126,    14951.52260208300}, 
    {     0.00000000022,  0.10813974117,    15423.26756087100}, 
    {     0.00000000025,  5.63091190933,     3416.87849797540}, 
    {     0.00000000025,  1.57746144847,    11567.19126307820}, 
    {     0.00000000026,  2.50180659493,    21791.69097326579}, 
    {     0.00000000022,  4.94823700773,     6681.64492949320}, 
    {     0.00000000026,  0.84448534014,     3397.51080163540}, 
    {     0.00000000021,  4.33866377991,    12729.66596748600}, 
    {     0.00000000021,  0.37058306281,     3391.89276456221}, 
    {     0.00000000022,  1.64362371744,     8852.24902869080}, 
    {     0.00000000027,  0.10733929729,     5195.24473233440}, 
    {     0.00000000021,  1.13140972844,    19403.77727388480}, 
    {     0.00000000026,  2.01526337234,     5032.77809620220}, 
    {     0.00000000021,  5.55525732543,    41748.05732892480}, 
    {     0.00000000021,  2.07959936360,    15106.87569121440}, 
    {     0.00000000024,  3.60866487742,    10006.58480891440}, 
    {     0.00000000028,  5.64135432549,    12516.36687204800}, 
    {     0.00000000027,  5.93032400892,     3074.00538497800}, 
    {     0.00000000025,  3.74768371499,     3232.94890276120}, 
    {     0.00000000022,  3.15578357220,    13366.04013545100}, 
    {     0.00000000021,  3.34013182507,    20752.66436247540}, 
    {     0.00000000026,  1.21869004343,     3377.21779200400}, 
    {     0.00000000024,  2.12604737559,     3171.03224356680}, 
    {     0.00000000022,  4.02124729955,    30774.50164257480}, 
    {     0.00000000024,  3.74309736843,     6747.71226231400}, 
    {     0.00000000023,  2.20705996255,    23553.86717003160}, 
    {     0.00000000021,  3.57070941130,    37895.42629036740}, 
    {     0.00000000023,  2.56549590800,    21192.36415686840}, 
    {     0.00000000021,  3.34401260695,    15010.89646399660}, 
    {     0.00000000019,  2.58752283276,    36261.27948574980}, 
    {     0.00000000021,  5.93180632509,    42146.20633233299}, 
    {     0.00000000018,  1.24405924793,     6768.53305793940}, 
    {     0.00000000019,  2.79026853354,    39203.74290904139}, 
    {     0.00000000024,  2.19710154155,    34513.26307268280}, 
    {     0.00000000020,  1.69850924464,    49225.58018914080}, 
    {     0.00000000018,  1.32432984119,    13497.51478683460}, 
    {     0.00000000018,  2.46520012266,     6944.30877677240}, 
    {     0.00000000018,  5.07942001013,     3337.07205469860}, 
    {     0.00000000018,  5.00983720257,     1655.56030419820}, 
    {     0.00000000018,  0.78739197008,    19676.45023123640}, 
    {     0.00000000018,  0.05420901908,     2142.64229812620}, 
};


static const struct vsop mars_longitude_l2[LONG_L2] = {
    {     0.00058152577,  2.04961712429,     3340.61242669980}, 
    {     0.00013459579,  2.45738706163,     6681.22485339960}, 
    {     0.00002432575,  2.79737979284,    10021.83728009940}, 
    {     0.00000401065,  3.13581149963,    13362.44970679920}, 
    {     0.00000451384,  0.00000000000,        0.00000000000}, 
    {     0.00000222025,  3.19437046607,        3.52311834900}, 
    {     0.00000120954,  0.54327128607,      155.42039943420}, 
    {     0.00000062971,  3.47765178989,    16703.06213349900}, 
    {     0.00000053644,  3.54171478781,     3344.13554504880}, 
    {     0.00000034273,  6.00208464365,     2281.23049651060}, 
    {     0.00000031659,  4.14001980084,      191.44826611160}, 
    {     0.00000029839,  1.99838739380,      796.29800681640}, 
    {     0.00000023172,  4.33401932281,      242.72860397400}, 
    {     0.00000021663,  3.44500841809,      398.14900340820}, 
    {     0.00000016050,  6.11000263211,     2146.16541647520}, 
    {     0.00000020369,  5.42202383442,      553.56940284240}, 
    {     0.00000014924,  6.09549588012,     3185.19202726560}, 
    {     0.00000016229,  0.65685105422,        0.98032106820}, 
    {     0.00000014317,  2.61898820749,     1349.86740965880}, 
    {     0.00000014411,  4.01941740099,      951.71840625060}, 
    {     0.00000011944,  3.86196758615,     6684.74797174860}, 
    {     0.00000015655,  1.22093822826,     1748.01641306700}, 
    {     0.00000011261,  4.71857181601,     2544.31441988340}, 
    {     0.00000013360,  0.60151621438,     1194.44701022460}, 
    {     0.00000010395,  0.25075540193,      382.89653222320}, 
    {     0.00000009415,  0.68050215057,     1059.38193018920}, 
    {     0.00000009580,  3.82256319681,    20043.67456019880}, 
    {     0.00000008996,  3.88272784458,     3738.76143010800}, 
    {     0.00000007498,  5.46428174266,     1751.53953141600}, 
    {     0.00000006499,  5.47802397833,     1592.59601363280}, 
    {     0.00000006307,  2.34134269478,     3097.88382272579}, 
    {     0.00000006864,  2.57523762859,     3149.16416058820}, 
    {     0.00000005871,  1.14862855780,        7.11354700080}, 
    {     0.00000006675,  2.37862627319,     4136.91043351620}, 
    {     0.00000004655,  4.43102251490,     6151.53388830500}, 
    {     0.00000004201,  3.68638044545,     5614.72937620960}, 
    {     0.00000004796,  2.89378142432,     3333.49887969900}, 
    {     0.00000004074,  6.12610105396,     5628.95647021120}, 
    {     0.00000003660,  4.06581319964,     1990.74501704100}, 
    {     0.00000003284,  2.79214099721,     3894.18182954220}, 
    {     0.00000003615,  2.46526861067,      529.69096509460}, 
    {     0.00000003214,  0.68469193035,     8962.45534991020}, 
    {     0.00000003087,  4.56932030502,     3496.03282613400}, 
    {     0.00000002918,  5.41494777349,     2914.01423582380}, 
    {     0.00000002925,  1.23098223044,     2787.04302385740}, 
    {     0.00000002808,  1.38431632694,     4292.33083295040}, 
    {     0.00000002652,  1.05282528913,     3341.59274776800}, 
    {     0.00000002920,  3.41297158184,     3337.08930835080}, 
    {     0.00000002423,  0.96484330240,     4535.05943692440}, 
    {     0.00000002311,  4.84742235872,     9492.14631500480}, 
    {     0.00000002597,  5.74792546254,     3340.59517304760}, 
    {     0.00000002190,  3.26596280325,      213.29909543800}, 
    {     0.00000002598,  1.49506860128,     3340.62968035200}, 
    {     0.00000002365,  4.18303842420,    10025.36039844840}, 
    {     0.00000002630,  4.67732434694,     3583.34103067380}, 
    {     0.00000002606,  2.64976204169,     2388.89402044920}, 
    {     0.00000001822,  0.97105743952,     1589.07289528380}, 
    {     0.00000002397,  1.04493547179,     4399.99435688900}, 
    {     0.00000002203,  0.16281603659,     6525.80445396540}, 
    {     0.00000002373,  4.26885534124,     7079.37385680780}, 
    {     0.00000002366,  0.00564620006,     4690.47983635860}, 
    {     0.00000001623,  4.95374152644,     5088.62883976680}, 
    {     0.00000002143,  0.47993241836,     2700.71514038580}, 
    {     0.00000001646,  4.94105214632,     1221.84856632140}, 
    {     0.00000001588,  1.11405721408,    12303.06777661000}, 
    {     0.00000001518,  0.11076145171,     2957.71589447660}, 
    {     0.00000001774,  3.80344931471,     3723.50895892300}, 
    {     0.00000001364,  3.86744855408,     6283.07584999140}, 
    {     0.00000001764,  2.51992889432,     2810.92146160520}, 
    {     0.00000001394,  2.73608766730,     7477.52286021600}, 
    {     0.00000001280,  5.47285286548,     6677.70173505060}, 
    {     0.00000001447,  2.97506973239,     6489.77658728800}, 
    {     0.00000001248,  3.77100223369,     2699.73481931760}, 
    {     0.00000001527,  2.92629955117,      640.87760738220}, 
    {     0.00000001197,  1.89205359446,     6681.24210705180}, 
    {     0.00000001418,  1.54599865534,     3347.72597370060}, 
    {     0.00000001423,  4.17063094406,    23384.28698689860}, 
    {     0.00000001042,  5.83283345776,     4933.20844033260}, 
    {     0.00000001196,  6.14479114175,     6681.20759974740}, 
    {     0.00000001153,  1.50265359557,      426.59819087600}, 
    {     0.00000001099,  3.80358943061,     3870.30339179440}, 
    {     0.00000000909,  3.81838122072,     5092.15195811580}, 
    {     0.00000001071,  5.04949161471,     5621.84292321040}, 
    {     0.00000000846,  3.82219998207,     3340.54511639700}, 
    {     0.00000001075,  3.81844135104,     3553.91152213780}, 
    {     0.00000000856,  3.42045045625,     3340.67973700260}, 
    {     0.00000000916,  1.91472787569,     3532.06069281140}, 
    {     0.00000000714,  4.26169501052,     9623.68827669120}, 
    {     0.00000000907,  4.12943952579,      162.46663613220}, 
    {     0.00000000653,  3.10816357251,     7234.79425624200}, 
    {     0.00000000792,  5.20659969594,       87.30820453981}, 
    {     0.00000000654,  1.57331630734,     2487.41604494780}, 
    {     0.00000000649,  2.78892909992,      574.34479833480}, 
    {     0.00000000648,  5.18111077100,    12832.75874170460}, 
    {     0.00000000707,  5.83195869320,     3339.63210563160}, 
    {     0.00000000520,  4.64660657418,     6836.64525283380}, 
    {     0.00000000660,  0.24998045706,     8969.56889691100}, 
    {     0.00000000640,  1.70935421799,     7632.94325965020}, 
    {     0.00000000528,  0.31105409350,     8031.09226305840}, 
    {     0.00000000510,  4.63676288319,    10419.98628350760}, 
    {     0.00000000604,  3.85002715377,     5486.77784317500}, 
    {     0.00000000514,  1.38796992796,     7740.60678358880}, 
    {     0.00000000462,  1.33678943112,     7875.67186362420}, 
    {     0.00000000495,  4.50170882091,      692.15760122680}, 
    {     0.00000000471,  1.42441365252,     6682.20517446780}, 
    {     0.00000000550,  4.41887772777,     5331.35744374080}, 
    {     0.00000000439,  1.25554168321,     4929.68532198360}, 
    {     0.00000000419,  5.44439060471,    10018.31416175040}, 
    {     0.00000000537,  1.46176527778,    15643.68020330980}, 
    {     0.00000000405,  1.57332289249,     6127.65545055720}, 
    {     0.00000000390,  3.81525595562,     6681.29216370240}, 
    {     0.00000000397,  4.62209715420,     7210.91581849420}, 
    {     0.00000000367,  1.00110839190,     6041.32756708560}, 
    {     0.00000000358,  0.15138024092,      639.89728631400}, 
    {     0.00000000369,  0.55699031997,    11773.37681151540}, 
    {     0.00000000433,  4.50587650409,    13365.97282514820}, 
    {     0.00000000472,  5.18372269228,     2301.58581590939}, 
    {     0.00000000389,  4.22520163179,     6681.15754309680}, 
    {     0.00000000366,  5.02827753161,     6923.95345737360}, 
    {     0.00000000326,  3.99284456376,     8955.34180290940}, 
    {     0.00000000320,  2.23597582782,    10021.85453375160}, 
    {     0.00000000321,  0.20524537430,    10021.82002644720}, 
    {     0.00000000337,  2.98232216826,     5729.50644714900}, 
    {     0.00000000323,  1.34413812795,     2118.76386037840}, 
    {     0.00000000338,  2.49683073767,     6438.49624942560}, 
    {     0.00000000322,  0.51214404564,     9866.41688066520}, 
    {     0.00000000274,  3.35270419822,     9830.38901398780}, 
    {     0.00000000271,  1.53180722885,     1039.02661079040}, 
    {     0.00000000271,  2.23239080465,     5828.02847164760}, 
    {     0.00000000255,  4.05578912871,     7064.12138562280}, 
    {     0.00000000245,  5.10524905635,     8429.24126646660}, 
    {     0.00000000262,  2.03073386216,     3767.21061757580}, 
    {     0.00000000254,  0.46317479341,     6298.32832117640}, 
    {     0.00000000249,  4.27544865193,     6894.52394883760}, 
    {     0.00000000232,  3.06292621291,    10818.13528691580}, 
    {     0.00000000241,  1.94265839706,     6688.33840040040}, 
    {     0.00000000204,  0.02615801903,     3914.95722503460}, 
    {     0.00000000206,  4.52434051121,    26724.89941359840}, 
    {     0.00000000244,  1.23370429435,     8432.76438481560}, 
    {     0.00000000246,  3.83080164245,     4562.46099302120}, 
    {     0.00000000236,  1.69741583748,     2942.46342329160}, 
    {     0.00000000183,  4.94847733715,    10177.25767953360}, 
    {     0.00000000200,  3.23521719204,     6674.11130639880}, 
    {     0.00000000206,  3.53318037860,    10575.40668294180}, 
    {     0.00000000203,  3.80703081380,     6467.92575796160}, 
    {     0.00000000173,  3.26078770157,     3981.49003408200}, 
    {     0.00000000160,  5.95148314584,      310.84079886840}, 
    {     0.00000000167,  2.15287688461,    10973.55568635000}, 
    {     0.00000000191,  0.77503447629,    15113.98923821520}, 
    {     0.00000000152,  4.35155334509,     3360.96774609859}, 
    {     0.00000000167,  2.41354473163,     3355.86489788480}, 
    {     0.00000000179,  4.59684946724,    12964.30070339100}, 
    {     0.00000000165,  1.93485741767,     3127.31333126180}, 
    {     0.00000000143,  0.30520037218,     1903.43681250120}, 
    {     0.00000000135,  1.64201243891,     3325.35995551480}, 
    {     0.00000000168,  5.98672368946,     3320.25710730100}, 
    {     0.00000000126,  0.06628028702,     9595.23908922340}, 
    {     0.00000000126,  5.09324195826,     3475.67750673520}, 
    {     0.00000000142,  2.22584385110,     3178.14579056760}, 
    {     0.00000000137,  5.52640508040,    16173.37116840440}, 
    {     0.00000000116,  5.54615744680,    13358.92658845020}, 
    {     0.00000000130,  6.12910259056,     8273.82086703240}, 
    {     0.00000000106,  5.74124915667,     2288.34404351140}, 
    {     0.00000000110,  4.00849488333,    13916.01910964160}, 
    {     0.00000000111,  4.15314444907,    10021.90459040220}, 
    {     0.00000000124,  1.03360247396,    18454.60166491500}, 
    {     0.00000000111,  1.81233800595,    18984.29263000960}, 
    {     0.00000000108,  4.01725736300,     5884.92684658320}, 
    {     0.00000000099,  0.69247362673,    12310.18132361080}, 
    {     0.00000000098,  2.52732520244,     3191.04922956520}, 
    {     0.00000000095,  6.00085009229,    14584.29827312060}, 
    {     0.00000000092,  4.38893173686,     9808.53818466140}, 
    {     0.00000000091,  1.72031299533,    11081.21921028860}, 
    {     0.00000000114,  4.11263836293,     6158.64743530580}, 
    {     0.00000000091,  1.71520550367,     1505.28780909299}, 
    {     0.00000000093,  5.66680963190,     3319.83703120740}, 
    {     0.00000000089,  4.96845061541,    13760.59871020740}, 
    {     0.00000000089,  0.44335699327,    11371.70468975820}, 
    {     0.00000000086,  2.99034396202,     7903.07341972100}, 
    {     0.00000000089,  5.87200048108,    16858.48253293320}, 
    {     0.00000000102,  4.55812091356,    10021.76996979660}, 
    {     0.00000000092,  1.59954108842,    24093.27678917520}, 
    {     0.00000000080,  0.23144257625,     9779.10867612540}, 
    {     0.00000000079,  4.65340786273,     6144.42034130420}, 
    {     0.00000000076,  0.49995616312,    13119.72110282519}, 
    {     0.00000000084,  5.55308493446,     3427.92063123960}, 
    {     0.00000000076,  4.52961122356,      708.98980227659}, 
    {     0.00000000072,  1.22310316961,     2274.11694950980}, 
    {     0.00000000097,  5.46490186895,    13517.87010623340}, 
    {     0.00000000073,  5.30141060834,     4845.90023579280}, 
    {     0.00000000070,  0.09877565579,     1437.17561419860}, 
    {     0.00000000093,  5.11228667278,    10551.52824519400}, 
    {     0.00000000075,  0.67412470168,    16460.33352952499}, 
    {     0.00000000068,  2.23465524386,    10213.28554621100}, 
    {     0.00000000079,  5.26872987203,      853.19638175200}, 
    {     0.00000000069,  0.59532377543,    12935.85151592320}, 
    {     0.00000000080,  1.78140455646,    10022.81760116760}, 
    {     0.00000000065,  1.38904078670,     3253.30422216000}, 
    {     0.00000000075,  6.03732407558,     5085.03841111500}, 
    {     0.00000000078,  2.75071312389,    19402.79695281660}, 
    {     0.00000000061,  1.49021039778,     5459.37628707820}, 
    {     0.00000000062,  2.50552301889,     5642.19824260920}, 
    {     0.00000000079,  1.57382509764,     8270.29774868340}, 
    {     0.00000000066,  0.35982344278,     7255.56965173440}, 
    {     0.00000000060,  0.51628343105,    13362.43245314700}, 
    {     0.00000000079,  3.84136206523,     2766.26762836500}, 
    {     0.00000000061,  1.35834394421,    19800.94595622480}, 
    {     0.00000000057,  2.63537932021,    14314.16811304980}, 
    {     0.00000000062,  6.23224285432,     9381.93999378540}, 
    {     0.00000000056,  3.92602466001,     4032.77002792660}, 
    {     0.00000000058,  4.80541369849,    16706.58525184800}, 
    {     0.00000000056,  1.07495829941,     3364.49086444760}, 
    {     0.00000000074,  3.11826754597,     1107.13880568480}, 
    {     0.00000000056,  5.92196461153,    21265.52312652020}, 
    {     0.00000000055,  0.69133485773,     3344.20285535160}, 
    {     0.00000000058,  0.03055561004,     3369.06161416760}, 
    {     0.00000000068,  1.89382886303,     9225.53927328300}, 
    {     0.00000000061,  4.41416512793,    22345.26037610820}, 
    {     0.00000000054,  5.99826659037,    21947.11137270000}, 
    {     0.00000000056,  1.90889246971,    12721.57209941700}, 
    {     0.00000000058,  0.64076710539,     3980.50971301380}, 
    {     0.00000000073,  1.53390867765,     9380.95967271720}, 
    {     0.00000000071,  1.55065593763,     3361.38782219220}, 
    {     0.00000000052,  4.45775383250,    10404.73381232260}, 
    {     0.00000000055,  0.25842078226,     3337.02199804800}, 
    {     0.00000000050,  0.62274445643,     7373.38245462640}, 
    {     0.00000000065,  2.99158486208,     3316.73398895200}, 
    {     0.00000000050,  2.91155201771,     8982.81066930900}, 
    {     0.00000000051,  2.53925124485,    13362.46696045140}, 
    {     0.00000000053,  1.75963973665,     2648.45482547300}, 
    {     0.00000000047,  3.74205609558,    33716.96506586640}, 
    {     0.00000000047,  2.33985323120,    16062.18452611680}, 
    {     0.00000000051,  4.76183443226,     8671.96987044060}, 
    {     0.00000000047,  3.61238635706,    30376.35263916660}, 
    {     0.00000000045,  3.17314820387,     2818.03500860600}, 
    {     0.00000000056,  0.85677332683,    17468.85519794540}, 
    {     0.00000000054,  1.68830003586,    11216.28429032400}, 
    {     0.00000000054,  1.32704907908,     8439.87793181640}, 
    {     0.00000000059,  3.89706899146,     5244.04923920100}, 
    {     0.00000000043,  1.45207414702,    24889.57479599160}, 
    {     0.00000000043,  4.93434500530,    14469.58851248400}, 
    {     0.00000000047,  0.63724859746,    15110.46611986620}, 
    {     0.00000000048,  1.93153003679,     9468.26787725700}, 
    {     0.00000000041,  0.80934461579,    13207.02930736500}, 
    {     0.00000000043,  0.86742732243,    20752.66436247540}, 
    {     0.00000000041,  3.35182836767,     9588.12554222260}, 
    {     0.00000000043,  3.19403696329,    22743.40937951640}, 
    {     0.00000000040,  3.80517212464,    28628.33622609960}, 
    {     0.00000000045,  3.44446459800,    14158.74771361560}, 
    {     0.00000000041,  5.33088551342,      765.79306444640}, 
    {     0.00000000038,  2.34719947252,    10028.95082710020}, 
    {     0.00000000037,  4.87740795169,    30065.51184029820}, 
    {     0.00000000042,  3.77822295434,     3503.07906283200}, 
    {     0.00000000037,  0.24131392245,     9168.64089834740}, 
    {     0.00000000037,  2.42831434862,     7107.82304427560}, 
    {     0.00000000039,  3.67137247569,    13171.00144068760}, 
    {     0.00000000037,  5.41610716116,    10264.56588407340}, 
    {     0.00000000047,  0.89637520949,    16703.04487984680}, 
    {     0.00000000041,  0.68153555810,    11766.26326451460}, 
    {     0.00000000046,  1.51332559161,     6040.34724601740}, 
    {     0.00000000037,  1.95319370926,     6702.00024889200}, 
    {     0.00000000036,  0.79575390273,    20597.24396304120}, 
    {     0.00000000035,  3.79593106555,     1066.49547719000}, 
    {     0.00000000035,  3.48692827125,     9070.11887384880}, 
    {     0.00000000035,  4.69051318198,    10235.13637553740}, 
    {     0.00000000034,  1.42262836561,    21795.21409161479}, 
    {     0.00000000047,  2.92683549770,    16703.07938715119}, 
    {     0.00000000044,  2.00401073062,    28230.18722269139}, 
    {     0.00000000033,  5.86775675864,    19513.98359510420}, 
    {     0.00000000035,  4.22435449199,     8584.66166590080}, 
    {     0.00000000044,  6.08581860630,     6660.44945790720}, 
    {     0.00000000033,  2.61681384731,     6696.47732458460}, 
    {     0.00000000034,  3.70456078721,    15664.03552270859}, 
    {     0.00000000043,  5.44670688059,     6816.28993343500}, 
    {     0.00000000037,  2.03776406606,    14556.89671702380}, 
    {     0.00000000037,  5.71433282530,     5099.26550511660}, 
    {     0.00000000041,  0.17225787246,    25287.72379939980}, 
    {     0.00000000031,  2.30685466428,    10042.61267559180}, 
    {     0.00000000034,  0.72658199838,    11780.49035851620}, 
    {     0.00000000030,  1.28426808967,    11243.68584642080}, 
    {     0.00000000030,  3.37226860046,    27832.03821928320}, 
    {     0.00000000030,  4.49208108982,     9499.25986200560}, 
    {     0.00000000032,  4.74490222844,    17256.63153634140}, 
    {     0.00000000031,  5.02978229455,    25685.87280280800}, 
    {     0.00000000029,  1.05521949715,    13936.79450513400}, 
    {     0.00000000029,  2.13159143713,    22324.90505670940}, 
    {     0.00000000034,  0.77946190155,    10596.18207843420}, 
    {     0.00000000028,  5.13684548975,    12012.58229714040}, 
    {     0.00000000029,  4.19390076272,     6106.88005506480}, 
    {     0.00000000030,  5.79496586838,    10156.90236013480}, 
    {     0.00000000030,  1.95532800090,     6665.97238221460}, 
    {     0.00000000030,  4.37086181476,    12295.95422960920}, 
    {     0.00000000037,  3.33119104614,    12323.42309600880}, 
    {     0.00000000032,  0.03328289020,    17924.91069982040}, 
    {     0.00000000031,  6.22551067475,     6660.86953400080}, 
    {     0.00000000027,  6.22583184601,    20199.09495963300}, 
    {     0.00000000027,  4.47604397206,    15508.61512327440}, 
    {     0.00000000027,  4.18952669137,    19004.64794940840}, 
    {     0.00000000029,  0.33347322113,    11614.43329373220}, 
    {     0.00000000027,  2.55492575464,    13553.89797291080}, 
    {     0.00000000027,  5.17429820364,    20047.19767854780}, 
    {     0.00000000026,  4.75069348623,     9485.03276800400}, 
    {     0.00000000028,  5.05646024487,    16304.91313009080}, 
    {     0.00000000026,  0.33571424841,     1758.65307841680}, 
    {     0.00000000026,  1.88254124807,     4379.63903749020}, 
    {     0.00000000026,  0.66164680044,     6677.63442474780}, 
    {     0.00000000027,  0.16359834714,    10001.06188460700}, 
    {     0.00000000026,  1.27240071340,    21548.96236929180}, 
    {     0.00000000027,  2.42251642195,     6518.75821726740}, 
    {     0.00000000025,  0.38159855574,    10001.48196070061}, 
    {     0.00000000025,  5.68892581324,     4193.80880845180}, 
    {     0.00000000025,  3.41513259489,     6657.34641565180}, 
    {     0.00000000031,  0.85409497605,    16276.46394262300}, 
    {     0.00000000025,  4.41986609477,    12168.00269657460}, 
    {     0.00000000030,  4.77047285234,    12722.55242048520}, 
    {     0.00000000028,  3.06003442590,     6247.51311552280}, 
    {     0.00000000025,  3.09863827375,    10037.08975128440}, 
    {     0.00000000025,  1.02575938018,    15650.79375031060}, 
    {     0.00000000024,  3.95596007260,     4936.79886898440}, 
    {     0.00000000024,  0.15547683375,    23141.55838292460}, 
    {     0.00000000024,  2.02621002883,     5989.06725217280}, 
    {     0.00000000030,  5.78174720450,    16699.53901514999}, 
    {     0.00000000026,  1.86541912366,    11610.91017538320}, 
    {     0.00000000026,  1.09364283303,     6684.81528205140}, 
    {     0.00000000025,  3.89771277869,     1052.26838318840}, 
    {     0.00000000027,  2.56503603603,    18052.92954315780}, 
    {     0.00000000023,  1.51797615340,    24491.42579258340}, 
    {     0.00000000023,  3.00396120711,    12566.15169998280}, 
    {     0.00000000022,  4.95564076891,    13362.38239649640}, 
    {     0.00000000026,  5.35396491473,    17101.21113690720}, 
    {     0.00000000025,  0.78394576420,     3863.18984479360}, 
    {     0.00000000029,  0.72436044897,     9638.94074787620}, 
    {     0.00000000023,  4.78936229419,    11925.27409260060}, 
    {     0.00000000028,  0.45519439131,     6709.67404086740}, 
    {     0.00000000026,  4.87772426583,    13149.15061136120}, 
    {     0.00000000023,  5.40586773017,    13892.14067189380}, 
    {     0.00000000023,  2.35248036676,    30774.50164257480}, 
    {     0.00000000028,  1.10862278422,     8425.65083781480}, 
    {     0.00000000023,  3.61712960620,     1581.95934828300}, 
    {     0.00000000026,  0.31100585552,     3603.69635007260}, 
    {     0.00000000020,  2.43389989577,    19406.67828817460}, 
    {     0.00000000025,  5.91413646106,     6680.24453233140}, 
    {     0.00000000020,  5.43460902247,    17395.21973472580}, 
    {     0.00000000025,  1.00211327228,     7321.12213971360}, 
    {     0.00000000020,  5.58281555175,    18606.49894600020}, 
    {     0.00000000025,  3.57752663624,     3873.82651014340}, 
    {     0.00000000021,  2.14222861506,    14421.83163698840}, 
    {     0.00000000020,  5.47581404162,    20735.83216142559}, 
    {     0.00000000021,  5.53809813850,    15265.88651930040}, 
    {     0.00000000019,  5.69034956533,    17013.90293236740}, 
    {     0.00000000019,  5.76144586324,    17085.95866572220}, 
    {     0.00000000022,  2.98924680598,     9602.35263622420}, 
    {     0.00000000019,  5.73996220529,     3651.45322556820}, 
    {     0.00000000018,  0.52367856726,    14054.60730802600}, 
    {     0.00000000022,  5.16650472247,     3376.64029337720}, 
    {     0.00000000020,  2.67348019896,    10448.43547097540}, 
    {     0.00000000018,  3.70248341637,    37057.57749256620}, 
    {     0.00000000018,  2.14231646843,    13363.43002786740}, 
    {     0.00000000020,  6.25669293739,     1744.42598441520}, 
    {     0.00000000020,  1.60190678685,    23296.97878235879}, 
    {     0.00000000023,  4.54770256231,    13362.51701710200}, 
    {     0.00000000024,  0.54356017220,     6475.03930496240}, 
    {     0.00000000023,  2.73656801737,     6261.74020952440}, 
    {     0.00000000018,  5.45243764566,    40000.04091585779}, 
    {     0.00000000018,  1.77799263643,     8799.98871377800}, 
    {     0.00000000018,  1.18266196226,    31172.65064598300}, 
    {     0.00000000019,  3.66181465270,     1596.18644228460}, 
    {     0.00000000018,  3.46673198156,     3546.79797513700}, 
    {     0.00000000022,  2.15272313802,     3335.08950239240}, 
    {     0.00000000018,  0.13829920233,     3877.41693879520}, 
    {     0.00000000020,  4.57210028361,     6701.58017279840}, 
    {     0.00000000019,  5.09290088720,     3205.54734666440}, 
    {     0.00000000016,  3.67355426368,    20995.39296644940}, 
    {     0.00000000016,  6.13550943291,     3134.42687826260}, 
    {     0.00000000016,  6.22620467137,    22854.59602180400}, 
    {     0.00000000016,  1.44137713060,     6460.81221096080}, 
    {     0.00000000015,  1.18753446282,     7203.80227149340}, 
    {     0.00000000016,  3.90125903944,     7322.10246078180}, 
    {     0.00000000015,  4.93156258719,     3304.58456002240}, 
    {     0.00000000017,  0.49763390696,    18208.34994259200}, 
    {     0.00000000017,  3.32863823640,     3333.56619000180}, 
    {     0.00000000014,  5.31587329158,    19645.52555679060}, 
    {     0.00000000017,  3.01193328720,     3344.49376205780}, 
    {     0.00000000016,  4.54660273048,     4392.88080988820}, 
    {     0.00000000013,  5.26350209812,    16702.99482319620}, 
    {     0.00000000016,  6.12947849429,    26087.90314157420}, 
    {     0.00000000013,  5.84447235851,      536.80451209540}, 
    {     0.00000000017,  4.09065954177,    16511.61386738740}, 
    {     0.00000000015,  5.73438221173,    14867.73751589219}, 
    {     0.00000000013,  2.54721959021,     6675.70192909220}, 
    {     0.00000000014,  1.31577259278,    21150.81336588360}, 
    {     0.00000000013,  2.12815796147,     3346.13535100720}, 
    {     0.00000000013,  3.59360902373,    12410.73130054860}, 
    {     0.00000000016,  5.67307416663,    11527.12508919240}, 
    {     0.00000000016,  0.84938642384,    10184.30391623160}, 
    {     0.00000000013,  6.16919624193,     3077.52850332700}, 
    {     0.00000000014,  3.93053280186,     3312.16323923200}, 
    {     0.00000000014,  2.55072089788,      206.18554843720}, 
    {     0.00000000013,  4.69830610865,    16703.12944380180}, 
    {     0.00000000012,  0.92968593112,    10713.99488132620}, 
    {     0.00000000011,  6.09331837551,     8827.39026987480}, 
    {     0.00000000014,  3.77650372404,    17499.36014031540}, 
    {     0.00000000011,  1.09619387864,    16547.64173406480}, 
    {     0.00000000011,  5.05016560122,    24076.44458812540}, 
    {     0.00000000015,  6.16612008928,     3347.65866339780}, 
    {     0.00000000011,  1.92845507292,    11769.85369316640}, 
    {     0.00000000013,  1.01843193479,    10018.24685144760}, 
    {     0.00000000015,  0.92188099847,     3281.23856478620}, 
    {     0.00000000013,  5.19040439871,    16489.76303806100}, 
    {     0.00000000011,  0.29063320387,     2906.90068882300}, 
    {     0.00000000011,  5.65061614555,    13605.17831077320}, 
    {     0.00000000013,  5.06832582026,    13575.74880223720}, 
    {     0.00000000011,  5.42648525700,    17232.75309859360}, 
    {     0.00000000014,  2.18442424174,    12808.88030395680}, 
    {     0.00000000010,  3.12070301287,     2803.80791460440}, 
    {     0.00000000011,  1.35555533168,     2277.70737816160}, 
    {     0.00000000010,  5.89715293869,     6768.53305793940}, 
    {     0.00000000010,  5.93295499002,    23937.85638974100}, 
    {     0.00000000012,  1.20813089438,     3336.73109134180}, 
    {     0.00000000011,  2.56209057142,    13369.56325380000}, 
    {     0.00000000012,  0.50116227157,    34513.26307268280}, 
    {     0.00000000010,  4.37163145009,     3607.21946842160}, 
    {     0.00000000011,  4.03902225289,     4407.10790388980}, 
    {     0.00000000010,  4.18585556139,        0.01725365220}, 
    {     0.00000000011,  0.06058557016,    26880.31981303260}, 
    {     0.00000000011,  5.12397606143,    33406.12426699800}, 
    {     0.00000000011,  1.00077091959,    12979.55317457600}, 
    {     0.00000000010,  0.39595065439,    14955.04572043200}, 
    {     0.00000000011,  3.36133910370,    16894.51039961060}, 
    {     0.00000000010,  1.63992012008,      220.41264243880}, 
    {     0.00000000010,  5.76293648428,    31968.94865279940}, 
    {     0.00000000013,  1.44898528338,    10025.42770875120}, 
    {     0.00000000011,  4.36692917575,    34115.11406927460}, 
    {     0.00000000010,  4.84826192777,    12839.87228870540}, 
    {     0.00000000010,  1.85828895892,     6593.91664885980}, 
    {     0.00000000010,  5.75866529304,     6717.25272007700}, 
    {     0.00000000012,  4.33022696919,     7747.72033058960}, 
    {     0.00000000011,  5.96309733546,    20040.15144184979}, 
    {     0.00000000010,  3.58563293895,    20354.51535906720}, 
    {     0.00000000010,  4.88835260040,    10042.19259949820}, 
    {     0.00000000010,  2.48515633128,    25665.51748340920}, 
    {     0.00000000009,  1.77145376267,    32367.09765620760}, 
};


static const struct vsop mars_longitude_l3[LONG_L3] = {
    {     0.00001467867,  0.44429839460,     3340.61242669980}, 
    {     0.00000692668,  0.88679887123,     6681.22485339960}, 
    {     0.00000189478,  1.28336839921,    10021.83728009940}, 
    {     0.00000041615,  1.64210455567,    13362.44970679920}, 
    {     0.00000022660,  2.05278956965,      155.42039943420}, 
    {     0.00000008126,  1.99049724299,    16703.06213349900}, 
    {     0.00000010455,  1.57992093693,        3.52311834900}, 
    {     0.00000004902,  2.82516875010,      242.72860397400}, 
    {     0.00000005379,  3.14159265359,        0.00000000000}, 
    {     0.00000003782,  2.01848153986,     3344.13554504880}, 
    {     0.00000003181,  4.59108786647,     3185.19202726560}, 
    {     0.00000003133,  0.65141319517,      553.56940284240}, 
    {     0.00000001698,  5.53803382831,      951.71840625060}, 
    {     0.00000001525,  5.71698515888,      191.44826611160}, 
    {     0.00000001451,  0.46068490220,      796.29800681640}, 
    {     0.00000001473,  2.33727441522,    20043.67456019880}, 
    {     0.00000001314,  5.36403056955,        0.98032106820}, 
    {     0.00000001178,  4.14644990348,     1349.86740965880}, 
    {     0.00000001138,  2.37914351932,     6684.74797174860}, 
    {     0.00000001046,  1.76915268602,      382.89653222320}, 
    {     0.00000000902,  5.35475854699,     1194.44701022460}, 
    {     0.00000000813,  2.74852234414,     1748.01641306700}, 
    {     0.00000000629,  6.08292992203,     3496.03282613400}, 
    {     0.00000000564,  1.87914711325,      398.14900340820}, 
    {     0.00000000566,  5.85439216540,        7.11354700080}, 
    {     0.00000000646,  3.17980126471,     3583.34103067380}, 
    {     0.00000000461,  5.99300094958,     2787.04302385740}, 
    {     0.00000000515,  1.00397565149,     3149.16416058820}, 
    {     0.00000000524,  4.94366714135,     6525.80445396540}, 
    {     0.00000000405,  1.25868884474,     2281.23049651060}, 
    {     0.00000000396,  2.33533869272,     3738.76143010800}, 
    {     0.00000000473,  0.85569341494,     4136.91043351620}, 
    {     0.00000000337,  5.42720231008,     1059.38193018920}, 
    {     0.00000000312,  3.71767667252,     3097.88382272579}, 
    {     0.00000000280,  5.77799085447,     3341.59274776800}, 
    {     0.00000000282,  2.71397487800,    10025.36039844840}, 
    {     0.00000000215,  5.72936855193,     4535.05943692440}, 
    {     0.00000000213,  2.52113312108,     1990.74501704100}, 
    {     0.00000000253,  2.68513749891,    23384.28698689860}, 
    {     0.00000000271,  1.11020953644,     2388.89402044920}, 
    {     0.00000000186,  4.87399580961,     2957.71589447660}, 
    {     0.00000000178,  3.91361250070,     1592.59601363280}, 
    {     0.00000000175,  0.87350226081,     3894.18182954220}, 
    {     0.00000000191,  4.57651964364,     3337.08930835080}, 
    {     0.00000000166,  2.74261580519,     7079.37385680780}, 
    {     0.00000000132,  1.21969793594,     7477.52286021600}, 
    {     0.00000000176,  5.82269855073,     4399.99435688900}, 
    {     0.00000000144,  1.41866825837,     6489.77658728800}, 
    {     0.00000000116,  3.26440506489,     9492.14631500480}, 
    {     0.00000000110,  5.25036780309,     8962.45534991020}, 
    {     0.00000000109,  2.69848602723,     6151.53388830500}, 
    {     0.00000000099,  3.53126616352,     6923.95345737360}, 
    {     0.00000000094,  5.83398846011,    12303.06777661000}, 
    {     0.00000000082,  5.71976568172,     4292.33083295040}, 
    {     0.00000000082,  0.07031928087,     6127.65545055720}, 
    {     0.00000000079,  5.82605787124,     1589.07289528380}, 
    {     0.00000000086,  5.29348370173,     9866.41688066520}, 
    {     0.00000000101,  0.00033367659,     3347.72597370060}, 
    {     0.00000000076,  4.33662644570,     4933.20844033260}, 
    {     0.00000000066,  4.98095301409,     5486.77784317500}, 
    {     0.00000000066,  1.74326529570,     3870.30339179440}, 
    {     0.00000000059,  1.47406427963,     7234.79425624200}, 
    {     0.00000000065,  4.13790023458,     3340.59517304760}, 
    {     0.00000000066,  6.17474740457,     6682.20517446780}, 
    {     0.00000000065,  6.16873733389,     3340.62968035200}, 
    {     0.00000000061,  3.04498621253,    13365.97282514820}, 
    {     0.00000000057,  0.34435287503,     6681.24210705180}, 
    {     0.00000000052,  3.10877560472,    10419.98628350760}, 
    {     0.00000000053,  1.49212635155,     5729.50644714900}, 
    {     0.00000000052,  6.16231097097,     7740.60678358880}, 
    {     0.00000000057,  4.59725498148,     6681.20759974740}, 
    {     0.00000000047,  6.08280843167,     7875.67186362420}, 
    {     0.00000000046,  2.22700618360,     6283.07584999140}, 
    {     0.00000000042,  4.17552906301,     4690.47983635860}, 
    {     0.00000000053,  4.86310998799,     5621.84292321040}, 
    {     0.00000000039,  3.01231289993,    26724.89941359840}, 
    {     0.00000000044,  1.83807443880,     3723.50895892300}, 
    {     0.00000000045,  3.66313190536,    12832.75874170460}, 
    {     0.00000000049,  2.90677449550,     5331.35744374080}, 
    {     0.00000000041,  5.09013551341,     8969.56889691100}, 
    {     0.00000000035,  1.80197655191,     9830.38901398780}, 
    {     0.00000000036,  6.20064893632,     6836.64525283380}, 
    {     0.00000000041,  4.73855176222,     6677.70173505060}, 
    {     0.00000000043,  0.12056288166,     7632.94325965020}, 
    {     0.00000000036,  3.95211035317,     5092.15195811580}, 
    {     0.00000000041,  1.02183708699,     3339.63210563160}, 
    {     0.00000000032,  6.08260895536,     4929.68532198360}, 
    {     0.00000000029,  1.62918363864,    10818.13528691580}, 
    {     0.00000000033,  5.28926114198,     6298.32832117640}, 
    {     0.00000000035,  2.19127331195,     3553.91152213780}, 
    {     0.00000000031,  1.71403126017,     6674.11130639880}, 
    {     0.00000000027,  2.59859773299,     9623.68827669120}, 
    {     0.00000000037,  6.26363818135,    15643.68020330980}, 
    {     0.00000000026,  0.41795219764,     6688.33840040040}, 
    {     0.00000000025,  2.61050876047,     8955.34180290940}, 
    {     0.00000000024,  2.72770670140,     7210.91581849420}, 
    {     0.00000000022,  0.56923205824,     3333.49887969900}, 
    {     0.00000000024,  1.08927112722,    13362.46696045140}, 
    {     0.00000000024,  1.27631664508,     2146.16541647520}, 
    {     0.00000000021,  2.25460322522,     6681.29216370240}, 
    {     0.00000000021,  1.21340354488,      529.69096509460}, 
    {     0.00000000019,  2.21770037001,     3340.54511639700}, 
    {     0.00000000019,  0.66923624814,    10021.85453375160}, 
    {     0.00000000019,  4.96725594495,    10021.82002644720}, 
    {     0.00000000021,  2.66383165337,     6681.15754309680}, 
    {     0.00000000019,  5.34528034089,    13362.43245314700}, 
    {     0.00000000020,  4.05200075148,    16173.37116840440}, 
    {     0.00000000018,  6.12827330419,     2118.76386037840}, 
    {     0.00000000019,  1.81106961128,     3340.67973700260}, 
    {     0.00000000023,  3.65530501555,     5884.92684658320}, 
    {     0.00000000017,  3.49526304116,    13760.59871020740}, 
    {     0.00000000017,  2.19106157796,    13171.00144068760}, 
    {     0.00000000018,  2.57298367742,     6894.52394883760}, 
    {     0.00000000015,  3.38406160245,    16706.58525184800}, 
    {     0.00000000020,  5.66097673948,    11773.37681151540}, 
    {     0.00000000016,  5.03015729119,     8031.09226305840}, 
    {     0.00000000018,  5.85813180984,    15113.98923821520}, 
    {     0.00000000015,  0.77504052248,    10028.95082710020}, 
    {     0.00000000015,  0.57957141835,    10973.55568635000}, 
    {     0.00000000014,  0.24974244701,     5088.62883976680}, 
    {     0.00000000018,  3.07924421940,    12964.30070339100}, 
    {     0.00000000015,  2.68623334057,    10021.90459040220}, 
    {     0.00000000015,  3.09469457587,    10021.76996979660}, 
    {     0.00000000013,  3.93023649028,    10264.56588407340}, 
    {     0.00000000013,  5.65831284328,    13207.02930736500}, 
    {     0.00000000013,  1.84300811278,     9070.11887384880}, 
    {     0.00000000014,  0.29740739896,    18984.29263000960}, 
    {     0.00000000013,  2.52001940946,     7064.12138562280}, 
    {     0.00000000013,  3.67191025834,     3320.25710730100}, 
    {     0.00000000013,  0.38182731490,    11081.21921028860}, 
    {     0.00000000015,  5.65316717493,     9638.94074787620}, 
    {     0.00000000015,  1.98431328230,    14158.74771361560}, 
    {     0.00000000012,  5.41217638500,    12310.18132361080}, 
    {     0.00000000013,  2.16005341496,     3503.07906283200}, 
    {     0.00000000013,  2.04039005845,     3360.96774609859}, 
    {     0.00000000012,  3.10587105006,    10551.52824519400}, 
    {     0.00000000012,  0.10001647761,     3355.86489788480}, 
    {     0.00000000011,  2.14032736093,    10014.72373309860}, 
    {     0.00000000011,  1.79726060971,     6438.49624942560}, 
    {     0.00000000014,  0.17608466993,    11216.28429032400}, 
    {     0.00000000011,  3.38101843423,    30065.51184029820}, 
    {     0.00000000010,  0.14034808917,     5459.37628707820}, 
    {     0.00000000012,  1.39972628733,     7322.10246078180}, 
    {     0.00000000010,  5.01174496801,     8432.76438481560}, 
    {     0.00000000010,  4.85370121323,     8827.39026987480}, 
    {     0.00000000012,  1.85790840539,    10575.40668294180}, 
    {     0.00000000011,  5.68929132609,     2544.31441988340}, 
    {     0.00000000013,  0.11973675130,     8270.29774868340}, 
    {     0.00000000010,  3.45366828680,     8671.96987044060}, 
    {     0.00000000010,  1.63456773166,     6467.92575796160}, 
    {     0.00000000012,  0.48472196247,     9468.26787725700}, 
    {     0.00000000010,  1.79285582925,     3981.49003408200}, 
    {     0.00000000012,  4.35157153740,    13358.92658845020}, 
    {     0.00000000012,  4.70754717702,     8273.82086703240}, 
    {     0.00000000009,  5.67195388102,     6041.32756708560}, 
    {     0.00000000011,  0.28291831064,    10022.81760116760}, 
    {     0.00000000012,  0.19598354169,     3767.21061757580}, 
    {     0.00000000009,  0.79888103600,     7107.82304427560}, 
    {     0.00000000009,  2.63887133820,     6040.34724601740}, 
    {     0.00000000010,  4.24040970796,    10018.31416175040}, 
    {     0.00000000008,  4.41344390506,     3532.06069281140}, 
    {     0.00000000009,  4.61082143531,     6254.62666252360}, 
    {     0.00000000010,  3.14867092101,    12295.95422960920}, 
    {     0.00000000008,  4.30808895338,    13517.87010623340}, 
    {     0.00000000007,  3.72930971887,    20047.19767854780}, 
    {     0.00000000007,  5.31461308603,     3980.50971301380}, 
    {     0.00000000007,  4.41228197932,    19513.98359510420}, 
    {     0.00000000006,  0.70081238478,    22324.90505670940}, 
    {     0.00000000007,  3.46042125643,    16304.91313009080}, 
    {     0.00000000006,  4.18130136613,     9225.53927328300}, 
    {     0.00000000007,  2.07260074047,     2274.11694950980}, 
    {     0.00000000008,  4.84690285943,     5614.72937620960}, 
    {     0.00000000007,  5.81948406996,    18454.60166491500}, 
    {     0.00000000006,  4.58700022729,    12935.85151592320}, 
    {     0.00000000006,  3.09847010281,    10235.13637553740}, 
    {     0.00000000007,  5.65100333611,     3325.35995551480}, 
    {     0.00000000006,  3.88836191013,     8429.24126646660}, 
    {     0.00000000006,  6.08444137601,      426.59819087600}, 
    {     0.00000000007,  4.39290235530,    16699.53901514999}, 
    {     0.00000000006,  4.96952219943,    11614.43329373220}, 
    {     0.00000000007,  3.86534915027,    17101.21113690720}, 
    {     0.00000000005,  3.27691563611,      213.29909543800}, 
    {     0.00000000006,  2.22078885531,    13916.01910964160}, 
    {     0.00000000005,  5.40200843260,    11371.70468975820}, 
    {     0.00000000006,  3.73369549160,    33406.12426699800}, 
    {     0.00000000005,  1.76068977855,     1066.49547719000}, 
    {     0.00000000005,  3.34460420545,     4562.46099302120}, 
    {     0.00000000005,  5.87001587166,    16547.64173406480}, 
    {     0.00000000005,  2.58164780968,    10404.73381232260}, 
    {     0.00000000005,  0.95143416553,     6872.67311951120}, 
    {     0.00000000005,  3.29623418943,    13362.38239649640}, 
    {     0.00000000005,  4.15921606694,        0.01725365220}, 
    {     0.00000000005,  1.88015249528,    15508.61512327440}, 
    {     0.00000000005,  4.69029931558,     2700.71514038580}, 
};


static const struct vsop mars_longitude_l4[LONG_L4] = {
    {     0.00000027242,  5.63997742320,     6681.22485339960}, 
    {     0.00000025511,  5.13956279086,     3340.61242669980}, 
    {     0.00000011147,  6.03556608878,    10021.83728009940}, 
    {     0.00000003190,  3.56206901204,      155.42039943420}, 
    {     0.00000003251,  0.12915616460,    13362.44970679920}, 
    {     0.00000000790,  0.48979114861,    16703.06213349900}, 
    {     0.00000000783,  1.31770747646,      242.72860397400}, 
    {     0.00000000500,  3.08200921500,     3185.19202726560}, 
    {     0.00000000374,  2.15499052115,      553.56940284240}, 
    {     0.00000000338,  6.23352693699,        3.52311834900}, 
    {     0.00000000199,  0.45348344109,     3344.13554504880}, 
    {     0.00000000168,  3.76870889622,     3496.03282613400}, 
    {     0.00000000171,  0.84135133604,    20043.67456019880}, 
    {     0.00000000115,  1.67425271260,     3583.34103067380}, 
    {     0.00000000080,  0.85706484335,     6684.74797174860}, 
    {     0.00000000091,  3.43800003890,     6525.80445396540}, 
    {     0.00000000062,  4.48712111677,     2787.04302385740}, 
    {     0.00000000043,  5.18700577258,     3097.88382272579}, 
    {     0.00000000047,  0.00000000000,        0.00000000000}, 
    {     0.00000000037,  1.18296722277,    23384.28698689860}, 
    {     0.00000000024,  4.29204464862,     6836.64525283380}, 
    {     0.00000000026,  1.20348583477,    10025.36039844840}, 
    {     0.00000000024,  5.60827511165,     4136.91043351620}, 
    {     0.00000000022,  5.74642710221,     3149.16416058820}, 
    {     0.00000000018,  2.03318579635,     6923.95345737360}, 
    {     0.00000000015,  4.26014468247,     3341.59274776800}, 
    {     0.00000000018,  2.33884195894,     3894.18182954220}, 
    {     0.00000000015,  0.76745028682,     3738.76143010800}, 
    {     0.00000000013,  3.78255342218,     9866.41688066520}, 
    {     0.00000000013,  4.84669665560,     6127.65545055720}, 
    {     0.00000000015,  5.90904577370,     2388.89402044920}, 
    {     0.00000000012,  4.04057703674,     4535.05943692440}, 
    {     0.00000000011,  3.87847882201,     1059.38193018920}, 
    {     0.00000000011,  6.15709897926,     6489.77658728800}, 
    {     0.00000000010,  1.72288144187,     9492.14631500480}, 
    {     0.00000000010,  1.57846217224,    13365.97282514820}, 
    {     0.00000000008,  2.41269301261,     1592.59601363280}, 
    {     0.00000000008,  3.38799237939,     2957.71589447660}, 
    {     0.00000000008,  6.09858519460,     7477.52286021600}, 
    {     0.00000000010,  1.26692397596,     1990.74501704100}, 
    {     0.00000000010,  1.19094173671,     7079.37385680780}, 
    {     0.00000000011,  4.27677188971,     4399.99435688900}, 
    {     0.00000000008,  4.14850970681,    13207.02930736500}, 
    {     0.00000000008,  1.54297406750,    26724.89941359840}, 
    {     0.00000000007,  0.26868468775,     9830.38901398780}, 
    {     0.00000000007,  0.08101546764,    10818.13528691580}, 
    {     0.00000000007,  2.42508289520,    10264.56588407340}, 
    {     0.00000000007,  5.57348066316,     6438.49624942560}, 
    {     0.00000000007,  4.62218969676,    10177.25767953360}, 
    {     0.00000000008,  0.34286691468,     3723.50895892300}, 
    {     0.00000000006,  1.60196605908,    10419.98628350760}, 
    {     0.00000000006,  4.33371839115,     4292.33083295040}, 
    {     0.00000000007,  4.61281837777,     7875.67186362420}, 
    {     0.00000000006,  4.67857531326,     2544.31441988340}, 
    {     0.00000000007,  1.51290306715,     5331.35744374080}, 
    {     0.00000000006,  4.16295898909,    12303.06777661000}, 
    {     0.00000000006,  4.52108494056,     3532.06069281140}, 
    {     0.00000000006,  4.66651817095,     7740.60678358880}, 
    {     0.00000000005,  6.26581073985,     5729.50644714900}, 
    {     0.00000000005,  2.75621336253,     4690.47983635860}, 
    {     0.00000000005,  2.78107610422,     4933.20844033260}, 
    {     0.00000000005,  4.63812650627,     6682.20517446780}, 
    {     0.00000000005,  5.81870543856,     2146.16541647520}, 
    {     0.00000000004,  4.97648147254,     3347.72597370060}, 
    {     0.00000000004,  1.92818801589,    16706.58525184800}, 
    {     0.00000000004,  3.51723776816,     5486.77784317500}, 
    {     0.00000000004,  4.37622919020,     3337.08930835080}, 
    {     0.00000000003,  3.74520053012,     6298.32832117640}, 
    {     0.00000000003,  4.94059407345,    11081.21921028860}, 
    {     0.00000000003,  5.20767397767,     9468.26787725700}, 
    {     0.00000000002,  5.60261719076,     3333.49887969900}, 
    {     0.00000000003,  6.08152672681,     3339.63210563160}, 
    {     0.00000000002,  1.90275008409,    30065.51184029820}, 
    {     0.00000000003,  3.36064341832,     5621.84292321040}, 
    {     0.00000000002,  0.01141937510,    10551.52824519400}, 
};


static const struct vsop mars_longitude_l5[LONG_L5] = {
    {     0.00000000762,  4.03556368806,     6681.22485339960}, 
    {     0.00000000511,  4.48770393640,    10021.83728009940}, 
    {     0.00000000360,  5.07296615717,      155.42039943420}, 
    {     0.00000000202,  4.88361321440,    13362.44970679920}, 
    {     0.00000000165,  3.48592135141,     3340.61242669980}, 
    {     0.00000000100,  6.09065293613,      242.72860397400}, 
    {     0.00000000062,  5.25625355993,    16703.06213349900}, 
    {     0.00000000064,  1.57192173495,     3185.19202726560}, 
    {     0.00000000035,  3.68331841812,      553.56940284240}, 
    {     0.00000000016,  5.23951751422,     3496.03282613400}, 
    {     0.00000000017,  5.60862454832,    20043.67456019880}, 
    {     0.00000000016,  0.16723854805,     3583.34103067380}, 
    {     0.00000000011,  1.93419597527,     6525.80445396540}, 
    {     0.00000000007,  5.17525588419,     3344.13554504880}, 
    {     0.00000000007,  2.97300501488,     2787.04302385740}, 
    {     0.00000000005,  0.39000584564,     3097.88382272579}, 
    {     0.00000000005,  5.60123387975,     6684.74797174860}, 
    {     0.00000000004,  5.97749583912,    23384.28698689860}, 
    {     0.00000000003,  2.29064254081,     9866.41688066520}, 
    {     0.00000000003,  0.52716684104,     6923.95345737360}, 
    {     0.00000000003,  6.06139189331,    10025.36039844840}, 
    {     0.00000000002,  0.00000000000,        0.00000000000}, 
    {     0.00000000002,  0.06588431932,    26724.89941359840}, 
    {     0.00000000001,  3.33966357719,     6127.65545055720}, 
};


static const struct vsop mars_latitude_b0[LAT_B0] = {
    {     0.03197134986,  3.76832042431,     3340.61242669980}, 
    {     0.00298033234,  4.10616996305,     6681.22485339960}, 
    {     0.00289104742,  0.00000000000,        0.00000000000}, 
    {     0.00031365539,  4.44651053090,    10021.83728009940}, 
    {     0.00003484100,  4.78812549260,    13362.44970679920}, 
    {     0.00000442999,  5.65233014206,     3337.08930835080}, 
    {     0.00000443401,  5.02642622964,     3344.13554504880}, 
    {     0.00000399109,  5.13056816928,    16703.06213349900}, 
    {     0.00000292506,  3.79290674178,     2281.23049651060}, 
    {     0.00000181982,  6.13648041445,     6151.53388830500}, 
    {     0.00000163159,  4.26399640691,      529.69096509460}, 
    {     0.00000159678,  2.23194572851,     1059.38193018920}, 
    {     0.00000139323,  2.41796458896,     8962.45534991020}, 
    {     0.00000149297,  2.16501221175,     5621.84292321040}, 
    {     0.00000142686,  1.18215016908,     3340.59517304760}, 
    {     0.00000142685,  3.21292181638,     3340.62968035200}, 
    {     0.00000082544,  5.36667920373,     6684.74797174860}, 
    {     0.00000073639,  5.09187695770,      398.14900340820}, 
    {     0.00000072660,  5.53775735826,     6283.07584999140}, 
    {     0.00000086377,  5.74429749104,     3738.76143010800}, 
    {     0.00000083276,  5.98866355811,     6677.70173505060}, 
    {     0.00000060116,  3.67960801961,      796.29800681640}, 
    {     0.00000063111,  0.73049101791,     5884.92684658320}, 
    {     0.00000062338,  4.85072128690,     2942.46342329160}, 
    {     0.00000046951,  5.54339769619,     3340.54511639700}, 
    {     0.00000046953,  5.13486674212,     3340.67973700260}, 
    {     0.00000046630,  5.47361589877,    20043.67456019880}, 
    {     0.00000045588,  2.13262340840,     2810.92146160520}, 
    {     0.00000041269,  0.20003146001,     9492.14631500480}, 
    {     0.00000047199,  4.52184637077,     3149.16416058820}, 
    {     0.00000038540,  4.08008471951,     4136.91043351620}, 
    {     0.00000033069,  4.06582536024,     1751.53953141600}, 
    {     0.00000029694,  5.92218475216,     3532.06069281140}, 
    {     0.00000032736,  2.62070842911,     2914.01423582380}, 
    {     0.00000029521,  2.75342613814,    12303.06777661000}, 
    {     0.00000028169,  2.06282641876,     5486.77784317500}, 
    {     0.00000028618,  4.94710659219,     3870.30339179440}, 
    {     0.00000026603,  3.55085867185,     6681.24210705180}, 
    {     0.00000026603,  1.52008697887,     6681.20759974740}, 
    {     0.00000023336,  2.27624326713,     1589.07289528380}, 
    {     0.00000026052,  2.60064406111,     4399.99435688900}, 
    {     0.00000022637,  2.27507286962,     1194.44701022460}, 
    {     0.00000018887,  6.04416592185,     7079.37385680780}, 
    {     0.00000014846,  3.41358397277,     5088.62883976680}, 
    {     0.00000019947,  2.67364901180,     8432.76438481560}, 
    {     0.00000014682,  5.89211770913,     9623.68827669120}, 
    {     0.00000014152,  2.42511982523,     3333.49887969900}, 
    {     0.00000013310,  2.62839885122,      426.59819087600}, 
    {     0.00000014008,  1.67425471692,     6254.62666252360}, 
    {     0.00000015104,  2.81013512447,     3496.03282613400}, 
    {     0.00000013011,  5.70759990125,    10025.36039844840}, 
    {     0.00000012080,  1.51805176385,     3185.19202726560}, 
    {     0.00000013183,  0.04521300408,    10018.31416175040}, 
    {     0.00000011553,  5.57419195540,      191.44826611160}, 
    {     0.00000011196,  0.55829476182,     5092.15195811580}, 
    {     0.00000011530,  2.13314729185,    11773.37681151540}, 
    {     0.00000010435,  5.72413969529,     6467.92575796160}, 
    {     0.00000009846,  0.86942034707,     1592.59601363280}, 
    {     0.00000009761,  1.09343319930,     2544.31441988340}, 
    {     0.00000008754,  5.47281526854,     6681.29216370240}, 
    {     0.00000008937,  4.83790383087,     6489.77658728800}, 
    {     0.00000008652,  4.72119070324,      213.29909543800}, 
    {     0.00000008797,  2.86598300684,     3341.59274776800}, 
    {     0.00000008384,  2.65895188994,     4535.05943692440}, 
    {     0.00000008213,  4.82608471380,     3553.91152213780}, 
    {     0.00000008799,  1.52911067895,     3339.63210563160}, 
    {     0.00000008103,  1.00994223680,     9225.53927328300}, 
    {     0.00000008754,  5.88131156904,     6681.15754309680}, 
    {     0.00000007209,  4.41679451115,     7477.52286021600}, 
    {     0.00000008559,  4.79005521282,     4690.47983635860}, 
    {     0.00000006087,  1.89070780881,     9595.23908922340}, 
    {     0.00000006974,  0.53247180771,    12832.75874170460}, 
    {     0.00000005584,  6.18908858151,     4292.33083295040}, 
    {     0.00000005038,  6.06394187474,     7210.91581849420}, 
    {     0.00000005127,  0.11856223993,     4562.46099302120}, 
    {     0.00000004863,  1.33050477323,     3894.18182954220}, 
    {     0.00000005592,  3.97792233579,     3127.31333126180}, 
    {     0.00000004965,  5.74590187611,     1990.74501704100}, 
    {     0.00000005531,  5.81704574177,    23384.28698689860}, 
    {     0.00000004184,  3.88899448118,    10021.85453375160}, 
    {     0.00000004184,  1.85821886750,    10021.82002644720}, 
    {     0.00000004685,  1.11750605341,     3319.83703120740}, 
    {     0.00000003954,  2.65571428448,     4929.68532198360}, 
    {     0.00000005174,  3.62345890346,     2700.71514038580}, 
    {     0.00000004639,  6.14089828121,        7.11354700080}, 
    {     0.00000004686,  3.27732030640,     3361.38782219220}, 
    {     0.00000004999,  3.09122275925,    15643.68020330980}, 
    {     0.00000003919,  2.96551660306,     7740.60678358880}, 
    {     0.00000003361,  1.85015691730,     2957.71589447660}, 
    {     0.00000004247,  4.19639326313,     2146.16541647520}, 
    {     0.00000004101,  6.22534362774,    10213.28554621100}, 
    {     0.00000003124,  0.08537434136,    10419.98628350760}, 
    {     0.00000003079,  2.41163576579,     3344.20285535160}, 
    {     0.00000003093,  1.98041916263,     3337.02199804800}, 
    {     0.00000003044,  4.38894724131,     1221.84856632140}, 
    {     0.00000002879,  2.93292958734,     2787.04302385740}, 
    {     0.00000003372,  4.45558231622,     6674.11130639880}, 
    {     0.00000002510,  4.06246201858,     6872.67311951120}, 
    {     0.00000002616,  1.23659105217,     4933.20844033260}, 
    {     0.00000003011,  4.33966319613,     2388.89402044920}, 
    {     0.00000003094,  2.40386312988,     2118.76386037840}, 
    {     0.00000002516,  2.30275461207,     3723.50895892300}, 
    {     0.00000002192,  1.68875393217,      639.89728631400}, 
    {     0.00000002157,  6.07606060132,     9808.53818466140}, 
    {     0.00000002686,  2.38168997181,    15113.98923821520}, 
    {     0.00000002156,  2.87768495226,     6041.32756708560}, 
    {     0.00000002495,  3.87397844397,     7903.07341972100}, 
    {     0.00000002253,  0.47470647524,     3475.67750673520}, 
    {     0.00000002443,  3.02632472426,     3767.21061757580}, 
    {     0.00000001937,  0.38000939550,    13358.92658845020}, 
    {     0.00000002213,  3.91980714687,     3205.54734666440}, 
    {     0.00000002386,  6.23866730110,    12964.30070339100}, 
    {     0.00000001806,  2.38402930496,    11243.68584642080}, 
    {     0.00000002265,  1.85773978984,     6525.80445396540}, 
    {     0.00000001642,  1.86812819920,     6680.24453233140}, 
    {     0.00000001616,  3.39939680231,     8429.24126646660}, 
    {     0.00000001646,  0.73259423152,     2274.11694950980}, 
    {     0.00000001910,  6.04319826335,    13365.97282514820}, 
    {     0.00000001493,  2.99362444740,     7875.67186362420}, 
    {     0.00000001567,  1.76858041654,      382.89653222320}, 
    {     0.00000001460,  1.40569772730,    14584.29827312060}, 
    {     0.00000001527,  5.79343223934,     6894.52394883760}, 
    {     0.00000001410,  5.17096392928,     9830.38901398780}, 
    {     0.00000001665,  3.60179345882,     2288.34404351140}, 
    {     0.00000001616,  2.19443242366,     8827.39026987480}, 
    {     0.00000001746,  0.10485638099,     3583.34103067380}, 
    {     0.00000001637,  3.20413465522,     6682.20517446780}, 
    {     0.00000001269,  2.02253887032,      155.42039943420}, 
    {     0.00000001508,  5.80804000686,     1748.01641306700}, 
    {     0.00000001296,  2.92894055497,     9381.93999378540}, 
    {     0.00000001291,  2.98932388263,     6836.64525283380}, 
    {     0.00000001357,  0.32863385589,     4032.77002792660}, 
    {     0.00000001377,  5.80980822627,    10021.90459040220}, 
    {     0.00000001377,  6.21830452626,    10021.76996979660}, 
    {     0.00000001227,  2.20421057800,    12935.85151592320}, 
    {     0.00000001080,  4.75504944444,    10818.13528691580}, 
    {     0.00000001016,  1.33950070697,    12566.15169998280}, 
    {     0.00000001083,  0.87620096870,    16173.37116840440}, 
    {     0.00000000958,  5.29506217215,     1066.49547719000}, 
    {     0.00000001035,  2.44289154523,     1052.26838318840}, 
    {     0.00000001153,  4.73776302778,     8031.09226305840}, 
    {     0.00000001042,  1.73541902040,     3369.06161416760}, 
    {     0.00000000899,  1.87266868844,     3077.52850332700}, 
    {     0.00000000892,  2.51349496317,     3603.69635007260}, 
    {     0.00000000905,  0.27366092731,     3325.35995551480}, 
    {     0.00000000883,  5.46536272796,     5614.72937620960}, 
    {     0.00000000949,  0.04595746600,     7064.12138562280}, 
    {     0.00000000872,  3.61194636597,     6702.00024889200}, 
    {     0.00000000842,  5.61715087411,     8955.34180290940}, 
    {     0.00000000843,  0.57535652957,     3191.04922956520}, 
    {     0.00000000904,  4.11836615587,     3355.86489788480}, 
    {     0.00000001044,  2.65886181159,     3312.16323923200}, 
    {     0.00000000807,  2.26443699939,     8969.56889691100}, 
    {     0.00000001047,  6.11318138367,     5331.35744374080}, 
    {     0.00000000933,  0.82557513360,     3503.07906283200}, 
    {     0.00000000946,  1.92369895048,     5628.95647021120}, 
    {     0.00000000979,  4.55692896386,     3097.88382272579}, 
    {     0.00000000846,  4.65092182656,     6438.49624942560}, 
    {     0.00000000901,  1.46779952141,     6660.44945790720}, 
    {     0.00000000738,  4.97714586030,    10014.72373309860}, 
    {     0.00000000762,  3.42578095887,    18984.29263000960}, 
    {     0.00000000934,  0.35012375677,     3264.34635542420}, 
    {     0.00000000894,  0.34992279460,    10551.52824519400}, 
    {     0.00000000665,  6.05549298647,     7632.94325965020}, 
    {     0.00000000605,  4.68477765315,     5729.50644714900}, 
    {     0.00000000593,  2.97202650027,     3178.14579056760}, 
    {     0.00000000617,  2.19525025122,    13362.43245314700}, 
    {     0.00000000579,  3.32297295321,    11081.21921028860}, 
    {     0.00000000579,  2.31207212499,     6677.63442474780}, 
    {     0.00000000585,  4.51639269767,     1648.44675719740}, 
    {     0.00000000572,  4.27986611626,     6546.15977336420}, 
    {     0.00000000626,  4.60732704004,     2487.41604494780}, 
    {     0.00000000649,  2.17890116209,     6298.32832117640}, 
    {     0.00000000617,  4.22631246059,    13362.46696045140}, 
    {     0.00000000550,  3.11154437229,     6144.42034130420}, 
    {     0.00000000551,  3.27082309354,     6127.65545055720}, 
    {     0.00000000536,  0.18974410122,     3346.13535100720}, 
    {     0.00000000557,  6.13684755137,    26724.89941359840}, 
    {     0.00000000571,  5.65326695555,     2921.12778282460}, 
    {     0.00000000552,  5.75733423477,      149.56319713460}, 
    {     0.00000000638,  4.49650387971,        3.52311834900}, 
    {     0.00000000552,  1.07796467941,      536.80451209540}, 
    {     0.00000000537,  4.19208253387,     3335.08950239240}, 
    {     0.00000000567,  2.62819919565,     2648.45482547300}, 
    {     0.00000000642,  3.24529035363,     3347.72597370060}, 
    {     0.00000000546,  2.76742592341,     5459.37628707820}, 
    {     0.00000000556,  4.98614620994,     6531.66165626500}, 
    {     0.00000000577,  2.74434323174,     6684.81528205140}, 
    {     0.00000000613,  3.01716269698,     8270.29774868340}, 
    {     0.00000000558,  5.89252214546,     6158.64743530580}, 
    {     0.00000000490,  4.59097788726,      522.57741809380}, 
    {     0.00000000445,  3.64218817161,    10713.99488132620}, 
    {     0.00000000539,  0.59290478457,      553.56940284240}, 
    {     0.00000000434,  1.99641894213,    26087.90314157420}, 
    {     0.00000000459,  4.84219649882,     1758.65307841680}, 
    {     0.00000000423,  3.77854426573,     6688.33840040040}, 
    {     0.00000000421,  3.10278288287,     8329.67161059700}, 
    {     0.00000000421,  4.43525950372,      103.09277421860}, 
    {     0.00000000502,  3.03141260243,     3360.96774609859}, 
    {     0.00000000422,  5.99160108582,      242.72860397400}, 
    {     0.00000000401,  2.06009473972,     3980.50971301380}, 
    {     0.00000000410,  5.85255892892,     3351.24909204960}, 
    {     0.00000000375,  2.50807799168,     6784.31762761820}, 
    {     0.00000000407,  0.30120685897,    16304.91313009080}, 
    {     0.00000000507,  1.35015942050,     3320.25710730100}, 
    {     0.00000000385,  1.06261944181,     7234.79425624200}, 
    {     0.00000000519,  4.61721845726,     7373.38245462640}, 
    {     0.00000000401,  0.51167765800,    17085.95866572220}, 
    {     0.00000000371,  0.41700411020,    13760.59871020740}, 
    {     0.00000000476,  0.81140579083,     6816.28993343500}, 
    {     0.00000000348,  3.36504090075,     8439.87793181640}, 
    {     0.00000000366,  6.05204080393,     3607.21946842160}, 
    {     0.00000000402,  2.67373540504,    18454.60166491500}, 
    {     0.00000000439,  0.41120720711,    10404.73381232260}, 
    {     0.00000000412,  4.81050886146,     3329.97576135000}, 
    {     0.00000000414,  0.21020717323,    13149.15061136120}, 
    {     0.00000000363,  2.19005207108,     9866.41688066520}, 
    {     0.00000000337,  5.46408092858,     6604.95878212400}, 
    {     0.00000000340,  1.73403450629,     1692.16566950240}, 
    {     0.00000000344,  3.58323138591,     7107.82304427560}, 
    {     0.00000000420,  2.77274750272,     2906.90068882300}, 
    {     0.00000000335,  2.02337504340,     3333.56619000180}, 
    {     0.00000000336,  2.78166289075,     4989.05918389720}, 
    {     0.00000000354,  5.41259531000,      951.71840625060}, 
    {     0.00000000328,  0.43464679588,     6923.95345737360}, 
    {     0.00000000422,  1.57604109190,     8273.82086703240}, 
    {     0.00000000324,  4.99183805155,    11371.70468975820}, 
    {     0.00000000351,  4.60780128099,     3074.00538497800}, 
    {     0.00000000333,  4.86995546846,     3863.18984479360}, 
    {     0.00000000319,  1.44518621932,    11769.85369316640}, 
    {     0.00000000296,  5.25657985927,       76.26607127560}, 
    {     0.00000000349,  1.62475328400,    17924.91069982040}, 
    {     0.00000000293,  2.20644147241,     3347.65866339780}, 
    {     0.00000000315,  4.55232705763,     5828.02847164760}, 
    {     0.00000000280,  1.42130915383,     6606.44325483230}, 
    {     0.00000000336,  1.56854446698,     1581.95934828300}, 
    {     0.00000000343,  0.27609995271,    10973.55568635000}, 
    {     0.00000000271,  0.08319244114,    10235.13637553740}, 
    {     0.00000000280,  0.76456352671,      853.19638175200}, 
    {     0.00000000317,  4.91459113397,     3443.70520091840}, 
    {     0.00000000257,  0.15729388867,    12168.00269657460}, 
    {     0.00000000237,  3.13372111959,       74.78159856730}, 
    {     0.00000000271,  1.83005081572,     3399.98628861340}, 
    {     0.00000000233,  3.20168136662,    10177.25767953360}, 
    {     0.00000000312,  0.28437379974,    13745.34623902240}, 
    {     0.00000000273,  4.53535816659,     3344.49376205780}, 
    {     0.00000000235,  0.68002127731,    17395.21973472580}, 
    {     0.00000000262,  3.84495676575,     9168.64089834740}, 
    {     0.00000000271,  4.94468984866,      692.15760122680}, 
    {     0.00000000254,  2.19490978520,     3281.23856478620}, 
    {     0.00000000220,  1.65407354495,     3546.79797513700}, 
    {     0.00000000283,  5.57869836989,     3973.39616601300}, 
    {     0.00000000229,  5.93154303656,     3364.49086444760}, 
    {     0.00000000223,  4.82754649914,     9779.10867612540}, 
    {     0.00000000222,  0.71802343753,    16699.53901514999}, 
    {     0.00000000218,  0.09851087609,    16706.58525184800}, 
    {     0.00000000221,  1.66603088558,    10575.40668294180}, 
    {     0.00000000259,  1.10209197887,     1744.42598441520}, 
    {     0.00000000243,  1.52418741589,    14054.60730802600}, 
    {     0.00000000273,  6.12933991688,     3336.73109134180}, 
    {     0.00000000232,  4.73422207994,     3316.73398895200}, 
    {     0.00000000210,  5.97258578150,      419.48464387520}, 
    {     0.00000000213,  5.35378103304,     1596.18644228460}, 
    {     0.00000000197,  3.32402522148,     5085.03841111500}, 
    {     0.00000000193,  0.90510860475,    14314.16811304980}, 
    {     0.00000000192,  2.63243342994,      433.71173787680}, 
    {     0.00000000188,  1.14982896161,    13892.14067189380}, 
    {     0.00000000201,  4.79531031801,     6261.74020952440}, 
    {     0.00000000205,  2.32320320233,    13916.01910964160}, 
    {     0.00000000191,  5.08395985443,     2178.13772229200}, 
    {     0.00000000191,  5.88821293073,     3340.19235060619}, 
    {     0.00000000236,  0.97334443524,     3230.40610548040}, 
    {     0.00000000200,  3.60041329895,     3304.58456002240}, 
    {     0.00000000165,  2.91702596948,     3415.39402526710}, 
    {     0.00000000191,  4.77647338120,     3341.03250279340}, 
    {     0.00000000174,  2.20553353979,    10020.85695903120}, 
    {     0.00000000161,  2.64795288862,     3304.00706139560}, 
    {     0.00000000173,  3.54115283211,    10022.81760116760}, 
    {     0.00000000154,  2.45901648246,    12722.55242048520}, 
    {     0.00000000160,  1.73968020025,     3377.21779200400}, 
    {     0.00000000196,  0.78013533938,     3376.64029337720}, 
    {     0.00000000153,  0.27339012265,    13362.38239649640}, 
    {     0.00000000190,  2.65194874683,     3657.00429635640}, 
    {     0.00000000172,  5.71074315284,     2384.32327072920}, 
    {     0.00000000157,  1.00235627417,     3209.07046501340}, 
    {     0.00000000150,  3.39592858899,     3472.15438838620}, 
    {     0.00000000165,  5.86531022351,     2803.80791460440}, 
    {     0.00000000154,  0.32136196843,     6665.97238221460}, 
    {     0.00000000178,  3.34070883939,    11216.28429032400}, 
    {     0.00000000192,  0.66075807383,     3134.42687826260}, 
    {     0.00000000161,  2.87906798526,     4392.88080988820}, 
    {     0.00000000159,  3.72252422670,    13517.87010623340}, 
    {     0.00000000168,  0.55763311382,      110.20632121940}, 
    {     0.00000000158,  5.67249624538,     4407.10790388980}, 
    {     0.00000000161,  1.76807930062,     6709.67404086740}, 
    {     0.00000000158,  5.50648633058,    13171.00144068760}, 
    {     0.00000000129,  1.21294002381,    19513.98359510420}, 
    {     0.00000000173,  0.17007903906,     3024.22055704320}, 
    {     0.00000000132,  4.25424435600,    16858.48253293320}, 
    {     0.00000000125,  2.88541822571,    17256.63153634140}, 
    {     0.00000000124,  2.59793302191,    12310.18132361080}, 
    {     0.00000000170,  4.06010395706,     2818.03500860600}, 
    {     0.00000000142,  3.02798835989,     3511.28529731900}, 
    {     0.00000000121,  5.24069969205,     9872.27408296480}, 
    {     0.00000000165,  2.53176540760,    16276.46394262300}, 
    {     0.00000000153,  6.14807907741,    13362.51701710200}, 
    {     0.00000000119,  4.15693538268,     3760.09707057500}, 
    {     0.00000000120,  0.64325982889,     4459.36821880260}, 
    {     0.00000000130,  4.94981293749,    13553.89797291080}, 
    {     0.00000000120,  0.17129908454,     8671.96987044060}, 
    {     0.00000000112,  0.16839834843,      135.06508003540}, 
    {     0.00000000137,  3.34809361979,     3341.04230982650}, 
    {     0.00000000126,  1.32248977876,     1349.86740965880}, 
    {     0.00000000111,  3.14219193941,    13524.91634293140}, 
    {     0.00000000119,  5.95363422696,    12295.95422960920}, 
    {     0.00000000131,  5.09769592268,    14158.74771361560}, 
    {     0.00000000141,  1.37128440708,     3169.93955608060}, 
    {     0.00000000112,  3.35851628879,     5989.06725217280}, 
    {     0.00000000104,  5.00797771373,    13119.72110282519}, 
    {     0.00000000110,  5.23389059260,     1375.77379984580}, 
    {     0.00000000105,  2.72700704697,     1162.47470440780}, 
    {     0.00000000104,  1.73770183724,     2221.85663459700}, 
    {     0.00000000137,  1.04576950390,     3340.18254357310}, 
    {     0.00000000106,  6.13491390193,      162.46663613220}, 
    {     0.00000000119,  2.63313118842,     7321.12213971360}, 
    {     0.00000000105,  3.09659915297,    20618.01935853360}, 
    {     0.00000000108,  1.01854560270,     3265.83082813250}, 
    {     0.00000000098,  4.23346395354,    23539.70738633280}, 
    {     0.00000000119,  4.07130782746,    10184.30391623160}, 
    {     0.00000000096,  1.81114730032,    10001.06188460700}, 
    {     0.00000000093,  3.58891064965,     5099.26550511660}, 
    {     0.00000000095,  4.94769174828,     3981.49003408200}, 
    {     0.00000000094,  5.37501534644,    13355.33615979840}, 
    {     0.00000000103,  0.43484814704,     1861.74585263540}, 
    {     0.00000000094,  0.13428933842,    15508.61512327440}, 
    {     0.00000000090,  3.76399049820,    22324.90505670940}, 
    {     0.00000000091,  3.95036658260,    10042.61267559180}, 
    {     0.00000000106,  4.30211754376,      640.87760738220}, 
    {     0.00000000109,  6.18873803073,     1478.86657406440}, 
    {     0.00000000088,  1.79608901341,     6247.51311552280}, 
    {     0.00000000102,  5.58780810365,     2766.26762836500}, 
    {     0.00000000110,  0.94707767481,     3274.12501778540}, 
    {     0.00000000084,  4.45487801852,     6696.47732458460}, 
    {     0.00000000085,  2.74791518135,     3407.09983561420}, 
    {     0.00000000087,  4.51187502918,      220.41264243880}, 
    {     0.00000000101,  5.94873233824,     8425.65083781480}, 
    {     0.00000000082,  0.01853826918,     9499.25986200560}, 
    {     0.00000000080,  0.42610497232,    18052.92954315780}, 
    {     0.00000000083,  2.96589752222,     6652.77566593180}, 
    {     0.00000000080,  4.61484797156,     3914.95722503460}, 
    {     0.00000000089,  3.53078320469,     9485.03276800400}, 
    {     0.00000000079,  1.50228054154,     2111.65031337760}, 
    {     0.00000000086,  0.42024324898,      956.28915597060}, 
    {     0.00000000088,  5.46048231018,    16460.33352952499}, 
    {     0.00000000091,  2.09965252231,      949.17560896980}, 
    {     0.00000000104,  1.72206104768,     3296.89351439480}, 
    {     0.00000000103,  1.25691413032,     3384.33133900480}, 
    {     0.00000000084,  5.78633258361,     5518.75014899180}, 
    {     0.00000000079,  1.79312483182,       38.13303563780}, 
    {     0.00000000073,  0.10771411146,    29822.78323632420}, 
    {     0.00000000087,  2.11653872859,     3450.81874791920}, 
    {     0.00000000071,  3.89470981165,     9380.95967271720}, 
    {     0.00000000075,  2.59391377956,     1964.83862685400}, 
    {     0.00000000098,  4.01500805880,     6843.69148953180}, 
    {     0.00000000079,  2.20331656568,    30220.93223973240}, 
    {     0.00000000074,  5.32028984035,    11766.26326451460}, 
    {     0.00000000068,  0.04696396376,     2125.87740737920}, 
    {     0.00000000069,  6.07535832352,    26482.17080962440}, 
    {     0.00000000084,  0.16860055001,      263.08392337280}, 
    {     0.00000000069,  2.05050096393,    29424.63423291600}, 
    {     0.00000000068,  5.03020376497,     9070.11887384880}, 
    {     0.00000000076,  2.00296092459,      224.34479570190}, 
    {     0.00000000066,  3.85497672006,    19406.67828817460}, 
    {     0.00000000066,  5.70059718736,    33561.54466643220}, 
    {     0.00000000067,  0.16590056505,    22743.40937951640}, 
    {     0.00000000065,  4.65403865898,     2807.39834325620}, 
    {     0.00000000069,  3.34398269353,    11670.28403729680}, 
    {     0.00000000087,  4.97795118361,     1118.75579210280}, 
    {     0.00000000063,  0.18907107644,    30065.51184029820}, 
    {     0.00000000064,  4.61910278723,     9886.77220006400}, 
    {     0.00000000073,  0.93704276887,    20735.83216142559}, 
    {     0.00000000060,  5.83782810193,     8646.06348025360}, 
    {     0.00000000062,  4.81385996015,    20199.09495963300}, 
    {     0.00000000059,  5.00167022948,     6414.61781167780}, 
    {     0.00000000068,  3.84295373259,     6571.01853218020}, 
    {     0.00000000061,  2.81706693695,     6944.30877677240}, 
    {     0.00000000065,  4.49019257083,      632.78373931320}, 
    {     0.00000000058,  5.65218977997,     9945.57120882380}, 
    {     0.00000000071,  2.51550158926,     9638.94074787620}, 
    {     0.00000000057,  3.27978831470,      206.18554843720}, 
    {     0.00000000058,  2.97636193658,    21795.21409161479}, 
    {     0.00000000056,  2.23539566426,    20995.39296644940}, 
    {     0.00000000057,  1.88470380043,    18451.07854656599}, 
    {     0.00000000071,  4.82445654330,     8542.97070603500}, 
    {     0.00000000061,  3.65964735564,    14421.83163698840}, 
    {     0.00000000056,  3.13785930666,     8799.98871377800}, 
    {     0.00000000057,  4.89910616374,     9602.35263622420}, 
    {     0.00000000065,  3.37158994673,    11610.91017538320}, 
    {     0.00000000067,  1.92961865108,    21265.52312652020}, 
    {     0.00000000055,  1.95164531766,     9588.12554222260}, 
    {     0.00000000057,  2.82246123078,    10124.93005431800}, 
    {     0.00000000057,  6.10387785338,    19800.94595622480}, 
    {     0.00000000055,  5.20958408712,     3237.51965248120}, 
    {     0.00000000057,  4.12311973381,    10028.95082710020}, 
    {     0.00000000054,  1.41693548950,    15906.76412668260}, 
    {     0.00000000053,  2.16367301961,     6418.14093002680}, 
    {     0.00000000060,  2.64664637730,    10018.24685144760}, 
    {     0.00000000068,  5.36545296940,     1228.96211332220}, 
    {     0.00000000051,  5.73844646896,     6048.44111408640}, 
    {     0.00000000053,  0.32024828883,    12721.57209941700}, 
    {     0.00000000051,  0.06318823307,    20206.14119633100}, 
    {     0.00000000049,  4.53400634462,     6675.70192909220}, 
    {     0.00000000051,  1.15453549218,    10156.90236013480}, 
    {     0.00000000064,  4.56324217308,    16703.07938715119}, 
    {     0.00000000060,  3.61007876606,     9468.26787725700}, 
    {     0.00000000059,  3.08394474122,    10025.42770875120}, 
    {     0.00000000064,  2.53221459501,    16703.04487984680}, 
    {     0.00000000056,  3.31981662811,     6518.75821726740}, 
    {     0.00000000047,  1.44559124267,     6643.09181776180}, 
    {     0.00000000050,  1.92346411481,    11614.43329373220}, 
    {     0.00000000047,  4.03823773711,    23958.63178523340}, 
    {     0.00000000046,  3.70969689047,     8859.36257569160}, 
    {     0.00000000060,  2.55451756882,    11780.49035851620}, 
    {     0.00000000047,  1.69255946598,     6660.86953400080}, 
    {     0.00000000044,  6.09481156053,     6460.81221096080}, 
    {     0.00000000044,  2.63075457414,    13936.79450513400}, 
    {     0.00000000053,  0.77837832855,    16865.52876963120}, 
    {     0.00000000049,  1.83317426993,    17654.78053974960}, 
    {     0.00000000042,  4.30403794400,     9065.54812412880}, 
    {     0.00000000047,  0.52827244925,     6686.74777770700}, 
    {     0.00000000042,  5.72053684220,     7203.80227149340}, 
    {     0.00000000041,  0.98430028881,    20426.57109242200}, 
    {     0.00000000051,  3.54371303345,    20597.24396304120}, 
    {     0.00000000041,  0.21190431801,     7314.00859271280}, 
    {     0.00000000038,  2.53053802253,    13207.02930736500}, 
    {     0.00000000039,  5.15577529354,     6670.58818804980}, 
    {     0.00000000045,  0.52366150729,    16489.76303806100}, 
    {     0.00000000051,  3.25181148972,     7799.98064550240}, 
    {     0.00000000049,  0.77149145450,    17101.21113690720}, 
    {     0.00000000038,  6.06656444914,     9389.05354078620}, 
    {     0.00000000036,  0.84094545235,    23937.85638974100}, 
};


static const struct vsop mars_latitude_b1[LAT_B1] = {
    {     0.00217310991,  6.04472194776,     3340.61242669980}, 
    {     0.00020976948,  3.14159265359,        0.00000000000}, 
    {     0.00012834709,  1.60810667915,     6681.22485339960}, 
    {     0.00003320981,  2.62947004077,    10021.83728009940}, 
    {     0.00000627200,  3.11898601248,    13362.44970679920}, 
    {     0.00000101990,  3.52113557592,    16703.06213349900}, 
    {     0.00000075107,  0.95983758515,     3337.08930835080}, 
    {     0.00000029264,  3.40307682710,     3344.13554504880}, 
    {     0.00000023251,  3.69342549027,     5621.84292321040}, 
    {     0.00000022190,  2.21703408598,     2281.23049651060}, 
    {     0.00000015454,  3.89610159362,    20043.67456019880}, 
    {     0.00000011867,  3.83861019788,     6684.74797174860}, 
    {     0.00000012038,  2.13866775328,     6151.53388830500}, 
    {     0.00000009697,  5.48941186798,     3340.62968035200}, 
    {     0.00000009697,  3.45863925102,     3340.59517304760}, 
    {     0.00000011537,  1.90395033905,     3532.06069281140}, 
    {     0.00000009276,  0.71941312462,     2942.46342329160}, 
    {     0.00000009240,  2.51747952408,     5884.92684658320}, 
    {     0.00000009876,  6.13507416822,     1059.38193018920}, 
    {     0.00000009265,  4.55759125226,     8962.45534991020}, 
    {     0.00000007822,  6.10932267009,     2810.92146160520}, 
    {     0.00000010369,  0.60195347181,      529.69096509460}, 
    {     0.00000008522,  4.40106741096,     3496.03282613400}, 
    {     0.00000007683,  1.21169696624,     6677.70173505060}, 
    {     0.00000007134,  1.93610705535,     2544.31441988340}, 
    {     0.00000006512,  3.11636422105,     3738.76143010800}, 
    {     0.00000006278,  6.23176923902,     3185.19202726560}, 
    {     0.00000005833,  0.74324094343,      398.14900340820}, 
    {     0.00000005033,  2.28727456802,     3149.16416058820}, 
    {     0.00000004958,  1.54200127913,     6283.07584999140}, 
    {     0.00000004325,  3.90636722132,     5092.15195811580}, 
    {     0.00000004813,  3.88560399245,     5486.77784317500}, 
    {     0.00000004474,  2.18937641288,     4136.91043351620}, 
    {     0.00000003023,  5.19879000530,     5088.62883976680}, 
    {     0.00000003194,  1.12695072198,     3340.67973700260}, 
    {     0.00000003167,  0.76774265684,     4399.99435688900}, 
    {     0.00000003066,  0.93923788410,     2914.01423582380}, 
    {     0.00000002840,  2.51888046278,     3870.30339179440}, 
    {     0.00000002622,  3.25368667606,     3339.63210563160}, 
    {     0.00000003192,  1.53317813619,     3340.54511639700}, 
    {     0.00000002879,  4.20588113950,    10025.36039844840}, 
    {     0.00000002435,  2.49243229030,     1751.53953141600}, 
    {     0.00000002066,  2.96021692416,     3894.18182954220}, 
    {     0.00000002366,  1.08506560814,      796.29800681640}, 
    {     0.00000002192,  0.22905210418,     4690.47983635860}, 
    {     0.00000002398,  0.43514026515,     1194.44701022460}, 
    {     0.00000002238,  4.06454135883,     7079.37385680780}, 
    {     0.00000001825,  5.46319390380,     1592.59601363280}, 
    {     0.00000001808,  4.83342714362,     8432.76438481560}, 
    {     0.00000002251,  4.25857270742,    23384.28698689860}, 
    {     0.00000001728,  1.06103820676,     3341.59274776800}, 
    {     0.00000001833,  1.57091276737,     4292.33083295040}, 
    {     0.00000001581,  0.93404031162,     4535.05943692440}, 
    {     0.00000001722,  2.98790749378,     6254.62666252360}, 
    {     0.00000001395,  3.43004445438,     2146.16541647520}, 
    {     0.00000001739,  4.00666290186,     9492.14631500480}, 
    {     0.00000001535,  2.94481028624,     6489.77658728800}, 
    {     0.00000001394,  2.71952784799,     7477.52286021600}, 
    {     0.00000001257,  1.34371702718,     2787.04302385740}, 
    {     0.00000001600,  5.41971849753,     3127.31333126180}, 
    {     0.00000001274,  4.11492658217,     1990.74501704100}, 
    {     0.00000001190,  4.24621398204,     3723.50895892300}, 
    {     0.00000001144,  5.30298760566,     6681.20759974740}, 
    {     0.00000001376,  0.38090537503,     1589.07289528380}, 
    {     0.00000001144,  1.05059380873,     6681.24210705180}, 
    {     0.00000001062,  0.51072898484,     6674.11130639880}, 
    {     0.00000001355,  0.30172057784,     6525.80445396540}, 
    {     0.00000001119,  0.28227067739,    12303.06777661000}, 
    {     0.00000000855,  0.15965897606,     2957.71589447660}, 
    {     0.00000001066,  2.74229978174,     2388.89402044920}, 
    {     0.00000001056,  4.82485604808,     3583.34103067380}, 
    {     0.00000000770,  3.92387598679,        7.11354700080}, 
    {     0.00000000922,  5.97832717399,     3097.88382272579}, 
    {     0.00000000713,  2.61601602080,     9225.53927328300}, 
    {     0.00000000693,  5.86945792010,     4933.20844033260}, 
    {     0.00000000738,  5.02837731897,    12832.75874170460}, 
    {     0.00000000763,  1.29638960572,     7740.60678358880}, 
    {     0.00000000656,  1.57943668761,     6467.92575796160}, 
    {     0.00000000663,  0.56970117211,      426.59819087600}, 
    {     0.00000000616,  2.90595542135,     3553.91152213780}, 
    {     0.00000000609,  4.27586920886,     4562.46099302120}, 
    {     0.00000000608,  4.61163488420,    10419.98628350760}, 
    {     0.00000000599,  4.51624214272,     6836.64525283380}, 
    {     0.00000000565,  3.63229110969,      155.42039943420}, 
    {     0.00000000562,  0.31418284081,      213.29909543800}, 
    {     0.00000000519,  1.00557611591,     4929.68532198360}, 
    {     0.00000000504,  4.17532879019,     6041.32756708560}, 
    {     0.00000000660,  3.62669217851,     7210.91581849420}, 
    {     0.00000000576,  4.54911948486,    13365.97282514820}, 
    {     0.00000000625,  1.44798343162,     3333.49887969900}, 
    {     0.00000000520,  1.30331504622,    15643.68020330980}, 
    {     0.00000000444,  2.08076069460,    10021.85453375160}, 
    {     0.00000000542,  2.02587783935,     2288.34404351140}, 
    {     0.00000000509,  1.65323927554,      191.44826611160}, 
    {     0.00000000444,  0.04999320087,    10021.82002644720}, 
    {     0.00000000557,  3.31349841992,     9623.68827669120}, 
    {     0.00000000472,  6.26731124720,     6438.49624942560}, 
    {     0.00000000559,  4.16781257217,    11773.37681151540}, 
    {     0.00000000399,  1.32358791559,     7875.67186362420}, 
    {     0.00000000445,  1.49656750781,     6682.20517446780}, 
    {     0.00000000385,  0.75203057166,     5614.72937620960}, 
    {     0.00000000386,  1.92088879703,     3325.35995551480}, 
    {     0.00000000377,  3.38213849272,     6681.15754309680}, 
    {     0.00000000360,  3.62049849377,     6680.24453233140}, 
    {     0.00000000352,  3.40685833182,     9830.38901398780}, 
    {     0.00000000346,  2.54878403272,     2274.11694950980}, 
    {     0.00000000336,  5.51924409428,     3361.38782219220}, 
    {     0.00000000329,  3.58450091417,     1066.49547719000}, 
    {     0.00000000343,  3.80876454378,     9595.23908922340}, 
    {     0.00000000383,  4.58860426691,     3360.96774609859}, 
    {     0.00000000367,  4.94614944232,     7903.07341972100}, 
    {     0.00000000318,  3.12211289329,    10818.13528691580}, 
    {     0.00000000298,  5.16474580641,     1748.01641306700}, 
    {     0.00000000310,  5.77231072116,     3205.54734666440}, 
    {     0.00000000378,  2.97214989967,     6681.29216370240}, 
    {     0.00000000303,  3.44801982034,     3319.83703120740}, 
    {     0.00000000292,  1.69888047283,     6127.65545055720}, 
    {     0.00000000288,  1.13506530643,     8955.34180290940}, 
    {     0.00000000281,  0.80027819229,    10018.31416175040}, 
    {     0.00000000326,  5.96924076920,      639.89728631400}, 
    {     0.00000000309,  1.38061994912,     3767.21061757580}, 
    {     0.00000000375,  4.48892934736,     5331.35744374080}, 
    {     0.00000000271,  4.61196466416,    26724.89941359840}, 
    {     0.00000000266,  3.08927427780,     5729.50644714900}, 
    {     0.00000000290,  2.44792712887,     3355.86489788480}, 
    {     0.00000000335,  6.08508450491,     3320.25710730100}, 
    {     0.00000000300,  0.25476556615,     2700.71514038580}, 
    {     0.00000000289,  3.45335160291,      382.89653222320}, 
    {     0.00000000260,  3.56570589402,     8827.39026987480}, 
    {     0.00000000246,  0.64772929845,     9866.41688066520}, 
    {     0.00000000298,  4.38515379625,     1052.26838318840}, 
    {     0.00000000251,  4.40903417777,    12964.30070339100}, 
    {     0.00000000260,  1.27300653213,     3347.72597370060}, 
    {     0.00000000280,  1.49182583330,    10213.28554621100}, 
    {     0.00000000225,  2.73440886519,     6872.67311951120}, 
    {     0.00000000225,  5.16642343920,     6923.95345737360}, 
    {     0.00000000226,  2.68107364511,     1221.84856632140}, 
    {     0.00000000222,  4.38874821491,      242.72860397400}, 
    {     0.00000000209,  5.01591708290,     6144.42034130420}, 
    {     0.00000000268,  2.27786943096,      553.56940284240}, 
    {     0.00000000218,  0.53299582810,     6298.32832117640}, 
    {     0.00000000261,  3.89759063291,     6894.52394883760}, 
    {     0.00000000213,  1.06038488787,     2118.76386037840}, 
    {     0.00000000210,  4.74220753176,     9381.93999378540}, 
    {     0.00000000192,  0.18364684632,      522.57741809380}, 
    {     0.00000000186,  1.48154759746,     7064.12138562280}, 
    {     0.00000000176,  3.93023367762,     2921.12778282460}, 
    {     0.00000000208,  4.86366921136,     3344.20285535160}, 
    {     0.00000000201,  0.36731227894,     8969.56889691100}, 
    {     0.00000000209,  4.43309730358,     3337.02199804800}, 
    {     0.00000000163,  4.54501296893,    11243.68584642080}, 
    {     0.00000000161,  1.62341728854,    11081.21921028860}, 
    {     0.00000000152,  3.98251813705,    10021.90459040220}, 
    {     0.00000000145,  1.06283180181,      951.71840625060}, 
    {     0.00000000149,  4.55824612447,    10551.52824519400}, 
    {     0.00000000184,  5.37374692745,    16173.37116840440}, 
    {     0.00000000143,  2.00077774476,     6688.33840040040}, 
    {     0.00000000145,  4.53139041634,     3312.16323923200}, 
    {     0.00000000156,  6.26070301430,     5628.95647021120}, 
    {     0.00000000157,  5.56167088817,      536.80451209540}, 
    {     0.00000000133,  5.43195789258,    13358.92658845020}, 
    {     0.00000000144,  1.31943624453,     3364.49086444760}, 
    {     0.00000000156,  4.10544868136,     6158.64743530580}, 
    {     0.00000000157,  6.23025291402,     8273.82086703240}, 
    {     0.00000000134,  4.31700501659,     8031.09226305840}, 
    {     0.00000000124,  1.26816196203,     8270.29774868340}, 
    {     0.00000000156,  4.39354558071,    10021.76996979660}, 
    {     0.00000000144,  2.48806691402,     3503.07906283200}, 
    {     0.00000000118,  1.78550823737,    18984.29263000960}, 
    {     0.00000000110,  6.12714281903,     7632.94325965020}, 
    {     0.00000000127,  3.05541911618,     3316.73398895200}, 
    {     0.00000000109,  0.91919644775,    10014.72373309860}, 
    {     0.00000000102,  1.54908471746,     7234.79425624200}, 
    {     0.00000000100,  5.04817125533,    13760.59871020740}, 
    {     0.00000000132,  2.66590263580,     8429.24126646660}, 
    {     0.00000000126,  0.13960736597,     1349.86740965880}, 
    {     0.00000000100,  0.74385347353,     2487.41604494780}, 
    {     0.00000000091,  0.24627212892,     3980.50971301380}, 
    {     0.00000000112,  2.30475590800,     3346.13535100720}, 
    {     0.00000000103,  4.23425277305,     3475.67750673520}, 
    {     0.00000000109,  3.21402242606,    17654.78053974960}, 
    {     0.00000000082,  0.28323060532,    15113.98923821520}, 
    {     0.00000000083,  0.53618493739,    13362.43245314700}, 
    {     0.00000000096,  3.66896983898,    12168.00269657460}, 
    {     0.00000000083,  2.56708795058,    13362.46696045140}, 
    {     0.00000000077,  4.92321070753,    16706.58525184800}, 
    {     0.00000000097,  2.11149094902,     3178.14579056760}, 
    {     0.00000000074,  0.95663828948,     2699.73481931760}, 
    {     0.00000000083,  1.82502676147,        3.52311834900}, 
    {     0.00000000085,  5.22946780555,     3304.58456002240}, 
    {     0.00000000083,  3.10647417000,     1758.65307841680}, 
    {     0.00000000070,  5.11510436801,     5828.02847164760}, 
    {     0.00000000077,  1.77323016185,     3335.08950239240}, 
    {     0.00000000082,  5.25824044848,      853.19638175200}, 
    {     0.00000000067,  0.98915661779,      433.71173787680}, 
    {     0.00000000078,  3.62913840245,     1596.18644228460}, 
    {     0.00000000078,  1.56367501585,     3336.73109134180}, 
    {     0.00000000084,  4.62334317796,    11371.70468975820}, 
    {     0.00000000072,  3.62008128206,     1581.95934828300}, 
    {     0.00000000072,  4.05769658716,     4407.10790388980}, 
    {     0.00000000085,  0.75421401009,     5459.37628707820}, 
    {     0.00000000074,  1.03163916867,     5085.03841111500}, 
    {     0.00000000058,  3.24082931383,    13517.87010623340}, 
    {     0.00000000056,  3.73441989631,    10713.99488132620}, 
    {     0.00000000061,  1.52242466354,    18052.92954315780}, 
    {     0.00000000053,  0.69821482369,     6702.00024889200}, 
    {     0.00000000057,  2.76439103910,     3344.49376205780}, 
    {     0.00000000069,  1.99074407937,    10575.40668294180}, 
    {     0.00000000059,  1.90513947603,    10022.81760116760}, 
    {     0.00000000051,  0.93662679832,    14314.16811304980}, 
    {     0.00000000069,  5.42699929964,     3376.64029337720}, 
    {     0.00000000053,  4.87818342068,     8671.96987044060}, 
    {     0.00000000065,  3.39290651505,    14584.29827312060}, 
    {     0.00000000057,  1.70570965163,     2648.45482547300}, 
    {     0.00000000054,  5.49765437527,     3369.06161416760}, 
    {     0.00000000054,  2.28971906454,    12566.15169998280}, 
    {     0.00000000068,  4.60849144076,     7373.38245462640}, 
    {     0.00000000049,  2.89959771413,    13916.01910964160}, 
    {     0.00000000058,  4.18351190862,    10177.25767953360}, 
    {     0.00000000058,  4.51310742397,     4032.77002792660}, 
    {     0.00000000048,  3.42793333559,     1744.42598441520}, 
    {     0.00000000064,  0.45002982477,     3863.18984479360}, 
    {     0.00000000047,  5.88584556234,    10973.55568635000}, 
    {     0.00000000057,  1.76184909465,    11216.28429032400}, 
    {     0.00000000053,  1.35755250698,    21393.54196985760}, 
    {     0.00000000059,  2.91197893810,     3981.49003408200}, 
    {     0.00000000053,  4.03461050047,    11769.85369316640}, 
    {     0.00000000052,  2.05672710904,    10404.73381232260}, 
    {     0.00000000060,  4.31863902545,     3077.52850332700}, 
    {     0.00000000060,  4.94577585891,     3603.69635007260}, 
    {     0.00000000052,  3.45056061273,     9808.53818466140}, 
    {     0.00000000048,  3.83792333621,    13171.00144068760}, 
    {     0.00000000050,  1.55014152662,      419.48464387520}, 
    {     0.00000000042,  1.56007012481,     8425.65083781480}, 
    {     0.00000000040,  4.52149159432,    10235.13637553740}, 
    {     0.00000000045,  4.94000875201,    16304.91313009080}, 
    {     0.00000000042,  2.03301048111,     7107.82304427560}, 
    {     0.00000000055,  2.94325348897,      640.87760738220}, 
    {     0.00000000039,  0.82091082076,    12310.18132361080}, 
    {     0.00000000040,  3.29013672690,     6247.51311552280}, 
    {     0.00000000040,  0.33830589904,     6531.66165626500}, 
    {     0.00000000044,  4.73395183232,    20597.24396304120}, 
    {     0.00000000037,  0.01359265708,     3914.95722503460}, 
    {     0.00000000037,  3.04848190227,     2766.26762836500}, 
    {     0.00000000037,  4.13243009725,    17256.63153634140}, 
    {     0.00000000043,  3.27442666790,    20995.39296644940}, 
    {     0.00000000035,  0.29856523330,     9779.10867612540}, 
    {     0.00000000045,  0.96453304167,    18454.60166491500}, 
    {     0.00000000036,  0.18334758502,     6660.86953400080}, 
    {     0.00000000043,  1.23912278835,     8439.87793181640}, 
    {     0.00000000034,  2.83078633705,     6696.47732458460}, 
    {     0.00000000043,  5.80649509131,     9168.64089834740}, 
    {     0.00000000034,  3.46884113350,     9070.11887384880}, 
    {     0.00000000037,  5.04438408684,     1692.16566950240}, 
    {     0.00000000040,  1.15262282119,    14712.31711645800}, 
    {     0.00000000035,  2.33581709312,       76.26607127560}, 
    {     0.00000000040,  3.54052855946,    14158.74771361560}, 
    {     0.00000000032,  4.96078703650,    24734.15439655740}, 
    {     0.00000000029,  2.34589185801,    13745.34623902240}, 
    {     0.00000000030,  6.17825920695,    12935.85151592320}, 
    {     0.00000000036,  4.78354946118,     3191.04922956520}, 
    {     0.00000000028,  4.98887480054,    30065.51184029820}, 
    {     0.00000000028,  2.51507274088,      692.15760122680}, 
    {     0.00000000027,  1.02364014288,    13207.02930736500}, 
    {     0.00000000035,  2.06348913435,     9468.26787725700}, 
    {     0.00000000027,  6.07463404086,    20199.09495963300}, 
    {     0.00000000027,  4.97808057680,    13362.38239649640}, 
    {     0.00000000033,  1.46173724832,    12295.95422960920}, 
    {     0.00000000025,  4.54782445360,     9499.25986200560}, 
    {     0.00000000025,  5.21847833578,     5099.26550511660}, 
    {     0.00000000025,  5.90368432966,    19513.98359510420}, 
    {     0.00000000025,  5.54544644558,    10264.56588407340}, 
    {     0.00000000029,  5.69085985167,    16699.53901514999}, 
    {     0.00000000030,  1.43603228163,     6040.34724601740}, 
    {     0.00000000028,  5.41811683281,    15110.46611986620}, 
    {     0.00000000032,  2.25828272513,     6665.97238221460}, 
    {     0.00000000023,  5.38626329146,     6660.44945790720}, 
    {     0.00000000023,  3.75194149686,    14054.60730802600}, 
    {     0.00000000028,  4.86716760481,     6701.58017279840}, 
    {     0.00000000027,  5.26172837256,     6816.28993343500}, 
    {     0.00000000023,  4.66125245752,    13149.15061136120}, 
    {     0.00000000027,  0.91821785260,     9638.94074787620}, 
    {     0.00000000023,  0.60587177409,     6604.95878212400}, 
    {     0.00000000025,  0.78041098485,    11766.26326451460}, 
    {     0.00000000025,  3.94777048397,    10020.85695903120}, 
    {     0.00000000026,  5.36280311705,     9485.03276800400}, 
    {     0.00000000020,  2.45752476953,    10028.95082710020}, 
    {     0.00000000020,  0.38029885589,    11614.43329373220}, 
    {     0.00000000026,  4.53241539149,    13362.51701710200}, 
    {     0.00000000019,  3.71366407424,     9588.12554222260}, 
    {     0.00000000022,  5.20856925736,    13892.14067189380}, 
};


static const struct vsop mars_latitude_b2[LAT_B2] = {
    {     0.00008888446,  1.06196052751,     3340.61242669980}, 
    {     0.00002595393,  3.14159265359,        0.00000000000}, 
    {     0.00000918914,  0.11538431190,     6681.22485339960}, 
    {     0.00000267883,  0.78837893063,    10021.83728009940}, 
    {     0.00000066911,  1.39435595847,    13362.44970679920}, 
    {     0.00000014267,  1.87268116087,    16703.06213349900}, 
    {     0.00000007948,  2.58819177832,     3337.08930835080}, 
    {     0.00000002709,  2.29241371893,    20043.67456019880}, 
    {     0.00000002911,  1.36634316448,     3344.13554504880}, 
    {     0.00000002528,  6.00423798411,     3496.03282613400}, 
    {     0.00000001617,  5.72212771018,     5621.84292321040}, 
    {     0.00000001625,  4.63140305669,     3185.19202726560}, 
    {     0.00000001173,  2.04871812080,     6684.74797174860}, 
    {     0.00000001066,  1.15825195582,     2281.23049651060}, 
    {     0.00000001043,  3.54796199484,     3532.06069281140}, 
    {     0.00000000724,  4.20458660775,     5884.92684658320}, 
    {     0.00000000610,  5.22430575829,     2810.92146160520}, 
    {     0.00000000557,  2.75698163218,     2942.46342329160}, 
    {     0.00000000655,  2.84033212598,     6677.70173505060}, 
    {     0.00000000641,  5.44557723446,     5486.77784317500}, 
    {     0.00000000498,  4.59850630546,     3894.18182954220}, 
    {     0.00000000501,  0.52535712881,     5088.62883976680}, 
    {     0.00000000521,  4.66308888977,     1059.38193018920}, 
    {     0.00000000490,  3.99314993252,     2544.31441988340}, 
    {     0.00000000408,  4.93937427401,     3339.63210563160}, 
    {     0.00000000396,  0.51430149629,     3340.62968035200}, 
    {     0.00000000470,  2.68379670864,    23384.28698689860}, 
    {     0.00000000389,  6.00426372731,     8962.45534991020}, 
    {     0.00000000446,  3.81307040390,     6151.53388830500}, 
    {     0.00000000396,  4.76665218791,     3340.59517304760}, 
    {     0.00000000360,  0.30420986478,     4136.91043351620}, 
    {     0.00000000368,  2.55488502496,    10025.36039844840}, 
    {     0.00000000417,  2.05816647037,      529.69096509460}, 
    {     0.00000000393,  1.18623350431,     3097.88382272579}, 
    {     0.00000000318,  4.89083986180,     5092.15195811580}, 
    {     0.00000000311,  0.52479429819,     3149.16416058820}, 
    {     0.00000000339,  1.91330658550,     4690.47983635860}, 
    {     0.00000000351,  3.22939666067,     4292.33083295040}, 
    {     0.00000000400,  4.99682542425,     6525.80445396540}, 
    {     0.00000000269,  5.24048656863,     4399.99435688900}, 
    {     0.00000000269,  6.01045237753,     2787.04302385740}, 
    {     0.00000000242,  5.84228858137,     3723.50895892300}, 
    {     0.00000000300,  3.33780918870,     3583.34103067380}, 
    {     0.00000000230,  1.39226657786,     3738.76143010800}, 
    {     0.00000000192,  5.54090794612,     3341.59274776800}, 
    {     0.00000000185,  2.67271130688,     6283.07584999140}, 
    {     0.00000000184,  2.21130914624,     7079.37385680780}, 
    {     0.00000000170,  5.17306622171,     6254.62666252360}, 
    {     0.00000000186,  3.68212348930,     1592.59601363280}, 
    {     0.00000000168,  2.39044142684,     1990.74501704100}, 
    {     0.00000000201,  0.91789291159,     2388.89402044920}, 
    {     0.00000000171,  4.81773821378,     1194.44701022460}, 
    {     0.00000000181,  2.50145688400,      398.14900340820}, 
    {     0.00000000177,  5.42788143021,     4535.05943692440}, 
    {     0.00000000153,  5.20921140136,     2146.16541647520}, 
    {     0.00000000131,  2.41348963069,     3340.67973700260}, 
    {     0.00000000150,  1.54231915192,     6438.49624942560}, 
    {     0.00000000149,  0.96225780576,     7477.52286021600}, 
    {     0.00000000129,  5.26033357561,      155.42039943420}, 
    {     0.00000000158,  4.47988793489,     3333.49887969900}, 
    {     0.00000000133,  6.05902381899,     6836.64525283380}, 
    {     0.00000000120,  4.73910738283,     2957.71589447660}, 
    {     0.00000000117,  2.22260771124,     6674.11130639880}, 
    {     0.00000000136,  5.83288551607,      796.29800681640}, 
    {     0.00000000157,  1.15241959296,     6489.77658728800}, 
    {     0.00000000110,  4.19180987487,     4933.20844033260}, 
    {     0.00000000130,  2.84683198305,     3340.54511639700}, 
    {     0.00000000121,  2.52786285342,     9492.14631500480}, 
    {     0.00000000108,  0.08979902661,     1748.01641306700}, 
    {     0.00000000117,  5.82410316896,     2914.01423582380}, 
    {     0.00000000086,  2.01927297840,        7.11354700080}, 
    {     0.00000000082,  3.80856644509,     6681.20759974740}, 
    {     0.00000000082,  5.83941329915,     6681.24210705180}, 
    {     0.00000000076,  0.08262821070,     6127.65545055720}, 
    {     0.00000000091,  2.96288127149,    13365.97282514820}, 
    {     0.00000000080,  2.85318684748,     8955.34180290940}, 
    {     0.00000000083,  5.02941237478,    12303.06777661000}, 
    {     0.00000000074,  3.62624366705,     6923.95345737360}, 
    {     0.00000000072,  1.17271788888,     3127.31333126180}, 
    {     0.00000000095,  4.98093994365,     1589.07289528380}, 
    {     0.00000000087,  5.81716080338,     7740.60678358880}, 
    {     0.00000000089,  0.48604673074,     3870.30339179440}, 
    {     0.00000000066,  3.06598137329,    26724.89941359840}, 
    {     0.00000000067,  6.01736846209,     6682.20517446780}, 
    {     0.00000000070,  0.64135636261,     2288.34404351140}, 
    {     0.00000000063,  3.19176567675,    12832.75874170460}, 
    {     0.00000000063,  2.70869032431,      242.72860397400}, 
    {     0.00000000062,  5.92753482553,     7875.67186362420}, 
    {     0.00000000074,  5.12213534011,     9866.41688066520}, 
    {     0.00000000076,  2.80770234482,     5331.35744374080}, 
    {     0.00000000063,  1.40446619803,     5729.50644714900}, 
    {     0.00000000065,  1.35907629616,     1349.86740965880}, 
    {     0.00000000056,  2.65764515134,      951.71840625060}, 
    {     0.00000000067,  4.84212554978,     2274.11694950980}, 
    {     0.00000000069,  2.48893325965,    10419.98628350760}, 
    {     0.00000000051,  5.98407977888,     6041.32756708560}, 
    {     0.00000000049,  4.85570926461,     4562.46099302120}, 
    {     0.00000000058,  4.99207597345,     8969.56889691100}, 
    {     0.00000000043,  5.63823020899,     4929.68532198360}, 
    {     0.00000000058,  6.20594898525,     3347.72597370060}, 
    {     0.00000000057,  2.89730834453,    10018.31416175040}, 
    {     0.00000000058,  3.89480774042,      553.56940284240}, 
    {     0.00000000047,  5.12333023108,      426.59819087600}, 
    {     0.00000000042,  1.03283454214,     6681.29216370240}, 
    {     0.00000000051,  1.17739312127,     1751.53953141600}, 
    {     0.00000000036,  4.71576514590,     6298.32832117640}, 
    {     0.00000000041,  4.11801359055,    10021.82002644720}, 
    {     0.00000000036,  2.79629985388,      213.29909543800}, 
    {     0.00000000033,  5.67092277262,    15643.68020330980}, 
    {     0.00000000033,  1.68550281175,     9830.38901398780}, 
    {     0.00000000032,  2.78277698783,     7210.91581849420}, 
    {     0.00000000041,  6.14975635778,    10021.85453375160}, 
    {     0.00000000031,  1.46914313245,    10818.13528691580}, 
    {     0.00000000030,  5.11654548214,    11773.37681151540}, 
    {     0.00000000030,  5.94013525093,     3767.21061757580}, 
    {     0.00000000028,  1.35093398031,     3553.91152213780}, 
    {     0.00000000027,  0.84036429724,     7632.94325965020}, 
    {     0.00000000029,  5.76529104850,     8031.09226305840}, 
    {     0.00000000026,  0.25856730853,     1066.49547719000}, 
    {     0.00000000024,  0.67405360149,     3360.96774609859}, 
    {     0.00000000024,  2.34265028137,     3320.25710730100}, 
    {     0.00000000028,  1.81680368660,     9623.68827669120}, 
    {     0.00000000022,  6.24243881749,     8432.76438481560}, 
    {     0.00000000021,  5.25722436514,     6680.24453233140}, 
    {     0.00000000023,  4.24982817116,     3325.35995551480}, 
    {     0.00000000022,  5.05378057964,     3355.86489788480}, 
    {     0.00000000026,  5.21495958693,      382.89653222320}, 
    {     0.00000000023,  2.27453854146,     7234.79425624200}, 
    {     0.00000000025,  1.69816682992,     6872.67311951120}, 
    {     0.00000000023,  4.13297133971,      639.89728631400}, 
    {     0.00000000019,  4.63736307953,     8429.24126646660}, 
    {     0.00000000018,  0.29318941103,      640.87760738220}, 
    {     0.00000000017,  3.12909635955,     6467.92575796160}, 
    {     0.00000000016,  1.92178558286,     6681.15754309680}, 
    {     0.00000000016,  0.47472874553,     1052.26838318840}, 
    {     0.00000000016,  0.09800770199,    11081.21921028860}, 
    {     0.00000000018,  3.26217306584,     7064.12138562280}, 
    {     0.00000000016,  5.48746970528,     9595.23908922340}, 
    {     0.00000000019,  4.63958564261,     8273.82086703240}, 
    {     0.00000000015,  2.52623641715,      191.44826611160}, 
    {     0.00000000016,  1.95271387752,     2699.73481931760}, 
    {     0.00000000015,  4.31015619343,     8827.39026987480}, 
    {     0.00000000014,  1.08241159656,    10973.55568635000}, 
    {     0.00000000015,  6.00000660183,    11371.70468975820}, 
    {     0.00000000013,  0.22518942674,     6688.33840040040}, 
    {     0.00000000013,  2.42192861366,    10575.40668294180}, 
    {     0.00000000011,  2.53752217003,    12964.30070339100}, 
    {     0.00000000011,  4.80028625279,    11769.85369316640}, 
    {     0.00000000014,  3.84407896636,    16173.37116840440}, 
    {     0.00000000011,  1.79883656022,     9779.10867612540}, 
    {     0.00000000010,  3.38769942924,    16706.58525184800}, 
    {     0.00000000013,  2.15740232885,     6894.52394883760}, 
    {     0.00000000010,  5.38827104551,    12310.18132361080}, 
    {     0.00000000012,  3.76810144879,     9225.53927328300}, 
    {     0.00000000011,  3.25290731199,     8671.96987044060}, 
    {     0.00000000011,  2.90564118820,     6040.34724601740}, 
    {     0.00000000010,  5.69430086859,    13207.02930736500}, 
    {     0.00000000009,  3.26007781906,    13760.59871020740}, 
    {     0.00000000009,  2.65306894671,    10551.52824519400}, 
    {     0.00000000009,  1.95264065659,     9070.11887384880}, 
    {     0.00000000011,  0.42402934223,     9381.93999378540}, 
};


static const struct vsop mars_latitude_b3[LAT_B3] = {
    {     0.00000330418,  2.04215300484,     3340.61242669980}, 
    {     0.00000093057,  0.00000000000,        0.00000000000}, 
    {     0.00000014546,  5.38525967237,    10021.83728009940}, 
    {     0.00000008731,  4.90252313032,     6681.22485339960}, 
    {     0.00000005215,  5.97441462813,    13362.44970679920}, 
    {     0.00000001422,  0.21283650226,    16703.06213349900}, 
    {     0.00000000585,  4.14327356645,     3337.08930835080}, 
    {     0.00000000489,  1.32053432093,     3496.03282613400}, 
    {     0.00000000332,  0.67062028539,    20043.67456019880}, 
    {     0.00000000281,  3.02888736938,     3185.19202726560}, 
    {     0.00000000095,  0.68129190368,     5621.84292321040}, 
    {     0.00000000117,  6.20178829761,     3344.13554504880}, 
    {     0.00000000100,  2.70816972496,     3097.88382272579}, 
    {     0.00000000086,  0.38064581922,     6684.74797174860}, 
    {     0.00000000071,  6.24412260280,     3894.18182954220}, 
    {     0.00000000079,  5.14539339999,     3532.06069281140}, 
    {     0.00000000080,  3.42045199039,     6525.80445396540}, 
    {     0.00000000061,  3.81929342821,     2942.46342329160}, 
    {     0.00000000066,  0.95264988100,    23384.28698689860}, 
    {     0.00000000062,  1.65751945223,     3583.34103067380}, 
    {     0.00000000062,  5.30607853843,     2544.31441988340}, 
    {     0.00000000042,  0.30552815689,     3339.63210563160}, 
    {     0.00000000037,  4.37754880706,     2787.04302385740}, 
    {     0.00000000043,  4.90457279180,     4292.33083295040}, 
    {     0.00000000036,  3.58183533863,     4690.47983635860}, 
    {     0.00000000034,  0.89018356943,    10025.36039844840}, 
    {     0.00000000032,  2.34732348899,     5088.62883976680}, 
    {     0.00000000028,  1.23206084526,     3723.50895892300}, 
    {     0.00000000026,  0.56214389305,      155.42039943420}, 
    {     0.00000000026,  4.11359839477,     6677.70173505060}, 
    {     0.00000000026,  0.37391494322,     2146.16541647520}, 
    {     0.00000000024,  5.78802013510,     5884.92684658320}, 
    {     0.00000000021,  2.91916849909,      529.69096509460}, 
    {     0.00000000019,  4.86965145048,     4136.91043351620}, 
    {     0.00000000023,  1.04314198221,     5486.77784317500}, 
    {     0.00000000018,  4.95637454569,     3149.16416058820}, 
    {     0.00000000017,  6.23546258970,     7079.37385680780}, 
    {     0.00000000017,  3.82096761296,     3341.59274776800}, 
    {     0.00000000019,  5.66874348929,     2388.89402044920}, 
    {     0.00000000015,  5.13426153783,     6489.77658728800}, 
    {     0.00000000014,  0.53723500958,     1990.74501704100}, 
    {     0.00000000014,  3.07166661567,     2957.71589447660}, 
    {     0.00000000012,  1.00141464760,     3340.62968035200}, 
    {     0.00000000012,  5.24418015401,     3340.59517304760}, 
    {     0.00000000013,  0.41162836180,     8962.45534991020}, 
    {     0.00000000012,  3.81140154428,     9866.41688066520}, 
    {     0.00000000012,  4.25382428399,     6151.53388830500}, 
    {     0.00000000015,  3.63297907536,     4535.05943692440}, 
    {     0.00000000012,  1.61461268629,     1592.59601363280}, 
    {     0.00000000010,  5.80958145013,     3333.49887969900}, 
    {     0.00000000010,  1.23772110632,     6836.64525283380}, 
    {     0.00000000009,  1.44366353557,    26724.89941359840}, 
    {     0.00000000008,  2.02732749775,     6923.95345737360}, 
    {     0.00000000009,  3.19116537565,     6438.49624942560}, 
    {     0.00000000008,  1.85197515729,     1194.44701022460}, 
    {     0.00000000008,  2.56762648035,      398.14900340820}, 
    {     0.00000000007,  3.69377532737,     4399.99435688900}, 
    {     0.00000000005,  4.73479766634,     6127.65545055720}, 
    {     0.00000000005,  0.39109547220,     5092.15195811580}, 
    {     0.00000000006,  1.41716854423,    13365.97282514820}, 
    {     0.00000000005,  3.98879770109,     6283.07584999140}, 
    {     0.00000000005,  1.86523815587,     1059.38193018920}, 
    {     0.00000000006,  5.52177150128,     7477.52286021600}, 
    {     0.00000000005,  1.92244747457,     2810.92146160520}, 
};


static const struct vsop mars_latitude_b4[LAT_B4] = {
    {     0.00000006007,  3.37637101191,     3340.61242669980}, 
    {     0.00000006625,  0.00000000000,        0.00000000000}, 
    {     0.00000000464,  3.77202757150,    10021.83728009940}, 
    {     0.00000000405,  0.63107416776,     6681.22485339960}, 
    {     0.00000000299,  4.32966790803,    13362.44970679920}, 
    {     0.00000000109,  4.85358280107,    16703.06213349900}, 
    {     0.00000000077,  2.88080440451,     3496.03282613400}, 
    {     0.00000000039,  1.43197590360,     3185.19202726560}, 
    {     0.00000000031,  5.67989354532,     3337.08930835080}, 
    {     0.00000000031,  5.33373014736,    20043.67456019880}, 
    {     0.00000000017,  4.32019018052,     3097.88382272579}, 
    {     0.00000000013,  1.77444975035,     6525.80445396540}, 
    {     0.00000000010,  0.04059602724,     3583.34103067380}, 
    {     0.00000000007,  4.46709463778,     6684.74797174860}, 
    {     0.00000000006,  1.85656049405,     2787.04302385740}, 
    {     0.00000000006,  1.15875671922,     3894.18182954220}, 
    {     0.00000000006,  5.76437007548,    23384.28698689860}, 
    {     0.00000000003,  2.91488661915,     6836.64525283380}, 
};


static const struct vsop mars_latitude_b5[LAT_B5] = {
    {     0.00000000368,  4.63460005338,     3340.61242669980}, 
    {     0.00000000045,  5.14206308865,     6681.22485339960}, 
    {     0.00000000035,  3.14159265359,        0.00000000000}, 
    {     0.00000000012,  2.68434578055,    13362.44970679920}, 
    {     0.00000000010,  4.43919916342,     3496.03282613400}, 
    {     0.00000000006,  1.70177189273,    10021.83728009940}, 
    {     0.00000000005,  3.20415104620,    16703.06213349900}, 
    {     0.00000000004,  6.15670065734,     3185.19202726560}, 
    {     0.00000000001,  3.71915090755,    20043.67456019880}, 
};


static const struct vsop mars_radius_r0[RADIUS_R0] = {
    {     1.53033488271,  0.00000000000,        0.00000000000}, 
    {     0.14184953160,  3.47971283528,     3340.61242669980}, 
    {     0.00660776362,  3.81783443019,     6681.22485339960}, 
    {     0.00046179117,  4.15595316782,    10021.83728009940}, 
    {     0.00008109733,  5.55958416318,     2810.92146160520}, 
    {     0.00007485318,  1.77239078402,     5621.84292321040}, 
    {     0.00005523191,  1.36436303770,     2281.23049651060}, 
    {     0.00003825160,  4.49407183687,    13362.44970679920}, 
    {     0.00002306537,  0.09081579001,     2544.31441988340}, 
    {     0.00001999396,  5.36059617709,     3337.08930835080}, 
    {     0.00002484394,  4.92545639920,     2942.46342329160}, 
    {     0.00001960195,  4.74249437639,     3344.13554504880}, 
    {     0.00001167119,  2.11260868341,     5092.15195811580}, 
    {     0.00001102816,  5.00908403998,      398.14900340820}, 
    {     0.00000899066,  4.40791133207,      529.69096509460}, 
    {     0.00000992252,  5.83861961952,     6151.53388830500}, 
    {     0.00000807354,  2.10217065501,     1059.38193018920}, 
    {     0.00000797915,  3.44839203899,      796.29800681640}, 
    {     0.00000740975,  1.49906336885,     2146.16541647520}, 
    {     0.00000692339,  2.13378874689,     8962.45534991020}, 
    {     0.00000633144,  0.89353283242,     3340.59517304760}, 
    {     0.00000725583,  1.24516810723,     8432.76438481560}, 
    {     0.00000633140,  2.92430446399,     3340.62968035200}, 
    {     0.00000574355,  0.82896244455,     2914.01423582380}, 
    {     0.00000526166,  5.38292991236,     3738.76143010800}, 
    {     0.00000629978,  1.28737486495,     1751.53953141600}, 
    {     0.00000472775,  5.19850522346,     3127.31333126180}, 
    {     0.00000348095,  4.83219199976,    16703.06213349900}, 
    {     0.00000283713,  2.90692064724,     3532.06069281140}, 
    {     0.00000279543,  5.25749685380,     6283.07584999140}, 
    {     0.00000233857,  5.10545987572,     5486.77784317500}, 
    {     0.00000219427,  5.58340231744,      191.44826611160}, 
    {     0.00000269896,  3.76393625127,     5884.92684658320}, 
    {     0.00000208335,  5.25476078693,     3340.54511639700}, 
    {     0.00000275217,  2.90817482492,     1748.01641306700}, 
    {     0.00000275506,  1.21767950614,     6254.62666252360}, 
    {     0.00000239119,  2.03669934656,     1194.44701022460}, 
    {     0.00000223189,  4.19861535147,     3149.16416058820}, 
    {     0.00000182689,  5.08062725665,     6684.74797174860}, 
    {     0.00000186207,  5.69871572410,     6677.70173505060}, 
    {     0.00000176000,  5.95341919657,     3870.30339179440}, 
    {     0.00000178617,  4.18423004741,     3333.49887969900}, 
    {     0.00000208330,  4.84626439637,     3340.67973700260}, 
    {     0.00000228126,  3.25526555588,     6872.67311951120}, 
    {     0.00000144312,  0.21306219460,     5088.62883976680}, 
    {     0.00000163527,  3.79888811958,     4136.91043351620}, 
    {     0.00000133126,  1.53906679361,     7903.07341972100}, 
    {     0.00000141755,  2.47792380112,     4562.46099302120}, 
    {     0.00000114927,  4.31748869065,     1349.86740965880}, 
    {     0.00000118789,  2.12168482244,     1589.07289528380}, 
    {     0.00000102094,  6.18145185708,     9492.14631500480}, 
    {     0.00000128570,  5.49884728795,     8827.39026987480}, 
    {     0.00000111546,  0.55346108403,    11243.68584642080}, 
    {     0.00000082498,  1.62220096558,    11773.37681151540}, 
    {     0.00000083204,  0.61551135046,     8429.24126646660}, 
    {     0.00000084463,  0.62274409931,     1592.59601363280}, 
    {     0.00000086666,  1.74984525176,     2700.71514038580}, 
    {     0.00000071813,  2.47494065480,    12303.06777661000}, 
    {     0.00000085321,  1.61634750496,     4690.47983635860}, 
    {     0.00000063641,  2.67334163937,      426.59819087600}, 
    {     0.00000068601,  2.40188234283,     4399.99435688900}, 
    {     0.00000058559,  4.72052839990,      213.29909543800}, 
    {     0.00000062009,  1.10068565926,     1221.84856632140}, 
    {     0.00000066499,  2.21296335919,     6041.32756708560}, 
    {     0.00000055810,  1.23288066320,     3185.19202726560}, 
    {     0.00000054969,  5.72695354791,      951.71840625060}, 
    {     0.00000052430,  3.02368095530,     4292.33083295040}, 
    {     0.00000055688,  5.44688671707,     3723.50895892300}, 
    {     0.00000058959,  3.26242460622,     6681.24210705180}, 
    {     0.00000044638,  2.01459444131,     8031.09226305840}, 
    {     0.00000058959,  1.23165296790,     6681.20759974740}, 
    {     0.00000042439,  2.26554261514,      155.42039943420}, 
    {     0.00000038955,  2.57760417339,     3341.59274776800}, 
    {     0.00000051550,  5.72324451485,     7079.37385680780}, 
    {     0.00000048940,  5.61613493545,     3553.91152213780}, 
    {     0.00000045406,  5.43303278149,     6467.92575796160}, 
    {     0.00000036438,  4.43922435395,     3894.18182954220}, 
    {     0.00000035980,  1.15972378713,     2288.34404351140}, 
    {     0.00000035268,  5.49032233898,     1990.74501704100}, 
    {     0.00000042192,  1.63254827838,     5628.95647021120}, 
    {     0.00000044292,  5.00344221303,     5614.72937620960}, 
    {     0.00000033616,  5.17029030468,    20043.67456019880}, 
    {     0.00000043256,  1.03722397198,    11769.85369316640}, 
    {     0.00000039237,  1.24237030858,     3339.63210563160}, 
    {     0.00000031949,  4.59259676953,     2274.11694950980}, 
    {     0.00000030352,  2.44163963455,    11371.70468975820}, 
    {     0.00000032269,  2.38222363233,     4535.05943692440}, 
    {     0.00000031855,  4.37536980289,        3.52311834900}, 
    {     0.00000029342,  4.06035002188,     3097.88382272579}, 
    {     0.00000031967,  1.93969979134,      382.89653222320}, 
    {     0.00000026164,  5.58463559826,     9623.68827669120}, 
    {     0.00000027903,  4.25809486053,     3191.04922956520}, 
    {     0.00000033044,  0.85475620169,      553.56940284240}, 
    {     0.00000027544,  1.57668645170,     9595.23908922340}, 
    {     0.00000025163,  0.81337734264,    10713.99488132620}, 
    {     0.00000022045,  0.85711201558,     3319.83703120740}, 
    {     0.00000024759,  5.38993953923,     2818.03500860600}, 
    {     0.00000023352,  6.01458974590,     3496.03282613400}, 
    {     0.00000024723,  2.58025225634,     2803.80791460440}, 
    {     0.00000019361,  5.18528881954,     6681.29216370240}, 
    {     0.00000019118,  5.41969355400,    10025.36039844840}, 
    {     0.00000019361,  5.59378511334,     6681.15754309680}, 
    {     0.00000018331,  5.79565723310,     7064.12138562280}, 
    {     0.00000018188,  5.61299105522,        7.11354700080}, 
    {     0.00000020393,  4.53615443964,     6489.77658728800}, 
    {     0.00000021258,  6.19174428363,    14054.60730802600}, 
    {     0.00000017094,  1.54988538094,     2957.71589447660}, 
    {     0.00000022794,  3.41719468533,     7632.94325965020}, 
    {     0.00000020561,  2.98654120324,     3361.38782219220}, 
    {     0.00000017050,  6.15529583629,    10404.73381232260}, 
    {     0.00000018007,  2.81505100996,     4032.77002792660}, 
    {     0.00000016487,  3.84534133372,    10973.55568635000}, 
    {     0.00000016056,  0.92819026247,    14584.29827312060}, 
    {     0.00000021008,  2.38506850221,     4989.05918389720}, 
    {     0.00000016291,  1.92190075688,     7373.38245462640}, 
    {     0.00000016286,  6.28252184173,     7210.91581849420}, 
    {     0.00000018575,  4.07319565284,     2388.89402044920}, 
    {     0.00000015976,  4.58379703739,     3264.34635542420}, 
    {     0.00000019909,  2.73523951203,     5099.26550511660}, 
    {     0.00000019667,  1.86294734899,     3443.70520091840}, 
    {     0.00000016500,  4.14061657170,     7477.52286021600}, 
    {     0.00000019492,  6.03778625701,    10018.31416175040}, 
    {     0.00000015097,  2.65433832872,     2787.04302385740}, 
    {     0.00000019099,  0.22623513076,    13745.34623902240}, 
    {     0.00000017164,  3.18826299350,     3347.72597370060}, 
    {     0.00000013407,  2.12775612449,     3344.20285535160}, 
    {     0.00000015407,  2.20766468871,     2118.76386037840}, 
    {     0.00000017246,  3.67064642858,     3205.54734666440}, 
    {     0.00000013091,  4.27475419816,    14314.16811304980}, 
    {     0.00000016437,  2.86612474805,    14712.31711645800}, 
    {     0.00000016648,  4.52135149200,     6674.11130639880}, 
    {     0.00000013718,  1.68586111426,     3337.02199804800}, 
    {     0.00000011824,  0.19675650045,     3475.67750673520}, 
    {     0.00000011757,  3.23020638064,     5828.02847164760}, 
    {     0.00000011884,  4.82075035433,     7234.79425624200}, 
    {     0.00000010608,  1.73995972784,      639.89728631400}, 
    {     0.00000011143,  0.23833349966,    12832.75874170460}, 
    {     0.00000011028,  0.44555687290,    10213.28554621100}, 
    {     0.00000010238,  5.74731032428,      242.72860397400}, 
    {     0.00000010052,  2.45096419672,     4929.68532198360}, 
    {     0.00000010061,  0.78904152333,     9381.93999378540}, 
    {     0.00000010065,  5.37509927353,     5085.03841111500}, 
    {     0.00000011897,  0.79890074455,     3265.83082813250}, 
    {     0.00000008983,  0.96474320941,     4933.20844033260}, 
    {     0.00000008976,  4.18310051894,     9225.53927328300}, 
    {     0.00000008982,  1.98499607259,    15113.98923821520}, 
    {     0.00000008325,  1.93706224943,     1648.44675719740}, 
    {     0.00000007832,  2.04997038646,     1758.65307841680}, 
    {     0.00000007964,  3.92258783522,     2921.12778282460}, 
    {     0.00000010223,  2.66509814753,     2487.41604494780}, 
    {     0.00000008277,  0.94860765545,     2906.90068882300}, 
    {     0.00000007371,  0.84436508721,      692.15760122680}, 
    {     0.00000007529,  5.68043313811,    13916.01910964160}, 
    {     0.00000007907,  2.81314645975,    15643.68020330980}, 
    {     0.00000006956,  3.32212696002,     3230.40610548040}, 
    {     0.00000007426,  6.09654676653,     3583.34103067380}, 
    {     0.00000006402,  4.19806999276,     5202.35827933520}, 
    {     0.00000006523,  6.11927838278,      135.06508003540}, 
    {     0.00000006127,  0.00122595969,     6836.64525283380}, 
    {     0.00000006223,  6.10653136990,    17256.63153634140}, 
    {     0.00000008161,  5.24822786208,    10575.40668294180}, 
    {     0.00000006163,  3.60026818309,    10021.85453375160}, 
    {     0.00000006163,  1.56949585888,    10021.82002644720}, 
    {     0.00000005673,  0.13638905291,    13524.91634293140}, 
    {     0.00000006257,  4.50450316951,     8425.65083781480}, 
    {     0.00000005249,  2.70116504868,     4459.36821880260}, 
    {     0.00000006470,  2.74232480124,     7740.60678358880}, 
    {     0.00000005523,  6.06378363783,    10419.98628350760}, 
    {     0.00000005548,  5.75002125481,    12168.00269657460}, 
    {     0.00000006827,  4.69340338938,    17654.78053974960}, 
    {     0.00000004993,  4.68464837021,      522.57741809380}, 
    {     0.00000006320,  3.31938091270,     3767.21061757580}, 
    {     0.00000004735,  0.00770324607,     3325.35995551480}, 
    {     0.00000005025,  2.33675441772,     1052.26838318840}, 
    {     0.00000004656,  5.15033151106,     1066.49547719000}, 
    {     0.00000004728,  5.77993082374,     9808.53818466140}, 
    {     0.00000005128,  1.57178942294,     6525.80445396540}, 
    {     0.00000004523,  1.44233177206,     3369.06161416760}, 
    {     0.00000006205,  4.48163731718,    22747.29071487440}, 
    {     0.00000006169,  4.59085555242,     6531.66165626500}, 
    {     0.00000005329,  4.55141789349,     1744.42598441520}, 
    {     0.00000004514,  5.94508421612,     6894.52394883760}, 
    {     0.00000004330,  3.10899106071,     4569.57454002200}, 
    {     0.00000005367,  5.08071026709,     2707.82868738660}, 
    {     0.00000005138,  1.28584065229,     8439.87793181640}, 
    {     0.00000004120,  5.48544036931,     2699.73481931760}, 
    {     0.00000005398,  5.21710209952,     5305.45105355380}, 
    {     0.00000004450,  5.56771154217,    16865.52876963120}, 
    {     0.00000003898,  1.48753002285,     9168.64089834740}, 
    {     0.00000003858,  1.23056079731,    16858.48253293320}, 
    {     0.00000003764,  0.27080818668,    17395.21973472580}, 
    {     0.00000004687,  3.05709075840,     5518.75014899180}, 
    {     0.00000004264,  2.79046663043,     3503.07906283200}, 
    {     0.00000003864,  0.37957786186,    10177.25767953360}, 
    {     0.00000003992,  1.84425142473,     3134.42687826260}, 
    {     0.00000003658,  2.95544843123,     6144.42034130420}, 
    {     0.00000003650,  1.58041651396,     6680.24453233140}, 
    {     0.00000003945,  1.98631850445,     8969.56889691100}, 
    {     0.00000003357,  2.72642619106,     7875.67186362420}, 
    {     0.00000003612,  2.91545290475,     6682.20517446780}, 
    {     0.00000004391,  0.81942455331,     3302.47939106200}, 
    {     0.00000004062,  5.46935163229,     3120.19978426100}, 
    {     0.00000003319,  1.77193665114,     3116.26763099790}, 
    {     0.00000003501,  1.17933995367,    10184.30391623160}, 
    {     0.00000004008,  1.33675583877,     6247.51311552280}, 
    {     0.00000003603,  0.15462927995,     2178.13772229200}, 
    {     0.00000003310,  3.12882757204,    17277.40693183380}, 
    {     0.00000004133,  4.39583076998,     3074.00538497800}, 
    {     0.00000003203,  3.36608406402,     2384.32327072920}, 
    {     0.00000003991,  3.82886107874,     3355.86489788480}, 
    {     0.00000004209,  1.90551053001,      263.08392337280}, 
    {     0.00000003751,  4.25459322896,     6261.74020952440}, 
    {     0.00000003111,  1.65372563906,    20199.09495963300}, 
    {     0.00000003627,  5.55043389753,      632.78373931320}, 
    {     0.00000002900,  1.91536985830,    12935.85151592320}, 
    {     0.00000003373,  5.50812409170,    23384.28698689860}, 
    {     0.00000003130,  5.44035193127,     6048.44111408640}, 
    {     0.00000003314,  5.83281937056,     5331.35744374080}, 
    {     0.00000003813,  0.80274300018,    13517.87010623340}, 
    {     0.00000003618,  3.68174019476,     5724.93569742900}, 
    {     0.00000002813,  1.68598843421,     2391.43681773000}, 
    {     0.00000002902,  5.30668266703,     8955.34180290940}, 
    {     0.00000003225,  2.29849058942,     3312.16323923200}, 
    {     0.00000002744,  5.50347742867,      149.56319713460}, 
    {     0.00000003860,  3.48197884682,    20618.01935853360}, 
    {     0.00000002810,  4.77172972854,     1964.83862685400}, 
    {     0.00000002711,  2.69239976396,     3178.14579056760}, 
    {     0.00000002711,  2.38313180043,     2648.45482547300}, 
    {     0.00000002831,  5.91934295130,    12964.30070339100}, 
    {     0.00000002739,  1.09522334227,      536.80451209540}, 
    {     0.00000002710,  6.10385329581,     3973.39616601300}, 
    {     0.00000002488,  3.87703808830,     1861.74585263540}, 
    {     0.00000002623,  2.65529542780,     8329.67161059700}, 
    {     0.00000002940,  5.68286095012,     6158.64743530580}, 
    {     0.00000002336,  3.24847007110,     4672.66731424060}, 
    {     0.00000002318,  1.69208910196,     3914.95722503460}, 
    {     0.00000002367,  4.75070694678,      103.09277421860}, 
    {     0.00000002963,  0.23379260146,    20597.24396304120}, 
    {     0.00000002182,  6.18341760619,     3346.13535100720}, 
    {     0.00000002451,  1.92510991367,     7799.98064550240}, 
    {     0.00000002549,  5.39464168921,     3863.18984479360}, 
    {     0.00000002121,  4.87506277174,     9830.38901398780}, 
    {     0.00000002181,  0.58531113635,      162.46663613220}, 
    {     0.00000002101,  2.84309144308,     3415.39402526710}, 
    {     0.00000002103,  3.06103660745,    19800.94595622480}, 
    {     0.00000002339,  3.90794221100,     3335.08950239240}, 
    {     0.00000002143,  5.40843887525,      266.60704172180}, 
    {     0.00000002026,  5.52082289678,    10021.90459040220}, 
    {     0.00000001997,  2.77245698491,    13936.79450513400}, 
    {     0.00000002143,  0.09046579554,    13358.92658845020}, 
    {     0.00000001995,  2.62507525502,       20.77539549240}, 
    {     0.00000001959,  4.88162273140,     3237.51965248120}, 
    {     0.00000002219,  1.06826905532,     3320.25710730100}, 
    {     0.00000002126,  3.02110226880,     5625.36604155940}, 
    {     0.00000002124,  3.68619137826,     5618.31980486140}, 
    {     0.00000001940,  1.28990042410,    17924.91069982040}, 
    {     0.00000002563,  2.09964366436,     7910.18696672180}, 
    {     0.00000002541,  4.92484934029,     6604.95878212400}, 
    {     0.00000001816,  5.57505731597,     3351.24909204960}, 
    {     0.00000001776,  5.77337176841,     3607.21946842160}, 
    {     0.00000001779,  4.48010754608,    10818.13528691580}, 
    {     0.00000001991,  2.60731155414,     3546.79797513700}, 
    {     0.00000001735,  1.51574912984,     1692.16566950240}, 
    {     0.00000002099,  5.75659410227,    13365.97282514820}, 
    {     0.00000001801,  2.73190366523,     3360.96774609859}, 
    {     0.00000001760,  2.21274514293,    13119.72110282519}, 
    {     0.00000001907,  3.32232991929,     6702.00024889200}, 
    {     0.00000001732,  1.43627324542,     4885.96640967860}, 
    {     0.00000002043,  1.19294433795,     6660.44945790720}, 
    {     0.00000001774,  2.18409046663,     6784.31762761820}, 
    {     0.00000001721,  4.86030510926,    10014.72373309860}, 
    {     0.00000001766,  2.09400474030,     3603.69635007260}, 
    {     0.00000001599,  3.48163351273,    23141.55838292460}, 
    {     0.00000001596,  3.52844251750,     6688.33840040040}, 
    {     0.00000001625,  3.24396520223,     3657.00429635640}, 
    {     0.00000001580,  1.88559955946,     6298.32832117640}, 
    {     0.00000001614,  5.73885935004,     4555.34744602040}, 
    {     0.00000001534,  5.17856445800,       76.26607127560}, 
    {     0.00000002034,  2.63611090015,    16460.33352952499}, 
    {     0.00000002025,  5.92932421118,    10021.76996979660}, 
    {     0.00000001690,  4.41092763741,     5729.50644714900}, 
    {     0.00000001880,  4.53291066339,     3329.97576135000}, 
    {     0.00000001529,  4.75820072827,     7895.95987272020}, 
    {     0.00000001529,  1.35292688408,     1581.95934828300}, 
    {     0.00000001807,  1.86211947929,     2693.60159338500}, 
    {     0.00000001871,  2.38027840271,     6843.69148953180}, 
    {     0.00000001525,  3.98478982422,     6546.15977336420}, 
    {     0.00000001391,  5.54907950578,     4775.76008845920}, 
    {     0.00000001447,  2.35649936426,     6034.21402008480}, 
    {     0.00000001425,  4.46726861881,      574.34479833480}, 
    {     0.00000001372,  1.07223935556,    12722.55242048520}, 
    {     0.00000001374,  1.81967687782,     9779.10867612540}, 
    {     0.00000001426,  2.56937630608,     3399.98628861340}, 
    {     0.00000001380,  5.76161063950,    16335.83780453660}, 
    {     0.00000001337,  2.97604378007,     6127.65545055720}, 
    {     0.00000001478,  4.74293012446,    12566.15169998280}, 
    {     0.00000001359,  0.80090329608,      853.19638175200}, 
    {     0.00000001716,  0.30679442592,    10551.52824519400}, 
    {     0.00000001544,  4.33406034501,      640.87760738220}, 
    {     0.00000001280,  2.00262938648,     6677.63442474780}, 
    {     0.00000001233,  1.02381163524,     3024.22055704320}, 
    {     0.00000001279,  1.92685858897,     3347.65866339780}, 
    {     0.00000001243,  2.44194753910,     6684.81528205140}, 
    {     0.00000001459,  1.74092527479,     3333.56619000180}, 
    {     0.00000001675,  1.79700655545,     1118.75579210280}, 
    {     0.00000001490,  2.59383061313,     2494.52959194860}, 
    {     0.00000001293,  3.31710472549,     3407.09983561420}, 
    {     0.00000001187,  4.92958290110,    22743.40937951640}, 
    {     0.00000001374,  2.53380484533,     5459.37628707820}, 
    {     0.00000001329,  1.99425606160,     1228.96211332220}, 
    {     0.00000001183,  4.25338096713,     3344.49376205780}, 
    {     0.00000001231,  2.50206387861,     4356.27544458400}, 
    {     0.00000001243,  2.65173439875,       74.78159856730}, 
    {     0.00000001285,  4.34087881585,     3326.38533269820}, 
    {     0.00000001119,  1.91321733325,     3281.23856478620}, 
    {     0.00000001265,  3.77353981627,    11236.57229942000}, 
    {     0.00000001089,  5.51229221434,     3017.10701004240}, 
    {     0.00000001286,  1.38393461860,     3077.52850332700}, 
    {     0.00000001100,  1.17127664716,     6606.44325483230}, 
    {     0.00000001256,  3.35491080997,     4039.88357492740}, 
    {     0.00000001381,  5.69970569949,     2807.39834325620}, 
    {     0.00000001106,  5.81878194960,     2675.85638156980}, 
    {     0.00000001187,  2.41348978779,    10596.18207843420}, 
    {     0.00000001052,  3.33521939538,     3304.58456002240}, 
    {     0.00000001184,  5.84735789822,     3336.73109134180}, 
    {     0.00000001071,  2.78692349783,     8270.29774868340}, 
    {     0.00000001106,  3.03323928564,     3929.67725370800}, 
    {     0.00000001013,  3.51980287593,     8013.27974094040}, 
    {     0.00000001079,  0.51857998748,     2814.44457995420}, 
    {     0.00000000997,  4.72549938173,      533.21408344360}, 
    {     0.00000001126,  0.52511404239,     6816.28993343500}, 
    {     0.00000001313,  2.07279662119,    23539.70738633280}, 
    {     0.00000000997,  4.03571286988,    16062.18452611680}, 
    {     0.00000001180,  0.60882533212,     2301.58581590939}, 
    {     0.00000000954,  5.90344184081,    20206.14119633100}, 
    {     0.00000000993,  0.07173946166,    24150.08005134500}, 
    {     0.00000001088,  1.25542347811,     5938.23479286700}, 
    {     0.00000001046,  2.22216816006,     3980.50971301380}, 
    {     0.00000000912,  2.54221161157,      433.71173787680}, 
    {     0.00000001248,  0.59994750055,    16173.37116840440}, 
    {     0.00000001027,  4.95981994495,    19676.45023123640}, 
    {     0.00000001108,  4.34209448160,     3339.12795399150}, 
    {     0.00000001188,  6.21563718642,     2679.37949991880}, 
    {     0.00000001143,  4.48026291181,    19402.79695281660}, 
    {     0.00000000947,  1.30292113731,     8273.82086703240}, 
    {     0.00000000841,  0.83266239461,     2597.62236616720}, 
    {     0.00000001017,  5.14490946009,     1596.18644228460}, 
    {     0.00000000832,  5.60623652030,     3340.19235060619}, 
    {     0.00000001035,  4.71834396549,      419.48464387520}, 
    {     0.00000000843,  5.30135428959,    26084.02180621620}, 
    {     0.00000000904,  0.45707711274,    12995.22537783680}, 
    {     0.00000001089,  0.51279391816,    11250.79939342160}, 
    {     0.00000000990,  2.06776071698,     7255.56965173440}, 
    {     0.00000000806,  3.09007612136,     5415.65737477320}, 
    {     0.00000000786,  4.62520938233,     2547.83753823240}, 
    {     0.00000000784,  6.24013860877,    15508.61512327440}, 
    {     0.00000000963,  2.10680539918,     6456.88005769770}, 
    {     0.00000000983,  2.34198517787,    18454.60166491500}, 
    {     0.00000000778,  3.56577545397,    12721.57209941700}, 
    {     0.00000000873,  5.09097165091,     2540.79130153440}, 
    {     0.00000000767,  3.08340332968,    11081.21921028860}, 
    {     0.00000000859,  4.14805102195,     6438.49624942560}, 
    {     0.00000001012,  4.45000929440,     3316.73398895200}, 
    {     0.00000000906,  4.29336078401,     3344.54457996290}, 
    {     0.00000000740,  2.61398721165,     2284.75361485960}, 
    {     0.00000000790,  6.03436807620,    12509.25332504720}, 
    {     0.00000000742,  4.11069563225,     3760.09707057500}, 
    {     0.00000000739,  0.52114868719,    18052.92954315780}, 
    {     0.00000000731,  3.28129610605,     3510.19260983280}, 
    {     0.00000000923,  2.78717980606,     1332.05488754080}, 
    {     0.00000000757,  0.86911170494,     1545.35398297880}, 
    {     0.00000000910,  2.74957179518,      316.39186965660}, 
    {     0.00000000776,  3.72496049906,     6571.01853218020}, 
    {     0.00000000996,  0.45947604134,    27490.69247804480}, 
    {     0.00000000704,  1.89599510634,    13362.43245314700}, 
    {     0.00000000702,  5.53839511728,     3364.49086444760}, 
    {     0.00000000698,  2.20800707948,    20995.39296644940}, 
    {     0.00000000701,  3.92671746155,    13362.46696045140}, 
    {     0.00000000764,  1.88253040974,     5732.04924442980}, 
    {     0.00000000699,  1.79149358545,      206.18554843720}, 
    {     0.00000000687,  0.34919720925,     5835.14201864840}, 
    {     0.00000000686,  0.12318958493,    13760.59871020740}, 
    {     0.00000000827,  0.49766945170,     3376.64029337720}, 
    {     0.00000000684,  0.23959365533,     2409.24933984800}, 
    {     0.00000000671,  0.51079989451,    25685.87280280800}, 
    {     0.00000000699,  5.90166576392,    19004.64794940840}, 
    {     0.00000000649,  4.88357273177,    11766.26326451460}, 
    {     0.00000000647,  3.01092562913,     5223.69391980220}, 
    {     0.00000000725,  3.28015382608,     4142.97634914600}, 
    {     0.00000000676,  0.48866539717,     5408.54382777240}, 
    {     0.00000000811,  3.13587175379,    18984.29263000960}, 
    {     0.00000000653,  4.27065316348,     1214.73501932060}, 
    {     0.00000000647,  3.62972991197,     7107.82304427560}, 
    {     0.00000000824,  4.49442636948,     3341.03250279340}, 
    {     0.00000000671,  0.17020701482,      110.20632121940}, 
    {     0.00000000626,  4.93471822146,     9872.27408296480}, 
    {     0.00000000583,  6.03261379086,    20809.46762464520}, 
    {     0.00000000586,  4.02402847599,      664.75604513000}, 
    {     0.00000000592,  4.01141532759,    19406.67828817460}, 
    {     0.00000000692,  1.45478322504,     3377.21779200400}, 
    {     0.00000000571,  1.20823617855,     5621.86017686260}, 
    {     0.00000000571,  5.46064992297,     5621.82566955820}, 
    {     0.00000000737,  3.19744761356,     9380.95967271720}, 
    {     0.00000000598,  3.05986754375,     3341.04230982650}, 
    {     0.00000000677,  4.72311533943,     8116.37251515900}, 
    {     0.00000000696,  0.14131183251,     6923.95345737360}, 
    {     0.00000000595,  2.17622352088,     7270.28968040780}, 
    {     0.00000000573,  0.40143379609,    15110.46611986620}, 
    {     0.00000000655,  1.08706089359,     3169.93955608060}, 
    {     0.00000000582,  1.68224967196,    26087.90314157420}, 
    {     0.00000000549,  1.67151859507,    11780.49035851620}, 
    {     0.00000000543,  2.42716241057,      170.67287061920}, 
    {     0.00000000533,  2.63968766595,     2277.70737816160}, 
    {     0.00000000584,  5.99680812069,     2149.68853482420}, 
    {     0.00000000576,  1.69042028754,     3384.33133900480}, 
    {     0.00000000546,  2.53920837226,     7380.49600162720}, 
    {     0.00000000598,  0.75754342787,     3340.18254357310}, 
    {     0.00000000575,  1.33793171924,     3296.89351439480}, 
    {     0.00000000526,  5.02709350225,     1375.77379984580}, 
    {     0.00000000541,  6.17208296381,    13149.15061136120}, 
    {     0.00000000689,  0.02979541784,    22345.26037610820}, 
    {     0.00000000540,  5.54146803424,     8646.06348025360}, 
    {     0.00000000528,  2.74122616237,     3826.58447948940}, 
    {     0.00000000505,  6.27740886099,    10235.13637553740}, 
    {     0.00000000689,  6.28209877521,    12295.95422960920}, 
    {     0.00000000499,  0.25663630799,     2142.64229812620}, 
    {     0.00000000498,  5.91370528027,     6460.81221096080}, 
    {     0.00000000508,  0.62111966418,    20735.83216142559}, 
    {     0.00000000522,  2.56526285270,     3877.41693879520}, 
    {     0.00000000588,  3.39977690249,     3329.56672643590}, 
    {     0.00000000486,  4.01080943956,    23937.85638974100}, 
    {     0.00000000573,  3.88912359036,     9065.54812412880}, 
    {     0.00000000535,  1.55491053821,     2221.85663459700}, 
    {     0.00000000523,  2.88572080247,     6040.34724601740}, 
    {     0.00000000473,  4.14503886880,     3113.13629391080}, 
    {     0.00000000459,  4.05994683743,     1162.47470440780}, 
    {     0.00000000494,  2.98928486614,     1039.02661079040}, 
    {     0.00000000487,  4.88596324970,     5511.63660199100}, 
    {     0.00000000537,  1.24870344441,    48835.19385644859}, 
    {     0.00000000462,  5.38999453893,    15664.03552270859}, 
    {     0.00000000580,  5.52560147930,     4981.94563689640}, 
    {     0.00000000524,  1.21845283197,    10721.10842832700}, 
    {     0.00000000583,  5.13992428384,     3873.82651014340}, 
    {     0.00000000440,  4.69966061314,      799.82112516540}, 
    {     0.00000000465,  5.49231586238,     3342.09689940810}, 
    {     0.00000000441,  2.28374512416,    12310.18132361080}, 
    {     0.00000000436,  0.12517834889,      956.28915597060}, 
    {     0.00000000440,  3.74259902142,     5195.24473233440}, 
    {     0.00000000537,  5.91841782585,     1478.86657406440}, 
    {     0.00000000429,  1.20544410750,       28.44918746780}, 
    {     0.00000000566,  3.86528084538,    26482.17080962440}, 
    {     0.00000000555,  5.30320900441,     2766.26762836500}, 
    {     0.00000000457,  1.45547501374,     5636.07001721200}, 
    {     0.00000000494,  0.63303483918,     3274.12501778540}, 
    {     0.00000000451,  0.35861793151,     6665.97238221460}, 
    {     0.00000000541,  1.89116221008,     9866.41688066520}, 
    {     0.00000000441,  5.47800914687,     4407.10790388980}, 
    {     0.00000000410,  1.94403991211,    10020.85695903120}, 
    {     0.00000000544,  3.15066022776,     8535.85715903420}, 
    {     0.00000000402,  3.25745210946,     5820.91492464680}, 
    {     0.00000000405,  0.93747657450,     2295.45759051220}, 
    {     0.00000000416,  1.42792982324,    21947.11137270000}, 
    {     0.00000000415,  3.32867165254,     8859.36257569160}, 
    {     0.00000000407,  0.86210907189,    29026.48522950779}, 
    {     0.00000000399,  4.65476356450,     4825.54491639400}, 
    {     0.00000000416,  2.62133861173,       38.13303563780}, 
    {     0.00000000403,  1.68400791647,     9588.12554222260}, 
    {     0.00000000413,  5.34053015386,     3189.56475685690}, 
    {     0.00000000431,  3.10172506449,    11216.28429032400}, 
    {     0.00000000494,  4.57792960212,     8542.97070603500}, 
    {     0.00000000383,  4.90093906321,    19146.75926614180}, 
    {     0.00000000456,  1.17955496121,    10610.90210710760}, 
    {     0.00000000420,  0.03239467048,     3192.53370227350}, 
    {     0.00000000378,  0.19461410317,     2067.93140107260}, 
    {     0.00000000425,  4.33864174857,      220.41264243880}, 
    {     0.00000000414,  1.15478222156,     6643.09181776180}, 
    {     0.00000000390,  4.75915594442,     6414.61781167780}, 
    {     0.00000000385,  2.74383378093,     1854.63230563460}, 
    {     0.00000000382,  3.26274102234,    31022.75317085620}, 
    {     0.00000000399,  1.37709427447,     9654.61295113700}, 
    {     0.00000000381,  4.18323991778,     6696.47732458460}, 
    {     0.00000000378,  5.87644939998,     6357.71943674220}, 
    {     0.00000000374,  4.16579540067,    13553.89797291080}, 
    {     0.00000000404,  3.12419888471,     3723.49170527080}, 
    {     0.00000000393,  5.81756122718,     3490.17562383440}, 
    {     0.00000000357,  3.99005864695,     8958.93223156120}, 
    {     0.00000000373,  1.27017379563,     2111.65031337760}, 
    {     0.00000000494,  4.66290046895,     1435.14766175940}, 
    {     0.00000000390,  2.02097473321,     1903.43681250120}, 
    {     0.00000000379,  4.08720452061,    10706.88133432540}, 
    {     0.00000000365,  2.26917834367,    28628.33622609960}, 
    {     0.00000000461,  1.90079945086,    25287.72379939980}, 
    {     0.00000000383,  2.18698994244,    16276.46394262300}, 
    {     0.00000000364,  3.25068295862,     5095.67507646480}, 
    {     0.00000000431,  1.79617275249,     6709.67404086740}, 
    {     0.00000000383,  4.73047210613,     3981.49003408200}, 
    {     0.00000000383,  2.72628596393,     3472.15438838620}, 
    {     0.00000000338,  1.71242732923,      224.34479570190}, 
    {     0.00000000336,  5.78510056191,    26880.31981303260}, 
    {     0.00000000358,  3.45328915967,       15.25247118500}, 
    {     0.00000000386,  6.20072810380,     8671.96987044060}, 
    {     0.00000000335,  1.10573866929,       59.37386191360}, 
    {     0.00000000394,  4.02046774112,     2075.04494807340}, 
    {     0.00000000404,  3.27554084958,      931.36308685180}, 
    {     0.00000000332,  4.57985270157,     8982.81066930900}, 
    {     0.00000000318,  3.29010380724,     9485.03276800400}, 
    {     0.00000000341,  6.08550074779,    17085.95866572220}, 
    {     0.00000000317,  4.05379693363,     3450.81874791920}, 
    {     0.00000000308,  1.01972298903,    18606.49894600020}, 
    {     0.00000000369,  2.84012437948,     4392.88080988820}, 
    {     0.00000000419,  2.79753443827,     5106.37905211740}, 
    {     0.00000000301,  5.54688241213,     3041.48603243060}, 
    {     0.00000000299,  5.01812614127,     2810.93871525740}, 
    {     0.00000000357,  1.15866958020,     4076.48894023160}, 
    {     0.00000000299,  2.98735462676,     2810.90420795300}, 
    {     0.00000000360,  5.83226121443,    26724.89941359840}, 
    {     0.00000000364,  0.71456222108,     3209.07046501340}, 
    {     0.00000000388,  5.01180713189,    12323.42309600880}, 
    {     0.00000000336,  4.60072831728,     9602.35263622420}, 
    {     0.00000000371,  2.23508025241,     4996.17273089800}, 
    {     0.00000000338,  5.83235701604,     4246.06912336460}, 
    {     0.00000000309,  5.24769404310,    13171.00144068760}, 
    {     0.00000000294,  2.20962875276,    11140.59307220220}, 
    {     0.00000000292,  3.07172302940,    11670.28403729680}, 
    {     0.00000000290,  0.39535768288,     2412.77245819700}, 
    {     0.00000000346,  1.74151420484,     5617.91076994730}, 
    {     0.00000000296,  6.04933382807,     9499.25986200560}, 
    {     0.00000000302,  3.01024090578,     7483.58877584580}, 
    {     0.00000000394,  2.12229107241,     6475.03930496240}, 
    {     0.00000000283,  0.52912721426,    16699.53901514999}, 
    {     0.00000000338,  4.94606216822,     5625.77507647350}, 
    {     0.00000000299,  5.26277094099,     9945.57120882380}, 
    {     0.00000000279,  0.54063870001,     3226.21331978640}, 
    {     0.00000000309,  3.17514941942,    14047.49376102520}, 
    {     0.00000000383,  3.23919312949,    10022.81760116760}, 
    {     0.00000000312,  2.74287650032,     6652.77566593180}, 
    {     0.00000000366,  5.48470145487,     3561.02506913860}, 
    {     0.00000000272,  0.11219838826,     7314.00859271280}, 
    {     0.00000000281,  5.15132055967,     2825.14855560680}, 
    {     0.00000000325,  2.45554148062,     8436.28750316460}, 
    {     0.00000000292,  3.33720528630,     9468.26787725700}, 
    {     0.00000000266,  1.64531471079,     4253.18267036540}, 
    {     0.00000000266,  1.69689370230,      647.01083331480}, 
    {     0.00000000260,  2.54461537647,       20.35531939880}, 
    {     0.00000000275,  2.78381954796,     2970.91261075940}, 
    {     0.00000000295,  5.96367554546,     4025.65648092580}, 
    {     0.00000000265,  4.00664363477,     2171.02417529120}, 
    {     0.00000000310,  1.40846068056,      589.06482700820}, 
    {     0.00000000267,  3.01024875581,     6518.75821726740}, 
    {     0.00000000259,  5.20888482694,     7366.26890762560}, 
    {     0.00000000274,  0.75900688956,     3735.23831175900}, 
    {     0.00000000305,  6.19137588974,     6677.34351804160}, 
    {     0.00000000265,  3.25039598109,    24889.57479599160}, 
    {     0.00000000260,  1.36534128911,      846.08283475120}, 
    {     0.00000000279,  6.19278334118,    16706.58525184800}, 
    {     0.00000000253,  4.14762846559,     5642.19824260920}, 
    {     0.00000000257,  0.08460483453,    13362.38239649640}, 
    {     0.00000000331,  6.27239577743,    16304.91313009080}, 
    {     0.00000000259,  2.03595864791,     2089.78223039900}, 
    {     0.00000000243,  1.92565816384,     6418.14093002680}, 
    {     0.00000000244,  1.37325119410,     2277.29834324750}, 
    {     0.00000000303,  3.78453746314,    28230.18722269139}, 
    {     0.00000000259,  4.79543939498,     6657.34641565180}, 
    {     0.00000000238,  1.18977479528,     3171.03224356680}, 
    {     0.00000000256,  1.01427800277,      568.82187402740}, 
    {     0.00000000236,  5.56425829083,       14.22709400160}, 
    {     0.00000000237,  2.97284129671,    27682.14074415640}, 
    {     0.00000000238,  2.47584234436,     5430.39465709880}, 
    {     0.00000000234,  4.34956793150,     6675.70192909220}, 
    {     0.00000000238,  0.13886525152,     3742.28454845700}, 
    {     0.00000000305,  4.59739079661,     6685.10618875760}, 
    {     0.00000000300,  3.81293221774,     1190.92389187560}, 
    {     0.00000000323,  1.67391005108,     4922.57177498280}, 
    {     0.00000000232,  4.82574695052,     9070.11887384880}, 
    {     0.00000000236,  2.40662610715,     3620.39893105220}, 
    {     0.00000000251,  5.04374120897,     1905.46476494040}, 
    {     0.00000000260,  4.54521365935,     2285.16264977370}, 
    {     0.00000000263,  0.63920765354,     2008.55753915900}, 
    {     0.00000000301,  3.78342344549,    34363.36559755600}, 
    {     0.00000000282,  5.00900221145,     5607.61582920880}, 
    {     0.00000000252,  5.72540861680,    17468.85519794540}, 
    {     0.00000000288,  2.26316945289,     6621.85099148600}, 
    {     0.00000000224,  3.76343722525,    10042.61267559180}, 
    {     0.00000000251,  5.51643360482,     3416.87849797540}, 
    {     0.00000000225,  5.50723076933,     4936.79886898440}, 
    {     0.00000000237,  4.86086962980,    14158.74771361560}, 
    {     0.00000000249,  1.06089727346,     3313.21087060300}, 
    {     0.00000000225,  2.16307488317,     3936.79080070880}, 
    {     0.00000000219,  1.70468184895,    18451.07854656599}, 
    {     0.00000000287,  5.70519621324,      792.77488846740}, 
    {     0.00000000244,  1.94639665939,        3.59042865180}, 
    {     0.00000000264,  1.49529049866,     6364.83298374300}, 
    {     0.00000000254,  5.34446995415,     5401.43028077160}, 
    {     0.00000000222,  1.30177724842,    29822.78323632420}, 
    {     0.00000000223,  2.66657203577,    31968.94865279940}, 
    {     0.00000000306,  6.06259585249,    14061.72085502680}, 
    {     0.00000000218,  5.18889136792,    23017.06265793620}, 
    {     0.00000000236,  3.30738668030,     1197.97012857360}, 
    {     0.00000000214,  2.72627704766,     6740.59871531320}, 
    {     0.00000000233,  1.62260863687,    10001.06188460700}, 
    {     0.00000000270,  0.90714933652,     6155.05700665400}, 
    {     0.00000000214,  2.48624019430,     5355.23588148860}, 
    {     0.00000000221,  2.98361193277,      131.54196168640}, 
    {     0.00000000210,  2.62093674086,    10124.93005431800}, 
    {     0.00000000211,  5.27490544059,    13355.33615979840}, 
    {     0.00000000259,  1.25267305827,     2641.34127847220}, 
    {     0.00000000213,  4.12642821680,    31570.79964939120}, 
    {     0.00000000285,  0.85763558421,     8749.15625447220}, 
    {     0.00000000243,  2.44748800604,     3311.18291816379}, 
    {     0.00000000226,  5.48392576152,     7203.80227149340}, 
    {     0.00000000251,  4.67012983731,     6666.99775939800}, 
    {     0.00000000264,  3.72622435629,     6747.71226231400}, 
    {     0.00000000260,  3.67749190897,     6645.19698672220}, 
    {     0.00000000209,  4.31928920378,     3337.86091608880}, 
    {     0.00000000207,  4.73304189825,     6679.74038069130}, 
    {     0.00000000206,  1.11183726079,     5888.44996493220}, 
    {     0.00000000215,  4.11048880636,     3378.74546233760}, 
    {     0.00000000213,  0.34186471358,     6686.74777770700}, 
    {     0.00000000214,  2.95860972924,    10824.20120254560}, 
    {     0.00000000204,  0.73237459786,        3.93215326310}, 
    {     0.00000000219,  0.88578298306,    19513.98359510420}, 
    {     0.00000000249,  0.99691404829,     5753.38488489680}, 
    {     0.00000000205,  2.60851826933,     2771.79055267240}, 
    {     0.00000000244,  2.73638895956,     5989.06725217280}, 
    {     0.00000000201,  3.31791007890,     6850.80503653260}, 
    {     0.00000000258,  2.77004595067,     2480.30249794700}, 
    {     0.00000000246,  3.34468800742,     3333.92876282570}, 
    {     0.00000000257,  5.95927379256,    13362.51701710200}, 
    {     0.00000000214,  4.83852070028,     6681.64492949320}, 
    {     0.00000000197,  0.55202541351,      735.87651353180}, 
    {     0.00000000216,  4.02521804874,     3133.91168940320}, 
    {     0.00000000255,  2.66015039822,     1062.90504853820}, 
    {     0.00000000209,  0.67381599651,    13892.14067189380}, 
    {     0.00000000193,  1.52645682131,      949.17560896980}, 
    {     0.00000000195,  2.87576501755,    21548.96236929180}, 
    {     0.00000000223,  1.09315483130,     6148.01076995600}, 
    {     0.00000000219,  1.52537634511,     6660.86953400080}, 
    {     0.00000000244,  4.10741249432,    22487.37169284160}, 
    {     0.00000000192,  2.90573573946,     8799.98871377800}, 
    {     0.00000000206,  5.11175805400,     4140.43355186520}, 
    {     0.00000000215,  0.20523958080,     4782.87363546000}, 
    {     0.00000000193,  3.19008521837,     6756.00645196690}, 
    {     0.00000000188,  1.03828263764,     9374.82644678460}, 
    {     0.00000000188,  2.50123675826,     6944.30877677240}, 
    {     0.00000000260,  1.61746038838,     2011.10033643980}, 
    {     0.00000000218,  0.84212090762,     6717.25272007700}, 
    {     0.00000000200,  2.43090582870,    10018.24685144760}, 
    {     0.00000000199,  5.81238461808,     4289.78803566960}, 
    {     0.00000000195,  3.02792862154,    32765.24665961580}, 
    {     0.00000000214,  5.95026024981,     6680.80477730600}, 
    {     0.00000000248,  5.77658456809,    15806.14683944200}, 
    {     0.00000000185,  3.13072183492,     3253.30422216000}, 
    {     0.00000000246,  2.58153533312,     1795.25844372100}, 
    {     0.00000000188,  4.02461769542,    14577.18472611980}, 
    {     0.00000000234,  3.36641746142,     8965.97846825920}, 
    {     0.00000000185,  0.96707446746,     2604.73591316800}, 
    {     0.00000000184,  1.46821995395,     1437.17561419860}, 
    {     0.00000000232,  5.61892824149,      227.47613278900}, 
    {     0.00000000211,  4.23517070569,    16703.07938715119}, 
    {     0.00000000196,  2.80582160764,     2796.69436760360}, 
    {     0.00000000198,  5.92373801410,     4133.38731516720}, 
    {     0.00000000223,  1.81801741599,     3184.21170619740}, 
    {     0.00000000184,  4.92796517214,     8166.15734309380}, 
    {     0.00000000244,  5.81091817596,    29424.63423291600}, 
    {     0.00000000185,  2.03013271464,     6674.17861670160}, 
    {     0.00000000181,  2.71503450485,     4186.69526145100}, 
    {     0.00000000225,  3.12302444250,     3613.28538405140}, 
    {     0.00000000197,  3.65879755110,     4271.97551355160}, 
    {     0.00000000241,  0.75274729025,     3232.94890276120}, 
    {     0.00000000222,  1.69212877746,    11614.43329373220}, 
    {     0.00000000182,  1.54430188037,     9947.05568153210}, 
    {     0.00000000181,  1.80044971980,     6717.83021870380}, 
    {     0.00000000178,  4.39527633207,     9886.77220006400}, 
    {     0.00000000195,  5.90931353628,     6705.10329114740}, 
    {     0.00000000182,  2.77245257008,     6887.41040183680}, 
    {     0.00000000203,  5.23403035771,     7586.68155006440}, 
    {     0.00000000181,  4.61381081330,     3361.94806716680}, 
    {     0.00000000183,  5.23652106144,     6578.13207918100}, 
    {     0.00000000207,  0.88261302661,    10156.90236013480}, 
    {     0.00000000183,  4.98729652435,     6670.58818804980}, 
    {     0.00000000173,  3.89701254344,     6019.99192661860}, 
    {     0.00000000176,  0.17686337588,      401.67212175720}, 
    {     0.00000000217,  1.94931402901,     8226.57883637840}, 
    {     0.00000000225,  2.30388003779,     1879.55837475340}, 
    {     0.00000000190,  2.71370120496,      742.99006053260}, 
    {     0.00000000183,  5.82189577442,     8962.43809625800}, 
    {     0.00000000172,  3.87119927472,    10028.95082710020}, 
    {     0.00000000197,  1.88682060252,     5032.77809620220}, 
    {     0.00000000172,  2.55622468142,     3188.71514561460}, 
    {     0.00000000217,  1.64882877306,    21265.52312652020}, 
    {     0.00000000209,  5.78130707501,     3343.36393731080}, 
    {     0.00000000187,  5.23125369896,     2125.87740737920}, 
    {     0.00000000197,  6.17705206967,     6947.83189512140}, 
    {     0.00000000167,  6.26759251026,    15849.86575174700}, 
    {     0.00000000180,  5.16028069861,    27832.03821928320}, 
    {     0.00000000189,  2.38894304278,     3212.59358336240}, 
    {     0.00000000176,  0.82131139167,    14591.41182012140}, 
    {     0.00000000181,  2.19749893549,    16703.04487984680}, 
    {     0.00000000172,  4.65456846579,     9175.75444534820}, 
    {     0.00000000164,  2.10466608169,     6688.27109009760}, 
    {     0.00000000214,  1.83336768044,     1596.11913198180}, 
    {     0.00000000164,  1.68898542913,     3468.63127003720}, 
    {     0.00000000183,  1.56948205762,     8962.47260356240}, 
    {     0.00000000167,  1.08651405162,    20426.57109242200}, 
    {     0.00000000191,  5.54553650068,     2806.98930834210}, 
    {     0.00000000167,  0.91858800204,     4001.84535348080}, 
    {     0.00000000165,  3.44053809432,    14421.83163698840}, 
    {     0.00000000166,  5.87188270355,     4452.25467180180}, 
    {     0.00000000200,  5.63217439694,    31172.65064598300}, 
    {     0.00000000171,  2.84145855585,     5490.30096152400}, 
    {     0.00000000189,  0.57701168949,     2973.38809773740}, 
    {     0.00000000163,  2.42147685134,     6314.00052443720}, 
    {     0.00000000222,  3.14790575450,    11610.91017538320}, 
    {     0.00000000224,  2.35840793377,     9638.94074787620}, 
    {     0.00000000206,  3.13951282157,     3336.68027343670}, 
    {     0.00000000162,  6.16561793774,     3547.31316399640}, 
    {     0.00000000163,  5.40393445608,       23.87843774780}, 
    {     0.00000000158,  5.87599422933,     4606.17990532620}, 
    {     0.00000000157,  5.56903233932,     4503.08713110760}, 
    {     0.00000000156,  3.08339691033,     3448.27595063840}, 
    {     0.00000000157,  4.06627173793,     5209.47182633600}, 
    {     0.00000000201,  2.56498664777,     7321.12213971360}, 
    {     0.00000000211,  1.66624816725,     3304.00706139560}, 
    {     0.00000000158,  3.66262944909,     6997.61672305620}, 
    {     0.00000000162,  0.05294981060,    11925.27409260060}, 
    {     0.00000000159,  5.73384451548,     1265.56747862640}, 
    {     0.00000000165,  1.72702001722,     1744.49329471800}, 
    {     0.00000000169,  0.46442541075,    17101.21113690720}, 
    {     0.00000000157,  5.95120005632,     8584.66166590080}, 
    {     0.00000000181,  5.48699984659,     3319.27678623280}, 
    {     0.00000000158,  3.38811845461,     8742.04270747140}, 
    {     0.00000000199,  2.86360029577,    10025.42770875120}, 
    {     0.00000000174,  4.73514708467,     9389.05354078620}, 
    {     0.00000000203,  1.71629299124,      699.27114822760}, 
    {     0.00000000162,  1.85939646363,     1329.51209026000}, 
    {     0.00000000186,  2.44573687199,     2814.85361486830}, 
    {     0.00000000152,  5.08616610530,     3322.79990458180}, 
    {     0.00000000180,  2.71480297259,     2910.49111747480}, 
    {     0.00000000191,  4.12947825174,     9911.63095888000}, 
    {     0.00000000178,  4.58774508036,     6685.15700666270}, 
    {     0.00000000168,  3.13703791538,     5621.91023351320}, 
    {     0.00000000185,  4.32212013296,      323.50541665740}, 
    {     0.00000000156,  1.10107924002,     3710.31224264020}, 
    {     0.00000000150,  1.23635082247,     4193.80880845180}, 
    {     0.00000000199,  1.83524172935,     3436.59165391760}, 
    {     0.00000000165,  3.32970937124,     1272.68102562720}, 
    {     0.00000000149,  0.13370088787,       36.02786667740}, 
    {     0.00000000195,  0.55473364753,    15265.88651930040}, 
    {     0.00000000153,  3.46485402109,    22324.90505670940}, 
    {     0.00000000168,  3.54553456767,     5621.77561290760}, 
    {     0.00000000156,  4.16889740894,    16894.51039961060}, 
    {     0.00000000146,  1.24102730441,     3372.58473251660}, 
    {     0.00000000163,  0.44791234897,    37895.42629036740}, 
    {     0.00000000154,  5.63537863362,     3185.25933756840}, 
    {     0.00000000197,  3.23364188387,     3774.32416457660}, 
    {     0.00000000179,  3.47455924555,     8564.30634650200}, 
    {     0.00000000185,  2.18250548132,      802.36392244620}, 
    {     0.00000000155,  2.58725745796,     1883.08149310240}, 
    {     0.00000000145,  2.62035460481,     3368.01398279660}, 
    {     0.00000000148,  2.51710178830,     3262.86188271590}, 
    {     0.00000000185,  3.03939668358,     3354.83952070140}, 
    {     0.00000000190,  6.00165436525,     4427.39591298580}, 
    {     0.00000000179,  6.01012688855,     6691.86151874940}, 
    {     0.00000000149,  5.39106891990,     2945.98654164060}, 
    {     0.00000000143,  3.37267915445,     3468.56395973440}, 
    {     0.00000000160,  2.16704681601,        0.98032106820}, 
    {     0.00000000188,  0.65797619362,      369.69981594040}, 
    {     0.00000000190,  1.63240538928,     2324.94940881560}, 
    {     0.00000000186,  1.44849264285,     1015.66301788420}, 
    {     0.00000000139,  1.27677785334,     6549.68289171320}, 
    {     0.00000000162,  4.35256558989,     4005.36847182980}, 
    {     0.00000000137,  2.20364649213,     1765.76662541760}, 
    {     0.00000000136,  0.45455359025,     3193.80074017620}, 
    {     0.00000000148,  5.14035003664,     1641.33321019660}, 
    {     0.00000000153,  5.97404356743,     3568.08855948880}, 
    {     0.00000000142,  3.30600789729,     6151.51663465280}, 
    {     0.00000000188,  0.98977442881,     2538.24850425360}, 
    {     0.00000000143,  3.06403412450,     1612.95133303160}, 
    {     0.00000000164,  1.67483546459,     2751.54759969160}, 
    {     0.00000000139,  4.12207666842,     5813.29118932200}, 
    {     0.00000000144,  1.96990399980,     2014.62345478880}, 
    {     0.00000000145,  5.54086212771,     3152.68727893721}, 
    {     0.00000000132,  0.96753793729,     3487.42411322340}, 
    {     0.00000000148,  1.54957786715,     7696.88787128380}, 
    {     0.00000000176,  2.35644988345,    11346.77862063940}, 
    {     0.00000000133,  6.01160718148,    34513.26307268280}, 
    {     0.00000000131,  2.48606821423,     1353.39052800780}, 
    {     0.00000000133,  3.01300582040,     3283.71405176420}, 
    {     0.00000000142,  5.33677852971,     6151.55114195720}, 
    {     0.00000000130,  5.25558990337,    13212.88650966460}, 
    {     0.00000000165,  1.32559153829,     6510.55198278040}, 
    {     0.00000000128,  6.07261046225,     3362.46325602620}, 
    {     0.00000000143,  1.04060603784,     3351.65812696370}, 
    {     0.00000000142,  0.29094317859,     3212.66089366520}, 
    {     0.00000000175,  3.17574071112,     6701.58017279840}, 
    {     0.00000000129,  2.90662663637,     6812.76681508600}, 
    {     0.00000000140,  5.87139171391,     6382.09845913040}, 
    {     0.00000000125,  1.62548810323,    10191.41746323240}, 
    {     0.00000000128,  3.55358985291,     3223.29255847960}, 
    {     0.00000000128,  0.49984480965,    10264.56588407340}, 
    {     0.00000000144,  4.44112984395,     7100.70949727480}, 
    {     0.00000000124,  2.02283056333,     6724.94376570460}, 
    {     0.00000000134,  0.19295362623,     3130.83644961080}, 
    {     0.00000000126,  4.30028787044,     1971.95217385480}, 
    {     0.00000000133,  5.00404182206,    11883.58313273480}, 
    {     0.00000000124,  0.73963594764,     1485.98012106520}, 
    {     0.00000000136,  0.79050065403,     2281.24775016280}, 
    {     0.00000000143,  3.34238727539,     3181.66890891660}, 
    {     0.00000000123,  0.47283015475,     3347.29609057390}, 
    {     0.00000000152,  5.01464455460,     3358.42494881780}, 
    {     0.00000000137,  5.73257098528,     5244.04923920100}, 
    {     0.00000000122,  1.37003015612,     3370.04193523580}, 
    {     0.00000000130,  0.90844304292,     3427.92063123960}, 
    {     0.00000000135,  3.56996218538,     3229.42578441220}, 
    {     0.00000000121,  3.19494013546,     4576.68808702280}, 
    {     0.00000000118,  2.08835676181,     2917.53735417280}, 
    {     0.00000000122,  3.91901660011,     4957.08687808040}, 
    {     0.00000000119,  4.05658830695,    10448.43547097540}, 
    {     0.00000000150,  5.89116199733,      966.97087743560}, 
    {     0.00000000136,  5.05814390558,     2281.21324285840}, 
    {     0.00000000123,  3.58787674774,     3318.76159737340}, 
    {     0.00000000127,  1.19117739028,     1461.05405194640}, 
    {     0.00000000153,  0.37313768413,     6533.14612897330}, 
    {     0.00000000141,  0.57680802743,    13532.02988993220}, 
    {     0.00000000145,  1.73326841662,     6637.50594109460}, 
    {     0.00000000139,  5.30202800327,    14128.24277124560}, 
    {     0.00000000133,  3.27057351136,    11876.46958573400}, 
    {     0.00000000138,  1.94291022720,     2921.68802779920}, 
    {     0.00000000115,  5.99542353480,    11986.67590695340}, 
    {     0.00000000119,  5.14629852269,    15636.56665630900}, 
    {     0.00000000152,  5.66773813508,     6530.17718355670}, 
    {     0.00000000134,  2.42024775707,     7167.19690618920}, 
    {     0.00000000123,  0.05231448695,     9801.42463766060}, 
    {     0.00000000117,  4.58820841700,    24491.42579258340}, 
    {     0.00000000126,  1.38941012006,      169.58018313300}, 
    {     0.00000000115,  3.75330944008,     3343.15522398060}, 
    {     0.00000000122,  1.21803689218,     3067.93946934820}, 
    {     0.00000000128,  1.42747405914,    16063.16484718500}, 
    {     0.00000000132,  4.73582902892,     2267.00340250900}, 
    {     0.00000000124,  0.77046518514,    12465.53441274220}, 
    {     0.00000000122,  3.66231014051,     8756.26980147300}, 
    {     0.00000000134,  0.81836719868,     3123.79021291280}, 
    {     0.00000000118,  0.15011057158,    18849.22754997420}, 
    {     0.00000000120,  4.11422319020,      604.84974070480}, 
    {     0.00000000125,  6.00462398457,     1442.26120876020}, 
    {     0.00000000109,  1.46394078440,     2854.64037391020}, 
    {     0.00000000108,  2.11691804266,       43.71891230500}, 
    {     0.00000000130,  1.43185911960,     3370.10424500320}, 
    {     0.00000000133,  2.31239626195,     9072.66167112960}, 
    {     0.00000000109,  1.33718905917,    10081.21114201300}, 
    {     0.00000000107,  1.71826183287,     1655.56030419820}, 
    {     0.00000000114,  3.89822123904,     2963.23881878400}, 
    {     0.00000000106,  1.99989592271,     3497.01314720220}, 
    {     0.00000000113,  2.53877396935,     5525.86369599260}, 
    {     0.00000000106,  5.79020088314,        1.48447270830}, 
    {     0.00000000130,  0.80396347034,     3397.51080163540}, 
    {     0.00000000130,  0.05444365195,     2185.25126929280}, 
    {     0.00000000106,  5.61886924411,     4878.85286267780}, 
    {     0.00000000104,  5.03145022037,     1751.52227776380}, 
    {     0.00000000146,  2.57659804831,     3308.64012088300}, 
    {     0.00000000103,  3.29589394730,     4379.63903749020}, 
    {     0.00000000104,  0.77903634693,     1751.55678506820}, 
    {     0.00000000118,  4.11883909157,    10927.29397676420}, 
    {     0.00000000104,  3.67398692909,    21393.54196985760}, 
    {     0.00000000106,  2.25698704670,    13207.02930736500}, 
    {     0.00000000126,  1.10289326964,     6680.79497027290}, 
    {     0.00000000106,  5.20738400843,       10.63666534980}, 
    {     0.00000000102,  3.81767069896,     6670.17915313570}, 
    {     0.00000000101,  5.96290213118,     5220.17080145320}, 
    {     0.00000000115,  0.57440366245,    13421.82356871280}, 
    {     0.00000000101,  1.87446179149,     9161.52735134660}, 
    {     0.00000000106,  6.20183341619,     3717.98603461560}, 
    {     0.00000000110,  5.45855327266,     7214.43893684320}, 
    {     0.00000000130,  0.47831160164,    13575.74880223720}, 
    {     0.00000000112,  6.25562428346,     3338.06962941900}, 
    {     0.00000000122,  0.14768895879,    16489.76303806100}, 
    {     0.00000000101,  0.55693458655,     3337.15661865360}, 
    {     0.00000000107,  3.90976860359,    11904.91877320180}, 
    {     0.00000000101,  1.70023673577,     3002.36972771680}, 
    {     0.00000000097,  1.94103649254,     5562.46906129680}, 
    {     0.00000000100,  2.35767934317,     3337.07205469860}, 
    {     0.00000000100,  3.76317527562,     3344.15279870100}, 
    {     0.00000000097,  5.19321707062,     5085.10572141780}, 
    {     0.00000000097,  1.69499718348,     3517.30615683360}, 
    {     0.00000000109,  4.25705461030,     8823.86715152580}, 
    {     0.00000000096,  3.51646478006,     1505.28780909299}, 
    {     0.00000000100,  4.38845221965,     3337.10656200300}, 
    {     0.00000000100,  1.73240240188,     3344.11829139661}, 
    {     0.00000000129,  4.96782688332,    15906.76412668260}, 
    {     0.00000000097,  0.55962169503,    30774.50164257480}, 
    {     0.00000000096,  3.16956558419,    12825.64519470380}, 
    {     0.00000000099,  1.12288651151,     4029.24690957760}, 
    {     0.00000000097,  4.42524428441,    21957.68072774700}, 
    {     0.00000000120,  6.18521207978,     9698.33186344200}, 
    {     0.00000000126,  3.40521738552,     6681.65473652630}, 
    {     0.00000000099,  5.29085847404,     5096.08411137890}, 
    {     0.00000000102,  2.46824311953,     1755.06264976500}, 
    {     0.00000000115,  6.10031030713,     3145.64104223920}, 
    {     0.00000000130,  2.24417329092,     1954.71715036360}, 
    {     0.00000000092,  0.97154538929,      927.83996850280}, 
    {     0.00000000097,  1.11670836674,     3341.79306935190}, 
    {     0.00000000110,  2.51719415565,     1045.15483618760}, 
    {     0.00000000107,  5.62562598823,     8425.71814811760}, 
    {     0.00000000099,  2.56868555050,    16858.41522263039}, 
    {     0.00000000095,  1.42994211615,    37455.72649597440}, 
    {     0.00000000104,  5.58969627803,    39048.32250960720}, 
    {     0.00000000103,  2.13529097914,    10050.28646756720}, 
    {     0.00000000094,  1.20811049650,     9495.66943335380}, 
    {     0.00000000118,  2.39940540526,    18208.34994259200}, 
    {     0.00000000097,  1.14141607148,    12089.76868117200}, 
    {     0.00000000100,  1.15512326078,     1385.89527633620}, 
    {     0.00000000090,  6.18770216893,    34554.81386366760}, 
    {     0.00000000090,  4.17568982529,        0.06731030280}, 
    {     0.00000000090,  3.79900428730,      685.04405422600}, 
    {     0.00000000090,  4.51840546059,    10037.08975128440}, 
    {     0.00000000098,  3.89390262306,     2373.64154926420}, 
    {     0.00000000095,  5.33609249023,     7636.46637799920}, 
    {     0.00000000088,  1.47691975375,     9488.62319665580}, 
    {     0.00000000098,  0.65689906709,     2810.98877190800}, 
    {     0.00000000092,  3.11888534564,     5298.33750655300}, 
    {     0.00000000088,  2.95228544051,     7218.02936549500}, 
    {     0.00000000096,  1.03219628412,     4591.44262300060}, 
    {     0.00000000123,  5.58913256956,     2735.76268599500}, 
    {     0.00000000095,  6.25308672334,     2942.53073359440}, 
    {     0.00000000087,  1.50371643513,     9983.70424446160}, 
    {     0.00000000092,  0.04735290682,    23546.75362303080}, 
    {     0.00000000090,  2.79573736864,    47477.56377607380}, 
    {     0.00000000094,  5.68827536044,     6106.88005506480}, 
    {     0.00000000087,  0.74049208991,    41990.78593289880}, 
    {     0.00000000101,  0.99308133444,     6614.73744448520}, 
    {     0.00000000115,  3.49732055752,        4.50343941720}, 
    {     0.00000000103,  1.06471408085,     2899.78714182220}, 
    {     0.00000000086,  0.18628425275,      216.82221378700}, 
    {     0.00000000086,  3.29796334238,     4061.75165790600}, 
    {     0.00000000099,  1.06539589813,     2810.85415130240}, 
    {     0.00000000114,  0.98391969927,    34115.11406927460}, 
    {     0.00000000088,  1.88203358965,    14867.73751589219}, 
    {     0.00000000094,  5.08829115370,     7792.86709850160}, 
    {     0.00000000084,  4.58521734382,     1699.27921650320}, 
    {     0.00000000089,  3.88606108572,    12199.97500239140}, 
    {     0.00000000105,  6.11980600515,     4819.47900076420}, 
    {     0.00000000097,  2.70091698598,     3339.43178404770}, 
    {     0.00000000113,  2.87005870648,      394.62588505920}, 
    {     0.00000000091,  3.46457148291,     4694.00295470760}, 
    {     0.00000000086,  1.91214909013,    55516.41870984820}, 
    {     0.00000000084,  4.30909434949,     4150.08989614680}, 
    {     0.00000000084,  3.05613772819,     9993.38809263160}, 
    {     0.00000000085,  4.49096869215,     6453.74872061060}, 
    {     0.00000000083,  5.66199608314,     1169.58825140860}, 
    {     0.00000000094,  0.76661204154,     4845.90023579280}, 
    {     0.00000000083,  2.57570774331,     4466.48176580340}, 
    {     0.00000000083,  5.82570496210,     6682.70932610790}, 
    {     0.00000000089,  4.76553691828,    35707.71008290740}, 
    {     0.00000000101,  1.51570299040,     7807.09419250320}, 
    {     0.00000000086,  0.66743846790,     2957.73314812880}, 
    {     0.00000000086,  3.60273523563,    13363.43002786740}, 
    {     0.00000000094,  0.57975808380,     3090.70796595760}, 
    {     0.00000000095,  3.35380642653,      661.23292678100}, 
    {     0.00000000092,  2.66589901893,    24341.52831745660}, 
    {     0.00000000088,  1.00573166083,     1059.39918384140}, 
    {     0.00000000083,  1.46681225258,    11527.12508919240}, 
    {     0.00000000081,  1.27062968985,     4893.07995667940}, 
    {     0.00000000080,  3.44636389322,      148.07872442630}, 
    {     0.00000000105,  3.47842036130,     3413.90955255880}, 
    {     0.00000000084,  4.33209852801,    51449.32426327820}, 
    {     0.00000000079,  4.42171441227,      151.04766984290}, 
    {     0.00000000082,  2.85230384631,    14164.81362924540}, 
    {     0.00000000106,  4.19479352477,     9090.47419324760}, 
    {     0.00000000078,  4.29426802519,      187.92514776260}, 
    {     0.00000000078,  5.38566529072,     2655.56837247380}, 
    {     0.00000000084,  2.15121245434,     3311.12060839640}, 
    {     0.00000000083,  4.28280129037,    74923.09699802278}, 
    {     0.00000000077,  1.45903147715,     2544.38173018620}, 
    {     0.00000000078,  3.92028514294,    16762.43599541260}, 
    {     0.00000000098,  3.78877505378,     3198.43379966360}, 
    {     0.00000000092,  2.80228448795,     3707.83675566220}, 
    {     0.00000000082,  2.45812896343,     9815.65173166220}, 
    {     0.00000000076,  3.92674885488,     2910.08208256070}, 
    {     0.00000000103,  2.90157610001,    12032.93761653920}, 
    {     0.00000000076,  3.20012751409,     7733.49323658800}, 
    {     0.00000000098,  3.28574616663,     3289.33208883739}, 
    {     0.00000000086,  0.44954589670,     2942.39611298880}, 
    {     0.00000000077,  2.05948930109,    12928.73796892240}, 
    {     0.00000000075,  0.85784191736,    28638.90558114660}, 
    {     0.00000000101,  0.72388999452,    48827.43118573260}, 
    {     0.00000000093,  0.96205455167,      151.89728108520}, 
    {     0.00000000083,  4.42677043697,     2060.81785407180}, 
    {     0.00000000085,  5.19438010130,     2146.14816282300}, 
    {     0.00000000078,  0.05738144523,    10507.80933288900}, 
    {     0.00000000096,  6.24132708355,       11.04570026390}, 
    {     0.00000000088,  2.27514694850,    13361.46938573100}, 
    {     0.00000000074,  5.19118661748,     1055.44977692610}, 
    {     0.00000000095,  1.32630130009,     9278.84721956680}, 
    {     0.00000000091,  5.56686260659,    27873.58901026800}, 
    {     0.00000000084,  0.41519041956,     4296.90158267040}, 
    {     0.00000000074,  5.09773610570,     9755.23023837760}, 
    {     0.00000000102,  0.99471814765,     8186.51266249260}, 
    {     0.00000000073,  4.78565969143,    10787.63034454580}, 
    {     0.00000000090,  1.23322132624,     9093.99731159660}, 
    {     0.00000000089,  1.52171318808,     5088.21980485270}, 
    {     0.00000000075,  3.17716258197,     4403.51747523800}, 
    {     0.00000000076,  2.66623960187,    12725.45343477500}, 
    {     0.00000000072,  2.57646391241,    10817.08765554480}, 
    {     0.00000000078,  0.17721609024,     3391.89276456221}, 
    {     0.00000000073,  1.65072523242,     5452.26274007740}, 
    {     0.00000000072,  2.24247662338,      272.67295735160}, 
    {     0.00000000084,  5.31880055844,     4716.38622654560}, 
    {     0.00000000081,  5.46340742050,     3856.07629779280}, 
    {     0.00000000091,  2.82213463878,      367.22432896240}, 
    {     0.00000000076,  5.54629636453,     4349.16189758320}, 
    {     0.00000000073,  4.61913155968,     3288.35211178700}, 
    {     0.00000000097,  0.68615321372,    10006.58480891440}, 
    {     0.00000000071,  0.29424294238,     1324.94134054000}, 
    {     0.00000000074,  1.74142938655,    78263.70942472259}, 
    {     0.00000000076,  0.00928867044,     6534.41316687600}, 
    {     0.00000000084,  2.33518173212,     3738.74417645580}, 
    {     0.00000000075,  3.61437779765,    12306.59089495900}, 
    {     0.00000000085,  0.94196641948,     2146.18267012740}, 
    {     0.00000000071,  2.07200856102,     9124.92198604240}, 
    {     0.00000000071,  4.48060598672,     9153.90361602180}, 
    {     0.00000000073,  0.28701671181,    10654.62101941260}, 
    {     0.00000000072,  0.84342376295,     3334.54651107000}, 
    {     0.00000000094,  5.72469267962,      206.70073729660}, 
    {     0.00000000091,  5.12701600437,     3392.87274161260}, 
    {     0.00000000076,  5.96038992872,     3482.79105373600}, 
    {     0.00000000071,  1.16745785331,     1574.84580128220}, 
    {     0.00000000071,  1.08624489534,     3866.78027344540}, 
    {     0.00000000071,  3.83802267632,    25298.29315444680}, 
    {     0.00000000075,  4.30016984862,    10177.19036923080}, 
    {     0.00000000081,  5.71063897801,    14687.39104733920}, 
    {     0.00000000070,  0.07475004834,    12839.87228870540}, 
    {     0.00000000080,  5.87829926376,     3495.96551583120}, 
    {     0.00000000069,  0.30282686836,    12012.58229714040}, 
    {     0.00000000071,  2.07966257785,     1063.31408345230}, 
    {     0.00000000071,  0.12080952310,    27433.88921587499}, 
    {     0.00000000072,  1.77506111582,     3564.95722240170}, 
    {     0.00000000069,  0.33478558217,        5.52292430740}, 
    {     0.00000000068,  1.56404561711,     2398.55036473080}, 
    {     0.00000000090,  2.61953849393,     3346.67834232960}, 
    {     0.00000000068,  1.06108185791,      191.38095580880}, 
    {     0.00000000093,  3.72700623766,     2472.67876262220}, 
    {     0.00000000077,  0.87794040199,     2917.94638908690}, 
    {     0.00000000067,  3.29797798194,     8006.16619393960}, 
    {     0.00000000082,  4.33799969295,     9360.60435331840}, 
    {     0.00000000068,  4.84097033274,    12942.96506292400}, 
    {     0.00000000083,  5.35554906977,     2125.81009707640}, 
    {     0.00000000083,  1.82578570378,     3511.28529731900}, 
    {     0.00000000068,  2.68247854175,    20213.25474333179}, 
    {     0.00000000086,  0.81171860574,      209.77597708900}, 
    {     0.00000000084,  4.36595418339,     3738.77868376020}, 
    {     0.00000000071,  2.76447756531,    15650.79375031060}, 
    {     0.00000000066,  3.31414998734,     8830.91338822380}, 
    {     0.00000000090,  0.71593793107,     3451.79906898740}, 
    {     0.00000000067,  4.04202356962,     3930.20969621960}, 
    {     0.00000000068,  4.35822797929,    12299.54465826100}, 
    {     0.00000000073,  3.66802441649,      194.97138446060}, 
    {     0.00000000077,  5.89874180574,     4307.58330413540}, 
    {     0.00000000089,  2.09613892664,     5312.56460055460}, 
    {     0.00000000068,  1.05513114246,     1987.22189869200}, 
    {     0.00000000082,  5.86597589657,     7747.72033058960}, 
    {     0.00000000071,  0.65820952553,      860.30992875280}, 
    {     0.00000000064,  0.98960038205,     3376.17516116840}, 
    {     0.00000000067,  5.22683619088,    24606.13555322000}, 
    {     0.00000000070,  0.96227192685,     8428.83223155250}, 
    {     0.00000000064,  5.15148312244,     8966.38750317330}, 
    {     0.00000000062,  6.18276166360,     3966.28261901220}, 
    {     0.00000000061,  1.47350010728,     1685.05212250160}, 
    {     0.00000000069,  4.32901678608,     8436.69653807870}, 
    {     0.00000000064,  2.11869877898,     3305.04969223120}, 
    {     0.00000000079,  5.29501968122,     8322.55806359620}, 
    {     0.00000000060,  1.17940250396,    97670.38771289718}, 
    {     0.00000000060,  5.15547946009,     4665.55376723980}, 
    {     0.00000000061,  4.04008021030,     2942.48067694380}, 
    {     0.00000000061,  0.44282820959,     4686.95671800959}, 
    {     0.00000000079,  2.10625649179,     7917.30051372260}, 
    {     0.00000000075,  4.81216780547,    27299.24421193320}, 
    {     0.00000000058,  1.69747168940,    12082.65513417120}, 
    {     0.00000000075,  1.85618011420,    52566.19261584059}, 
    {     0.00000000057,  5.11652903646,     1898.33396428740}, 
    {     0.00000000075,  5.15830659680,    45884.96776244100}, 
    {     0.00000000060,  2.68566185208,     6283.05859633920}, 
    {     0.00000000056,  3.77198339507,      299.12639426920}, 
    {     0.00000000072,  0.05525158510,     6286.59896834040}, 
    {     0.00000000075,  5.79419108898,     1059.36467653700}, 
    {     0.00000000056,  0.47178586543,     1727.66109366820}, 
    {     0.00000000061,  2.00931045169,     2942.44616963940}, 
    {     0.00000000060,  2.60462801513,    30376.35263916660}, 
    {     0.00000000057,  4.18603648623,     4531.53631857540}, 
    {     0.00000000059,  1.95998946118,     7593.79509706520}, 
    {     0.00000000059,  0.11151543852,     5960.08562219340}, 
    {     0.00000000068,  3.50707258885,     7064.10413197060}, 
    {     0.00000000056,  2.43554289279,    11567.19126307820}, 
    {     0.00000000060,  0.23404709116,     2619.47319549360}, 
    {     0.00000000066,  2.94716590333,     8446.99147881720}, 
    {     0.00000000059,  5.49704665474,     7322.10246078180}, 
    {     0.00000000064,  3.95992112220,     3050.12694723020}, 
    {     0.00000000055,  2.19506741266,        7.04623669800}, 
    {     0.00000000058,  0.32431074295,    19645.52555679060}, 
    {     0.00000000075,  4.12415692769,    21150.81336588360}, 
    {     0.00000000075,  3.99896297048,     5483.25472482600}, 
    {     0.00000000057,  0.21772333641,    17402.33328172660}, 
    {     0.00000000069,  3.20209555520,    16066.06586147480}, 
    {     0.00000000056,  2.00267092675,    17660.30346405700}, 
    {     0.00000000060,  4.71643347424,     6283.09310364360}, 
    {     0.00000000054,  0.38782719267,      360.11078196160}, 
    {     0.00000000073,  3.41087754271,    14556.89671702380}, 
    {     0.00000000068,  5.74655335863,      987.74627292800}, 
};


static const struct vsop mars_radius_r1[RADIUS_R1] = {
    {     0.01107433345,  2.03250524857,     3340.61242669980}, 
    {     0.00103175887,  2.37071847807,     6681.22485339960}, 
    {     0.00012877200,  0.00000000000,        0.00000000000}, 
    {     0.00010815880,  2.70888095665,    10021.83728009940}, 
    {     0.00001194550,  3.04702256206,    13362.44970679920}, 
    {     0.00000438582,  2.88835054603,     2281.23049651060}, 
    {     0.00000395700,  3.42323670971,     3344.13554504880}, 
    {     0.00000182576,  1.58427562964,     2544.31441988340}, 
    {     0.00000135851,  3.38507063082,    16703.06213349900}, 
    {     0.00000128199,  0.62991771813,     1059.38193018920}, 
    {     0.00000127059,  1.95391155885,      796.29800681640}, 
    {     0.00000118443,  2.99762091382,     2146.16541647520}, 
    {     0.00000128362,  6.04343227063,     3337.08930835080}, 
    {     0.00000087534,  3.42053385867,      398.14900340820}, 
    {     0.00000083021,  3.85575072018,     3738.76143010800}, 
    {     0.00000075604,  4.45097659377,     6151.53388830500}, 
    {     0.00000072002,  2.76443992447,      529.69096509460}, 
    {     0.00000066545,  2.54878381470,     1751.53953141600}, 
    {     0.00000054305,  0.67754203387,     8962.45534991020}, 
    {     0.00000051043,  3.72584855417,     6684.74797174860}, 
    {     0.00000066413,  4.40596377334,     1748.01641306700}, 
    {     0.00000047860,  2.28524521788,     2914.01423582380}, 
    {     0.00000049420,  5.72961379219,     3340.59517304760}, 
    {     0.00000049420,  1.47720011103,     3340.62968035200}, 
    {     0.00000057519,  0.54356133120,     1194.44701022460}, 
    {     0.00000048320,  2.58061402348,     3149.16416058820}, 
    {     0.00000036383,  6.02729341698,     3185.19202726560}, 
    {     0.00000037161,  5.81436290851,     1349.86740965880}, 
    {     0.00000036035,  5.89515829011,     3333.49887969900}, 
    {     0.00000031111,  0.97820401887,      191.44826611160}, 
    {     0.00000038957,  2.31902442004,     4136.91043351620}, 
    {     0.00000027256,  5.41369838171,     1592.59601363280}, 
    {     0.00000024302,  3.75838444077,      155.42039943420}, 
    {     0.00000022808,  1.74818178182,     5088.62883976680}, 
    {     0.00000022322,  0.93941901193,      951.71840625060}, 
    {     0.00000021712,  3.83569490817,     6283.07584999140}, 
    {     0.00000021302,  0.78030571909,     1589.07289528380}, 
    {     0.00000021631,  4.56903942095,     3532.06069281140}, 
    {     0.00000017957,  4.21923537063,     3870.30339179440}, 
    {     0.00000018241,  0.41334220202,     5486.77784317500}, 
    {     0.00000016250,  3.80772429678,     3340.54511639700}, 
    {     0.00000016803,  5.54855432911,     3097.88382272579}, 
    {     0.00000016852,  4.53696884484,     4292.33083295040}, 
    {     0.00000015749,  4.75766175289,     9492.14631500480}, 
    {     0.00000015747,  3.72356261757,    20043.67456019880}, 
    {     0.00000020429,  3.13541604634,     4690.47983635860}, 
    {     0.00000014699,  5.95340513928,     3894.18182954220}, 
    {     0.00000016251,  3.39910570757,     3340.67973700260}, 
    {     0.00000014256,  3.99914527335,     1990.74501704100}, 
    {     0.00000016529,  0.96740368703,     4399.99435688900}, 
    {     0.00000013011,  5.14215010082,     6677.70173505060}, 
    {     0.00000012482,  1.03238555854,     3341.59274776800}, 
    {     0.00000016454,  3.53827765951,     2700.71514038580}, 
    {     0.00000016167,  2.34891110870,      553.56940284240}, 
    {     0.00000013169,  0.41462220221,     5614.72937620960}, 
    {     0.00000011270,  1.02387117266,    12303.06777661000}, 
    {     0.00000012410,  6.23139144626,     5628.95647021120}, 
    {     0.00000012747,  0.69046237163,     3723.50895892300}, 
    {     0.00000011828,  6.25270937134,     2274.11694950980}, 
    {     0.00000010382,  1.23229650709,      426.59819087600}, 
    {     0.00000011207,  1.31732435116,     3496.03282613400}, 
    {     0.00000010345,  0.90062869301,     4535.05943692440}, 
    {     0.00000012214,  4.22347837212,     7079.37385680780}, 
    {     0.00000009764,  3.45310129694,      382.89653222320}, 
    {     0.00000008583,  1.16478890510,     2787.04302385740}, 
    {     0.00000007879,  5.73808303461,     2288.34404351140}, 
    {     0.00000009192,  1.81719352796,     6681.24210705180}, 
    {     0.00000007752,  4.15038634174,     6041.32756708560}, 
    {     0.00000009192,  6.06960723129,     6681.20759974740}, 
    {     0.00000009008,  2.58179552398,     2388.89402044920}, 
    {     0.00000006770,  0.24011880700,    11773.37681151540}, 
    {     0.00000007088,  3.51428380287,     8031.09226305840}, 
    {     0.00000009159,  3.90203365989,     3553.91152213780}, 
    {     0.00000007233,  3.70260535699,     2818.03500860600}, 
    {     0.00000006701,  4.25537421062,      242.72860397400}, 
    {     0.00000006534,  0.04317593308,     2957.71589447660}, 
    {     0.00000008783,  2.19764346848,     1221.84856632140}, 
    {     0.00000006540,  2.11811131682,     8429.24126646660}, 
    {     0.00000006835,  4.04527289029,    10025.36039844840}, 
    {     0.00000007279,  4.26969778292,     2803.80791460440}, 
    {     0.00000007679,  1.00816125095,     8432.76438481560}, 
    {     0.00000005736,  3.13988802339,      213.29909543800}, 
    {     0.00000005343,  3.78184164680,     5092.15195811580}, 
    {     0.00000005985,  2.96429619989,     6489.77658728800}, 
    {     0.00000005132,  3.98288020531,        7.11354700080}, 
    {     0.00000006264,  1.90345600186,     5621.84292321040}, 
    {     0.00000005238,  2.67050910776,     7477.52286021600}, 
    {     0.00000006264,  1.60046198142,     3347.72597370060}, 
    {     0.00000006527,  2.76220386403,     3339.63210563160}, 
    {     0.00000004594,  1.82031785094,     2810.92146160520}, 
    {     0.00000005460,  4.60869963415,     3583.34103067380}, 
    {     0.00000004730,  0.90611934427,     5099.26550511660}, 
    {     0.00000005484,  4.91405753832,     7632.94325965020}, 
    {     0.00000004002,  4.14100005210,     9623.68827669120}, 
    {     0.00000003836,  0.03411499404,     7234.79425624200}, 
    {     0.00000003618,  5.76553319747,     4933.20844033260}, 
    {     0.00000003747,  0.08776717073,     6525.80445396540}, 
    {     0.00000003016,  3.73804058695,     6681.29216370240}, 
    {     0.00000003975,  4.91286826343,     2942.46342329160}, 
    {     0.00000003911,  0.67457174687,     3127.31333126180}, 
    {     0.00000003923,  3.07698893109,        3.52311834900}, 
    {     0.00000003943,  0.53936955267,     5884.92684658320}, 
    {     0.00000002902,  4.66228680082,     7210.91581849420}, 
    {     0.00000002803,  1.00505054832,     7064.12138562280}, 
    {     0.00000003152,  4.54611126545,     2487.41604494780}, 
    {     0.00000002797,  0.05226680768,      639.89728631400}, 
    {     0.00000002758,  5.17057629399,     5828.02847164760}, 
    {     0.00000003020,  4.14658810846,     6681.15754309680}, 
    {     0.00000003000,  0.82762095066,     5085.03841111500}, 
    {     0.00000003022,  2.59437829291,     2906.90068882300}, 
    {     0.00000002673,  0.69433657973,     2699.73481931760}, 
    {     0.00000002593,  1.08691889359,     4929.68532198360}, 
    {     0.00000003127,  0.99947199034,     2118.76386037840}, 
    {     0.00000002597,  5.01157388627,    10018.31416175040}, 
    {     0.00000002606,  5.34395258978,    10973.55568635000}, 
    {     0.00000002779,  3.98360727591,     6467.92575796160}, 
    {     0.00000002457,  1.52659064342,     6836.64525283380}, 
    {     0.00000002381,  3.93615187831,    11371.70468975820}, 
    {     0.00000002584,  5.08907827632,    12832.75874170460}, 
    {     0.00000002204,  0.18721790349,     9595.23908922340}, 
    {     0.00000002127,  5.69525267283,     3191.04922956520}, 
    {     0.00000002065,  3.54230184958,     1066.49547719000}, 
    {     0.00000001862,  5.01664572032,     3475.67750673520}, 
    {     0.00000002077,  1.30210079493,     7740.60678358880}, 
    {     0.00000001834,  5.68364410455,     3319.83703120740}, 
    {     0.00000002026,  6.16037765302,     1744.42598441520}, 
    {     0.00000001705,  2.21753874961,     2921.12778282460}, 
    {     0.00000001836,  6.16475140098,     8425.65083781480}, 
    {     0.00000002060,  6.24256627641,     6674.11130639880}, 
    {     0.00000001735,  4.58252413180,    10419.98628350760}, 
    {     0.00000001853,  1.36791191191,    15643.68020330980}, 
    {     0.00000001683,  1.92963115929,     3767.21061757580}, 
    {     0.00000001955,  0.46151752408,    10575.40668294180}, 
    {     0.00000001800,  2.30912443204,     3355.86489788480}, 
    {     0.00000001761,  5.87259776407,     3320.25710730100}, 
    {     0.00000001440,  2.15100457092,    10021.85453375160}, 
    {     0.00000001845,  4.06143234617,    23384.28698689860}, 
    {     0.00000001419,  4.64964683208,     4562.46099302120}, 
    {     0.00000001410,  1.50439659549,     3325.35995551480}, 
    {     0.00000001435,  0.12022404881,    10021.82002644720}, 
    {     0.00000001446,  0.55888114207,    15113.98923821520}, 
    {     0.00000001334,  1.25480751834,     7875.67186362420}, 
    {     0.00000001442,  1.38958372017,     6682.20517446780}, 
    {     0.00000001601,  4.34240972038,     5331.35744374080}, 
    {     0.00000001377,  0.14567625356,     1758.65307841680}, 
    {     0.00000001283,  5.78388498920,    14584.29827312060}, 
    {     0.00000001281,  1.35158715330,    10404.73381232260}, 
    {     0.00000001255,  6.02547192213,     3264.34635542420}, 
    {     0.00000001471,  0.34647878204,     8969.56889691100}, 
    {     0.00000001237,  1.88316546445,    10177.25767953360}, 
    {     0.00000001554,  5.93165013851,     8439.87793181640}, 
    {     0.00000001185,  4.18096920842,     3360.96774609859}, 
    {     0.00000001192,  0.89923984424,    13916.01910964160}, 
    {     0.00000001331,  1.86674667785,      692.15760122680}, 
    {     0.00000001190,  4.29364281529,     6894.52394883760}, 
    {     0.00000001303,  1.44666271090,     6254.62666252360}, 
    {     0.00000001141,  0.15138021311,     3134.42687826260}, 
    {     0.00000001498,  1.54298726882,     3361.38782219220}, 
    {     0.00000001061,  0.67393132017,     3344.20285535160}, 
    {     0.00000001210,  0.85308958022,     3120.19978426100}, 
    {     0.00000001003,  1.28017736997,     4569.57454002200}, 
    {     0.00000001056,  0.13188094879,      522.57741809380}, 
    {     0.00000001011,  5.77318421567,    14314.16811304980}, 
    {     0.00000001172,  2.99768268266,     6247.51311552280}, 
    {     0.00000001071,  0.24747292047,     3337.02199804800}, 
    {     0.00000001088,  2.57510503125,     6261.74020952440}, 
    {     0.00000001033,  5.69839016800,      536.80451209540}, 
    {     0.00000000870,  1.50282095865,     6127.65545055720}, 
    {     0.00000000952,  2.92551885687,     5729.50644714900}, 
    {     0.00000001113,  2.84407720846,      640.87760738220}, 
    {     0.00000000861,  3.21490378166,     3914.95722503460}, 
    {     0.00000000873,  5.26929669197,    10213.28554621100}, 
    {     0.00000001068,  0.49291392496,    11243.68584642080}, 
    {     0.00000000802,  3.33123564567,     9830.38901398780}, 
    {     0.00000000800,  4.64163681160,     6144.42034130420}, 
    {     0.00000001047,  4.05904372261,     6158.64743530580}, 
    {     0.00000000739,  4.93374014310,     3230.40610548040}, 
    {     0.00000000736,  3.01566811571,    10818.13528691580}, 
    {     0.00000000716,  2.52258068421,     5202.35827933520}, 
    {     0.00000000708,  4.39529316737,     9808.53818466140}, 
    {     0.00000000789,  1.72502040817,     3178.14579056760}, 
    {     0.00000000721,  6.23937282110,     3369.06161416760}, 
    {     0.00000000711,  1.96395412586,     6688.33840040040}, 
    {     0.00000000720,  0.38908319399,     6298.32832117640}, 
    {     0.00000000879,  2.11099461733,     2301.58581590939}, 
    {     0.00000000911,  2.30898309496,    13517.87010623340}, 
    {     0.00000000920,  4.36440466625,    13365.97282514820}, 
    {     0.00000000660,  3.41324530637,     1648.44675719740}, 
    {     0.00000000822,  2.14217300701,     7903.07341972100}, 
    {     0.00000000655,  5.97028443361,      574.34479833480}, 
    {     0.00000000709,  2.24666710788,     9225.53927328300}, 
    {     0.00000000684,  4.02188175404,     1052.26838318840}, 
    {     0.00000000789,  3.58669777772,     2693.60159338500}, 
    {     0.00000000590,  0.67864102888,     8955.34180290940}, 
    {     0.00000000604,  2.73534347693,    16858.48253293320}, 
    {     0.00000000574,  4.11129193530,     6034.21402008480}, 
    {     0.00000000626,  4.45275856522,    12964.30070339100}, 
    {     0.00000000563,  3.72669761947,    13119.72110282519}, 
    {     0.00000000547,  3.03559794900,     2707.82868738660}, 
    {     0.00000000682,  3.62536638300,     6048.44111408640}, 
    {     0.00000000534,  4.65553794211,      135.06508003540}, 
    {     0.00000000537,  3.32526208431,     9779.10867612540}, 
    {     0.00000000621,  0.31692147043,     7910.18696672180}, 
    {     0.00000000508,  1.23782896960,     4555.34744602040}, 
    {     0.00000000636,  1.31861189187,     2648.45482547300}, 
    {     0.00000000674,  2.88169508451,     3316.73398895200}, 
    {     0.00000000566,  4.94059125257,     6923.95345737360}, 
    {     0.00000000492,  0.48544563054,    12935.85151592320}, 
    {     0.00000000494,  1.58242260326,      162.46663613220}, 
    {     0.00000000494,  4.05908212710,    10021.90459040220}, 
    {     0.00000000476,  4.50803141082,     2384.32327072920}, 
    {     0.00000000463,  1.30989375876,    17256.63153634140}, 
    {     0.00000000436,  5.18941467679,    13358.92658845020}, 
    {     0.00000000510,  5.29711079669,      853.19638175200}, 
    {     0.00000000457,  5.52250921497,     6438.49624942560}, 
    {     0.00000000444,  4.37462471228,    12168.00269657460}, 
    {     0.00000000426,  4.06251388975,      149.56319713460}, 
    {     0.00000000501,  6.12177016731,     8273.82086703240}, 
    {     0.00000000419,  3.51950671003,     9168.64089834740}, 
    {     0.00000000449,  0.15703403836,     7895.95987272020}, 
    {     0.00000000400,  0.93203728344,      433.71173787680}, 
    {     0.00000000390,  1.26783113077,     5459.37628707820}, 
    {     0.00000000458,  3.57016754913,     1596.18644228460}, 
    {     0.00000000494,  4.46695057001,    10021.76996979660}, 
    {     0.00000000514,  4.14599732838,    16460.33352952499}, 
    {     0.00000000512,  2.12376964366,     3335.08950239240}, 
    {     0.00000000369,  0.85046311178,     3364.49086444760}, 
    {     0.00000000447,  0.42171107066,     9866.41688066520}, 
    {     0.00000000383,  2.74377480867,     3344.49376205780}, 
    {     0.00000000359,  2.19508793723,     5518.75014899180}, 
    {     0.00000000388,  0.58874025278,     3980.50971301380}, 
    {     0.00000000374,  0.93936421015,     3863.18984479360}, 
    {     0.00000000463,  4.99368680534,    10551.52824519400}, 
    {     0.00000000363,  5.57806007125,    16062.18452611680}, 
    {     0.00000000367,  1.45560460881,     1039.02661079040}, 
    {     0.00000000366,  5.42971242456,    11236.57229942000}, 
    {     0.00000000323,  3.25474887566,     3116.26763099790}, 
    {     0.00000000395,  5.43639546793,    16173.37116840440}, 
    {     0.00000000316,  5.10881664095,    17395.21973472580}, 
    {     0.00000000315,  1.63649866499,    11081.21921028860}, 
    {     0.00000000328,  4.57813175450,    19800.94595622480}, 
    {     0.00000000313,  4.76509182263,     3304.58456002240}, 
    {     0.00000000318,  0.10125354955,     1692.16566950240}, 
    {     0.00000000380,  1.11418824718,     3503.07906283200}, 
    {     0.00000000359,  1.40924904562,     8270.29774868340}, 
    {     0.00000000325,  3.52159798740,     1903.43681250120}, 
    {     0.00000000304,  6.27804875103,     2391.43681773000}, 
    {     0.00000000303,  4.26667073131,    13936.79450513400}, 
    {     0.00000000314,  5.05418964097,    12721.57209941700}, 
    {     0.00000000313,  6.10446893161,    17924.91069982040}, 
    {     0.00000000299,  0.48751113813,     3347.65866339780}, 
    {     0.00000000327,  3.19964410433,     3981.49003408200}, 
    {     0.00000000333,  2.95583825569,     6680.24453233140}, 
    {     0.00000000290,  4.52908707678,     5724.93569742900}, 
    {     0.00000000278,  4.30130850558,     3607.21946842160}, 
    {     0.00000000375,  5.37102625037,     3376.64029337720}, 
    {     0.00000000270,  5.61134597717,     4032.77002792660}, 
    {     0.00000000268,  4.93749874461,    13760.59871020740}, 
    {     0.00000000288,  1.85605347821,     6702.00024889200}, 
    {     0.00000000285,  4.36928341258,     6040.34724601740}, 
    {     0.00000000361,  4.69076903889,     9380.95967271720}, 
    {     0.00000000266,  5.81522234941,     1214.73501932060}, 
    {     0.00000000302,  3.60805252615,     7255.56965173440}, 
    {     0.00000000249,  3.48983298099,     3237.51965248120}, 
    {     0.00000000329,  5.11789854678,    11250.79939342160}, 
    {     0.00000000335,  6.05389905145,     6660.44945790720}, 
    {     0.00000000243,  0.48285973973,    13362.43245314700}, 
    {     0.00000000246,  4.41923388458,     3546.79797513700}, 
    {     0.00000000239,  3.73063112648,       76.26607127560}, 
    {     0.00000000239,  6.27698012526,     1964.83862685400}, 
    {     0.00000000243,  2.51395431898,    13362.46696045140}, 
    {     0.00000000238,  4.61731653137,    17277.40693183380}, 
    {     0.00000000232,  3.12136758982,    20199.09495963300}, 
    {     0.00000000278,  3.88609085933,    10596.18207843420}, 
    {     0.00000000281,  6.14213490828,    19402.79695281660}, 
    {     0.00000000240,  3.88518850785,     4407.10790388980}, 
    {     0.00000000237,  3.07960027546,    12566.15169998280}, 
    {     0.00000000221,  2.20298576445,     7107.82304427560}, 
    {     0.00000000240,  4.41435097930,    26724.89941359840}, 
    {     0.00000000297,  3.78413749616,     2766.26762836500}, 
    {     0.00000000217,  1.37807210380,     3415.39402526710}, 
    {     0.00000000219,  1.12519699838,    19004.64794940840}, 
    {     0.00000000264,  5.35368881837,     6816.28993343500}, 
    {     0.00000000213,  4.60102337184,     3973.39616601300}, 
    {     0.00000000207,  0.02823735894,    11780.49035851620}, 
    {     0.00000000269,  5.04544647217,     9381.93999378540}, 
    {     0.00000000199,  0.56008805316,     6677.63442474780}, 
    {     0.00000000198,  5.08122652297,     5820.91492464680}, 
    {     0.00000000202,  0.66026194818,    15664.03552270859}, 
    {     0.00000000199,  2.66232840511,     6696.47732458460}, 
    {     0.00000000195,  1.32702139505,     8329.67161059700}, 
    {     0.00000000217,  4.71573630875,     8671.96987044060}, 
    {     0.00000000200,  6.08006112918,     8982.81066930900}, 
    {     0.00000000199,  0.64418678665,     3017.10701004240}, 
    {     0.00000000242,  0.76562027191,     3281.23856478620}, 
    {     0.00000000198,  3.90737735547,      266.60704172180}, 
    {     0.00000000255,  6.06895152008,    14054.60730802600}, 
    {     0.00000000198,  1.08773858955,     6684.81528205140}, 
    {     0.00000000184,  5.68692308350,     5642.19824260920}, 
    {     0.00000000211,  0.41936979363,     5732.04924442980}, 
    {     0.00000000179,  4.60064915956,    10235.13637553740}, 
    {     0.00000000198,  1.01742381306,     3336.73109134180}, 
    {     0.00000000207,  0.80705657101,     3877.41693879520}, 
    {     0.00000000183,  0.18403294603,    22743.40937951640}, 
    {     0.00000000213,  1.66556553404,    18984.29263000960}, 
    {     0.00000000201,  1.61667781335,    11216.28429032400}, 
    {     0.00000000234,  0.91473007796,    18454.60166491500}, 
    {     0.00000000182,  6.15499981293,     4885.96640967860}, 
    {     0.00000000212,  4.84465364468,     5618.31980486140}, 
    {     0.00000000165,  4.67153799461,     3253.30422216000}, 
    {     0.00000000187,  6.23120773270,     6660.86953400080}, 
    {     0.00000000185,  2.77104254836,      220.41264243880}, 
    {     0.00000000206,  3.58916234480,     3205.54734666440}, 
    {     0.00000000225,  1.77219878817,     5625.36604155940}, 
    {     0.00000000161,  6.26906099125,     1437.17561419860}, 
    {     0.00000000211,  1.50617882193,     4039.88357492740}, 
    {     0.00000000162,  3.95593670469,       20.35531939880}, 
    {     0.00000000163,  0.67965511211,    12310.18132361080}, 
    {     0.00000000177,  2.14779710666,     3346.13535100720}, 
    {     0.00000000156,  3.33869391672,     9070.11887384880}, 
    {     0.00000000157,  6.09909456790,      103.09277421860}, 
    {     0.00000000160,  3.55342782572,     7373.38245462640}, 
    {     0.00000000177,  1.65819873579,    10713.99488132620}, 
    {     0.00000000180,  3.51640761022,      533.21408344360}, 
    {     0.00000000157,  4.91581260270,    15508.61512327440}, 
    {     0.00000000191,  1.74466477182,    10022.81760116760}, 
    {     0.00000000154,  2.64640687885,     3333.56619000180}, 
    {     0.00000000162,  1.27235392680,     5415.65737477320}, 
    {     0.00000000173,  3.76300416846,     3561.02506913860}, 
    {     0.00000000143,  1.32201387342,     6460.81221096080}, 
    {     0.00000000144,  0.86610432289,     7380.49600162720}, 
    {     0.00000000150,  0.23528657910,     1228.96211332220}, 
    {     0.00000000149,  4.75865756164,    16706.58525184800}, 
    {     0.00000000142,  0.12641372157,      647.01083331480}, 
    {     0.00000000144,  1.75250316940,     3657.00429635640}, 
    {     0.00000000190,  2.97474143350,     2178.13772229200}, 
    {     0.00000000180,  1.62979022238,    22345.26037610820}, 
    {     0.00000000137,  0.86380989573,     3603.69635007260}, 
    {     0.00000000171,  5.55954917189,     3265.83082813250}, 
    {     0.00000000157,  0.21333168528,    11614.43329373220}, 
    {     0.00000000139,  4.12171291700,     3351.24909204960}, 
    {     0.00000000152,  4.88531923989,      110.20632121940}, 
    {     0.00000000140,  0.73627264345,     6784.31762761820}, 
    {     0.00000000164,  2.74481179645,     4672.66731424060}, 
    {     0.00000000137,  3.68919280446,    13171.00144068760}, 
    {     0.00000000129,  0.92616757170,      419.48464387520}, 
    {     0.00000000168,  3.42400489879,     1581.95934828300}, 
    {     0.00000000131,  4.47058088889,     9499.25986200560}, 
    {     0.00000000178,  0.23826290032,    12323.42309600880}, 
    {     0.00000000129,  2.67549491276,     6546.15977336420}, 
    {     0.00000000151,  3.49362947695,    14158.74771361560}, 
    {     0.00000000145,  1.88394518039,     9468.26787725700}, 
    {     0.00000000138,  1.92770959202,       15.25247118500}, 
    {     0.00000000156,  0.69181715595,     6475.03930496240}, 
    {     0.00000000125,  2.87440336541,    21947.11137270000}, 
    {     0.00000000120,  6.04082590555,     6606.44325483230}, 
    {     0.00000000119,  0.22502589672,    11766.26326451460}, 
    {     0.00000000138,  4.50665834944,     2480.30249794700}, 
    {     0.00000000122,  5.75861465034,    19513.98359510420}, 
    {     0.00000000118,  5.77539819462,    12722.55242048520}, 
    {     0.00000000153,  4.38474958775,    13362.51701710200}, 
    {     0.00000000147,  5.86793324184,     3169.93955608060}, 
    {     0.00000000123,  4.65915578752,    13149.15061136120}, 
    {     0.00000000118,  3.89507779037,     4936.79886898440}, 
    {     0.00000000115,  1.78200876468,     4379.63903749020}, 
    {     0.00000000126,  4.43971496486,     3568.08855948880}, 
    {     0.00000000125,  5.79244198156,    10721.10842832700}, 
    {     0.00000000114,  0.36704570747,     3384.33133900480}, 
    {     0.00000000112,  0.26706304724,     3077.52850332700}, 
    {     0.00000000115,  0.23672592064,      224.34479570190}, 
    {     0.00000000113,  2.49103811840,    18606.49894600020}, 
    {     0.00000000112,  3.50999860760,     1375.77379984580}, 
    {     0.00000000111,  2.05577813769,    25685.87280280800}, 
    {     0.00000000108,  0.41427720679,    10014.72373309860}, 
    {     0.00000000107,  5.88054875426,     4193.80880845180}, 
    {     0.00000000144,  2.37737192511,     4989.05918389720}, 
    {     0.00000000106,  5.26328794163,    10264.56588407340}, 
    {     0.00000000123,  1.15405187760,     2807.39834325620}, 
    {     0.00000000108,  0.69362164321,    13207.02930736500}, 
    {     0.00000000109,  4.81754388250,    13362.38239649640}, 
    {     0.00000000105,  1.20865142997,     8584.66166590080}, 
    {     0.00000000112,  3.04107822201,     1118.75579210280}, 
    {     0.00000000140,  3.07461233480,     3329.97576135000}, 
    {     0.00000000104,  5.07342540664,    23141.55838292460}, 
    {     0.00000000100,  4.08698733114,     3511.28529731900}, 
    {     0.00000000100,  2.21629137011,    10042.61267559180}, 
    {     0.00000000130,  3.04769575195,     3341.03250279340}, 
    {     0.00000000117,  2.96906061501,     9602.35263622420}, 
    {     0.00000000133,  0.92660324186,     5401.43028077160}, 
    {     0.00000000098,  4.54292546461,     3362.46325602620}, 
    {     0.00000000103,  1.15607014363,     1162.47470440780}, 
    {     0.00000000100,  5.45538240620,     3024.22055704320}, 
    {     0.00000000106,  0.04672320679,    10001.06188460700}, 
    {     0.00000000102,  5.43051265314,    13892.14067189380}, 
    {     0.00000000100,  1.80839732608,     6665.97238221460}, 
    {     0.00000000106,  5.15137987333,      956.28915597060}, 
    {     0.00000000120,  4.93427545375,     3443.70520091840}, 
    {     0.00000000096,  2.50517646103,      664.75604513000}, 
    {     0.00000000095,  1.54460105726,     8799.98871377800}, 
    {     0.00000000096,  2.32476267442,    10028.95082710020}, 
    {     0.00000000113,  1.74410378340,    11610.91017538320}, 
    {     0.00000000096,  1.63061364111,    11925.27409260060}, 
    {     0.00000000108,  4.35937497672,     6531.66165626500}, 
    {     0.00000000105,  4.33268432166,     3490.17562383440}, 
    {     0.00000000104,  1.94703327593,     8965.97846825920}, 
    {     0.00000000091,  2.01570699070,    22324.90505670940}, 
    {     0.00000000121,  0.83420201993,     9638.94074787620}, 
    {     0.00000000090,  4.32704593030,     2277.70737816160}, 
    {     0.00000000120,  3.68749411290,     3873.82651014340}, 
    {     0.00000000092,  0.67037378438,       23.87843774780}, 
    {     0.00000000094,  4.85202869277,    14047.49376102520}, 
    {     0.00000000098,  1.49843517093,     1062.90504853820}, 
    {     0.00000000111,  3.91313035726,     3311.18291816379}, 
    {     0.00000000090,  1.13909960610,    20809.46762464520}, 
    {     0.00000000122,  3.09764437623,     6685.10618875760}, 
    {     0.00000000089,  1.35955728945,       74.78159856730}, 
    {     0.00000000087,  0.40525161626,     2221.85663459700}, 
    {     0.00000000091,  1.65719601329,    24150.08005134500}, 
    {     0.00000000087,  4.95577178269,     7314.00859271280}, 
    {     0.00000000119,  2.52666872323,     3312.16323923200}, 
    {     0.00000000086,  4.91140297195,     1505.28780909299}, 
    {     0.00000000090,  5.47684323652,    16699.53901514999}, 
    {     0.00000000093,  1.61394240489,     3341.04230982650}, 
    {     0.00000000084,  1.19467014431,     3450.81874791920}, 
    {     0.00000000093,  5.65496964075,     6717.25272007700}, 
    {     0.00000000088,  2.07197299634,     8013.27974094040}, 
    {     0.00000000091,  3.19274526675,     6657.34641565180}, 
    {     0.00000000116,  5.59201102649,     2814.44457995420}, 
    {     0.00000000108,  1.61835726703,     3774.32416457660}, 
    {     0.00000000100,  3.20917035158,    25287.72379939980}, 
    {     0.00000000081,  3.97528452038,      170.67287061920}, 
    {     0.00000000096,  6.24177147506,     5511.63660199100}, 
    {     0.00000000082,  2.54795664637,     6675.70192909220}, 
    {     0.00000000109,  0.33310112429,     6709.67404086740}, 
    {     0.00000000078,  2.39251862859,    13553.89797291080}, 
    {     0.00000000087,  1.23871371074,     6705.10329114740}, 
    {     0.00000000089,  5.11656374881,     3451.79906898740}, 
    {     0.00000000084,  5.98544635153,     3760.09707057500}, 
    {     0.00000000097,  4.60643770505,     6701.58017279840}, 
    {     0.00000000090,  1.49936448326,     4271.97551355160}, 
    {     0.00000000097,  2.05363004056,     6518.75821726740}, 
    {     0.00000000091,  5.44752826195,     3427.92063123960}, 
    {     0.00000000091,  3.80708729431,     2125.87740737920}, 
    {     0.00000000105,  2.99053884594,     3326.38533269820}, 
    {     0.00000000093,  5.59480359619,     3340.18254357310}, 
    {     0.00000000100,  6.02550501045,     3313.21087060300}, 
    {     0.00000000076,  1.47971015405,     5408.54382777240}, 
    {     0.00000000075,  6.16095890090,     3370.04193523580}, 
    {     0.00000000078,  4.97425495725,     3229.42578441220}, 
    {     0.00000000079,  5.94388373870,     6155.05700665400}, 
    {     0.00000000073,  4.44787843599,    20206.14119633100}, 
    {     0.00000000074,  4.70229419011,    24889.57479599160}, 
    {     0.00000000078,  1.74679623517,     6756.00645196690}, 
    {     0.00000000073,  3.32559034423,     9588.12554222260}, 
    {     0.00000000074,  1.02108709897,    12295.95422960920}, 
    {     0.00000000076,  1.96280508181,    14421.83163698840}, 
    {     0.00000000073,  3.01125622032,      206.18554843720}, 
    {     0.00000000073,  0.91136148207,     2675.85638156980}, 
    {     0.00000000078,  1.71095661489,     3399.98628861340}, 
    {     0.00000000072,  3.22896783419,    52175.80628314840}, 
    {     0.00000000086,  4.69272071417,    14061.72085502680}, 
    {     0.00000000077,  5.64501410813,     3209.07046501340}, 
    {     0.00000000080,  5.70275817485,    10156.90236013480}, 
    {     0.00000000075,  3.83222347813,    39048.32250960720}, 
    {     0.00000000071,  0.76956199701,     7366.26890762560}, 
    {     0.00000000084,  0.79243785412,    16276.46394262300}, 
    {     0.00000000098,  2.04888453127,    15265.88651930040}, 
    {     0.00000000084,  4.65013165954,     6947.83189512140}, 
    {     0.00000000073,  4.30089715672,    21548.96236929180}, 
    {     0.00000000086,  1.50050122351,     5989.06725217280}, 
    {     0.00000000070,  2.69225539304,     3296.89351439480}, 
    {     0.00000000094,  0.74409756620,     5244.04923920100}, 
    {     0.00000000074,  2.27409026869,     4845.90023579280}, 
    {     0.00000000071,  3.75623870844,    28628.33622609960}, 
    {     0.00000000067,  3.31991953846,     6414.61781167780}, 
    {     0.00000000067,  1.32197410604,    23546.75362303080}, 
    {     0.00000000065,  2.68548224676,     4186.69526145100}, 
    {     0.00000000064,  3.98415414793,     3368.01398279660}, 
    {     0.00000000065,  4.15810281695,     3340.19235060619}, 
    {     0.00000000073,  2.84956464399,     8542.97070603500}, 
    {     0.00000000064,  1.07959823787,     6944.30877677240}, 
    {     0.00000000064,  1.20206773863,       38.13303563780}, 
    {     0.00000000079,  1.01784404862,     7321.12213971360}, 
    {     0.00000000070,  3.81533325092,     6578.13207918100}, 
    {     0.00000000063,  0.67886798875,     6688.27109009760}, 
    {     0.00000000086,  2.24834434956,     3232.94890276120}, 
    {     0.00000000074,  3.63312603513,    15906.76412668260}, 
    {     0.00000000061,  5.69343218974,     4459.36821880260}, 
    {     0.00000000068,  5.10830400193,     9485.03276800400}, 
    {     0.00000000061,  1.95896237186,    12199.97500239140}, 
    {     0.00000000076,  0.43724958811,     5032.77809620220}, 
    {     0.00000000062,  3.22645996942,     2540.79130153440}, 
    {     0.00000000061,  4.22937427795,     1854.63230563460}, 
    {     0.00000000070,  1.02515278218,     6621.85099148600}, 
    {     0.00000000060,  1.09184289831,    10124.93005431800}, 
    {     0.00000000060,  4.72802697102,    16865.52876963120}, 
    {     0.00000000059,  2.92995535821,     9886.77220006400}, 
    {     0.00000000058,  4.87086894257,    48300.16010269000}, 
    {     0.00000000058,  0.43992500862,     6418.14093002680}, 
    {     0.00000000058,  5.73619727103,     2008.55753915900}, 
    {     0.00000000072,  4.52406363260,    16304.91313009080}, 
    {     0.00000000067,  0.75347219892,    16703.04487984680}, 
    {     0.00000000070,  4.09500525151,     3416.87849797540}, 
    {     0.00000000080,  1.80777950075,      931.36308685180}, 
    {     0.00000000060,  4.92798256747,     3391.89276456221}, 
    {     0.00000000058,  2.45928697672,     4005.36847182980}, 
    {     0.00000000075,  4.81816499658,     3289.33208883739}, 
    {     0.00000000058,  1.73479637157,     2409.24933984800}, 
    {     0.00000000062,  5.24555453429,    17101.21113690720}, 
    {     0.00000000055,  3.59862329711,     7322.10246078180}, 
    {     0.00000000060,  0.91598691483,    10018.24685144760}, 
    {     0.00000000054,  5.54310937490,     2604.73591316800}, 
    {     0.00000000057,  0.39808125859,    18451.07854656599}, 
    {     0.00000000059,  2.02922256380,    45486.81875903279}, 
    {     0.00000000068,  2.78497806929,    16703.07938715119}, 
    {     0.00000000054,  1.76917054114,     3510.19260983280}, 
    {     0.00000000063,  2.80264902488,    16894.51039961060}, 
    {     0.00000000074,  1.36214292325,    10025.42770875120}, 
    {     0.00000000063,  2.41547192168,       59.37386191360}, 
    {     0.00000000054,  1.06826755543,     8948.22825590860}, 
    {     0.00000000051,  1.64684042106,     3472.15438838620}, 
    {     0.00000000052,  3.43538989813,    14867.73751589219}, 
    {     0.00000000062,  0.86680408610,    17468.85519794540}, 
    {     0.00000000051,  2.12159286185,     2412.77245819700}, 
    {     0.00000000056,  6.11996315499,    17085.95866572220}, 
    {     0.00000000053,  2.94662143572,    11527.12508919240}, 
    {     0.00000000050,  3.17196717347,     2111.65031337760}, 
    {     0.00000000055,  5.72607545560,    10706.88133432540}, 
    {     0.00000000062,  0.57333106196,     3171.03224356680}, 
    {     0.00000000053,  1.29021847041,     6652.77566593180}, 
    {     0.00000000052,  4.17299292219,     6106.88005506480}, 
    {     0.00000000065,  3.82721710324,    18208.34994259200}, 
    {     0.00000000065,  5.11165617529,     3113.13629391080}, 
    {     0.00000000048,  3.04479041123,     4140.43355186520}, 
    {     0.00000000048,  5.15462485717,    12012.58229714040}, 
    {     0.00000000049,  2.53202412418,    10448.43547097540}, 
    {     0.00000000055,  0.78890011077,    11769.85369316640}, 
    {     0.00000000047,  3.65081479882,     9872.27408296480}, 
    {     0.00000000047,  2.74355062408,    14577.18472611980}, 
    {     0.00000000051,  4.86147404192,     1485.98012106520}, 
    {     0.00000000059,  2.96261275062,    14071.43950907579}, 
    {     0.00000000060,  1.59668057901,     4025.65648092580}, 
    {     0.00000000045,  1.38985168616,     1272.68102562720}, 
    {     0.00000000046,  4.84193245992,    32124.36905223359}, 
    {     0.00000000048,  4.20779723621,    43340.65334255760}, 
    {     0.00000000047,  1.43502382920,     2938.94030494260}, 
    {     0.00000000058,  4.41305155897,     1478.86657406440}, 
    {     0.00000000045,  5.07966377852,     3318.76159737340}, 
    {     0.00000000058,  5.58121433180,     6643.09181776180}, 
    {     0.00000000047,  1.08172284939,     3448.27595063840}, 
    {     0.00000000048,  5.02446939402,     6645.19698672220}, 
    {     0.00000000044,  4.02177323039,     9389.05354078620}, 
    {     0.00000000042,  0.75715065967,     6357.71943674220}, 
    {     0.00000000042,  0.28202781151,    10001.48196070061}, 
    {     0.00000000042,  5.05676915852,     3397.51080163540}, 
    {     0.00000000043,  4.94357970653,    18052.92954315780}, 
    {     0.00000000050,  4.04580413243,     5835.14201864840}, 
    {     0.00000000046,  0.42891568037,    14128.24277124560}, 
    {     0.00000000043,  4.15051754642,     8535.85715903420}, 
    {     0.00000000053,  6.08293348275,     3377.21779200400}, 
    {     0.00000000041,  1.24482327948,     3212.59358336240}, 
    {     0.00000000041,  5.60183242162,      685.04405422600}, 
    {     0.00000000055,  2.49939849707,     8186.51266249260}, 
    {     0.00000000041,  5.04767355904,     6571.01853218020}, 
    {     0.00000000042,  3.00593850304,    10037.08975128440}, 
    {     0.00000000042,  2.08907550710,    13363.43002786740}, 
    {     0.00000000041,  0.56957277734,    20995.39296644940}, 
    {     0.00000000045,  1.33351374757,      632.78373931320}, 
    {     0.00000000046,  0.81640935106,    45884.96776244100}, 
    {     0.00000000040,  5.83979846235,      846.08283475120}, 
    {     0.00000000041,  0.05913112284,    21150.81336588360}, 
    {     0.00000000044,  2.89985709529,     6872.67311951120}, 
    {     0.00000000046,  4.79599204822,     1835.32461760680}, 
    {     0.00000000045,  1.98433687681,     1861.74585263540}, 
    {     0.00000000040,  4.76232751326,     4392.88080988820}, 
    {     0.00000000044,  4.30367510983,    21000.91589075680}, 
    {     0.00000000040,  6.09284885194,     7483.58877584580}, 
    {     0.00000000040,  2.33956668789,    12729.66596748600}, 
    {     0.00000000046,  2.86512929328,    38650.17350619900}, 
    {     0.00000000038,  3.65846461938,    29698.28751133580}, 
    {     0.00000000038,  2.26400097984,    38407.44490222499}, 
    {     0.00000000038,  4.62487442464,    13532.02988993220}, 
    {     0.00000000045,  0.05726736439,     8226.57883637840}, 
    {     0.00000000043,  5.28854105201,     3274.12501778540}, 
    {     0.00000000037,  4.75280838392,    30065.51184029820}, 
    {     0.00000000047,  6.25707790441,    24606.13555322000}, 
    {     0.00000000037,  5.02115296017,    11128.97608578420}, 
    {     0.00000000039,  1.71554278762,     7696.88787128380}, 
    {     0.00000000037,  4.34652985120,     3283.71405176420}, 
    {     0.00000000037,  3.91795548862,     9945.57120882380}, 
    {     0.00000000038,  1.54872687701,     6740.59871531320}, 
    {     0.00000000036,  6.11671952560,     9947.05568153210}, 
    {     0.00000000036,  4.61440005357,     6901.63749583840}, 
    {     0.00000000038,  0.44080908793,    24491.42579258340}, 
    {     0.00000000036,  1.73681874925,     3468.63127003720}, 
    {     0.00000000041,  5.69294900570,    26087.90314157420}, 
    {     0.00000000046,  4.24370266362,     3074.00538497800}, 
    {     0.00000000038,  0.72727556007,    26084.02180621620}, 
    {     0.00000000035,  0.09307361585,     8742.04270747140}, 
    {     0.00000000035,  1.35173564664,     7218.02936549500}, 
    {     0.00000000038,  5.04852696556,    16066.06586147480}, 
    {     0.00000000039,  4.09330106885,    28783.75662553379}, 
    {     0.00000000035,  2.18607267347,     8859.36257569160}, 
    {     0.00000000034,  3.37294996504,    48429.28218232440}, 
    {     0.00000000037,  3.20773047278,    41748.05732892480}, 
    {     0.00000000036,  1.14449536410,    15650.79375031060}, 
    {     0.00000000043,  2.47145616667,    10020.85695903120}, 
    {     0.00000000040,  6.03176945066,    17810.20093918380}, 
    {     0.00000000034,  0.51621135764,     1107.13880568480}, 
    {     0.00000000038,  5.52686444444,     3742.28454845700}, 
    {     0.00000000035,  4.07971812965,     8646.06348025360}, 
    {     0.00000000037,  0.76802632064,    35464.98147893340}, 
    {     0.00000000034,  0.48466144733,    38805.59390563319}, 
    {     0.00000000044,  4.85886492681,     6604.95878212400}, 
    {     0.00000000033,  0.15905665569,    10787.63034454580}, 
    {     0.00000000033,  6.26077209051,     4106.40549114620}, 
    {     0.00000000032,  4.72374245003,     8827.39026987480}, 
    {     0.00000000034,  1.67384584037,    40398.18991926600}, 
    {     0.00000000038,  3.42695313525,    37703.97802425580}, 
    {     0.00000000037,  5.01873798104,    13575.74880223720}, 
    {     0.00000000043,  4.79904796675,     5195.24473233440}, 
    {     0.00000000038,  2.54832320063,    10184.30391623160}, 
    {     0.00000000032,  0.26465341730,     3029.77162783140}, 
    {     0.00000000032,  6.21574097484,    15110.46611986620}, 
    {     0.00000000031,  3.63433062848,    45088.66975562460}, 
    {     0.00000000042,  0.55440675602,    32920.66705904999}, 
    {     0.00000000035,  3.96268115235,     3185.25933756840}, 
    {     0.00000000033,  5.88039450059,    19403.77727388480}, 
    {     0.00000000041,  4.27695289187,     7747.72033058960}, 
    {     0.00000000033,  5.41476981924,    20735.83216142559}, 
    {     0.00000000041,  4.13964021510,    12516.36687204800}, 
    {     0.00000000036,  6.22368196486,     4356.27544458400}, 
    {     0.00000000031,  1.81900571208,    24093.27678917520}, 
    {     0.00000000041,  2.61892942249,    24076.44458812540}, 
    {     0.00000000030,  1.25750331570,    34363.36559755600}, 
    {     0.00000000035,  4.30790850908,     4447.75123238460}, 
    {     0.00000000034,  2.15402582261,    12502.13977804640}, 
    {     0.00000000030,  1.74402934752,    10177.19036923080}, 
    {     0.00000000034,  4.98491983613,    20199.02764933019}, 
    {     0.00000000029,  0.38968519354,    35707.71008290740}, 
    {     0.00000000035,  1.98847450868,    14556.89671702380}, 
    {     0.00000000032,  0.36447448811,     5466.42252377620}, 
    {     0.00000000029,  2.84335822989,     3651.45322556820}, 
    {     0.00000000029,  1.70561861073,    42146.20633233299}, 
    {     0.00000000029,  6.27427740112,    31022.75317085620}, 
    {     0.00000000029,  4.85775467825,       36.02786667740}, 
    {     0.00000000029,  0.65663514164,     3344.11829139661}, 
    {     0.00000000039,  2.60584004585,     6679.74038069130}, 
    {     0.00000000031,  4.96068967529,    15423.26756087100}, 
    {     0.00000000032,  4.30747041560,    30376.35263916660}, 
    {     0.00000000031,  4.97488131714,    48031.13317891620}, 
    {     0.00000000036,  5.21102353378,      860.30992875280}, 
    {     0.00000000029,  2.68740712720,     3344.15279870100}, 
    {     0.00000000029,  4.89226176414,    14469.58851248400}, 
    {     0.00000000035,  0.63682098833,    23553.86717003160}, 
    {     0.00000000028,  3.93317215375,     2655.56837247380}, 
    {     0.00000000028,  4.95417710116,      792.77488846740}, 
    {     0.00000000031,  1.20412048035,    16328.72425753579}, 
    {     0.00000000033,  2.23175098152,    44768.09940987860}, 
    {     0.00000000033,  5.53387746412,    38086.87455647900}, 
    {     0.00000000028,  5.39448318150,     1250.83019630080}, 
    {     0.00000000034,  0.46215642912,     2751.54759969160}, 
    {     0.00000000031,  6.25053987025,    17388.10618772499}, 
    {     0.00000000028,  1.84806130514,     2075.04494807340}, 
    {     0.00000000029,  4.75344799610,    28230.18722269139}, 
    {     0.00000000028,  4.36162258057,    39203.74290904139}, 
    {     0.00000000032,  5.19762814944,     1214.80232962340}, 
    {     0.00000000027,  1.83675735374,    45494.58142974879}, 
    {     0.00000000028,  4.99070749177,     6593.91664885980}, 
    {     0.00000000027,  3.31433250805,    12942.96506292400}, 
    {     0.00000000029,  4.94569969969,       87.30820453981}, 
    {     0.00000000027,  1.32843166459,     7203.80227149340}, 
};


static const struct vsop mars_radius_r2[RADIUS_R2] = {
    {     0.00044242249,  0.47930604954,     3340.61242669980}, 
    {     0.00008138042,  0.86998389204,     6681.22485339960}, 
    {     0.00001274915,  1.22593985222,    10021.83728009940}, 
    {     0.00000187388,  1.57298976045,    13362.44970679920}, 
    {     0.00000040745,  1.97082077028,     3344.13554504880}, 
    {     0.00000052395,  3.14159265359,        0.00000000000}, 
    {     0.00000026617,  1.91665337822,    16703.06213349900}, 
    {     0.00000017828,  4.43491476419,     2281.23049651060}, 
    {     0.00000011713,  4.52509926559,     3185.19202726560}, 
    {     0.00000010210,  5.39147322060,     1059.38193018920}, 
    {     0.00000009950,  0.41865678448,      796.29800681640}, 
    {     0.00000009236,  4.53559625376,     2146.16541647520}, 
    {     0.00000007299,  3.14214513120,     2544.31441988340}, 
    {     0.00000007214,  2.29302335628,     6684.74797174860}, 
    {     0.00000006810,  5.26707245601,      155.42039943420}, 
    {     0.00000006526,  2.30772456100,     3738.76143010800}, 
    {     0.00000007783,  5.93373461009,     1748.01641306700}, 
    {     0.00000005840,  1.05191820290,     1349.86740965880}, 
    {     0.00000006750,  5.30191763402,     1194.44701022460}, 
    {     0.00000004695,  0.76881032874,     3097.88382272579}, 
    {     0.00000005390,  1.00200068360,     3149.16416058820}, 
    {     0.00000004406,  2.45557331437,      951.71840625060}, 
    {     0.00000004286,  3.89642578846,     1592.59601363280}, 
    {     0.00000003516,  1.84991934524,      398.14900340820}, 
    {     0.00000003699,  2.26016989021,    20043.67456019880}, 
    {     0.00000003378,  3.81703201748,     1751.53953141600}, 
    {     0.00000004585,  0.80785643853,     4136.91043351620}, 
    {     0.00000003201,  2.11661594157,     5614.72937620960}, 
    {     0.00000003620,  1.32428600053,     3333.49887969900}, 
    {     0.00000002915,  1.19342490174,      529.69096509460}, 
    {     0.00000002979,  2.86468474914,     6151.53388830500}, 
    {     0.00000003057,  4.55288594507,     5628.95647021120}, 
    {     0.00000002906,  1.20300479533,     3894.18182954220}, 
    {     0.00000003848,  3.86071515455,      553.56940284240}, 
    {     0.00000002819,  2.48714583532,     1990.74501704100}, 
    {     0.00000002657,  6.07409846258,     4292.33083295040}, 
    {     0.00000002698,  2.92100135189,     3496.03282613400}, 
    {     0.00000002396,  5.94193484091,     2787.04302385740}, 
    {     0.00000002263,  2.56188049651,      191.44826611160}, 
    {     0.00000002169,  5.36834559071,     8962.45534991020}, 
    {     0.00000002149,  2.74919289456,      242.72860397400}, 
    {     0.00000002218,  1.85260509629,     3337.08930835080}, 
    {     0.00000001998,  5.76396921426,     3341.59274776800}, 
    {     0.00000001999,  3.82347205028,     2914.01423582380}, 
    {     0.00000001835,  5.68648448195,     1589.07289528380}, 
    {     0.00000001810,  3.32122811143,     5088.62883976680}, 
    {     0.00000001968,  4.17404480033,     3340.59517304760}, 
    {     0.00000002411,  4.68376177281,     4690.47983635860}, 
    {     0.00000001967,  6.20570363430,     3340.62968035200}, 
    {     0.00000001626,  5.67648778513,     4535.05943692440}, 
    {     0.00000002161,  1.07446445419,     2388.89402044920}, 
    {     0.00000001965,  3.10811453974,     3583.34103067380}, 
    {     0.00000001985,  5.75867975763,     4399.99435688900}, 
    {     0.00000001504,  4.95929390466,      382.89653222320}, 
    {     0.00000001276,  4.82147500391,     2957.71589447660}, 
    {     0.00000001475,  2.22614544794,     3723.50895892300}, 
    {     0.00000001196,  3.26743061042,     9492.14631500480}, 
    {     0.00000001349,  4.87558985925,     6525.80445396540}, 
    {     0.00000001436,  2.69754023270,     7079.37385680780}, 
    {     0.00000001223,  2.61880227353,    10025.36039844840}, 
    {     0.00000001402,  5.19177439326,     2700.71514038580}, 
    {     0.00000001202,  0.93436294282,     2810.92146160520}, 
    {     0.00000000870,  5.81258009514,    12303.06777661000}, 
    {     0.00000000867,  2.20048756217,     2699.73481931760}, 
    {     0.00000000831,  2.01782919511,     5092.15195811580}, 
    {     0.00000000856,  5.96129932558,      426.59819087600}, 
    {     0.00000000847,  2.26415579047,     6283.07584999140}, 
    {     0.00000000917,  1.40259081260,     6489.77658728800}, 
    {     0.00000000833,  1.17376008822,     7477.52286021600}, 
    {     0.00000001041,  6.27097603149,     3347.72597370060}, 
    {     0.00000000965,  3.40293030184,     5621.84292321040}, 
    {     0.00000000723,  4.26276570887,     4933.20844033260}, 
    {     0.00000000770,  2.06490049164,     5486.77784317500}, 
    {     0.00000000706,  2.34080074294,        7.11354700080}, 
    {     0.00000000954,  2.11093711712,     3870.30339179440}, 
    {     0.00000000844,  2.23791576390,     3553.91152213780}, 
    {     0.00000000647,  2.24565892529,     3340.54511639700}, 
    {     0.00000000653,  3.98464883505,     6677.70173505060}, 
    {     0.00000000717,  0.29523050971,     6681.24210705180}, 
    {     0.00000000828,  0.22887694811,     3532.06069281140}, 
    {     0.00000000612,  1.56040446304,     7234.79425624200}, 
    {     0.00000000717,  4.54583138124,     6681.20759974740}, 
    {     0.00000000585,  3.29614213819,     1221.84856632140}, 
    {     0.00000000646,  1.83615168340,     3340.67973700260}, 
    {     0.00000000560,  5.05995427063,     8031.09226305840}, 
    {     0.00000000651,  0.16211451692,     7632.94325965020}, 
    {     0.00000000488,  3.07833516040,     6836.64525283380}, 
    {     0.00000000534,  4.25727954634,     3339.63210563160}, 
    {     0.00000000507,  2.59915154873,    23384.28698689860}, 
    {     0.00000000376,  6.27013206389,     2487.41604494780}, 
    {     0.00000000342,  4.71066540976,      639.89728631400}, 
    {     0.00000000449,  1.34119375784,      640.87760738220}, 
    {     0.00000000332,  2.66137676648,     9623.68827669120}, 
    {     0.00000000341,  5.96083550282,     4929.68532198360}, 
    {     0.00000000347,  6.09473597335,     7740.60678358880}, 
    {     0.00000000324,  6.05446352414,     2118.76386037840}, 
    {     0.00000000406,  4.95790035333,     8969.56889691100}, 
    {     0.00000000310,  0.02051325960,     6127.65545055720}, 
    {     0.00000000402,  2.84641476266,     5331.35744374080}, 
    {     0.00000000319,  1.44556053767,     5729.50644714900}, 
    {     0.00000000298,  5.73923165875,     6041.32756708560}, 
    {     0.00000000294,  3.06922916435,    10419.98628350760}, 
    {     0.00000000282,  6.04219786503,     7875.67186362420}, 
    {     0.00000000276,  5.11697230915,    11773.37681151540}, 
    {     0.00000000261,  2.89861311314,     7210.91581849420}, 
    {     0.00000000257,  1.08764384198,     2288.34404351140}, 
    {     0.00000000273,  3.83429606896,     8429.24126646660}, 
    {     0.00000000288,  6.13587869160,     6682.20517446780}, 
    {     0.00000000302,  3.61511244935,    12832.75874170460}, 
    {     0.00000000235,  2.21419308330,     6681.29216370240}, 
    {     0.00000000317,  3.60614958531,     2301.58581590939}, 
    {     0.00000000288,  5.08466449059,     2274.11694950980}, 
    {     0.00000000254,  0.36594869690,     3767.21061757580}, 
    {     0.00000000235,  2.62463894760,     6681.15754309680}, 
    {     0.00000000223,  3.46012483249,     6923.95345737360}, 
    {     0.00000000207,  3.44496733465,    10177.25767953360}, 
    {     0.00000000215,  0.57778871417,    10973.55568635000}, 
    {     0.00000000203,  3.89606611321,    10018.31416175040}, 
    {     0.00000000191,  2.41041363946,     8955.34180290940}, 
    {     0.00000000191,  1.58000924939,    10818.13528691580}, 
    {     0.00000000194,  2.45866911623,     7064.12138562280}, 
    {     0.00000000183,  1.67726083027,      213.29909543800}, 
    {     0.00000000191,  0.58807580019,     5828.02847164760}, 
    {     0.00000000238,  1.99795553508,    10575.40668294180}, 
    {     0.00000000246,  2.17522479887,     4562.46099302120}, 
    {     0.00000000177,  0.66443060538,    10021.85453375160}, 
    {     0.00000000176,  4.91646923030,    10021.82002644720}, 
    {     0.00000000217,  2.93960990684,    13365.97282514820}, 
    {     0.00000000213,  0.15664432335,     2942.46342329160}, 
    {     0.00000000166,  4.75384735897,     3914.95722503460}, 
    {     0.00000000155,  1.78567177351,     9830.38901398780}, 
    {     0.00000000164,  5.17682847411,     6298.32832117640}, 
    {     0.00000000176,  5.21146444811,     9866.41688066520}, 
    {     0.00000000157,  2.69801327811,     6894.52394883760}, 
    {     0.00000000148,  6.26338410775,     1039.02661079040}, 
    {     0.00000000148,  0.36640929573,     6688.33840040040}, 
    {     0.00000000150,  1.22257750814,      574.34479833480}, 
    {     0.00000000138,  2.09458777391,     1066.49547719000}, 
    {     0.00000000165,  6.15932460183,    15643.68020330980}, 
    {     0.00000000161,  4.66659171956,     8273.82086703240}, 
    {     0.00000000126,  0.68196579031,     6438.49624942560}, 
    {     0.00000000127,  1.69257165301,     3981.49003408200}, 
    {     0.00000000118,  2.78189840631,     3360.96774609859}, 
    {     0.00000000130,  0.84499223832,     3355.86489788480}, 
    {     0.00000000120,  0.30079432657,     3127.31333126180}, 
    {     0.00000000123,  1.63529824790,     6674.11130639880}, 
    {     0.00000000129,  2.26711428102,     6467.92575796160}, 
    {     0.00000000104,  0.07355376701,     3325.35995551480}, 
    {     0.00000000130,  4.41777190830,     3320.25710730100}, 
    {     0.00000000095,  1.32397695499,     7903.07341972100}, 
    {     0.00000000113,  0.65843018903,     3178.14579056760}, 
    {     0.00000000092,  4.98212090453,     9779.10867612540}, 
    {     0.00000000100,  4.11210877353,      536.80451209540}, 
    {     0.00000000096,  3.52474152096,     3475.67750673520}, 
    {     0.00000000106,  5.41425307049,    15113.98923821520}, 
    {     0.00000000100,  2.91165340473,      692.15760122680}, 
    {     0.00000000107,  3.76142120324,    13517.87010623340}, 
    {     0.00000000094,  3.21490077835,     8671.96987044060}, 
    {     0.00000000086,  5.24456061569,    13119.72110282519}, 
    {     0.00000000089,  5.73824161119,    11371.70468975820}, 
    {     0.00000000106,  5.90729095013,     8432.76438481560}, 
    {     0.00000000098,  3.61325552038,      853.19638175200}, 
    {     0.00000000080,  2.97911637785,    26724.89941359840}, 
    {     0.00000000078,  0.95802015551,     3191.04922956520}, 
    {     0.00000000080,  5.90881737672,     6040.34724601740}, 
    {     0.00000000087,  2.51076876054,     1052.26838318840}, 
    {     0.00000000091,  3.00950021946,    12964.30070339100}, 
    {     0.00000000075,  1.32761316297,    17924.91069982040}, 
    {     0.00000000073,  5.00315639405,     1903.43681250120}, 
    {     0.00000000073,  4.09954161905,     3319.83703120740}, 
    {     0.00000000074,  2.58079983162,    10021.90459040220}, 
    {     0.00000000070,  5.37592930185,    12310.18132361080}, 
    {     0.00000000072,  2.54228814803,     5884.92684658320}, 
    {     0.00000000069,  3.48131994134,    13760.59871020740}, 
    {     0.00000000068,  3.24176355205,    16706.58525184800}, 
    {     0.00000000067,  4.69007678444,      522.57741809380}, 
    {     0.00000000070,  1.00588846894,    13362.46696045140}, 
    {     0.00000000070,  2.38386517904,    13916.01910964160}, 
    {     0.00000000069,  5.27194307948,     3980.50971301380}, 
    {     0.00000000074,  3.94650982500,    16173.37116840440}, 
    {     0.00000000077,  0.12291238953,    11216.28429032400}, 
    {     0.00000000062,  0.15391383953,    11081.21921028860}, 
    {     0.00000000065,  3.97651716363,    13358.92658845020}, 
    {     0.00000000074,  2.99585183104,    10021.76996979660}, 
    {     0.00000000080,  6.17370752997,     9380.95967271720}, 
    {     0.00000000061,  2.56972324319,      149.56319713460}, 
    {     0.00000000059,  3.80951935336,    10264.56588407340}, 
    {     0.00000000060,  4.79893452692,     1437.17561419860}, 
    {     0.00000000064,  0.24188540623,    18984.29263000960}, 
    {     0.00000000059,  6.09929610915,     5459.37628707820}, 
    {     0.00000000060,  2.26503107747,    28628.33622609960}, 
    {     0.00000000067,  2.07568987702,     1596.18644228460}, 
    {     0.00000000058,  5.26082962947,    13362.43245314700}, 
    {     0.00000000056,  1.88732579172,     9070.11887384880}, 
    {     0.00000000058,  0.87844749732,     5642.19824260920}, 
    {     0.00000000056,  1.18238857561,     6696.47732458460}, 
    {     0.00000000062,  3.98214740104,     3427.92063123960}, 
    {     0.00000000055,  5.72462334370,      433.71173787680}, 
    {     0.00000000056,  2.35545469122,    33716.96506586640}, 
    {     0.00000000055,  3.77399580108,    10213.28554621100}, 
    {     0.00000000055,  1.33171417253,     8982.81066930900}, 
    {     0.00000000056,  5.49808236951,    24093.27678917520}, 
    {     0.00000000053,  5.34430579198,     5099.26550511660}, 
    {     0.00000000063,  3.53402427573,     3205.54734666440}, 
    {     0.00000000066,  6.22551943489,     8270.29774868340}, 
    {     0.00000000055,  4.74960633412,     6660.86953400080}, 
    {     0.00000000054,  0.30483383119,    12721.57209941700}, 
    {     0.00000000067,  0.58592813080,     3335.08950239240}, 
    {     0.00000000054,  2.12825168465,    13171.00144068760}, 
    {     0.00000000055,  5.03409432626,     7255.56965173440}, 
    {     0.00000000051,  2.91157155859,    10404.73381232260}, 
    {     0.00000000068,  2.44228862715,     6158.64743530580}, 
    {     0.00000000049,  0.23351885884,     4379.63903749020}, 
    {     0.00000000068,  2.26299130022,     2766.26762836500}, 
    {     0.00000000050,  6.10119450350,     3253.30422216000}, 
    {     0.00000000048,  2.36328912422,     4032.77002792660}, 
    {     0.00000000060,  0.30397974651,     9225.53927328300}, 
    {     0.00000000049,  5.45150193687,    13207.02930736500}, 
    {     0.00000000048,  0.72695221239,    10028.95082710020}, 
    {     0.00000000061,  3.40242612458,    10551.52824519400}, 
    {     0.00000000049,  3.40240207389,     3304.58456002240}, 
    {     0.00000000047,  2.83602015531,     9808.53818466140}, 
    {     0.00000000047,  0.50228092595,    17395.21973472580}, 
    {     0.00000000047,  3.03745055781,     6144.42034130420}, 
    {     0.00000000051,  1.27412586850,     3344.49376205780}, 
    {     0.00000000050,  1.83471955356,    30376.35263916660}, 
    {     0.00000000046,  0.75336415193,    16062.18452611680}, 
    {     0.00000000048,  0.33255135928,     6702.00024889200}, 
    {     0.00000000056,  0.21744516383,    10022.81760116760}, 
    {     0.00000000046,  5.83138098160,     3364.49086444760}, 
    {     0.00000000044,  0.79889168525,     7107.82304427560}, 
    {     0.00000000051,  0.35982632787,     9468.26787725700}, 
    {     0.00000000044,  3.10598653755,    10235.13637553740}, 
    {     0.00000000049,  0.14978113272,     2648.45482547300}, 
    {     0.00000000058,  4.51787450922,     6660.44945790720}, 
    {     0.00000000042,  5.40417232308,     3344.20285535160}, 
    {     0.00000000048,  2.42299327989,     4407.10790388980}, 
    {     0.00000000057,  3.84354136220,     6816.28993343500}, 
    {     0.00000000047,  1.49030680647,     6247.51311552280}, 
    {     0.00000000043,  5.14318704546,     7373.38245462640}, 
    {     0.00000000053,  5.94275298258,     8439.87793181640}, 
    {     0.00000000042,  0.14486089509,     1505.28780909299}, 
    {     0.00000000049,  5.57153056447,    17468.85519794540}, 
    {     0.00000000055,  6.26098836404,     3361.38782219220}, 
    {     0.00000000046,  3.07675286071,    12722.55242048520}, 
    {     0.00000000042,  4.74455545491,     3369.06161416760}, 
    {     0.00000000043,  4.97295184315,     3337.02199804800}, 
    {     0.00000000055,  3.80215638520,     3376.64029337720}, 
    {     0.00000000049,  4.43316054873,     9595.23908922340}, 
    {     0.00000000047,  1.97344701193,     1581.95934828300}, 
    {     0.00000000043,  0.38914582059,     6665.97238221460}, 
    {     0.00000000040,  1.06953099245,    23695.12778576700}, 
    {     0.00000000039,  1.54137978685,     2818.03500860600}, 
    {     0.00000000039,  3.79055778605,    33318.81606245820}, 
    {     0.00000000037,  5.27208151144,    20752.66436247540}, 
    {     0.00000000041,  1.82257882538,    14158.74771361560}, 
    {     0.00000000039,  3.15412760412,    14469.58851248400}, 
    {     0.00000000041,  0.55705920174,     3346.13535100720}, 
    {     0.00000000040,  5.57723811162,     3863.18984479360}, 
    {     0.00000000038,  2.71525209390,     8584.66166590080}, 
    {     0.00000000049,  5.44994428603,     9638.94074787620}, 
    {     0.00000000036,  4.85483701684,    23141.55838292460}, 
    {     0.00000000038,  2.11687208088,    15664.03552270859}, 
    {     0.00000000035,  5.30700692772,     6677.63442474780}, 
    {     0.00000000047,  2.56845181850,      162.46663613220}, 
    {     0.00000000034,  0.52542487310,    10713.99488132620}, 
    {     0.00000000047,  1.37540278055,     3316.73398895200}, 
    {     0.00000000045,  3.09384709364,     6701.58017279840}, 
    {     0.00000000036,  5.41035019142,    20597.24396304120}, 
    {     0.00000000035,  0.84359386197,     6518.75821726740}, 
    {     0.00000000038,  2.22559377525,     3503.07906283200}, 
    {     0.00000000043,  1.70231864194,    12323.42309600880}, 
    {     0.00000000046,  4.97118367286,     9381.93999378540}, 
    {     0.00000000043,  0.95148893985,    34115.11406927460}, 
    {     0.00000000035,  5.73672778427,     6684.81528205140}, 
    {     0.00000000043,  2.34641544095,     5244.04923920100}, 
    {     0.00000000040,  5.92298266112,     3336.73109134180}, 
    {     0.00000000032,  2.93166446867,     9499.25986200560}, 
    {     0.00000000032,  5.16999042304,     5085.03841111500}, 
    {     0.00000000033,  4.25349328071,    36659.42848915800}, 
    {     0.00000000043,  1.50296327105,    27035.74021246680}, 
    {     0.00000000040,  5.84317493907,    16460.33352952499}, 
    {     0.00000000032,  4.13881058425,    31570.79964939120}, 
    {     0.00000000035,  5.50392428699,     8425.65083781480}, 
    {     0.00000000034,  1.60980125001,    12566.15169998280}, 
    {     0.00000000034,  3.68494085870,     8827.39026987480}, 
    {     0.00000000031,  3.75179356135,     4845.90023579280}, 
    {     0.00000000030,  4.87421522701,     1692.16566950240}, 
    {     0.00000000037,  1.12999386856,    18052.92954315780}, 
    {     0.00000000031,  2.73132541218,    12295.95422960920}, 
    {     0.00000000030,  0.60227284998,    20354.51535906720}, 
    {     0.00000000030,  3.56474503430,    16304.91313009080}, 
    {     0.00000000030,  0.00488152861,    11243.68584642080}, 
    {     0.00000000039,  3.34380105325,    29978.20363575840}, 
    {     0.00000000028,  3.12073820291,    11925.27409260060}, 
    {     0.00000000027,  2.53950067771,    19004.64794940840}, 
    {     0.00000000028,  2.80254457895,     3607.21946842160}, 
    {     0.00000000032,  4.04412731190,     6680.24453233140}, 
    {     0.00000000028,  5.05697601811,    17412.05193577560}, 
    {     0.00000000029,  5.85207825749,    31172.65064598300}, 
    {     0.00000000033,  5.16379108102,    10596.18207843420}, 
    {     0.00000000027,  1.49309168626,     8186.51266249260}, 
    {     0.00000000027,  2.25111298175,       76.26607127560}, 
    {     0.00000000029,  1.82581479324,     3333.56619000180}, 
    {     0.00000000026,  5.61633953268,    14054.60730802600}, 
    {     0.00000000025,  4.87224086763,     3077.52850332700}, 
    {     0.00000000025,  4.33552142677,    17085.95866572220}, 
    {     0.00000000027,  0.80699664558,    20735.83216142559}, 
    {     0.00000000025,  5.15192817935,    11766.26326451460}, 
    {     0.00000000024,  4.12825907026,     4193.80880845180}, 
    {     0.00000000024,  4.31275606947,    14584.29827312060}, 
    {     0.00000000024,  2.19374141743,        3.52311834900}, 
    {     0.00000000024,  4.96463811748,    26087.90314157420}, 
    {     0.00000000027,  4.99613391588,     3877.41693879520}, 
    {     0.00000000029,  2.40082338888,     3312.16323923200}, 
    {     0.00000000024,  3.11953483056,    13149.15061136120}, 
    {     0.00000000030,  5.66813524124,     3281.23856478620}, 
    {     0.00000000026,  6.15978676797,      419.48464387520}, 
    {     0.00000000022,  2.11310905377,    20995.39296644940}, 
    {     0.00000000022,  5.24071820165,    12935.85151592320}, 
    {     0.00000000021,  1.72081702579,     2803.80791460440}, 
    {     0.00000000021,  4.18626331979,      187.92514776260}, 
    {     0.00000000022,  2.34227094593,     7322.10246078180}, 
    {     0.00000000021,  2.91971393449,    12168.00269657460}, 
    {     0.00000000023,  0.93103820963,     6261.74020952440}, 
    {     0.00000000022,  6.06510562418,    15110.46611986620}, 
    {     0.00000000020,  5.98993383835,    24150.08005134500}, 
    {     0.00000000022,  2.68877932276,     3546.79797513700}, 
    {     0.00000000023,  0.86323712599,    30774.50164257480}, 
    {     0.00000000020,  0.72774754977,    13553.89797291080}, 
    {     0.00000000022,  3.09244912137,    13362.38239649640}, 
    {     0.00000000020,  0.33937394936,     5989.06725217280}, 
    {     0.00000000025,  4.69237538534,     3347.65866339780}, 
    {     0.00000000025,  3.51209525616,    15265.88651930040}, 
    {     0.00000000026,  3.36529647088,    21265.52312652020}, 
    {     0.00000000021,  3.15458479593,    26637.59120905859}, 
    {     0.00000000019,  5.02104925490,     3029.77162783140}, 
    {     0.00000000019,  6.15294842048,    18208.34994259200}, 
    {     0.00000000023,  2.63078161726,    24491.42579258340}, 
    {     0.00000000025,  2.94366934698,    13362.51701710200}, 
    {     0.00000000020,  0.86927302126,     3399.98628861340}, 
    {     0.00000000018,  4.37088769243,     3651.45322556820}, 
    {     0.00000000022,  4.79007467235,    11614.43329373220}, 
    {     0.00000000019,  5.80539564686,    21795.21409161479}, 
    {     0.00000000017,  2.62698055094,     6872.67311951120}, 
    {     0.00000000020,  4.13854946023,    16699.53901514999}, 
    {     0.00000000018,  2.69537794731,    27682.14074415640}, 
    {     0.00000000017,  2.35800085725,     7788.36365908440}, 
    {     0.00000000016,  5.12979256980,     1744.42598441520}, 
    {     0.00000000019,  4.36117042303,    11780.49035851620}, 
    {     0.00000000017,  3.98180845854,    18606.49894600020}, 
    {     0.00000000020,  5.29535152048,    13936.79450513400}, 
    {     0.00000000018,  0.90866227881,    27433.88921587499}, 
    {     0.00000000018,  1.15898054343,      220.41264243880}, 
    {     0.00000000021,  1.07415905494,    11769.85369316640}, 
    {     0.00000000018,  3.61054156740,     9485.03276800400}, 
    {     0.00000000020,  5.54806425258,    14128.24277124560}, 
    {     0.00000000015,  4.19346479448,    23937.85638974100}, 
    {     0.00000000019,  2.49025671313,    24341.52831745660}, 
    {     0.00000000015,  6.22588872744,     8799.98871377800}, 
    {     0.00000000014,  2.27829337274,     4447.75123238460}, 
    {     0.00000000015,  1.86263855445,     2921.12778282460}, 
    {     0.00000000014,  3.59449757262,     3074.00538497800}, 
    {     0.00000000016,  4.04109191506,     3134.42687826260}, 
    {     0.00000000018,  1.50064662425,    19406.67828817460}, 
    {     0.00000000014,  4.63902518517,    11527.12508919240}, 
    {     0.00000000019,  5.20657856071,    32920.66705904999}, 
    {     0.00000000018,  5.05191310629,     3603.69635007260}, 
};


static const struct vsop mars_radius_r3[RADIUS_R3] = {
    {     0.00001113108,  5.14987305093,     3340.61242669980}, 
    {     0.00000424447,  5.61343952053,     6681.22485339960}, 
    {     0.00000100044,  5.99727457548,    10021.83728009940}, 
    {     0.00000019606,  0.07631453783,    13362.44970679920}, 
    {     0.00000003478,  0.42912010211,    16703.06213349900}, 
    {     0.00000004693,  3.14159265359,        0.00000000000}, 
    {     0.00000002870,  0.44692002393,     3344.13554504880}, 
    {     0.00000002428,  3.02114808809,     3185.19202726560}, 
    {     0.00000000687,  0.80560442666,     6684.74797174860}, 
    {     0.00000000578,  0.77849309402,    20043.67456019880}, 
    {     0.00000000540,  3.86818792995,     1059.38193018920}, 
    {     0.00000000468,  4.52509679627,     3496.03282613400}, 
    {     0.00000000487,  1.60861075208,     3583.34103067380}, 
    {     0.00000000362,  4.42325508671,     2787.04302385740}, 
    {     0.00000000397,  5.72008479880,     3149.16416058820}, 
    {     0.00000000299,  0.75708428385,     3738.76143010800}, 
    {     0.00000000352,  5.55622002342,     4136.91043351620}, 
    {     0.00000000316,  3.37609906858,     6525.80445396540}, 
    {     0.00000000234,  2.13923292630,     3097.88382272579}, 
    {     0.00000000214,  4.20457486315,     3341.59274776800}, 
    {     0.00000000214,  0.56472270648,      155.42039943420}, 
    {     0.00000000201,  2.35183535764,     1592.59601363280}, 
    {     0.00000000206,  0.96951658721,     1990.74501704100}, 
    {     0.00000000231,  5.82604761072,     2388.89402044920}, 
    {     0.00000000163,  4.15852184076,     4535.05943692440}, 
    {     0.00000000148,  3.28924896754,     2957.71589447660}, 
    {     0.00000000155,  5.12396546072,      796.29800681640}, 
    {     0.00000000154,  1.13809634337,    10025.36039844840}, 
    {     0.00000000158,  3.76267616455,     1194.44701022460}, 
    {     0.00000000134,  5.57743966517,     3894.18182954220}, 
    {     0.00000000145,  3.02382693331,     3337.08930835080}, 
    {     0.00000000147,  4.25259909424,     4399.99435688900}, 
    {     0.00000000100,  4.26399779787,     1589.07289528380}, 
    {     0.00000000091,  6.12313839857,     6489.77658728800}, 
    {     0.00000000100,  1.12570940535,    23384.28698689860}, 
    {     0.00000000100,  1.17079212321,     7079.37385680780}, 
    {     0.00000000076,  6.00434755125,      529.69096509460}, 
    {     0.00000000076,  5.93213294948,     7477.52286021600}, 
    {     0.00000000069,  1.70323063297,     9492.14631500480}, 
    {     0.00000000069,  3.69074496365,     8962.45534991020}, 
    {     0.00000000068,  0.15861692654,     3870.30339179440}, 
    {     0.00000000061,  4.14189658327,     4292.33083295040}, 
    {     0.00000000063,  1.94108069224,     6923.95345737360}, 
    {     0.00000000060,  4.28936601254,    12303.06777661000}, 
    {     0.00000000065,  1.11375145336,     6151.53388830500}, 
    {     0.00000000075,  4.71644556135,     3347.72597370060}, 
    {     0.00000000056,  2.74147961496,     4933.20844033260}, 
    {     0.00000000053,  4.77467577413,     6127.65545055720}, 
    {     0.00000000050,  2.57807944338,     3340.59517304760}, 
    {     0.00000000049,  3.72534850744,     9866.41688066520}, 
    {     0.00000000050,  4.60885064189,     3340.62968035200}, 
    {     0.00000000042,  6.14743017903,     7234.79425624200}, 
    {     0.00000000042,  3.43563949713,     5486.77784317500}, 
    {     0.00000000044,  4.47908248027,      426.59819087600}, 
    {     0.00000000040,  0.79167327114,        7.11354700080}, 
    {     0.00000000045,  6.24183361898,     2274.11694950980}, 
    {     0.00000000038,  1.09272124839,     9623.68827669120}, 
    {     0.00000000042,  4.60964038446,     6682.20517446780}, 
    {     0.00000000038,  6.18558685622,     5729.50644714900}, 
    {     0.00000000038,  4.61315601536,     7740.60678358880}, 
    {     0.00000000036,  3.14996505800,      639.89728631400}, 
    {     0.00000000040,  1.47221984696,    13365.97282514820}, 
    {     0.00000000034,  2.44888174358,     2288.34404351140}, 
    {     0.00000000033,  4.07561553526,     3532.06069281140}, 
    {     0.00000000033,  4.00337366796,      191.44826611160}, 
    {     0.00000000034,  2.61360044785,     4690.47983635860}, 
    {     0.00000000042,  2.12093492483,    12832.75874170460}, 
    {     0.00000000032,  4.50887364887,     7875.67186362420}, 
    {     0.00000000032,  1.57458654370,    10419.98628350760}, 
    {     0.00000000042,  4.64340929626,    15643.68020330980}, 
    {     0.00000000034,  5.06656541832,     6681.24210705180}, 
    {     0.00000000036,  0.28987292152,     3723.50895892300}, 
    {     0.00000000033,  4.52563219188,     4929.68532198360}, 
    {     0.00000000034,  2.74382990905,     6677.70173505060}, 
    {     0.00000000029,  4.82292532787,     6836.64525283380}, 
    {     0.00000000031,  1.25306031255,      242.72860397400}, 
    {     0.00000000040,  1.33261257095,     5331.35744374080}, 
    {     0.00000000034,  3.03578748114,     6681.20759974740}, 
    {     0.00000000028,  5.44161669691,    10021.85453375160}, 
    {     0.00000000028,  3.41041355991,    10021.82002644720}, 
    {     0.00000000029,  1.44701292203,    26724.89941359840}, 
    {     0.00000000027,  0.23446626513,     9830.38901398780}, 
    {     0.00000000031,  3.55930404825,     8969.56889691100}, 
    {     0.00000000027,  0.62554177429,     6681.29216370240}, 
    {     0.00000000028,  0.66108605606,     6283.07584999140}, 
    {     0.00000000026,  2.93963456706,     2544.31441988340}, 
    {     0.00000000028,  3.02947324104,     2281.23049651060}, 
    {     0.00000000026,  0.06758130889,    10818.13528691580}, 
    {     0.00000000033,  5.38463358374,      553.56940284240}, 
    {     0.00000000026,  1.18522107539,     8955.34180290940}, 
    {     0.00000000030,  5.72396134501,     3339.63210563160}, 
    {     0.00000000032,  2.01050754787,     5884.92684658320}, 
    {     0.00000000027,  3.74433763737,     6298.32832117640}, 
    {     0.00000000026,  1.03437538808,     6681.15754309680}, 
    {     0.00000000024,  0.07873299732,      382.89653222320}, 
    {     0.00000000027,  0.62459992026,     3553.91152213780}, 
    {     0.00000000024,  3.46652790647,     8031.09226305840}, 
    {     0.00000000027,  4.97242136909,     3767.21061757580}, 
    {     0.00000000021,  0.34500515713,      398.14900340820}, 
    {     0.00000000022,  0.16000431895,     6674.11130639880}, 
    {     0.00000000025,  4.80981908946,     7632.94325965020}, 
    {     0.00000000020,  1.03308861369,     7210.91581849420}, 
    {     0.00000000019,  1.00795666182,     7064.12138562280}, 
    {     0.00000000020,  5.08085454093,     6688.33840040040}, 
    {     0.00000000024,  4.53131373076,     1748.01641306700}, 
    {     0.00000000021,  1.00067762870,     6894.52394883760}, 
    {     0.00000000021,  2.68399619671,    10018.31416175040}, 
    {     0.00000000018,  0.24311256346,     3981.49003408200}, 
    {     0.00000000023,  3.25718834734,     5621.84292321040}, 
    {     0.00000000018,  5.22850479583,     3333.49887969900}, 
    {     0.00000000017,  0.65399461894,     3340.54511639700}, 
    {     0.00000000016,  2.23166601637,    10264.56588407340}, 
    {     0.00000000016,  3.99319122882,      951.71840625060}, 
    {     0.00000000017,  0.24322966235,     3340.67973700260}, 
    {     0.00000000015,  0.68756621158,     2699.73481931760}, 
    {     0.00000000015,  0.79676193982,     6438.49624942560}, 
    {     0.00000000019,  3.09984967041,     8273.82086703240}, 
    {     0.00000000018,  5.49826928276,     2146.16541647520}, 
    {     0.00000000014,  4.64772091449,     2118.76386037840}, 
    {     0.00000000015,  2.35470306373,     5092.15195811580}, 
    {     0.00000000014,  4.97209858575,    11081.21921028860}, 
    {     0.00000000017,  0.37871098191,    10575.40668294180}, 
    {     0.00000000014,  0.53224061765,     1066.49547719000}, 
    {     0.00000000014,  1.08680225227,     6040.34724601740}, 
    {     0.00000000015,  4.55907710983,     8270.29774868340}, 
    {     0.00000000016,  5.13375747116,     9468.26787725700}, 
    {     0.00000000013,  0.53705768941,     5088.62883976680}, 
    {     0.00000000013,  0.11088343011,      213.29909543800}, 
    {     0.00000000013,  1.73016080294,     8671.96987044060}, 
    {     0.00000000012,  3.99880295457,    13207.02930736500}, 
    {     0.00000000012,  4.09699657905,     6041.32756708560}, 
    {     0.00000000013,  5.63225993860,     3178.14579056760}, 
    {     0.00000000011,  3.61924209254,    11773.37681151540}, 
    {     0.00000000013,  4.97777304006,    10022.81760116760}, 
    {     0.00000000011,  2.29245339567,     2914.01423582380}, 
    {     0.00000000011,  0.17994697060,     9070.11887384880}, 
    {     0.00000000012,  5.15200495439,    10973.55568635000}, 
    {     0.00000000014,  6.05434498977,      640.87760738220}, 
    {     0.00000000011,  1.75779397460,     4562.46099302120}, 
    {     0.00000000012,  1.46467398653,    12964.30070339100}, 
    {     0.00000000010,  3.56966848964,    15113.98923821520}, 
    {     0.00000000009,  4.80839551981,     3325.35995551480}, 
    {     0.00000000010,  1.23311080707,     3360.96774609859}, 
    {     0.00000000009,  1.93544907019,    13760.59871020740}, 
    {     0.00000000010,  0.49076916855,     2810.92146160520}, 
    {     0.00000000010,  2.49016534434,    16173.37116840440}, 
    {     0.00000000009,  3.62373278148,     5614.72937620960}, 
    {     0.00000000009,  2.29700488106,     8429.24126646660}, 
    {     0.00000000009,  2.52785501283,     3427.92063123960}, 
    {     0.00000000009,  5.57605456632,     3355.86489788480}, 
    {     0.00000000008,  3.38386554244,     8827.39026987480}, 
    {     0.00000000008,  1.67431441943,    16706.58525184800}, 
    {     0.00000000008,  3.62389227844,    12310.18132361080}, 
    {     0.00000000008,  2.25791643317,      151.89728108520}, 
    {     0.00000000008,  3.08029498940,     6254.62666252360}, 
    {     0.00000000010,  2.86769411066,     3320.25710730100}, 
    {     0.00000000008,  3.03420706487,     1751.53953141600}, 
    {     0.00000000007,  0.11237624686,     3127.31333126180}, 
    {     0.00000000009,  4.92065236724,    11216.28429032400}, 
    {     0.00000000007,  3.67458682256,     3980.50971301380}, 
};


static const struct vsop mars_radius_r4[RADIUS_R4] = {
    {     0.00000019551,  3.58210746512,     3340.61242669980}, 
    {     0.00000016322,  4.05115851142,     6681.22485339960}, 
    {     0.00000005848,  4.46381646580,    10021.83728009940}, 
    {     0.00000001533,  4.84332951095,    13362.44970679920}, 
    {     0.00000000375,  1.50951652931,     3185.19202726560}, 
    {     0.00000000340,  5.20519444932,    16703.06213349900}, 
    {     0.00000000152,  5.16376141170,     3344.13554504880}, 
    {     0.00000000126,  2.19183723061,     3496.03282613400}, 
    {     0.00000000148,  0.00000000000,        0.00000000000}, 
    {     0.00000000088,  0.10430359862,     3583.34103067380}, 
    {     0.00000000071,  5.56060980870,    20043.67456019880}, 
    {     0.00000000050,  5.56346631885,     6684.74797174860}, 
    {     0.00000000048,  2.91926298132,     2787.04302385740}, 
    {     0.00000000057,  1.86870004051,     6525.80445396540}, 
    {     0.00000000034,  3.63370917313,     3097.88382272579}, 
    {     0.00000000021,  2.30993179224,     1059.38193018920}, 
    {     0.00000000020,  4.04278354592,     4136.91043351620}, 
    {     0.00000000018,  4.17438755890,     3149.16416058820}, 
    {     0.00000000017,  5.90833786763,    23384.28698689860}, 
    {     0.00000000014,  1.98185426243,      155.42039943420}, 
    {     0.00000000013,  4.43167860883,     7477.52286021600}, 
    {     0.00000000017,  5.93839376025,    10025.36039844840}, 
    {     0.00000000015,  4.58867012625,     6489.77658728800}, 
    {     0.00000000014,  2.22119368504,     9866.41688066520}, 
    {     0.00000000013,  3.24667481494,     6127.65545055720}, 
    {     0.00000000013,  0.48623714297,     6923.95345737360}, 
    {     0.00000000012,  5.44223670746,     3738.76143010800}, 
    {     0.00000000016,  2.67418088918,     4399.99435688900}, 
    {     0.00000000014,  0.78383138857,     3894.18182954220}, 
    {     0.00000000011,  2.64507772215,     3341.59274776800}, 
    {     0.00000000012,  4.34268478367,     2388.89402044920}, 
    {     0.00000000012,  2.52802901788,     6836.64525283380}, 
    {     0.00000000009,  2.81895333303,     4292.33083295040}, 
    {     0.00000000012,  5.83109172622,     7079.37385680780}, 
    {     0.00000000009,  0.76993290644,     1592.59601363280}, 
    {     0.00000000008,  3.56780948809,      796.29800681640}, 
    {     0.00000000008,  2.59620253825,     4535.05943692440}, 
    {     0.00000000008,  3.91827119997,     6438.49624942560}, 
    {     0.00000000009,  2.21473599227,     1194.44701022460}, 
    {     0.00000000008,  1.21128945285,     4690.47983635860}, 
    {     0.00000000007,  3.08488687971,     2544.31441988340}, 
    {     0.00000000008,  5.72388554390,     1990.74501704100}, 
    {     0.00000000008,  3.00192257768,     3532.06069281140}, 
    {     0.00000000008,  4.44918099254,     3339.63210563160}, 
    {     0.00000000008,  3.21999751217,     3347.72597370060}, 
    {     0.00000000007,  1.16933312219,     4933.20844033260}, 
    {     0.00000000008,  5.12244052839,     3723.50895892300}, 
    {     0.00000000006,  4.60069136817,     5729.50644714900}, 
    {     0.00000000006,  1.82718202907,     2957.71589447660}, 
    {     0.00000000006,  3.00923601434,     6682.20517446780}, 
    {     0.00000000005,  2.74887623421,     1589.07289528380}, 
    {     0.00000000005,  2.01586492272,     5486.77784317500}, 
    {     0.00000000005,  6.17623487651,    13365.97282514820}, 
    {     0.00000000006,  3.96856230146,     2146.16541647520}, 
    {     0.00000000005,  2.80833888276,     3337.08930835080}, 
    {     0.00000000004,  2.92720462940,     7875.67186362420}, 
    {     0.00000000004,  4.02001405595,     3333.49887969900}, 
};


static const struct vsop mars_radius_r5[RADIUS_R5] = {
    {     0.00000000475,  2.47621038205,     6681.22485339960}, 
    {     0.00000000270,  2.90961348988,    10021.83728009940}, 
    {     0.00000000116,  1.76766655427,     3340.61242669980}, 
    {     0.00000000097,  3.31315004582,    13362.44970679920}, 
    {     0.00000000049,  6.28284800757,     3185.19202726560}, 
    {     0.00000000027,  3.69297278191,    16703.06213349900}, 
    {     0.00000000013,  3.67011956659,     3496.03282613400}, 
    {     0.00000000012,  4.88179002689,     3583.34103067380}, 
    {     0.00000000012,  3.14159265359,        0.00000000000}, 
    {     0.00000000009,  4.05335755845,    20043.67456019880}, 
    {     0.00000000009,  0.35575801457,     6525.80445396540}, 
    {     0.00000000006,  3.95186839136,     6684.74797174860}, 
    {     0.00000000005,  1.40424074649,     2787.04302385740}, 
    {     0.00000000005,  3.60327227648,     3344.13554504880}, 
    {     0.00000000004,  5.11981331029,     3097.88382272579}, 
    {     0.00000000004,  5.24603068590,     6923.95345737360}, 
    {     0.00000000002,  0.40954426011,     9866.41688066520}, 
};

/* Chapter 31 Pg 206-207 Equ 31.1 31.2 , 31.3 using VSOP 87
 * Calculate mars rectangular heliocentric ecliptical coordinates
 * for given julian day. Values are in UA.
 * params : Julian day, rect coords */
void get_mars_helio_coords(double JD, double * X, double * Y, double * Z)
{
	double t, t2, t3, t4, t5;
	double L0, L1, L2, L3, L4, L5;
	double B0, B1, B2, B3, B4, B5;
	double R0, R1, R2, R3, R4, R5;
	double L,B,R;

	/* get julian ephemeris day */
	t = (JD - 2451545.0) / 365250;
	t2 = t * t;
	t3 = t2 * t;
	t4 = t3 * t;
	t5 = t4 * t;

	/* calc L series */
	L0 = calc_series (mars_longitude_l0, LONG_L0, t);
	L1 = calc_series (mars_longitude_l1, LONG_L1, t);
	L2 = calc_series (mars_longitude_l2, LONG_L2, t);
	L3 = calc_series (mars_longitude_l3, LONG_L3, t);
	L4 = calc_series (mars_longitude_l4, LONG_L4, t);
	L5 = calc_series (mars_longitude_l5, LONG_L5, t);
	L = (L0 + L1 * t + L2 * t2 + L3 * t3 + L4 * t4 + L5 * t5);

	/* calc B series */
	B0 = calc_series (mars_latitude_b0, LAT_B0, t);
	B1 = calc_series (mars_latitude_b1, LAT_B1, t);
	B2 = calc_series (mars_latitude_b2, LAT_B2, t);
	B3 = calc_series (mars_latitude_b3, LAT_B3, t);
	B4 = calc_series (mars_latitude_b4, LAT_B4, t);
	B5 = calc_series (mars_latitude_b5, LAT_B5, t);
	B = (B0 + B1 * t + B2 * t2 + B3 * t3 + B4 * t4 + B5 * t5);

	/* calc R series */
	R0 = calc_series (mars_radius_r0, RADIUS_R0, t);
	R1 = calc_series (mars_radius_r1, RADIUS_R1, t);
	R2 = calc_series (mars_radius_r2, RADIUS_R2, t);
	R3 = calc_series (mars_radius_r3, RADIUS_R3, t);
	R4 = calc_series (mars_radius_r4, RADIUS_R4, t);
	R5 = calc_series (mars_radius_r5, RADIUS_R5, t);
	R = (R0 + R1 * t + R2 * t2 + R3 * t3 + R4 * t4 + R5 * t5);

	/* change to fk5 reference frame */
	vsop87_to_fk5(&L, &B, JD);

	/* convert to rectangular coord */
	sphe_to_rect(L, B, R, X, Y, Z);
}
