/*
 * SwamiConfig.h - Swami configuration system header file
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMI_CONFIG_H__
#define __SWAMI_CONFIG_H__

#include <glib.h>
#include "swamidll.h"

typedef struct _SwamiConfigStaticVars SwamiConfigStaticVars;

/* configuration domain category (determines file domain is stored in) */
typedef enum {
  SWAMI_CONFIG_CATEGORY_MAIN,	/* main swami.cfg */
  SWAMI_CONFIG_CATEGORY_STATE,	/* state variables swami_state.cfg */
  SWAMI_CONFIG_CATEGORY_PLUGIN,	/* plugin variables plugins.cfg */
  SWAMI_CONFIG_CATEGORY_PLUGIN_STATE, /* plugin state vars plugin_state.cfg */
  SWAMI_CONFIG_CATEGORY_COUNT	/* dummy - count of domain categories */
} SwamiConfigCategory;

/* structure used as arrays to define batches of config variables */
struct _SwamiConfigStaticVars
{
  char *domain;			/* domain to add variable to, NULL to use last
				   defined domain in array */
  char *id;			/* string identifier for this variable */
  GTokenType type;		/* type of value */
  GTokenValue def;		/* default value */
};

SWAMI_API void swami_config_init (void);
SWAMI_API void swami_config_add_domain (const char *domain,
					SwamiConfigCategory category);
SWAMI_API void swami_config_add_variable (const char *domain, const char *id,
					  GTokenType type,
					  const GTokenValue *def);
SWAMI_API void
swami_config_add_static_variables (const SwamiConfigStaticVars *vars,
				   int count);
SWAMI_API GTokenValue *swami_config_get_value (const char *domain,
					       const char *id);
SWAMI_API int swami_config_get_int (const char *domain, const char *id,
				    gboolean *found);
SWAMI_API float swami_config_get_float (const char *domain, const char *id,
					gboolean *found);
SWAMI_API char *swami_config_get_string (const char *domain, const char *id);
SWAMI_API void swami_config_set_value (const char *domain, const char *id,
				       const GTokenValue *value);
SWAMI_API void swami_config_set_int (const char *domain, const char *id,
				     int value);
SWAMI_API void swami_config_set_float (const char *domain, const char *id,
				       float value);
SWAMI_API void swami_config_set_string (const char *domain, const char *id,
					const char *value);

SWAMI_API void swami_config_load (void);
SWAMI_API void swami_config_save (gboolean changed_only);

#endif
