/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.ValidationFocusManager;
import java.util.Vector;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.FlowLayout;
import swingwt.awt.LayoutManager;
import swingwt.awt.TableLayout;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwtx.custom.validation.ValidatableComponent;
import swingwtx.custom.validation.ValidatableJTextField;
import swingwtx.custom.validation.ValidationGroup;
import swingwtx.swing.FocusManager;
import swingwtx.swing.JButton;
import swingwtx.swing.JFrame;
import swingwtx.swing.JLabel;
import swingwtx.swing.JOptionPane;
import swingwtx.swing.JPanel;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.event.ValidationEvent;
import swingwtx.swing.event.ValidationListener;

public class ValidationTest
extends JFrame {
    ValidatableJTextField txtFullName;
    ValidatableJTextField txtTown;
    ValidatableJTextField txtAge;
    ValidatableJTextField txtPhone;
    ValidationGroup vg;

    public ValidationTest() {
        this.setTitle("ValidationGroup Sample");
        this.setSize(new Dimension(300, 200));
        this.getContentPane().setLayout((LayoutManager)new BorderLayout());
        this.vg = new ValidationGroup();
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new TableLayout(0, 2));
        jPanel.add((Component)new JLabel("Full Name:"));
        this.txtFullName = new ValidatableJTextField();
        this.txtFullName.setPreferredSize(new Dimension(200, 25));
        this.txtFullName.addValidationListener(new ValidationListener(){

            public void validating(ValidationEvent validationEvent) {
                if (ValidationTest.this.txtFullName.getText().trim().length() == 0) {
                    validationEvent.setValid(false, "Please enter the full name of the customer.");
                } else if (ValidationTest.this.txtFullName.getText().indexOf(" ") == -1) {
                    validationEvent.setValid(false, "Please enter at least the first and last name of the customer.");
                } else {
                    validationEvent.setValid(true);
                }
            }
        });
        jPanel.add((Component)this.txtFullName);
        this.vg.add((ValidatableComponent)this.txtFullName);
        jPanel.add((Component)new JLabel("Town:"));
        this.txtTown = new ValidatableJTextField();
        this.txtTown.setPreferredSize(new Dimension(200, 25));
        this.txtTown.addValidationListener(new ValidationListener(){

            public void validating(ValidationEvent validationEvent) {
                if (ValidationTest.this.txtTown.getText().trim().length() == 0) {
                    validationEvent.setValid(false, "Please enter the customer's town.");
                } else {
                    validationEvent.setValid(true);
                }
            }
        });
        jPanel.add((Component)this.txtTown);
        this.vg.add((ValidatableComponent)this.txtTown);
        jPanel.add((Component)new JLabel("Age:"));
        this.txtAge = new ValidatableJTextField();
        this.txtAge.setPreferredSize(new Dimension(200, 25));
        this.txtAge.addValidationListener(new ValidationListener(){

            public void validating(ValidationEvent validationEvent) {
                if (!this.isNumber(ValidationTest.this.txtAge.getText())) {
                    validationEvent.setValid(false, "Please enter the customer's age, as a whole number.");
                } else {
                    validationEvent.setValid(true);
                }
            }

            public boolean isNumber(String string) {
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return true;
            }
        });
        jPanel.add((Component)this.txtAge);
        this.vg.add((ValidatableComponent)this.txtAge);
        jPanel.add((Component)new JLabel("Phone #"));
        this.txtPhone = new ValidatableJTextField();
        this.txtPhone.setPreferredSize(new Dimension(200, 25));
        this.txtPhone.addValidationListener(new ValidationListener(){

            public void validating(ValidationEvent validationEvent) {
                if (ValidationTest.this.txtPhone.getText().trim().length() == 0 || ValidationTest.this.txtPhone.getText().trim().length() != 8) {
                    validationEvent.setValid(false, "Please enter the customer's phone number in the format nnn-nnnn.");
                } else {
                    validationEvent.setValid(true);
                }
            }
        });
        jPanel.add((Component)this.txtPhone);
        this.vg.add((ValidatableComponent)this.txtPhone);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new FlowLayout());
        JButton jButton = new JButton("Cancel");
        jButton.setMnemonic('c');
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidationTest.this.dispose();
            }
        });
        jPanel2.add((Component)jButton);
        JButton jButton2 = new JButton("Ok");
        jButton2.setMnemonic('o');
        final ValidationTest validationTest = this;
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ValidationTest.this.vg.checkValidation()) {
                    JOptionPane.showMessageDialog((Container)validationTest, (Object)"Validation Failed.", (String)"Error", (int)1);
                } else {
                    ValidationTest.this.dispose();
                }
            }
        });
        jPanel2.add((Component)jButton2);
        this.setDefaultButton(jButton2);
        ValidationFocusManager validationFocusManager = new ValidationFocusManager();
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.txtFullName.getComponent());
        vector.add(this.txtTown.getComponent());
        vector.add(this.txtAge.getComponent());
        vector.add(this.txtPhone.getComponent());
        vector.add(jButton);
        vector.add(jButton2);
        validationFocusManager.setComponents(vector);
        vector = null;
        FocusManager.setCurrentManager((FocusManager)validationFocusManager);
        this.getContentPane().add((Component)jPanel, (Object)"Center");
        this.getContentPane().add((Component)jPanel2, (Object)"South");
        this.show();
    }

    public static void main(String[] stringArray) {
        if (SwingWTUtils.isMacOSX()) {
            SwingWTUtils.initialiseMacOSX((Runnable)new Runnable(){

                public void run() {
                    new ValidationTest();
                }
            });
        } else {
            new ValidationTest();
        }
    }
}

