/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt.event;

import swingwt.awt.Component;
import swingwt.awt.event.ComponentEvent;

public abstract class InputEvent
extends ComponentEvent {
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int ALT_GRAPH_MASK = 32;
    public static final int BUTTON1_MASK = 16;
    public static final int BUTTON2_MASK = 8;
    public static final int BUTTON3_MASK = 4;
    public static final int SHIFT_DOWN_MASK = 64;
    public static final int CTRL_DOWN_MASK = 128;
    public static final int META_DOWN_MASK = 256;
    public static final int ALT_DOWN_MASK = 512;
    public static final int BUTTON1_DOWN_MASK = 1024;
    public static final int BUTTON2_DOWN_MASK = 2048;
    public static final int BUTTON3_DOWN_MASK = 4096;
    public static final int ALT_GRAPH_DOWN_MASK = 8192;
    private long when;
    int modifiers = 0;

    InputEvent(Component source, int id, long when, int modifiers) {
        super(source, id);
        this.when = when;
        this.modifiers = modifiers;
    }

    public InputEvent(Component source) {
        super(source);
    }

    public InputEvent(Component source, int id) {
        super(source, id);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isAltDown() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean isShiftDown() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isControlDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isMetaDown() {
        return (this.modifiers & 4) != 0;
    }

    public static int translateSWTModifiers(int swtModifiers) {
        int awtModifiers = 0;
        if ((swtModifiers & 0x40000) > 0) {
            awtModifiers |= 2;
        }
        if ((swtModifiers & 0x20000) > 0) {
            awtModifiers |= 1;
        }
        if ((swtModifiers & 0x10000) > 0) {
            awtModifiers |= 8;
        }
        if ((swtModifiers & 0x80000) > 0) {
            awtModifiers |= 0x400;
        }
        if ((swtModifiers & 0x100000) > 0) {
            awtModifiers |= 0x800;
        }
        if ((swtModifiers & 0x200000) > 0) {
            awtModifiers |= 0x1000;
        }
        if ((swtModifiers & 0x400000) > 0) {
            awtModifiers |= 4;
        }
        return awtModifiers;
    }

    public static int translateAWTModifiers(int awtModifiers) {
        int swtModifiers = 0;
        if ((awtModifiers & 2) > 0) {
            swtModifiers |= 0x40000;
        }
        if ((awtModifiers & 1) > 0) {
            swtModifiers |= 0x20000;
        }
        if ((awtModifiers & 8) > 0) {
            swtModifiers |= 0x10000;
        }
        if ((awtModifiers & 0x400) > 0) {
            swtModifiers |= 0x80000;
        }
        if ((awtModifiers & 0x800) > 0) {
            swtModifiers |= 0x100000;
        }
        if ((awtModifiers & 0x1000) > 0) {
            swtModifiers |= 0x200000;
        }
        if ((awtModifiers & 4) > 0) {
            swtModifiers |= 0x400000;
        }
        return swtModifiers;
    }
}

