/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwtx.swing.Icon;
import swingwtx.swing.JComponent;
import swingwtx.swing.SwingConstants;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;

public class JLabel
extends JComponent
implements SwingConstants {
    protected Label ppeer = null;
    protected String pText = "";
    protected Icon pImage = null;
    protected int pHTextPosition = 2;
    protected int pVTextPosition = 1;
    protected int pHAlign = 2;
    protected int pVAlign = 1;
    protected Component labelFor = null;

    public JLabel() {
    }

    public JLabel(String text) {
        this.pText = text;
    }

    public JLabel(String text, int align) {
        this.pText = text;
        this.setHorizontalAlignment(align);
    }

    public JLabel(Icon icon) {
        this.pImage = icon;
    }

    public JLabel(String text, Icon icon, int align) {
        this.pText = text;
        this.pImage = icon;
        this.setHorizontalAlignment(align);
    }

    public String getText() {
        return this.pText;
    }

    public void setText(String text) {
        this.pText = text;
        if (this.pText == null) {
            this.pText = "";
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JLabel.this.ppeer)) {
                    JLabel.this.ppeer.setText(SwingWTUtils.removeHTML(JLabel.this.pText));
                }
                if (JLabel.this.parent != null) {
                    JLabel.this.parent.invalidate();
                    JLabel.this.repaint();
                }
            }
        });
    }

    public void setLabelFor(Component c) {
        this.labelFor = c;
    }

    public Component getLabelFor() {
        return this.labelFor;
    }

    public void setDisplayedMnemonic(char c) {
    }

    public void setDisplayedMnemonic(int c) {
    }

    public void setIcon(Icon icon) {
        this.pImage = icon;
        final JLabel pthis = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JLabel.this.ppeer)) {
                    if (JLabel.this.pImage == null) {
                        JLabel.this.ppeer.setImage(null);
                    } else {
                        JLabel.this.ppeer.setImage(SwingWTUtils.getSWTImageFromSwingIcon(pthis, JLabel.this.pImage));
                    }
                    if (JLabel.this.parent != null) {
                        JLabel.this.parent.invalidate();
                        JLabel.this.repaint();
                    }
                }
            }
        });
    }

    public Icon getIcon() {
        return this.pImage;
    }

    public Icon getDisabledIcon() {
        return null;
    }

    public void setDisabledIcon(Icon icon) {
    }

    public void setHorizontalAlignment(final int align) {
        this.pHAlign = align;
        SwingUtilities.invokeAsync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JLabel.this.ppeer)) {
                    JLabel.this.ppeer.setAlignment(SwingWTUtils.translateSwingAlignmentConstant(align) | SwingWTUtils.translateSwingAlignmentConstant(JLabel.this.pVAlign));
                }
            }
        });
    }

    public void setVerticalAlignment(final int align) {
        this.pVAlign = align;
        SwingUtilities.invokeAsync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JLabel.this.ppeer)) {
                    JLabel.this.ppeer.setAlignment(SwingWTUtils.translateSwingAlignmentConstant(align) | SwingWTUtils.translateSwingAlignmentConstant(JLabel.this.pHAlign));
                }
            }
        });
    }

    public int getHorizontalAlignment() {
        return this.pHAlign;
    }

    public int getVerticalAlignment() {
        return this.pVAlign;
    }

    public void setHorizontalTextPosition(int textpos) {
        this.setHorizontalAlignment(textpos);
    }

    public void setVerticalTextPosition(int textpos) {
        this.setVerticalAlignment(textpos);
    }

    public int getHorizontalTextPosition() {
        return this.getHorizontalAlignment();
    }

    public int getVerticalTextPosition() {
        return this.getVerticalAlignment();
    }

    protected Dimension calculatePreferredSize() {
        Dimension size = new Dimension(SwingWTUtils.getRenderStringWidth(this.pText), SwingWTUtils.getRenderStringHeight(this.pText));
        this.setSize(size);
        return size;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.ppeer = new Label(parent.getComposite(), 0);
        if (this.pText != null) {
            this.ppeer.setText(SwingWTUtils.removeHTML(this.pText));
        }
        this.ppeer.setAlignment(SwingWTUtils.translateSwingAlignmentConstant(this.pHAlign) | SwingWTUtils.translateSwingAlignmentConstant(this.pVAlign));
        if (this.pImage != null) {
            this.setIcon(this.pImage);
        }
        this.peer = this.ppeer;
        this.parent = parent;
    }
}

