/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.activities;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.EnablementDialog;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public final class WorkbenchActivityHelper {
    public static boolean allowUseOf(Object object) {
        IPluginContribution contribution;
        if (!WorkbenchActivityHelper.isFiltering()) {
            return true;
        }
        if (object instanceof IPluginContribution && (contribution = (IPluginContribution)object).getPluginId() != null) {
            IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IIdentifier identifier = workbenchActivitySupport.getActivityManager().getIdentifier(WorkbenchActivityHelper.createUnifiedId(contribution));
            return WorkbenchActivityHelper.allow(identifier);
        }
        return true;
    }

    private static boolean allow(IIdentifier identifier) {
        EnablementDialog dialog;
        if (identifier.isEnabled()) {
            return true;
        }
        if (!PlatformUI.getWorkbench().getPreferenceStore().getBoolean("shouldPromptForEnablement")) {
            WorkbenchActivityHelper.enableIdentifier(identifier);
            return true;
        }
        Set activityIds = new HashSet(identifier.getActivityIds());
        Iterator i = activityIds.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            if (!PlatformUI.getWorkbench().getPreferenceStore().getBoolean(WorkbenchActivityHelper.removalKey(id))) continue;
            i.remove();
        }
        if (activityIds.isEmpty()) {
            activityIds = identifier.getActivityIds();
        }
        if ((dialog = new EnablementDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), activityIds)).open() == 0) {
            WorkbenchActivityHelper.enabledActivities(dialog.getActivitiesToEnable());
            if (dialog.getDontAsk()) {
                Iterator i2 = activityIds.iterator();
                while (i2.hasNext()) {
                    String id = (String)i2.next();
                    PlatformUI.getWorkbench().getPreferenceStore().setValue(WorkbenchActivityHelper.removalKey(id), true);
                }
            }
            return true;
        }
        return false;
    }

    public static final String createUnifiedId(IPluginContribution contribution) {
        if (contribution.getPluginId() != null) {
            return String.valueOf(contribution.getPluginId()) + '/' + contribution.getLocalId();
        }
        return contribution.getLocalId();
    }

    private static void enabledActivities(Collection activities) {
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        HashSet newSet = new HashSet(activitySupport.getActivityManager().getEnabledActivityIds());
        newSet.addAll(activities);
        activitySupport.setEnabledActivityIds(newSet);
    }

    private static final void enableIdentifier(IIdentifier identifier) {
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        HashSet newSet = new HashSet(activitySupport.getActivityManager().getEnabledActivityIds());
        newSet.addAll(identifier.getActivityIds());
        activitySupport.setEnabledActivityIds(newSet);
    }

    public static final boolean filterItem(Object object) {
        IWorkbenchActivitySupport workbenchActivitySupport;
        IIdentifier identifier;
        IPluginContribution contribution;
        return object instanceof IPluginContribution && (contribution = (IPluginContribution)object).getPluginId() != null && !(identifier = (workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager().getIdentifier(WorkbenchActivityHelper.createUnifiedId(contribution))).isEnabled();
    }

    public static final boolean isFiltering() {
        return !PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getDefinedActivityIds().isEmpty();
    }

    private static String removalKey(String id) {
        return "no-prompt-for." + id;
    }

    private WorkbenchActivityHelper() {
    }
}

