// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: VTime.cpp
// 
//---------------------------------------------------------------------------

#include <warped/SerializedInstance.h>
#include <warped/DeserializerManager.h>
#include "VHDLVTime.hh"

const VHDLVTime &
VHDLVTime::getVHDLVTimeZero(){
  static const VHDLVTime ZERO = VHDLVTime( 0, 0 );
  return ZERO;
}

const VHDLVTime &
VHDLVTime::getVHDLVTimePositiveInfinity(){ 
  static const VHDLVTime PINFINITY = VHDLVTime( warped64Max, warped32Max );
  return PINFINITY; 
}

void 
VHDLVTime::serialize( SerializedInstance *serialized ) const {
  serialized->addInt64( getMajor() );
  serialized->addInt( getMinor() );
}

Serializable *
VHDLVTime::deserialize( SerializedInstance *serialized ){
  warped64_t major = serialized->getInt64();
  int minor = serialized->getInt();
  VHDLVTime *retval = new VHDLVTime( major,
			     minor );
  return retval;
}


void 
VHDLVTime::registerDeserializer(){
  DeserializerManager::instance()->registerDeserializer( getVHDLVTimeDataType(),
							 &deserialize );
}
