#!/usr/local/bin/perl
# index.cgi
# Display a list of all known printers

require './lpadmin-lib.pl';
&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1, 0,
		 undef, undef, undef,
		 &text('index_style',
			$text{'style_'.$config{'print_style'}} ||
			uc($config{'print_style'})));
@plist = &list_printers();

# Check the print system (if possible)
if (defined(&check_print_system)) {
	$pserr = &check_print_system();
	if ($pserr) {
		print $pserr,"\n";
		print &text('index_esystem',
		    "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
		&ui_print_footer("/", $text{'index'});
		exit;
		}
	}

if ($config{'sort_mode'}) {
	@plist = sort { $a cmp $b } @plist;
	}
if (@plist) {
	print "<a href=edit_printer.cgi?new=1>$text{'index_add'}</a><br>\n"
		if ($access{'add'});
	if ($config{'display_mode'}) {
		# Just show printer names
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>$text{'index_header'}</b></td> </tr>\n";
		print "<tr $cb> <td><table width=100%>\n";
		$i = 0;
		foreach $p (@plist) {
			local $ed = &can_edit_printer($p);
			local $jb = &can_edit_jobs($p);
			next if (!$ed && !$jb && !$access{'view'});
			print "<tr>\n" if ($i%4 == 0);
			print "<td width=25%>";
			if ($ed) {
				print "<a href='edit_printer.cgi?name=$p'>",
				      "$p</a>\n";
				}
			else {
				print "$p\n";
				}
			if ($config{'show_jobs'}) {
				local @jobs = &get_jobs($p->{'name'});
				print "&nbsp;<a href='list_jobs.cgi?name=$p'>",
				      "(",&text('index_jcount', scalar(@jobs)),
				      ")</a></td>\n";
				}
			else {
				print "&nbsp;<a href='list_jobs.cgi?name=$p'>",
				      "($text{'index_jlist'})</a></td>\n";
				}
			print "</tr>\n" if ($i%4 == 3);
			$i++;
			}
		print "</table></td></tr></table>\n";
		}
	else {
		# Show full printer details
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>$text{'index_name'}</b></td> ",
		      "<td><b>$text{'index_desc'}</b></td> ",
		      "<td><b>$text{'index_to'}</b></td> ";
		if ($config{'show_status'}) {
			print "<td><b>$text{'index_enabled'}</b></td> ",
			      "<td><b>$text{'index_accepting'}</b></td> ";
			}
		else {
			print "<td><b>$text{'index_driver'}</b></td> ";
			}
		print "<td><b>$text{'index_jobs'}</b></td> </tr>\n";
		for($i=0; $i<@plist; $i++) {
			local ($wdrv, $hdrv, $drv);
			local $ed = &can_edit_printer($plist[$i]);
			local $jb = &can_edit_jobs($plist[$i]);
			next if (!$ed && !$jb && !$access{'view'});
			$p = &get_printer($plist[$i], !$config{'show_status'});
			$ed = 0 if ($p->{'ro'});

			print "<tr $cb>\n";
			if ($ed) {
				print "<td><a href=\"edit_printer.cgi?",
				      "name=$p->{'name'}\">",
				      &html_escape($p->{'name'}),"</a></td>\n";
				}
			else {
				print "<td>",&html_escape($p->{'name'}),"</td>\n";
				}
			print "<td>",$p->{'desc'} ? &html_escape($p->{'desc'})
						  : "<br>","</td>\n";
			if (!$webmin_windows_driver) {
				$wdrv = &is_webmin_windows_driver($p->{'iface'}, $p);
				}
			$wdrv = &is_windows_driver($p->{'iface'}, $p) if (!$wdrv);
			$hdrv = &is_hpnp_driver($p->{'iface'}, $p);
			if ($wdrv) {
				print "<td><tt>\\\\$wdrv->{'server'}",
				      "\\$wdrv->{'share'}</tt></td>\n";
				$p->{'iface'} = $wdrv->{'program'};
				}
			elsif ($hdrv) {
				print "<td><tt>HPNP $hdrv->{'server'}:",
				      "$hdrv->{'port'}</tt></td>\n";
				$p->{'iface'} = $hdrv->{'program'};
				}
			elsif ($p->{'rhost'}) {
				local $qu = $p->{'rqueue'} ? $p->{'rqueue'}
							   : $p->{'name'};
				print"<td><tt>$p->{'rhost'}:$qu</tt></td>\n";
				}
			elsif ($p->{'dhost'}) {
				print"<td><tt>$p->{'dhost'}:$p->{'dport'}</tt></td>\n";
				}
			else {
				print "<td>",&dev_name($p->{'dev'}),"</td>\n";
				}
			if (!$webmin_print_driver) {
				$drv = &is_webmin_driver($p->{'iface'}, $p);
				}
			$drv = &is_driver($p->{'iface'}, $p)
				if ($drv->{'mode'} == 0 || $drv->{'mode'} == 2);
			if ($config{'show_status'}) {
				printf "<td>%s</td>\n",
					$p->{'enabled'} ? $text{'yes'} : $text{'no'};
				printf "<td>%s</td>\n",
					$p->{'accepting'} ? $text{'yes'} : $text{'no'};
				}
			else {
				print "<td>",&html_escape($drv->{'desc'}),"</td>\n";
				}
			print "<td><a href=\"list_jobs.cgi?name=",
			      "$p->{'name'}\">";
			if ($config{'show_jobs'}) {
				local @jobs = &get_jobs($p->{'name'});
				print scalar(@jobs);
				}
			else {
				print $text{'index_list'};
				}
			print "</a></td> </tr>\n";
			}
		print "</table>\n";
		}
	}
else { print "<h3>$text{'index_none'}</h3>\n"; }
print "<a href=edit_printer.cgi?new=1>$text{'index_add'}</a>\n"
	if ($access{'add'});
print "<p>\n";

# display button to start or stop the scheduler (lpd, lpsched, etc..)
$pid = &sched_running();
if ($pid < 0 || !$access{'stop'}) {
	# cannot stop or start..
	}
elsif ($pid && $access{'stop'} == 2) {
	# can only restart
	print "<hr>\n";
	print "<form action=restart.cgi>\n";
        print "<input type=hidden name=pid value=$pid>\n";
        print "<table width=100%><tr><td>\n";
        print "<input type=submit value=\"$text{'index_restart'}\"></td>\n";
	print "<td>$text{'index_restartmsg'}</td> </tr></table>\n";
        print "</form>\n";
	}
elsif ($pid) {
	print "<hr>\n";
	print "<form action=stop.cgi>\n";
        print "<input type=hidden name=pid value=$pid>\n";
        print "<table width=100%><tr><td>\n";
        print "<input type=submit value=\"$text{'index_stop'}\"></td>\n";
	print "<td>$text{'index_stopmsg'}</td> </tr></table>\n";
        print "</form>\n";
	}
else {
	print "<hr>\n";
	print "<form action=start.cgi>\n";
        print "<table width=100%><tr><td>\n";
        print "<input type=submit value=\"$text{'index_start'}\"></td>\n";
	print "<td>$text{'index_startmsg'}</td> </tr></table>\n";
        print "</form>\n";
	}

&ui_print_footer("/", $text{'index'});

