/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1999 */
/* See the file NOTICE for conditions of use and distribution. */

/* Header for the forwardfile director */

/* Private structure for the private options. The first block of them must be
kept in step with the private options for the aliasfile director, because they
are used by a common subroutine. Some of these are settable in one of the
directors only. */

typedef struct {
  /************ Common block *******************/
  transport_instance *directory_transport;
  char *expand_directory_transport;
  transport_instance *directory2_transport;
  char *expand_directory2_transport;
  transport_instance *file_transport;
  char *expand_file_transport;
  transport_instance *pipe_transport;
  char *expand_pipe_transport;
  transport_instance *reply_transport;
  char *expand_reply_transport;
  BOOL  check_ancestor;
  BOOL  check_local_user;
  BOOL  forbid_file;
  BOOL  forbid_pipe;
  BOOL  forbid_reply;
  BOOL  one_time;
  /*********************************************/
  char *file_dir;
  char *pw_dir;
  char *file;
  char *syntax_errors_to;
  char *syntax_errors_text;
  int   modemask;
  uid_t *owners;
  gid_t *owngroups;
  BOOL  check_group;
  BOOL  filter;
  BOOL  allow_system_actions;
  BOOL  forbid_filter_exists;
  BOOL  forbid_filter_logwrite;
  BOOL  forbid_filter_lookup;
  BOOL  forbid_filter_perl;
  BOOL  forbid_include;
  BOOL  ignore_eacces;
  BOOL  ignore_enotdir;
  BOOL  qualify_preserve_domain;
  BOOL  use_seteuid;
  BOOL  freeze_missing_include;
  BOOL  rewrite;
  BOOL  skip_syntax_errors;
} forwardfile_director_options_block;

/* Data for reading the private options. */

extern optionlist forwardfile_director_options[];
extern int forwardfile_director_options_count;

/* Block containing default values. */

extern forwardfile_director_options_block forwardfile_director_option_defaults;

/* The main and initialization entry points for the director */

extern int forwardfile_director_entry(director_instance *, address_item *,
  address_item **, address_item **, address_item **, address_item **, BOOL);

extern void forwardfile_director_init(director_instance *);

/* End of directors/forwardfile.h */
