/*
 * Decompiled with CFR 0.152.
 */
package symantec.tools.debug;

import symantec.tools.debug.Agent;
import symantec.tools.debug.DebuggerCallback;
import symantec.tools.debug.RemoteAgent;
import symantec.tools.debug.RemoteClass;
import symantec.tools.debug.RemoteObject;
import symantec.tools.debug.RemoteThread;
import symantec.tools.debug.RemoteThreadGroup;
import symantec.tools.debug.SymDbgExprFindContext;
import symantec.tools.debug.SymDbgExprResult;
import symantec.tools.debug.SymDbgLoadExpr;

public class RemoteDebugger {
    private RemoteAgent agent;

    public RemoteDebugger(String string, String string2, DebuggerCallback debuggerCallback, boolean bl) throws Exception {
        this.agent = new RemoteAgent(string, string2, "", debuggerCallback, bl);
    }

    public RemoteDebugger(String string, DebuggerCallback debuggerCallback, boolean bl) throws Exception {
        if (Agent.isDebuggable()) {
            this.agent = new RemoteAgent(debuggerCallback, bl);
            return;
        }
        this.agent = new RemoteAgent(null, null, string, debuggerCallback, bl);
    }

    public int getProcessId() {
        return this.agent.getProcessId();
    }

    public int getProcessHandle() {
        return this.agent.getProcessHandle();
    }

    public void closeDebugSocket() {
        this.agent.closeDebugSocket();
    }

    public void debugBreak() throws Exception {
        this.agent.debugBreak();
    }

    public void close() {
        this.agent.close();
    }

    public RemoteObject get(Integer n) {
        return this.agent.get(n);
    }

    public RemoteClass[] listClasses() throws Exception {
        return this.agent.listClasses();
    }

    public RemoteClass findClass(String string) throws Exception {
        return this.agent.findClass(string);
    }

    public RemoteThreadGroup[] listThreadGroups(RemoteThreadGroup remoteThreadGroup) throws Exception {
        return this.agent.listThreadGroups(remoteThreadGroup);
    }

    public void cont() throws Exception {
        this.agent.resumeLastSuspendedThreads();
    }

    public void gc(RemoteObject[] remoteObjectArray) throws Exception {
        this.agent.gc(remoteObjectArray);
    }

    public void trace(boolean bl) throws Exception {
        this.agent.trace(bl);
    }

    public void itrace(boolean bl) throws Exception {
        this.agent.itrace(bl);
    }

    public int totalMemory() throws Exception {
        return this.agent.totalMemory();
    }

    public int freeMemory() throws Exception {
        return this.agent.freeMemory();
    }

    public RemoteThreadGroup run(int n, String[] stringArray) throws Exception {
        return this.agent.run(n, stringArray);
    }

    public String[] listBreakpoints() throws Exception {
        return this.agent.listBreakpoints();
    }

    public String[] getExceptionCatchList() throws Exception {
        return this.agent.getExceptionCatchList();
    }

    public RemoteClass[] getExceptionCatchClassList() throws Exception {
        return this.agent.getExceptionCatchClassList();
    }

    public SymDbgLoadExpr loadExpressionClass(byte[] byArray) throws Exception {
        return this.agent.loadExpressionClass(byArray);
    }

    public SymDbgExprFindContext getExpressionContextLines(int n) throws Exception {
        return this.agent.getExpressionContextLines(n);
    }

    public SymDbgExprResult evaluateExpression(RemoteThread remoteThread, int n) throws Exception {
        return this.agent.evaluateExpression(remoteThread, n);
    }

    public int reloadMethod(String string, String string2, String string3, byte[] byArray) throws Exception {
        return this.agent.reloadMethod(string, string2, string3, byArray);
    }

    public String getSourcePath() throws Exception {
        return this.agent.getSourcePath();
    }

    public void setSourcePath(String string) throws Exception {
        this.agent.setSourcePath(string);
    }

    public void addSystemThread() {
        Agent.addSystemThread(Thread.currentThread());
    }

    public void addSystemThread(Thread thread) {
        Agent.addSystemThread(thread);
    }
}

