/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.CORBA;

import com.visigenic.vbroker.CORBA.GiopOutputStream;
import com.visigenic.vbroker.CORBA.GiopStream;
import com.visigenic.vbroker.CORBA.ORB;
import com.visigenic.vbroker.CORBA.OrbObject;
import com.visigenic.vbroker.CORBA.TypeCode;
import com.visigenic.vbroker.GIOP.RequestHeader;
import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.IORHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.portable.InputStream;

public class GiopOutputStreamImpl
extends GiopOutputStream
implements GiopStream,
OrbObject {
    ORB _orb;
    byte[] _bytes;
    int _offset;
    boolean _byteOrder = false;
    RequestHeader _request;

    GiopOutputStreamImpl() {
    }

    public void init(ORB oRB, java.lang.Object[] objectArray) {
        this._orb = oRB;
        this._bytes = new byte[100];
    }

    public int offset() {
        return this._offset;
    }

    public void offset(int n) {
        this._offset = n;
    }

    public boolean byteOrder() {
        return this._byteOrder;
    }

    public void byteOrder(boolean bl) {
        this._byteOrder = bl;
    }

    int computePad(int n) {
        int n2 = this._offset % n;
        if (n2 == 0) {
            return 0;
        }
        return n - n2;
    }

    public byte[] bytes() {
        return this._bytes;
    }

    public byte[] toByteArray() {
        int n = this.offset();
        byte[] byArray = new byte[n];
        System.arraycopy(this._bytes, 0, byArray, 0, n);
        return byArray;
    }

    public RequestHeader request() {
        return this._request;
    }

    public void request(RequestHeader requestHeader) {
        this._request = requestHeader;
    }

    public InputStream create_input_stream() {
        return this._orb.newGiopInputStream(this._bytes);
    }

    public void read(byte[] byArray, int n, int n2) {
        System.arraycopy(this._bytes, n, byArray, 0, n2);
    }

    void expand(int n) {
        byte[] byArray = new byte[Math.max(this._bytes.length * 2, n)];
        System.arraycopy(this._bytes, 0, byArray, 0, this._bytes.length);
        this._bytes = byArray;
    }

    public void write_Object(Object object) {
        IOR iOR = object == null ? this._orb.nullIor() : this._orb.getDelegate(object).ior(object);
        IORHelper.write(this, iOR);
    }

    public void write_TypeCode(org.omg.CORBA.TypeCode typeCode) {
        if (typeCode == null || !(typeCode instanceof TypeCode)) {
            throw new BAD_PARAM("Invalid TypeCode: " + typeCode);
        }
        ((TypeCode)typeCode).write(this);
    }

    public void write_any(Any any) {
        if (any == null) {
            throw new BAD_PARAM("Null parameter: any");
        }
        this.write_TypeCode(any.type());
        any.write_value(this);
    }

    public void write_Principal(Principal principal) {
        byte[] byArray = principal.name();
        this.write_long(byArray.length);
        this.write_octet_array(byArray, 0, byArray.length);
    }

    public void write_boolean(boolean bl) {
        this.write_octet((byte)(bl ? 1 : 0));
    }

    public void write_char(char c) {
        this.write_octet((byte)c);
    }

    public void write_wchar(char c) {
        this.write_short((short)c);
    }

    public void write_ushort(short s) {
        this.write_short(s);
    }

    public void write_ulong(int n) {
        this.write_long(n);
    }

    public void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public void write_octet(byte by) {
        int n = this._offset + 1;
        if (n >= this._bytes.length) {
            this.expand(n);
        }
        this._bytes[this._offset++] = by;
    }

    public void write_short(short s) {
        int n = this.computePad(2);
        int n2 = this._offset + n + 2;
        if (n2 >= this._bytes.length) {
            this.expand(n2);
        }
        this._offset += n;
        if (!this.byteOrder()) {
            this._bytes[this._offset++] = (byte)(s >>> 8);
            this._bytes[this._offset++] = (byte)s;
            return;
        }
        this._bytes[this._offset++] = (byte)s;
        this._bytes[this._offset++] = (byte)(s >>> 8);
    }

    public void write_long(int n) {
        int n2 = this.computePad(4);
        int n3 = this._offset + n2 + 4;
        if (n3 >= this._bytes.length) {
            this.expand(n3);
        }
        this._offset += n2;
        if (!this.byteOrder()) {
            this._bytes[this._offset++] = (byte)(n >>> 24);
            this._bytes[this._offset++] = (byte)(n >>> 16);
            this._bytes[this._offset++] = (byte)(n >>> 8);
            this._bytes[this._offset++] = (byte)n;
            return;
        }
        this._bytes[this._offset++] = (byte)n;
        this._bytes[this._offset++] = (byte)(n >>> 8);
        this._bytes[this._offset++] = (byte)(n >>> 16);
        this._bytes[this._offset++] = (byte)(n >>> 24);
    }

    public void write_longlong(long l) {
        int n = this.computePad(8);
        int n2 = this._offset + n + 8;
        if (n2 >= this._bytes.length) {
            this.expand(n2);
        }
        this._offset += n;
        if (!this.byteOrder()) {
            this._bytes[this._offset++] = (byte)(l >>> 56);
            this._bytes[this._offset++] = (byte)(l >>> 48);
            this._bytes[this._offset++] = (byte)(l >>> 40);
            this._bytes[this._offset++] = (byte)(l >>> 32);
            this._bytes[this._offset++] = (byte)(l >>> 24);
            this._bytes[this._offset++] = (byte)(l >>> 16);
            this._bytes[this._offset++] = (byte)(l >>> 8);
            this._bytes[this._offset++] = (byte)l;
            return;
        }
        this._bytes[this._offset++] = (byte)l;
        this._bytes[this._offset++] = (byte)(l >>> 8);
        this._bytes[this._offset++] = (byte)(l >>> 16);
        this._bytes[this._offset++] = (byte)(l >>> 24);
        this._bytes[this._offset++] = (byte)(l >>> 32);
        this._bytes[this._offset++] = (byte)(l >>> 40);
        this._bytes[this._offset++] = (byte)(l >>> 48);
        this._bytes[this._offset++] = (byte)(l >>> 56);
    }

    public void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public void write_string(String string) {
        if (string == null) {
            this.write_long(0);
            return;
        }
        int n = string.length() + 1;
        this.write_long(n);
        byte[] byArray = new byte[n];
        string.getBytes(0, n - 1, byArray, 0);
        byArray[n - 1] = 0;
        this.write_octet_array(byArray, 0, n);
    }

    public void write_wstring(String string) {
        if (string == null) {
            this.write_long(0);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            new DataOutputStream(byteArrayOutputStream).writeUTF(string);
        }
        catch (IOException iOException) {
            throw new MARSHAL("Invalid unicode string: " + string);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.write_long(byArray.length);
        this.write_octet_array(byArray, 0, byArray.length);
    }

    public void write_octet_array(byte[] byArray, int n, int n2) {
        int n3 = this._offset + n2;
        if (n3 >= this._bytes.length) {
            this.expand(n3);
        }
        System.arraycopy(byArray, n, this._bytes, this._offset, n2);
        this._offset = n3;
    }

    public void write_boolean_array(boolean[] blArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_boolean(blArray[n3]);
            ++n3;
        }
    }

    public void write_char_array(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_char(cArray[n3]);
            ++n3;
        }
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_wchar(cArray[n3]);
            ++n3;
        }
    }

    public void write_short_array(short[] sArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_short(sArray[n3]);
            ++n3;
        }
    }

    public void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public void write_long_array(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_long(nArray[n3]);
            ++n3;
        }
    }

    public void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public void write_longlong_array(long[] lArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_longlong(lArray[n3]);
            ++n3;
        }
    }

    public void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public void write_float_array(float[] fArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_float(fArray[n3]);
            ++n3;
        }
    }

    public void write_double_array(double[] dArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.write_double(dArray[n3]);
            ++n3;
        }
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void write(int n) throws IOException {
        this.write_octet((byte)n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.write_octet_array(byArray, n, n2);
    }
}

