/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.CORBA;

import com.visigenic.vbroker.CORBA.ORB;
import com.visigenic.vbroker.CORBA.ObjectId;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Skeleton;

public class PersistentId
extends ObjectId {
    private String _repId;
    private String _objectName;
    private static boolean _backwardCompatible = true;
    private static Dictionary _bcConverterTable = new Hashtable();

    public PersistentId(ORB oRB, InputStream inputStream) {
        super(oRB);
        this._repId = inputStream.read_string();
        this._objectName = inputStream.read_string();
        this.store();
    }

    public PersistentId(ORB oRB, String string, String string2) {
        super(oRB);
        this._repId = string;
        this._objectName = string2;
        this.store();
    }

    private void store() {
        if (_backwardCompatible && this._repId.startsWith("IDL:") && this._repId.endsWith(":1.0")) {
            _bcConverterTable.put(this._orb.repIdToIdlName(this._repId), this._repId);
        }
    }

    public void write(OutputStream outputStream) {
        outputStream.write_long(0);
        outputStream.write_string(this._repId);
        outputStream.write_string(this._objectName);
    }

    public boolean isPersistent() {
        return true;
    }

    public String repId() {
        return this._repId;
    }

    public String objectName() {
        return this._objectName;
    }

    public Skeleton toSkeleton() {
        Dictionary dictionary = this._orb.persistentSkeletons();
        synchronized (dictionary) {
            Object object;
            Dictionary dictionary2 = (Dictionary)this._orb.persistentSkeletons().get(this._repId);
            if (dictionary2 == null) {
                if (_backwardCompatible && (object = (String)_bcConverterTable.get(this._repId)) != null) {
                    dictionary2 = (Dictionary)this._orb.persistentSkeletons().get(object);
                }
                if (dictionary2 == null) {
                    throw new NO_IMPLEMENT();
                }
            }
            if ((object = (Skeleton)dictionary2.get(this._objectName)) == null) {
                if (this._objectName.equals("")) {
                    dictionary2.elements();
                    try {
                        object = (Skeleton)dictionary2.elements().nextElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
                if (object == null) {
                    throw new NO_IMPLEMENT();
                }
            }
            Object object2 = object;
            Object var3_5 = null;
            return object2;
        }
    }

    public void activate(Skeleton skeleton) {
        Dictionary dictionary = this._orb.persistentSkeletons();
        synchronized (dictionary) {
            String[] stringArray = skeleton._ids();
            int n = 0;
            while (n < stringArray.length) {
                Hashtable<String, Skeleton> hashtable = (Hashtable<String, Skeleton>)this._orb.persistentSkeletons().get(stringArray[n]);
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Skeleton>();
                    this._orb.persistentSkeletons().put(stringArray[n], hashtable);
                }
                ((Dictionary)hashtable).put(this._objectName, skeleton);
                ++n;
            }
            return;
        }
    }

    public void deactivate(Skeleton skeleton) {
        Dictionary dictionary = this._orb.persistentSkeletons();
        synchronized (dictionary) {
            String[] stringArray = skeleton._ids();
            int n = 0;
            while (n < stringArray.length) {
                Dictionary dictionary2 = (Dictionary)this._orb.persistentSkeletons().get(stringArray[n]);
                if (dictionary2 == null) {
                    Object var3_6 = null;
                    return;
                }
                dictionary2.remove(this._objectName);
                ++n;
            }
            return;
        }
    }

    public String toString() {
        return "PersistentId[repId=" + this._repId + ",objectName=" + this._objectName + "]";
    }
}

