/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.PrintStream;
import netscape.application.AWTCompatibility;
import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.DebugGraphicsColorFilter;
import netscape.application.DebugGraphicsInfo;
import netscape.application.ExternalWindow;
import netscape.application.Font;
import netscape.application.Graphics;
import netscape.application.GraphicsState;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.View;

public class DebugGraphics
extends Graphics {
    static ExternalWindow debugWindow;
    public static final int LOG_OPTION = 1;
    public static final int FLASH_OPTION = 2;
    public static final int BUFFERED_OPTION = 4;
    public static final int NONE_OPTION = -1;

    public DebugGraphics(View view) {
        super(view);
        this.setDebugOptions(view.shouldDebugGraphics());
    }

    public DebugGraphics(Bitmap bitmap) {
        super(bitmap);
    }

    public static void setFlashColor(Color color) {
        DebugGraphics.info().flashColor = color;
    }

    public static Color flashColor() {
        return DebugGraphics.info().flashColor;
    }

    public static void setFlashTime(int n) {
        DebugGraphics.info().flashTime = n;
    }

    public static int flashTime() {
        return DebugGraphics.info().flashTime;
    }

    public static void setFlashCount(int n) {
        DebugGraphics.info().flashCount = n;
    }

    public static int flashCount() {
        return DebugGraphics.info().flashCount;
    }

    public static void setLogStream(PrintStream printStream) {
        DebugGraphics.info().stream = printStream;
    }

    public static PrintStream logStream() {
        return DebugGraphics.info().stream;
    }

    public void pushState() {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " -> state");
        }
        super.pushState();
    }

    public void popState() {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " <- state");
        }
        super.popState();
    }

    public void setFont(Font font) {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting font: " + font);
        }
        super.setFont(font);
    }

    public void setColor(Color color) {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting color: " + color);
        }
        super.setColor(color);
    }

    public void translate(int n, int n2) {
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Translating by: " + new Point(n, n2) + " to: " + new Point(n + graphicsState.xOffset, n2 + graphicsState.yOffset));
        }
        super.translate(n, n2);
    }

    public void setClipRect(Rect rect, boolean bl) {
        this.state();
        super.setClipRect(rect, bl);
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting clipRect: " + rect + " New clipRect: " + this.clipRect());
        }
    }

    public void setPaintMode() {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting paint mode");
        }
        super.setPaintMode();
    }

    public void setXORMode(Color color) {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting XOR mode: " + color);
        }
        super.setXORMode(color);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing rect: " + new Rect(n, n2, n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawRect(n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            Color color = graphicsState.color;
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                super.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                super.drawRect(n, n2, n3, n4);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            super.setColor(color);
        }
        super.drawRect(n, n2, n3, n4);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling rect: " + new Rect(n, n2, n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillRect(n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            Color color = graphicsState.color;
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                super.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                super.fillRect(n, n2, n3, n4);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            super.setColor(color);
        }
        super.fillRect(n, n2, n3, n4);
    }

    public void drawRoundedRect(int n, int n2, int n3, int n4, int n5, int n6) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing rounded rect: " + new Rect(n, n2, n3, n4) + " arcWidth: " + n5 + " archHeight: " + n6);
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawRoundedRect(n, n2, n3, n4, n5, n6);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            Color color = graphicsState.color;
            int n7 = debugGraphicsInfo.flashCount * 2 - 1;
            int n8 = 0;
            while (n8 < n7) {
                super.setColor(n8 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                super.drawRoundedRect(n, n2, n3, n4, n5, n6);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n8;
            }
            super.setColor(color);
        }
        super.drawRoundedRect(n, n2, n3, n4, n5, n6);
    }

    public void fillRoundedRect(int n, int n2, int n3, int n4, int n5, int n6) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing rounded rect: " + new Rect(n, n2, n3, n4) + " arcWidth: " + n5 + " archHeight: " + n6);
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillRoundedRect(n, n2, n3, n4, n5, n6);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            Color color = graphicsState.color;
            int n7 = debugGraphicsInfo.flashCount * 2 - 1;
            int n8 = 0;
            while (n8 < n7) {
                super.setColor(n8 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                super.fillRoundedRect(n, n2, n3, n4, n5, n6);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n8;
            }
            super.setColor(color);
        }
        super.fillRoundedRect(n, n2, n3, n4, n5, n6);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing line: " + new Rect(n, n2, n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawLine(n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            Color color = graphicsState.color;
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                super.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                super.drawLine(n, n2, n3, n4);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            super.setColor(color);
        }
        super.drawLine(n, n2, n3, n4);
    }

    public void drawPoint(int n, int n2) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing point: " + new Point(n, n2));
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawLine(n, n2, n, n2);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            Color color = graphicsState.color;
            int n3 = debugGraphicsInfo.flashCount * 2 - 1;
            int n4 = 0;
            while (n4 < n3) {
                super.setColor(n4 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                super.drawLine(n, n2, n, n2);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n4;
            }
            super.setColor(color);
        }
        super.drawLine(n, n2, n, n2);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing oval: " + new Rect(n, n2, n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawOval(n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            Color color = graphicsState.color;
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                super.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                super.drawOval(n, n2, n3, n4);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            super.setColor(color);
        }
        super.drawOval(n, n2, n3, n4);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling oval: " + new Rect(n, n2, n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillOval(n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            Color color = graphicsState.color;
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                super.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                super.fillOval(n, n2, n3, n4);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            super.setColor(color);
        }
        super.fillOval(n, n2, n3, n4);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing arc: " + new Rect(n, n2, n3, n4) + " startAngle: " + n5 + " arcAngle: " + n6);
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawArc(n, n2, n3, n4, n5, n6);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            Color color = graphicsState.color;
            int n7 = debugGraphicsInfo.flashCount * 2 - 1;
            int n8 = 0;
            while (n8 < n7) {
                super.setColor(n8 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                super.drawArc(n, n2, n3, n4, n5, n6);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n8;
            }
            super.setColor(color);
        }
        super.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling arc: " + new Rect(n, n2, n3, n4) + " startAngle: " + n5 + " arcAngle: " + n6);
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillArc(n, n2, n3, n4, n5, n6);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            Color color = graphicsState.color;
            int n7 = debugGraphicsInfo.flashCount * 2 - 1;
            int n8 = 0;
            while (n8 < n7) {
                super.setColor(n8 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                super.fillArc(n, n2, n3, n4, n5, n6);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n8;
            }
            super.setColor(color);
        }
        super.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing polygon: " + " nPoints: " + n + " X's: " + nArray + " Y's: " + nArray2);
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawPolygon(nArray, nArray2, n);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            Color color = graphicsState.color;
            int n2 = debugGraphicsInfo.flashCount * 2 - 1;
            int n3 = 0;
            while (n3 < n2) {
                super.setColor(n3 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                super.drawPolygon(nArray, nArray2, n);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n3;
            }
            super.setColor(color);
        }
        super.drawPolygon(nArray, nArray2, n);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling polygon: " + " nPoints: " + n + " X's: " + nArray + " Y's: " + nArray2);
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillPolygon(nArray, nArray2, n);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            Color color = graphicsState.color;
            int n2 = debugGraphicsInfo.flashCount * 2 - 1;
            int n3 = 0;
            while (n3 < n2) {
                super.setColor(n3 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                super.fillPolygon(nArray, nArray2, n);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n3;
            }
            super.setColor(color);
        }
        super.fillPolygon(nArray, nArray2, n);
    }

    public void drawBitmapAt(Bitmap bitmap, int n, int n2) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing bitmap: " + bitmap + " at: " + new Point(n, n2));
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawBitmapAt(bitmap, n, n2);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            int n3 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = AWTCompatibility.awtImageProducerForBitmap((Bitmap)bitmap);
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsColorFilter(debugGraphicsInfo.flashColor));
            Bitmap bitmap2 = AWTCompatibility.bitmapForAWTImageProducer((ImageProducer)filteredImageSource);
            int n4 = 0;
            while (n4 < n3) {
                super.drawBitmapAt(n4 % 2 == 0 ? bitmap2 : bitmap, n, n2);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n4;
            }
        }
        super.drawBitmapAt(bitmap, n, n2);
    }

    public void drawBitmapScaled(Bitmap bitmap, int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (graphicsState.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing scaled bitmap: " + bitmap + " in rect: " + new Rect(n, n2, n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (graphicsState.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawBitmapScaled(bitmap, n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (graphicsState.debugFlash()) {
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = AWTCompatibility.awtImageProducerForBitmap((Bitmap)bitmap);
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsColorFilter(debugGraphicsInfo.flashColor));
            Bitmap bitmap2 = AWTCompatibility.bitmapForAWTImageProducer((ImageProducer)filteredImageSource);
            int n6 = 0;
            while (n6 < n5) {
                super.drawBitmapScaled(n6 % 2 == 0 ? bitmap2 : bitmap, n, n2, n3, n4);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
        }
        super.drawBitmapScaled(bitmap, n, n2, n3, n4);
    }

    public void drawString(String string, int n, int n2) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (!(graphicsState.debugOptions == 0 || graphicsState.font != null && graphicsState.font.wasDownloaded())) {
            if (graphicsState.debugLog()) {
                DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing string: \"" + string + "\" at: " + new Point(n, n2));
            }
            if (this.isDrawingBuffer()) {
                if (graphicsState.debugBuffered()) {
                    Graphics graphics = this.debugGraphics();
                    graphics.drawString(string, n, n2);
                    graphics.dispose();
                }
            } else if (graphicsState.debugFlash()) {
                Color color = graphicsState.color;
                int n3 = debugGraphicsInfo.flashCount * 2 - 1;
                int n4 = 0;
                while (n4 < n3) {
                    super.setColor(n4 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                    super.drawString(string, n, n2);
                    AWTCompatibility.awtToolkit().sync();
                    this.sleep(debugGraphicsInfo.flashTime);
                    ++n4;
                }
                super.setColor(color);
            }
        }
        super.drawString(string, n, n2);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        Font font;
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (!(graphicsState.debugOptions == 0 || (font = this.font()) != null && font.wasDownloaded())) {
            if (graphicsState.debugLog()) {
                DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing bytes at: " + new Point(n3, n4));
            }
            if (this.isDrawingBuffer()) {
                if (graphicsState.debugBuffered()) {
                    Graphics graphics = this.debugGraphics();
                    graphics.drawBytes(byArray, n, n2, n3, n4);
                    graphics.dispose();
                }
            } else if (graphicsState.debugFlash()) {
                Color color = graphicsState.color;
                int n5 = debugGraphicsInfo.flashCount * 2 - 1;
                int n6 = 0;
                while (n6 < n5) {
                    super.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                    super.drawBytes(byArray, n, n2, n3, n4);
                    AWTCompatibility.awtToolkit().sync();
                    this.sleep(debugGraphicsInfo.flashTime);
                    ++n6;
                }
                super.setColor(color);
            }
        }
        super.drawBytes(byArray, n, n2, n3, n4);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        Font font;
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (!(graphicsState.debugOptions == 0 || (font = this.font()) != null && font.wasDownloaded())) {
            if (graphicsState.debugLog()) {
                DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing chars at " + new Point(n3, n4));
            }
            if (this.isDrawingBuffer()) {
                if (graphicsState.debugBuffered()) {
                    Graphics graphics = this.debugGraphics();
                    graphics.drawChars(cArray, n, n2, n3, n4);
                    graphics.dispose();
                }
            } else if (graphicsState.debugFlash()) {
                Color color = graphicsState.color;
                int n5 = debugGraphicsInfo.flashCount * 2 - 1;
                int n6 = 0;
                while (n6 < n5) {
                    super.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                    super.drawChars(cArray, n, n2, n3, n4);
                    AWTCompatibility.awtToolkit().sync();
                    this.sleep(debugGraphicsInfo.flashTime);
                    ++n6;
                }
                super.setColor(color);
            }
        }
        super.drawChars(cArray, n, n2, n3, n4);
    }

    void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Copying area from: " + new Rect(n, n2, n3, n4) + " to: " + new Point(n5, n6));
        }
        super.copyArea(n, n2, n3, n4, n5, n6);
    }

    final void sleep(int n) {
        try {
            Thread.sleep(n);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setDebugOptions(int n) {
        if (n != 0) {
            GraphicsState graphicsState = this.state();
            if (n == -1) {
                if (graphicsState.debugOptions != 0) {
                    System.err.println(String.valueOf(this.toShortString()) + " Disabling debug");
                    graphicsState.debugOptions = 0;
                    return;
                }
            } else if (graphicsState.debugOptions != n) {
                graphicsState.debugOptions |= n;
                if (graphicsState.debugLog()) {
                    System.err.println(String.valueOf(this.toShortString()) + " Enabling debug");
                }
            }
        }
    }

    public int debugOptions() {
        return this.state().debugOptions;
    }

    void setDebug(View view) {
        this.setDebugOptions(Graphics.viewDebug(view));
    }

    public int debug() {
        return this.state().debugOptions;
    }

    private Graphics debugGraphics() {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        GraphicsState graphicsState = this.state();
        if (debugGraphicsInfo.debugWindow == null) {
            debugGraphicsInfo.debugWindow = new ExternalWindow();
            debugGraphicsInfo.debugWindow.setResizable(false);
        }
        ExternalWindow externalWindow = debugGraphicsInfo.debugWindow;
        Size size = externalWindow.windowSizeForContentSize(this.primaryClipRect.width, this.primaryClipRect.height);
        Rect rect = externalWindow.bounds();
        if (rect.width > size.width) {
            size.width = rect.width;
        }
        if (rect.height > size.height) {
            size.height = rect.height;
        }
        externalWindow.sizeTo(size.width, size.height);
        externalWindow.show();
        DebugGraphics debugGraphics = new DebugGraphics(externalWindow.rootView());
        ((Graphics)debugGraphics).setFont(graphicsState.font);
        ((Graphics)debugGraphics).setColor(graphicsState.color);
        ((Graphics)debugGraphics).translate(graphicsState.xOffset, graphicsState.yOffset);
        debugGraphics.setClipRect(this.clipRect());
        if (graphicsState.debugFlash()) {
            ((Graphics)debugGraphics).setDebugOptions(2);
        }
        return debugGraphics;
    }

    static DebugGraphicsInfo info() {
        return Graphics.info();
    }
}

