/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.Rectangle;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class Polygon
implements Codable {
    public int numPoints;
    public int[] xPoints;
    public int[] yPoints;
    java.awt.Polygon awtPolygon;
    static final String XPOINTS = "xPoints";
    static final String YPOINTS = "yPoints";

    public Polygon() {
        this.awtPolygon = new java.awt.Polygon();
        this.update();
    }

    public Polygon(int[] nArray, int[] nArray2, int n) {
        this.awtPolygon = new java.awt.Polygon(nArray, nArray2, n);
        this.update();
    }

    public void addPoint(int n, int n2) {
        this.awtPolygon.addPoint(n, n2);
        this.update();
    }

    public Rect boundingRect() {
        Rectangle rectangle = this.awtPolygon.getBoundingBox();
        Rect rect = new Rect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.update();
        return rect;
    }

    public boolean containsPoint(int n, int n2) {
        boolean bl = this.awtPolygon.inside(n, n2);
        this.update();
        return bl;
    }

    public boolean containsPoint(Point point) {
        return this.containsPoint(point.x, point.y);
    }

    public void moveBy(int n, int n2) {
        int n3 = this.awtPolygon.npoints;
        while (n3-- > 0) {
            int n4 = n3;
            this.awtPolygon.xpoints[n4] = this.awtPolygon.xpoints[n4] + n;
            int n5 = n3;
            this.awtPolygon.ypoints[n5] = this.awtPolygon.ypoints[n5] + n2;
        }
    }

    private void update() {
        this.numPoints = this.awtPolygon.npoints;
        this.xPoints = this.awtPolygon.xpoints;
        this.yPoints = this.awtPolygon.ypoints;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.Polygon", 1);
        classInfo.addField(XPOINTS, (byte)9);
        classInfo.addField(YPOINTS, (byte)9);
    }

    public void encode(Encoder encoder) throws CodingException {
        if (this.numPoints == 0) {
            return;
        }
        encoder.encodeIntArray(XPOINTS, this.xPoints, 0, this.numPoints);
        encoder.encodeIntArray(YPOINTS, this.yPoints, 0, this.numPoints);
    }

    public void decode(Decoder decoder) throws CodingException {
        int[] nArray = decoder.decodeIntArray(XPOINTS);
        int[] nArray2 = decoder.decodeIntArray(YPOINTS);
        if (nArray == null || nArray.length == 0) {
            return;
        }
        this.numPoints = nArray.length;
        int n = 0;
        while (n < nArray.length) {
            this.addPoint(nArray[n], nArray2[n]);
            ++n;
        }
    }

    public void finishDecoding() throws CodingException {
    }
}

