/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.ButtonPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Button
extends Component {
    String label;
    String actionCommand;
    transient ActionListener actionListener;
    private static final String base = "button";
    private static int nameCounter;
    private static final long serialVersionUID = -8774683716313001058L;
    private int buttonSerializedDataVersion = 1;

    public Button() {
        this("");
    }

    public Button(String string) {
        this.name = base + nameCounter++;
        this.label = string;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createButton(this);
        }
        super.addNotify();
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        ButtonPeer buttonPeer = (ButtonPeer)this.peer;
        if (buttonPeer != null) {
            buttonPeer.setLabel(string);
        }
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        if (this.actionCommand == null) {
            return this.label;
        }
        return this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 1001) {
            return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",label=" + this.label;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == "actionL") {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }
}

