/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.TextField;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.awt.motif.NumericField;
import sun.awt.motif.PrintControl;
import sun.awt.motif.Separator;

class UPrintDialog
extends Dialog {
    public static final int WAITING = 0;
    public static final int PRINT = 1;
    public static final int CANCELLED = 2;
    public int printStatus = 0;
    private PrintControl printControl;
    private PrintJob printJob;
    private int destType;
    private int orientation;
    private int paperSize;
    private Label docTitle;
    private NumericField copiesField;
    private CheckboxGroup destCBG;
    private Checkbox[] destCB = new Checkbox[2];
    private TextField[] destField = new TextField[2];
    private static int FIELD_LEN = 28;
    private Label bannerLbl;
    private TextField bannerField;
    private Label optionsLbl;
    private TextField optionsField;
    private CheckboxGroup orientCBG;
    private Checkbox[] orientCB = new Checkbox[2];
    private CheckboxGroup paperCBG;
    private Checkbox[] paperCB = new Checkbox[4];
    private Button printButton;
    private Button cancelButton;
    private static final String PRINT_LABEL = new String(UPrintDialog.getMsg("button.print"));
    private static final String CANCEL_LABEL = new String(UPrintDialog.getMsg("button.cancel"));
    private static ResourceBundle messageRB;

    static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle("sun.awt.motif.resources.updialog");
            return;
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PrintDialog is missing.");
        }
    }

    static String getMsg(String string) {
        if (messageRB == null) {
            UPrintDialog.initResource();
        }
        try {
            return messageRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PrintDialog is broken, There is no " + string + " key in resource");
        }
    }

    private void addComponent(Component component, Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6, int n7, Insets insets) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.anchor = n6;
        gridBagConstraints.fill = n7;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = n4;
        gridBagConstraints.weighty = n5;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public UPrintDialog(Frame frame, String string) {
        super(frame, string, true);
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(10, 0, 0, 0);
        Insets insets3 = new Insets(8, 6, 0, 10);
        Insets insets4 = new Insets(0, 40, 0, 0);
        Insets insets5 = new Insets(10, 6, 0, 0);
        Insets insets6 = new Insets(0, 6, 10, 10);
        Insets insets7 = new Insets(0, 0, 0, 10);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        Font font = this.getFont();
        Font font2 = new Font("Dialog", 1, font.getSize());
        this.setFont(font2);
        Label label = new Label(UPrintDialog.getMsg("label.print"), 2);
        this.addComponent(label, this, gridBagLayout, gridBagConstraints, 0, 0, 1, 0, 1, 13, 0, insets2);
        this.docTitle = new Label("");
        this.docTitle.setFont(font);
        this.addComponent(this.docTitle, this, gridBagLayout, gridBagConstraints, 1, 0, 3, 1, 1, 17, 1, insets5);
        label = new Label(UPrintDialog.getMsg("label.copies"), 2);
        this.addComponent(label, this, gridBagLayout, gridBagConstraints, 0, 1, 1, 0, 1, 13, 0, insets2);
        this.copiesField = new NumericField(3);
        this.copiesField.setFont(font);
        this.addComponent(this.copiesField, this, gridBagLayout, gridBagConstraints, 1, 1, 1, 0, 1, 17, 0, insets5);
        this.setNumCopies(1);
        label = new Label(UPrintDialog.getMsg("label.printto"), 2);
        this.addComponent(label, this, gridBagLayout, gridBagConstraints, 0, 2, 1, 0, 1, 13, 0, insets2);
        this.destCBG = new CheckboxGroup();
        this.destCB[0] = new Checkbox(UPrintDialog.getMsg("checkbox.printer"), this.destCBG, true);
        this.addComponent(this.destCB[0], this, gridBagLayout, gridBagConstraints, 0, 3, 2, 0, 1, 17, 0, insets4);
        this.destField[0] = new TextField(FIELD_LEN);
        this.destField[0].setFont(font);
        this.addComponent(this.destField[0], this, gridBagLayout, gridBagConstraints, 2, 3, 2, 1, 1, 10, 2, insets7);
        this.destCB[1] = new Checkbox(UPrintDialog.getMsg("checkbox.file"), this.destCBG, false);
        this.addComponent(this.destCB[1], this, gridBagLayout, gridBagConstraints, 0, 4, 2, 0, 1, 17, 0, insets4);
        this.destField[1] = new TextField(FIELD_LEN);
        this.destField[1].setFont(font);
        this.addComponent(this.destField[1], this, gridBagLayout, gridBagConstraints, 2, 4, 2, 1, 1, 10, 2, insets7);
        this.destType = 0;
        this.destField[1].disable();
        this.bannerLbl = new Label(UPrintDialog.getMsg("label.banner"), 2);
        this.addComponent(this.bannerLbl, this, gridBagLayout, gridBagConstraints, 0, 5, 3, 0, 1, 13, 0, insets2);
        this.bannerField = new TextField(24);
        this.bannerField.setFont(font);
        this.addComponent(this.bannerField, this, gridBagLayout, gridBagConstraints, 3, 5, 1, 1, 1, 17, 2, insets3);
        this.optionsLbl = new Label(UPrintDialog.getMsg("label.commandoption"), 2);
        this.addComponent(this.optionsLbl, this, gridBagLayout, gridBagConstraints, 0, 6, 3, 0, 1, 13, 3, insets);
        this.optionsField = new TextField(24);
        this.optionsField.setFont(font);
        this.addComponent(this.optionsField, this, gridBagLayout, gridBagConstraints, 3, 6, 1, 1, 1, 17, 2, insets6);
        Separator separator = new Separator(100, 4, 0);
        this.addComponent(separator, this, gridBagLayout, gridBagConstraints, 0, 7, 4, 1, 1, 10, 2, insets);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        panel.setLayout(gridBagLayout2);
        this.addComponent(panel, this, gridBagLayout, gridBagConstraints, 0, 8, 4, 1, 1, 17, 2, insets);
        label = new Label(UPrintDialog.getMsg("label.papersize"), 2);
        this.addComponent(label, panel, gridBagLayout2, gridBagConstraints, 0, 0, 1, 1, 1, 17, 0, insets2);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(2, 2));
        this.addComponent(panel2, panel, gridBagLayout2, gridBagConstraints, 0, 1, 1, 1, 1, 10, 0, insets6);
        this.paperCBG = new CheckboxGroup();
        this.paperCB[0] = new Checkbox(UPrintDialog.getMsg("checkbox.letter"), this.paperCBG, true);
        panel2.add(this.paperCB[0]);
        this.paperCB[2] = new Checkbox(UPrintDialog.getMsg("checkbox.executive"), this.paperCBG, false);
        panel2.add(this.paperCB[2]);
        this.paperCB[1] = new Checkbox(UPrintDialog.getMsg("checkbox.legal"), this.paperCBG, false);
        panel2.add(this.paperCB[1]);
        this.paperCB[3] = new Checkbox(UPrintDialog.getMsg("checkbox.a4"), this.paperCBG, false);
        panel2.add(this.paperCB[3]);
        this.paperSize = 0;
        label = new Label(UPrintDialog.getMsg("label.orientation"), 2);
        this.addComponent(label, panel, gridBagLayout2, gridBagConstraints, 1, 0, 1, 1, 1, 17, 0, insets2);
        panel2 = new Panel();
        panel2.setLayout(new GridLayout(2, 1));
        this.addComponent(panel2, panel, gridBagLayout2, gridBagConstraints, 1, 1, 1, 1, 1, 10, 0, insets6);
        this.orientCBG = new CheckboxGroup();
        this.orientCB[1] = new Checkbox(UPrintDialog.getMsg("checkbox.portrait"), this.orientCBG, true);
        panel2.add(this.orientCB[1]);
        this.orientCB[0] = new Checkbox(UPrintDialog.getMsg("checkbox.landscape"), this.orientCBG, false);
        panel2.add(this.orientCB[0]);
        this.orientation = 1;
        separator = new Separator(100, 4, 0);
        this.addComponent(separator, this, gridBagLayout, gridBagConstraints, 0, 9, 4, 1, 0, 17, 2, insets);
        panel2 = new Panel();
        panel2.setLayout(new FlowLayout(1, 28, 10));
        this.addComponent(panel2, this, gridBagLayout, gridBagConstraints, 0, 10, 4, 1, 0, 10, 0, insets);
        this.printButton = new Button(PRINT_LABEL);
        panel2.add(this.printButton);
        this.cancelButton = new Button(CANCEL_LABEL);
        panel2.add(this.cancelButton);
        this.pack();
    }

    private void setupDestType(int n) {
        this.destField[this.destType].disable();
        this.destField[n].enable();
        if (n == 0) {
            this.bannerLbl.enable();
            this.bannerField.enable();
            this.optionsLbl.enable();
            this.optionsField.enable();
        } else {
            this.bannerLbl.disable();
            this.bannerField.disable();
            this.optionsLbl.disable();
            this.optionsField.disable();
        }
        this.destType = n;
    }

    public PrintJob getPrintJob(PrintControl printControl) {
        this.printControl = printControl;
        this.printJob = null;
        this.show();
        return this.printJob;
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Checkbox) {
            int n = 0;
            while (n < 2) {
                if (event.target == this.destCB[n]) {
                    if (n != this.destType) {
                        this.setupDestType(n);
                        this.destField[n].requestFocus();
                    }
                    return true;
                }
                ++n;
            }
            n = 0;
            while (n < 2) {
                if (event.target == this.orientCB[n]) {
                    this.orientation = n;
                    return true;
                }
                ++n;
            }
            n = 0;
            while (n < 4) {
                if (event.target == this.paperCB[n]) {
                    this.paperSize = n;
                    return true;
                }
                ++n;
            }
        }
        if (PRINT_LABEL.equals(object)) {
            this.printStatus = 1;
            this.printJob = this.printControl.createPrintJob(this.destType, this.getDestString(this.destType), this.getOptionsString(), this.getBannerString(), this.getPaperSize(), this.getOrientation(), this.getNumCopies());
            if (this.printJob != null) {
                this.hide();
            }
            return true;
        }
        if (CANCEL_LABEL.equals(object)) {
            this.printStatus = 2;
            this.hide();
            return true;
        }
        return super.action(event, object);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.printStatus = 2;
            this.hide();
            return true;
        }
        return super.handleEvent(event);
    }

    public int getNumCopies() {
        int n = 0;
        try {
            n = this.copiesField.getValue();
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public int getDestType() {
        return this.destType;
    }

    public String getDestString(int n) {
        return this.destField[n].getText();
    }

    public String getBannerString() {
        return this.bannerField.getText();
    }

    public String getOptionsString() {
        return this.optionsField.getText();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getPaperSize() {
        return this.paperSize;
    }

    public void setDocumentTitle(String string) {
        this.docTitle.setText(string);
    }

    public void setNumCopies(int n) {
        this.copiesField.setValue(n);
    }

    public void setDestType(int n) {
        if (n != this.destType) {
            this.destCB[n].setState(true);
            this.setupDestType(n);
        }
    }

    public void setDestString(int n, String string) {
        this.destField[n].setText(string);
    }

    public void setBannerString(String string) {
        this.bannerField.setText(string);
    }

    public void setOptionsString(String string) {
        this.optionsField.setText(string);
    }

    public void setOrientation(int n) {
        if (n != this.orientation) {
            this.orientation = n;
            this.orientCB[n].setState(true);
        }
    }

    public void setPaperSize(int n) {
        if (n != this.paperSize) {
            this.paperSize = n;
            this.paperCB[n].setState(true);
        }
    }
}

