/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BERIntegral;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.controls.LDAPPersistSearchControl;

public class LDAPEntryChangeControl
extends LDAPControl {
    private int m_changeNumber = -1;
    private int m_changeTypes = -1;
    private String m_previousDN;
    public static final String ENTRYCHANGED = "2.16.840.1.113730.3.4.7";

    public LDAPEntryChangeControl() {
        super(ENTRYCHANGED, false, null);
    }

    public LDAPEntryChangeControl(String string, boolean bl, byte[] byArray) throws LDAPException, IOException {
        super(ENTRYCHANGED, false, byArray);
        BERElement bERElement;
        if (!string.equals(ENTRYCHANGED)) {
            throw new LDAPException("oid must be LDAPEntryChangeControl.ENTRYCHANGED", 89);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.m_value);
        new BERSequence();
        JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
        int[] nArray = new int[]{0};
        BERSequence bERSequence = (BERSequence)BERElement.getElement(jDAPBERTagDecoder, byteArrayInputStream, nArray);
        BEREnumerated bEREnumerated = (BEREnumerated)bERSequence.elementAt(0);
        this.m_changeTypes = bEREnumerated.getValue();
        if (bERSequence.size() > 1) {
            if (bERSequence.elementAt(1) instanceof BEROctetString) {
                bERElement = (BEROctetString)bERSequence.elementAt(1);
                try {
                    this.m_previousDN = new String(((BEROctetString)bERElement).getValue(), "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else if (bERSequence.elementAt(1) instanceof BERInteger) {
                bERElement = (BERInteger)bERSequence.elementAt(1);
                this.m_changeNumber = ((BERIntegral)bERElement).getValue();
            }
        }
        if (bERSequence.size() > 2) {
            bERElement = (BERInteger)bERSequence.elementAt(2);
            this.m_changeNumber = ((BERIntegral)bERElement).getValue();
        }
    }

    public void setChangeNumber(int n) {
        this.m_changeNumber = n;
    }

    public void setChangeType(int n) {
        this.m_changeTypes = n;
    }

    public void setPreviousDN(String string) {
        this.m_previousDN = string;
    }

    public int getChangeNumber() {
        return this.m_changeNumber;
    }

    public int getChangeType() {
        return this.m_changeTypes;
    }

    public String getPreviousDN() {
        return this.m_previousDN;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{EntryChangedCtrl:");
        stringBuffer.append(" isCritical=");
        stringBuffer.append(this.isCritical());
        stringBuffer.append(" changeTypes=");
        stringBuffer.append(LDAPPersistSearchControl.typesToString(this.m_changeTypes));
        stringBuffer.append(" previousDN=");
        stringBuffer.append(this.m_previousDN);
        stringBuffer.append(" changeNumber=");
        stringBuffer.append(this.m_changeNumber);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

