/*
 * multilingual support for nvi
 * Copyright(c) 1996, 1997 by Jun-ichiro Itoh.  All rights reserved.
 * Author contact: <itojun@mt.cs.keio.ac.jp>
 * $Id: multi_eucjp.c,v 1.1.2.1 1997/09/23 00:43:48 itojun Exp $
 *
 * Freely redistributable, reusable, unless otherwise noted in accompanying
 * document. (for example, redistribution is prohibited during alpha-test
 * period)
 * Absolutely no warranty.
 *
 * The code is based on:
 *	jelvis japanization patch by Jun-ichiro Itoh
 *	nvi 1.03 japanization patch by Yoshitaka Tokugawa <toku@dit.co.jp>
 */

#include "config.h"

#ifdef MULTIBYTE

#include <sys/types.h>
#include <sys/queue.h>

#include <bitstring.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../common/common.h"
#include "multibyte.h"

#if 0
int
int_to_eucjp(sp, e, dst, pdlen, src, slen, pflags, state)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *dst;
	size_t *pdlen;
	CHAR_T *src;
	size_t slen;
	int *pflags;
	ISO2022STATE *state;
{
	CHAR_T *p;
	CHAR_T *q;
	size_t i;

	if (pflags)
		FL_INIT(*pflags, 0);
	q = dst;
	p = src;

	for (i = 0; i < slen; i++) {
		if (CS_RAW(p[0])) {
			if (dst) {
				*q++ = p[1] | 0x80;
				p += 2;
			} else {
				q++;
				p += 2;
			}
			i++;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_RAW);
			continue;
		}
		if (p[0] == CS_JISX0208_1983 || p[0] == CS_JISX0208_1978) {
			/*
			 * If we're using euc-jp, there's no distinction
			 * between JIS0208 variants.
			 */
			if (dst) {
				p++;
				*q++ = *p++ | 0x80;
				*q++ = *p++ | 0x80;
			} else {
				q += 2;
				p += 3;
			}
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}
		if (p[0] == CS_JISX0201_RIGHT) {
			if (dst) {
				p++;
				*q++ = 0x8e;
				*q++ = *p++ | 0x80;
			} else {
				q += 2;
				p += 2;
			}
			i++;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}
		if (p[0] == CS_JISX0212_1990) {
			if (dst) {
				p++;
				*q++ = 0x8f;
				*q++ = *p++ | 0x80;
				*q++ = *p++ | 0x80;
			} else {
				q += 3;
				p += 3;
			}
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}
		if (p[0] & 0x80) {
			/*
			 * Unknown encoding.  Simply skip them.
			 */
			p += charset(p[0]).blen;
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_SKIP);
			continue;
		}

		if (dst)
			*q++ = *p++;
		else {
			q++;
			p++;
		}
	}

	if (pdlen)
		*pdlen = q - dst;
	return 0;
}
#endif

int
eucjp_display(sp, e, name, p)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *name;
	CHAR_T *p;
{
	if (p[0] == CS_JISX0208_1990 || p[0] == CS_JISX0208_1983
	 || p[0] == CS_JISX0208_1978) {
		name[0] = p[1] | 0x80;
		name[1] = p[2] | 0x80;
		name[2] = '\0';
		return 1;
	}
	return 0;
}
#endif /*MULTIBYTE*/
