/*
 * multilingual support for nvi
 * Copyright(c) 1996, 1997 by Jun-ichiro Itoh.  All rights reserved.
 * Author contact: <itojun@mt.cs.keio.ac.jp>
 * $Id: multi_quail.c,v 1.1.2.1 1997/09/23 00:43:58 itojun Exp $
 *
 * Freely redistributable, reusable, unless otherwise noted in accompanying
 * document. (for example, redistribution is prohibited during alpha-test
 * period)
 * Absolutely no warranty.
 *
 * The code is based on:
 *	jelvis japanization patch by Jun-ichiro Itoh
 *	nvi 1.03 japanization patch by Yoshitaka Tokugawa <toku@dit.co.jp>
 */

#include "config.h"

#ifdef MULTIBYTE

#include <sys/types.h>
#include <sys/queue.h>

#include <bitstring.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../common/common.h"
#include "multibyte.h"

struct _dict {
	char	*name;
	CHAR_T	charset;
	char	*str;
};
typedef struct _dict DICT;

static DICT quaildict[] = {
#if 0
	/*hangul*/
	{ "r",	CS_KSC5601, "$!" },
	{ "s",	CS_KSC5601, "$$" },
	{ "e",	CS_KSC5601, "$\'" },
	{ "f",	CS_KSC5601, "$)" },
	{ "a",	CS_KSC5601, "$1" },
	{ "q",	CS_KSC5601, "$2" },
	{ "t",	CS_KSC5601, "$5" },
	{ "d",	CS_KSC5601, "$7" },
	{ "w",	CS_KSC5601, "$8" },
	{ "c",	CS_KSC5601, "$:" },
	{ "z",	CS_KSC5601, "$;" },
	{ "x",	CS_KSC5601, "$<" },
	{ "v",	CS_KSC5601, "$=" },
	{ "g",	CS_KSC5601, "$>" },

	{ "R",	CS_KSC5601, "$\"" },
	{ "E",	CS_KSC5601, "$(" },
	{ "Q",	CS_KSC5601, "$3" },
	{ "W",	CS_KSC5601, "$9" },
	{ "T",	CS_KSC5601, "$6" },
	{ "P",	CS_KSC5601, "$F" },

	{ "k",	CS_KSC5601, "$?" },
	{ "i",	CS_KSC5601, "$A" },
	{ "j",	CS_KSC5601, "$C" },
	{ "p",	CS_KSC5601, "$D" },
	{ "u",	CS_KSC5601, "$E" },
	{ "h",	CS_KSC5601, "$G" },
	{ "y",	CS_KSC5601, "$K" },
	{ "n",	CS_KSC5601, "$L" },
	{ "b",	CS_KSC5601, "$P" },
	{ "m",	CS_KSC5601, "$Q" },
	{ "l",	CS_KSC5601, "$S" },
	{ "o",	CS_KSC5601, "$@" },
	{ "O",	CS_KSC5601, "@g" },

	{ "rk",	CS_KSC5601, "0!" },
	{ "rkr",	CS_KSC5601, "0\"" },
	{ "rks",	CS_KSC5601, "0#" },
	{ "rke",	CS_KSC5601, "0$" },
	{ "rkf",	CS_KSC5601, "0%" },
	{ "rkfr",	CS_KSC5601, "0&" },
	{ "rkfa",	CS_KSC5601, "0\'" },
	{ "rka",	CS_KSC5601, "0(" },
	{ "rkq",	CS_KSC5601, "0)" },
	{ "rkqt",	CS_KSC5601, "0*" },
	{ "rkt",	CS_KSC5601, "0+" },
	{ "rkT",	CS_KSC5601, "0," },
	{ "rkd",	CS_KSC5601, "0-" },
	{ "rkw",	CS_KSC5601, "0." },
	{ "rkc",	CS_KSC5601, "0/" },
	{ "rkx",	CS_KSC5601, "00" },
	{ "rkv",	CS_KSC5601, "01" },
	{ "rkg",	CS_KSC5601, "02" },
	{ "ro",	CS_KSC5601, "03" },
	{ "ror",	CS_KSC5601, "04" },
	{ "ros",	CS_KSC5601, "05" },
	{ "rof",	CS_KSC5601, "06" },
	{ "roa",	CS_KSC5601, "07" },
	{ "roq",	CS_KSC5601, "08" },
	{ "rot",	CS_KSC5601, "09" },
	{ "roT",	CS_KSC5601, "0:" },
	{ "rod",	CS_KSC5601, "0;" },
	{ "ri",	CS_KSC5601, "0<" },
	{ "rir",	CS_KSC5601, "0=" },
	{ "ris",	CS_KSC5601, "0>" },
	{ "rif",	CS_KSC5601, "0?" },
	{ "rit",	CS_KSC5601, "0@" },
	{ "rid",	CS_KSC5601, "0A" },
	{ "rO",	CS_KSC5601, "0B" },
	{ "rOs",	CS_KSC5601, "0C" },
	{ "rOf",	CS_KSC5601, "0D" },
	{ "rj",	CS_KSC5601, "0E" },
	{ "rjr",	CS_KSC5601, "0F" },
	{ "rjs",	CS_KSC5601, "0G" },
	{ "rje",	CS_KSC5601, "0H" },
	{ "rjf",	CS_KSC5601, "0I" },
	{ "rjfa",	CS_KSC5601, "0J" },
	{ "rja",	CS_KSC5601, "0K" },
	{ "rjq",	CS_KSC5601, "0L" },
	{ "rjt",	CS_KSC5601, "0M" },
	{ "rjT",	CS_KSC5601, "0N" },
	{ "rjd",	CS_KSC5601, "0O" },
	{ "rjw",	CS_KSC5601, "0P" },
	{ "rjx",	CS_KSC5601, "0Q" },
	{ "rjv",	CS_KSC5601, "0R" },
	{ "rjg",	CS_KSC5601, "0S" },
	{ "rp",	CS_KSC5601, "0T" },
	{ "rps",	CS_KSC5601, "0U" },
	{ "rpf",	CS_KSC5601, "0V" },
	{ "rpa",	CS_KSC5601, "0W" },
	{ "rpq",	CS_KSC5601, "0X" },
	{ "rpt",	CS_KSC5601, "0Y" },
	{ "rpd",	CS_KSC5601, "0[" },
	{ "rpT",	CS_KSC5601, "0Z" },
	{ "ru",	CS_KSC5601, "0\\" },
	{ "rur",	CS_KSC5601, "0]" },
	{ "ruR",	CS_KSC5601, "0^" },
	{ "rus",	CS_KSC5601, "0_" },
	{ "rue",	CS_KSC5601, "0`" },
	{ "ruf",	CS_KSC5601, "0a" },
	{ "rua",	CS_KSC5601, "0b" },
	{ "ruq",	CS_KSC5601, "0c" },
	{ "rut",	CS_KSC5601, "0d" },
	{ "ruT",	CS_KSC5601, "0e" },
	{ "rud",	CS_KSC5601, "0f" },
	{ "rux",	CS_KSC5601, "0g" },
	{ "rP",	CS_KSC5601, "0h" },
	{ "rPs",	CS_KSC5601, "0i" },
	{ "rPf",	CS_KSC5601, "0j" },
	{ "rPq",	CS_KSC5601, "0k" },
	{ "rPt",	CS_KSC5601, "0l" },
	{ "rh",	CS_KSC5601, "0m" },
	{ "rhr",	CS_KSC5601, "0n" },
	{ "rhs",	CS_KSC5601, "0o" },
	{ "rhe",	CS_KSC5601, "0p" },
	{ "rhf",	CS_KSC5601, "0q" },
	{ "rhfa",	CS_KSC5601, "0r" },
	{ "rhft",	CS_KSC5601, "0s" },
	{ "rhfg",	CS_KSC5601, "0t" },
	{ "rha",	CS_KSC5601, "0u" },
	{ "rhq",	CS_KSC5601, "0v" },
	{ "rht",	CS_KSC5601, "0w" },
	{ "rhd",	CS_KSC5601, "0x" },
	{ "rhw",	CS_KSC5601, "0y" },
	{ "rhk",	CS_KSC5601, "0z" },
	{ "rhkr",	CS_KSC5601, "0{" },
	{ "rhks",	CS_KSC5601, "0|" },
	{ "rhkf",	CS_KSC5601, "0}" },
	{ "rhkfa",	CS_KSC5601, "0~" },
	{ "rhka",	CS_KSC5601, "1!" },
	{ "rhkq",	CS_KSC5601, "1\"" },
	{ "rhkt",	CS_KSC5601, "1#" },
	{ "rhkd",	CS_KSC5601, "1$" },
	{ "rho",	CS_KSC5601, "1%" },
	{ "rhos",	CS_KSC5601, "1&" },
	{ "rhof",	CS_KSC5601, "1\'" },
	{ "rhoq",	CS_KSC5601, "1(" },
	{ "rhoT",	CS_KSC5601, "1)" },
	{ "rhod",	CS_KSC5601, "1*" },
	{ "rhl",	CS_KSC5601, "1+" },
	{ "rhlr",	CS_KSC5601, "1," },
	{ "rhls",	CS_KSC5601, "1-" },
	{ "rhlf",	CS_KSC5601, "1." },
	{ "rhla",	CS_KSC5601, "1/" },
	{ "rhlq",	CS_KSC5601, "10" },
	{ "rhlt",	CS_KSC5601, "11" },
	{ "rhld",	CS_KSC5601, "12" },
	{ "ry",	CS_KSC5601, "13" },
	{ "rys",	CS_KSC5601, "14" },
	{ "ryf",	CS_KSC5601, "15" },
	{ "ryq",	CS_KSC5601, "16" },
	{ "ryt",	CS_KSC5601, "17" },
	{ "rn",	CS_KSC5601, "18" },
	{ "rnr",	CS_KSC5601, "19" },
	{ "rns",	CS_KSC5601, "1:" },
	{ "rne",	CS_KSC5601, "1;" },
	{ "rnf",	CS_KSC5601, "1<" },
	{ "rnfr",	CS_KSC5601, "1=" },
	{ "rnfa",	CS_KSC5601, "1>" },
	{ "rnfg",	CS_KSC5601, "1?" },
	{ "rna",	CS_KSC5601, "1@" },
	{ "rnq",	CS_KSC5601, "1A" },
	{ "rnt",	CS_KSC5601, "1B" },
	{ "rnd",	CS_KSC5601, "1C" },
	{ "rnw",	CS_KSC5601, "1D" },
	{ "rnj",	CS_KSC5601, "1E" },
	{ "rnjr",	CS_KSC5601, "1F" },
	{ "rnjs",	CS_KSC5601, "1G" },
	{ "rnjf",	CS_KSC5601, "1H" },
	{ "rnjT",	CS_KSC5601, "1I" },
	{ "rnjd",	CS_KSC5601, "1J" },
	{ "rnp",	CS_KSC5601, "1K" },
	{ "rnpt",	CS_KSC5601, "1L" },
	{ "rnl",	CS_KSC5601, "1M" },
	{ "rnlr",	CS_KSC5601, "1N" },
	{ "rnls",	CS_KSC5601, "1O" },
	{ "rnlf",	CS_KSC5601, "1P" },
	{ "rnla",	CS_KSC5601, "1Q" },
	{ "rnlq",	CS_KSC5601, "1R" },
	{ "rnlt",	CS_KSC5601, "1S" },
	{ "rb",	CS_KSC5601, "1T" },
	{ "rbs",	CS_KSC5601, "1U" },
	{ "rbf",	CS_KSC5601, "1V" },
	{ "rm",	CS_KSC5601, "1W" },
	{ "rmr",	CS_KSC5601, "1X" },
	{ "rms",	CS_KSC5601, "1Y" },
	{ "rme",	CS_KSC5601, "1Z" },
	{ "rmf",	CS_KSC5601, "1[" },
	{ "rmfr",	CS_KSC5601, "1\\" },
	{ "rma",	CS_KSC5601, "1]" },
	{ "rmq",	CS_KSC5601, "1^" },
	{ "rmt",	CS_KSC5601, "1_" },
	{ "rmd",	CS_KSC5601, "1`" },
	{ "rml",	CS_KSC5601, "1a" },
	{ "rl",	CS_KSC5601, "1b" },
	{ "rlr",	CS_KSC5601, "1c" },
	{ "rls",	CS_KSC5601, "1d" },
	{ "rle",	CS_KSC5601, "1e" },
	{ "rlf",	CS_KSC5601, "1f" },
	{ "rlfa",	CS_KSC5601, "1g" },
	{ "rla",	CS_KSC5601, "1h" },
	{ "rlq",	CS_KSC5601, "1i" },
	{ "rlt",	CS_KSC5601, "1j" },
	{ "rld",	CS_KSC5601, "1k" },
	{ "rlw",	CS_KSC5601, "1l" },
	{ "rlv",	CS_KSC5601, "1m" },
	{ "Rk",	CS_KSC5601, "1n" },
	{ "Rkr",	CS_KSC5601, "1o" },
	{ "RkR",	CS_KSC5601, "1p" },
	{ "Rks",	CS_KSC5601, "1q" },
	{ "Rkf",	CS_KSC5601, "1r" },
	{ "Rkfa",	CS_KSC5601, "1s" },
	{ "Rka",	CS_KSC5601, "1t" },
	{ "Rkq",	CS_KSC5601, "1u" },
	{ "Rkt",	CS_KSC5601, "1v" },
	{ "RkT",	CS_KSC5601, "1w" },
	{ "Rkd",	CS_KSC5601, "1x" },
	{ "Rkx",	CS_KSC5601, "1y" },
	{ "Ro",	CS_KSC5601, "1z" },
	{ "Ror",	CS_KSC5601, "1{" },
	{ "Ros",	CS_KSC5601, "1|" },
	{ "Rof",	CS_KSC5601, "1}" },
	{ "Roa",	CS_KSC5601, "1~" },
	{ "Roq",	CS_KSC5601, "2!" },
	{ "Rot",	CS_KSC5601, "2\"" },
	{ "RoT",	CS_KSC5601, "2#" },
	{ "Rod",	CS_KSC5601, "2$" },
	{ "Ri",	CS_KSC5601, "2%" },
	{ "Rir",	CS_KSC5601, "2&" },
	{ "Rif",	CS_KSC5601, "2\'" },
	{ "Rj",	CS_KSC5601, "2(" },
	{ "Rjr",	CS_KSC5601, "2)" },
	{ "RjR",	CS_KSC5601, "2*" },
	{ "Rjs",	CS_KSC5601, "2+" },
	{ "Rjf",	CS_KSC5601, "2," },
	{ "Rja",	CS_KSC5601, "2-" },
	{ "Rjq",	CS_KSC5601, "2." },
	{ "Rjt",	CS_KSC5601, "2/" },
	{ "RjT",	CS_KSC5601, "20" },
	{ "Rjd",	CS_KSC5601, "21" },
	{ "Rp",	CS_KSC5601, "22" },
	{ "Rpr",	CS_KSC5601, "23" },
	{ "Rps",	CS_KSC5601, "24" },
	{ "Rpa",	CS_KSC5601, "25" },
	{ "Rpt",	CS_KSC5601, "26" },
	{ "Rpd",	CS_KSC5601, "27" },
	{ "Ru",	CS_KSC5601, "28" },
	{ "Rus",	CS_KSC5601, "29" },
	{ "Ruf",	CS_KSC5601, "2:" },
	{ "Rut",	CS_KSC5601, "2;" },
	{ "RuT",	CS_KSC5601, "2<" },
	{ "Rux",	CS_KSC5601, "2=" },
	{ "RP",	CS_KSC5601, "2>" },
	{ "Rh",	CS_KSC5601, "2?" },
	{ "Rhr",	CS_KSC5601, "2@" },
	{ "Rhs",	CS_KSC5601, "2A" },
	{ "Rhsg",	CS_KSC5601, "2B" },
	{ "Rhf",	CS_KSC5601, "2C" },
	{ "Rha",	CS_KSC5601, "2D" },
	{ "Rhq",	CS_KSC5601, "2E" },
	{ "Rht",	CS_KSC5601, "2F" },
	{ "Rhd",	CS_KSC5601, "2G" },
	{ "Rhw",	CS_KSC5601, "2H" },
	{ "Rhc",	CS_KSC5601, "2I" },
	{ "Rhk",	CS_KSC5601, "2J" },
	{ "Rhkr",	CS_KSC5601, "2K" },
	{ "Rhkf",	CS_KSC5601, "2L" },
	{ "RhkT",	CS_KSC5601, "2M" },
	{ "Rhkd",	CS_KSC5601, "2N" },
	{ "Rho",	CS_KSC5601, "2O" },
	{ "Rhor",	CS_KSC5601, "2P" },
	{ "Rhod",	CS_KSC5601, "2Q" },
	{ "Rhl",	CS_KSC5601, "2R" },
	{ "Rhls",	CS_KSC5601, "2S" },
	{ "Rhlf",	CS_KSC5601, "2T" },
	{ "Rhla",	CS_KSC5601, "2U" },
	{ "Rhlq",	CS_KSC5601, "2V" },
	{ "Rhld",	CS_KSC5601, "2W" },
	{ "Ry",	CS_KSC5601, "2X" },
	{ "Rn",	CS_KSC5601, "2Y" },
	{ "Rnr",	CS_KSC5601, "2Z" },
	{ "Rns",	CS_KSC5601, "2[" },
	{ "Rnf",	CS_KSC5601, "2\\" },
	{ "Rnfg",	CS_KSC5601, "2]" },
	{ "Rna",	CS_KSC5601, "2^" },
	{ "Rnq",	CS_KSC5601, "2_" },
	{ "Rnt",	CS_KSC5601, "2`" },
	{ "Rnd",	CS_KSC5601, "2a" },
	{ "Rnw",	CS_KSC5601, "2b" },
	{ "Rnj",	CS_KSC5601, "2c" },
	{ "Rnjf",	CS_KSC5601, "2d" },
	{ "RnjT",	CS_KSC5601, "2e" },
	{ "Rnjd",	CS_KSC5601, "2f" },
	{ "Rnp",	CS_KSC5601, "2g" },
	{ "Rnpr",	CS_KSC5601, "2h" },
	{ "Rnps",	CS_KSC5601, "2i" },
	{ "Rnpf",	CS_KSC5601, "2j" },
	{ "Rnpa",	CS_KSC5601, "2k" },
	{ "Rnpq",	CS_KSC5601, "2l" },
	{ "RnpT",	CS_KSC5601, "2m" },
	{ "Rnl",	CS_KSC5601, "2n" },
	{ "Rnls",	CS_KSC5601, "2o" },
	{ "Rnlf",	CS_KSC5601, "2p" },
	{ "Rnla",	CS_KSC5601, "2q" },
	{ "Rnlq",	CS_KSC5601, "2r" },
	{ "Rb",	CS_KSC5601, "2s" },
	{ "Rm",	CS_KSC5601, "2t" },
	{ "Rmr",	CS_KSC5601, "2u" },
	{ "Rms",	CS_KSC5601, "2v" },
	{ "Rmsg",	CS_KSC5601, "2w" },
	{ "Rmf",	CS_KSC5601, "2x" },
	{ "Rmfa",	CS_KSC5601, "2y" },
	{ "Rmfg",	CS_KSC5601, "2z" },
	{ "Rma",	CS_KSC5601, "2{" },
	{ "Rmq",	CS_KSC5601, "2|" },
	{ "Rmt",	CS_KSC5601, "2}" },
	{ "Rmd",	CS_KSC5601, "2~" },
	{ "Rmx",	CS_KSC5601, "3!" },
	{ "Rl",	CS_KSC5601, "3\"" },
	{ "Rlr",	CS_KSC5601, "3#" },
	{ "Rls",	CS_KSC5601, "3$" },
	{ "Rlf",	CS_KSC5601, "3%" },
	{ "Rla",	CS_KSC5601, "3&" },
	{ "Rlq",	CS_KSC5601, "3\'" },
	{ "Rlt",	CS_KSC5601, "3(" },
	{ "Rld",	CS_KSC5601, "3)" },
	{ "sk",	CS_KSC5601, "3*" },
	{ "skr",	CS_KSC5601, "3+" },
	{ "skR",	CS_KSC5601, "3," },
	{ "sks",	CS_KSC5601, "3-" },
	{ "ske",	CS_KSC5601, "3." },
	{ "skf",	CS_KSC5601, "3/" },
	{ "skfr",	CS_KSC5601, "30" },
	{ "skfa",	CS_KSC5601, "31" },
	{ "ska",	CS_KSC5601, "32" },
	{ "skq",	CS_KSC5601, "33" },
	{ "skt",	CS_KSC5601, "34" },
	{ "skT",	CS_KSC5601, "35" },
	{ "skd",	CS_KSC5601, "36" },
	{ "skw",	CS_KSC5601, "37" },
	{ "skc",	CS_KSC5601, "38" },
	{ "skx",	CS_KSC5601, "39" },
	{ "skg",	CS_KSC5601, "3:" },
	{ "so",	CS_KSC5601, "3;" },
	{ "sor",	CS_KSC5601, "3<" },
	{ "sos",	CS_KSC5601, "3=" },
	{ "sof",	CS_KSC5601, "3>" },
	{ "soa",	CS_KSC5601, "3?" },
	{ "soq",	CS_KSC5601, "3@" },
	{ "sot",	CS_KSC5601, "3A" },
	{ "soT",	CS_KSC5601, "3B" },
	{ "sod",	CS_KSC5601, "3C" },
	{ "si",	CS_KSC5601, "3D" },
	{ "sir",	CS_KSC5601, "3E" },
	{ "sis",	CS_KSC5601, "3F" },
	{ "sif",	CS_KSC5601, "3G" },
	{ "sia",	CS_KSC5601, "3H" },
	{ "sid",	CS_KSC5601, "3I" },
	{ "sj",	CS_KSC5601, "3J" },
	{ "sjr",	CS_KSC5601, "3K" },
	{ "sjrt",	CS_KSC5601, "3L" },
	{ "sjs",	CS_KSC5601, "3M" },
	{ "sjf",	CS_KSC5601, "3N" },
	{ "sjfa",	CS_KSC5601, "3O" },
	{ "sjfq",	CS_KSC5601, "3P" },
	{ "sja",	CS_KSC5601, "3Q" },
	{ "sjq",	CS_KSC5601, "3R" },
	{ "sjt",	CS_KSC5601, "3S" },
	{ "sjT",	CS_KSC5601, "3T" },
	{ "sjd",	CS_KSC5601, "3U" },
	{ "sjg",	CS_KSC5601, "3V" },
	{ "sp",	CS_KSC5601, "3W" },
	{ "spr",	CS_KSC5601, "3X" },
	{ "sps",	CS_KSC5601, "3Y" },
	{ "spf",	CS_KSC5601, "3Z" },
	{ "spa",	CS_KSC5601, "3[" },
	{ "spq",	CS_KSC5601, "3\\" },
	{ "spt",	CS_KSC5601, "3]" },
	{ "spT",	CS_KSC5601, "3^" },
	{ "spd",	CS_KSC5601, "3_" },
	{ "su",	CS_KSC5601, "3`" },
	{ "sur",	CS_KSC5601, "3a" },
	{ "sus",	CS_KSC5601, "3b" },
	{ "suf",	CS_KSC5601, "3c" },
	{ "sua",	CS_KSC5601, "3d" },
	{ "suq",	CS_KSC5601, "3e" },
	{ "suT",	CS_KSC5601, "3f" },
	{ "sud",	CS_KSC5601, "3g" },
	{ "suz",	CS_KSC5601, "3h" },
	{ "sP",	CS_KSC5601, "3i" },
	{ "sPs",	CS_KSC5601, "3j" },
	{ "sh",	CS_KSC5601, "3k" },
	{ "shr",	CS_KSC5601, "3l" },
	{ "shs",	CS_KSC5601, "3m" },
	{ "shf",	CS_KSC5601, "3n" },
	{ "shfa",	CS_KSC5601, "3o" },
	{ "sha",	CS_KSC5601, "3p" },
	{ "shq",	CS_KSC5601, "3q" },
	{ "sht",	CS_KSC5601, "3r" },
	{ "shd",	CS_KSC5601, "3s" },
	{ "shv",	CS_KSC5601, "3t" },
	{ "shg",	CS_KSC5601, "3u" },
	{ "shk",	CS_KSC5601, "3v" },
	{ "shks",	CS_KSC5601, "3w" },
	{ "shkf",	CS_KSC5601, "3x" },
	{ "shkT",	CS_KSC5601, "3y" },
	{ "shl",	CS_KSC5601, "3z" },
	{ "shls",	CS_KSC5601, "3{" },
	{ "shlf",	CS_KSC5601, "3|" },
	{ "shla",	CS_KSC5601, "3}" },
	{ "shlq",	CS_KSC5601, "3~" },
	{ "shlt",	CS_KSC5601, "4!" },
	{ "sy",	CS_KSC5601, "4\"" },
	{ "syr",	CS_KSC5601, "4#" },
	{ "sys",	CS_KSC5601, "4$" },
	{ "syf",	CS_KSC5601, "4%" },
	{ "syq",	CS_KSC5601, "4&" },
	{ "syt",	CS_KSC5601, "4\'" },
	{ "syd",	CS_KSC5601, "4(" },
	{ "sn",	CS_KSC5601, "4)" },
	{ "snr",	CS_KSC5601, "4*" },
	{ "sns",	CS_KSC5601, "4+" },
	{ "sne",	CS_KSC5601, "4," },
	{ "snf",	CS_KSC5601, "4-" },
	{ "sna",	CS_KSC5601, "4." },
	{ "snq",	CS_KSC5601, "4/" },
	{ "snt",	CS_KSC5601, "40" },
	{ "snd",	CS_KSC5601, "41" },
	{ "snj",	CS_KSC5601, "42" },
	{ "snjT",	CS_KSC5601, "43" },
	{ "snp",	CS_KSC5601, "44" },
	{ "snl",	CS_KSC5601, "45" },
	{ "snls",	CS_KSC5601, "46" },
	{ "snlf",	CS_KSC5601, "47" },
	{ "snla",	CS_KSC5601, "48" },
	{ "snlq",	CS_KSC5601, "49" },
	{ "sb",	CS_KSC5601, "4:" },
	{ "sbr",	CS_KSC5601, "4;" },
	{ "sbf",	CS_KSC5601, "4<" },
	{ "sba",	CS_KSC5601, "4=" },
	{ "sbq",	CS_KSC5601, "4>" },
	{ "sbd",	CS_KSC5601, "4?" },
	{ "sm",	CS_KSC5601, "4@" },
	{ "smr",	CS_KSC5601, "4A" },
	{ "sms",	CS_KSC5601, "4B" },
	{ "smf",	CS_KSC5601, "4C" },
	{ "smfr",	CS_KSC5601, "4D" },
	{ "smfa",	CS_KSC5601, "4E" },
	{ "sma",	CS_KSC5601, "4F" },
	{ "smq",	CS_KSC5601, "4G" },
	{ "smt",	CS_KSC5601, "4H" },
	{ "smd",	CS_KSC5601, "4I" },
	{ "smw",	CS_KSC5601, "4J" },
	{ "smv",	CS_KSC5601, "4K" },
	{ "sml",	CS_KSC5601, "4L" },
	{ "smls",	CS_KSC5601, "4M" },
	{ "smlf",	CS_KSC5601, "4N" },
	{ "sl",	CS_KSC5601, "4O" },
	{ "slr",	CS_KSC5601, "4P" },
	{ "sls",	CS_KSC5601, "4Q" },
	{ "slf",	CS_KSC5601, "4R" },
	{ "slfa",	CS_KSC5601, "4S" },
	{ "sla",	CS_KSC5601, "4T" },
	{ "slq",	CS_KSC5601, "4U" },
	{ "slt",	CS_KSC5601, "4V" },
	{ "sld",	CS_KSC5601, "4W" },
	{ "slv",	CS_KSC5601, "4X" },
	{ "ek",	CS_KSC5601, "4Y" },
	{ "ekr",	CS_KSC5601, "4Z" },
	{ "ekR",	CS_KSC5601, "4[" },
	{ "eks",	CS_KSC5601, "4\\" },
	{ "eke",	CS_KSC5601, "4]" },
	{ "ekf",	CS_KSC5601, "4^" },
	{ "ekfr",	CS_KSC5601, "4_" },
	{ "ekfa",	CS_KSC5601, "4`" },
	{ "ekfq",	CS_KSC5601, "4a" },
	{ "ekfg",	CS_KSC5601, "4b" },
	{ "eka",	CS_KSC5601, "4c" },
	{ "ekq",	CS_KSC5601, "4d" },
	{ "ekt",	CS_KSC5601, "4e" },
	{ "ekT",	CS_KSC5601, "4f" },
	{ "ekd",	CS_KSC5601, "4g" },
	{ "ekw",	CS_KSC5601, "4h" },
	{ "ekc",	CS_KSC5601, "4i" },
	{ "ekg",	CS_KSC5601, "4j" },
	{ "eo",	CS_KSC5601, "4k" },
	{ "eor",	CS_KSC5601, "4l" },
	{ "eos",	CS_KSC5601, "4m" },
	{ "eof",	CS_KSC5601, "4n" },
	{ "eoa",	CS_KSC5601, "4o" },
	{ "eoq",	CS_KSC5601, "4p" },
	{ "eot",	CS_KSC5601, "4q" },
	{ "eoT",	CS_KSC5601, "4r" },
	{ "eod",	CS_KSC5601, "4s" },
	{ "ei",	CS_KSC5601, "4t" },
	{ "ej",	CS_KSC5601, "4u" },
	{ "ejr",	CS_KSC5601, "4v" },
	{ "ejR",	CS_KSC5601, "4w" },
	{ "ejs",	CS_KSC5601, "4x" },
	{ "eje",	CS_KSC5601, "4y" },
	{ "ejf",	CS_KSC5601, "4z" },
	{ "ejfa",	CS_KSC5601, "4{" },
	{ "ejfq",	CS_KSC5601, "4|" },
	{ "eja",	CS_KSC5601, "4}" },
	{ "ejq",	CS_KSC5601, "4~" },
	{ "ejt",	CS_KSC5601, "5!" },
	{ "ejd",	CS_KSC5601, "5\"" },
	{ "ejc",	CS_KSC5601, "5#" },
	{ "ejv",	CS_KSC5601, "5$" },
	{ "ep",	CS_KSC5601, "5%" },
	{ "epr",	CS_KSC5601, "5&" },
	{ "eps",	CS_KSC5601, "5\'" },
	{ "epf",	CS_KSC5601, "5(" },
	{ "epa",	CS_KSC5601, "5)" },
	{ "epq",	CS_KSC5601, "5*" },
	{ "ept",	CS_KSC5601, "5+" },
	{ "epT",	CS_KSC5601, "5," },
	{ "epd",	CS_KSC5601, "5-" },
	{ "eu",	CS_KSC5601, "5." },
	{ "eus",	CS_KSC5601, "5/" },
	{ "euf",	CS_KSC5601, "50" },
	{ "euT",	CS_KSC5601, "51" },
	{ "eud",	CS_KSC5601, "52" },
	{ "eP",	CS_KSC5601, "53" },
	{ "ePs",	CS_KSC5601, "54" },
	{ "eh",	CS_KSC5601, "55" },
	{ "ehr",	CS_KSC5601, "56" },
	{ "ehs",	CS_KSC5601, "57" },
	{ "ehe",	CS_KSC5601, "58" },
	{ "ehf",	CS_KSC5601, "59" },
	{ "ehfa",	CS_KSC5601, "5:" },
	{ "ehft",	CS_KSC5601, "5;" },
	{ "eha",	CS_KSC5601, "5<" },
	{ "ehq",	CS_KSC5601, "5=" },
	{ "eht",	CS_KSC5601, "5>" },
	{ "ehd",	CS_KSC5601, "5?" },
	{ "ehc",	CS_KSC5601, "5@" },
	{ "ehx",	CS_KSC5601, "5A" },
	{ "ehk",	CS_KSC5601, "5B" },
	{ "ehks",	CS_KSC5601, "5C" },
	{ "ehkf",	CS_KSC5601, "5D" },
	{ "eho",	CS_KSC5601, "5E" },
	{ "ehoT",	CS_KSC5601, "5F" },
	{ "ehl",	CS_KSC5601, "5G" },
	{ "ehls",	CS_KSC5601, "5H" },
	{ "ehlf",	CS_KSC5601, "5I" },
	{ "ehla",	CS_KSC5601, "5J" },
	{ "ehlq",	CS_KSC5601, "5K" },
	{ "ehlt",	CS_KSC5601, "5L" },
	{ "ey",	CS_KSC5601, "5M" },
	{ "en",	CS_KSC5601, "5N" },
	{ "enr",	CS_KSC5601, "5O" },
	{ "ens",	CS_KSC5601, "5P" },
	{ "enf",	CS_KSC5601, "5Q" },
	{ "ena",	CS_KSC5601, "5R" },
	{ "enq",	CS_KSC5601, "5S" },
	{ "ent",	CS_KSC5601, "5T" },
	{ "end",	CS_KSC5601, "5U" },
	{ "enj",	CS_KSC5601, "5V" },
	{ "enjT",	CS_KSC5601, "5W" },
	{ "enp",	CS_KSC5601, "5X" },
	{ "enpd",	CS_KSC5601, "5Y" },
	{ "enl",	CS_KSC5601, "5Z" },
	{ "enls",	CS_KSC5601, "5[" },
	{ "enlf",	CS_KSC5601, "5\\" },
	{ "enlq",	CS_KSC5601, "5]" },
	{ "enlt",	CS_KSC5601, "5^" },
	{ "enld",	CS_KSC5601, "5_" },
	{ "eb",	CS_KSC5601, "5`" },
	{ "ebs",	CS_KSC5601, "5a" },
	{ "ebf",	CS_KSC5601, "5b" },
	{ "eba",	CS_KSC5601, "5c" },
	{ "ebd",	CS_KSC5601, "5d" },
	{ "em",	CS_KSC5601, "5e" },
	{ "emr",	CS_KSC5601, "5f" },
	{ "ems",	CS_KSC5601, "5g" },
	{ "eme",	CS_KSC5601, "5h" },
	{ "emf",	CS_KSC5601, "5i" },
	{ "emfa",	CS_KSC5601, "5j" },
	{ "ema",	CS_KSC5601, "5k" },
	{ "emq",	CS_KSC5601, "5l" },
	{ "emt",	CS_KSC5601, "5m" },
	{ "emd",	CS_KSC5601, "5n" },
	{ "eml",	CS_KSC5601, "5o" },
	{ "el",	CS_KSC5601, "5p" },
	{ "elr",	CS_KSC5601, "5q" },
	{ "els",	CS_KSC5601, "5r" },
	{ "ele",	CS_KSC5601, "5s" },
	{ "elf",	CS_KSC5601, "5t" },
	{ "ela",	CS_KSC5601, "5u" },
	{ "elq",	CS_KSC5601, "5v" },
	{ "elt",	CS_KSC5601, "5w" },
	{ "elT",	CS_KSC5601, "5x" },
	{ "eld",	CS_KSC5601, "5y" },
	{ "elw",	CS_KSC5601, "5z" },
	{ "Ek",	CS_KSC5601, "5{" },
	{ "Ekr",	CS_KSC5601, "5|" },
	{ "Eks",	CS_KSC5601, "5}" },
	{ "Ekf",	CS_KSC5601, "5~" },
	{ "Eka",	CS_KSC5601, "6!" },
	{ "Ekq",	CS_KSC5601, "6\"" },
	{ "Ekt",	CS_KSC5601, "6#" },
	{ "EkT",	CS_KSC5601, "6$" },
	{ "Ekd",	CS_KSC5601, "6%" },
	{ "Ekg",	CS_KSC5601, "6&" },
	{ "Eo",	CS_KSC5601, "6\'" },
	{ "Eor",	CS_KSC5601, "6(" },
	{ "Eos",	CS_KSC5601, "6)" },
	{ "Eof",	CS_KSC5601, "6*" },
	{ "Eoa",	CS_KSC5601, "6+" },
	{ "Eoq",	CS_KSC5601, "6," },
	{ "Eot",	CS_KSC5601, "6-" },
	{ "EoT",	CS_KSC5601, "6." },
	{ "Eod",	CS_KSC5601, "6/" },
	{ "Ej",	CS_KSC5601, "60" },
	{ "Ejr",	CS_KSC5601, "61" },
	{ "Ejs",	CS_KSC5601, "62" },
	{ "Ejf",	CS_KSC5601, "63" },
	{ "Ejfa",	CS_KSC5601, "64" },
	{ "Ejfq",	CS_KSC5601, "65" },
	{ "Eja",	CS_KSC5601, "66" },
	{ "Ejq",	CS_KSC5601, "67" },
	{ "Ejt",	CS_KSC5601, "68" },
	{ "EjT",	CS_KSC5601, "69" },
	{ "Ejd",	CS_KSC5601, "6:" },
	{ "Ejg",	CS_KSC5601, "6;" },
	{ "Ep",	CS_KSC5601, "6<" },
	{ "Epr",	CS_KSC5601, "6=" },
	{ "Eps",	CS_KSC5601, "6>" },
	{ "Epf",	CS_KSC5601, "6?" },
	{ "Epa",	CS_KSC5601, "6@" },
	{ "Epq",	CS_KSC5601, "6A" },
	{ "Ept",	CS_KSC5601, "6B" },
	{ "EpT",	CS_KSC5601, "6C" },
	{ "Epd",	CS_KSC5601, "6D" },
	{ "Eu",	CS_KSC5601, "6E" },
	{ "EuT",	CS_KSC5601, "6F" },
	{ "Eh",	CS_KSC5601, "6G" },
	{ "Ehr",	CS_KSC5601, "6H" },
	{ "Ehs",	CS_KSC5601, "6I" },
	{ "Ehf",	CS_KSC5601, "6J" },
	{ "Ehd",	CS_KSC5601, "6K" },
	{ "Ehk",	CS_KSC5601, "6L" },
	{ "Ehkf",	CS_KSC5601, "6M" },
	{ "Eho",	CS_KSC5601, "6N" },
	{ "Ehl",	CS_KSC5601, "6O" },
	{ "Ehls",	CS_KSC5601, "6P" },
	{ "En",	CS_KSC5601, "6Q" },
	{ "Enr",	CS_KSC5601, "6R" },
	{ "Ens",	CS_KSC5601, "6S" },
	{ "Enf",	CS_KSC5601, "6T" },
	{ "Enfg",	CS_KSC5601, "6U" },
	{ "Ena",	CS_KSC5601, "6V" },
	{ "End",	CS_KSC5601, "6W" },
	{ "Enp",	CS_KSC5601, "6X" },
	{ "Enl",	CS_KSC5601, "6Y" },
	{ "Enls",	CS_KSC5601, "6Z" },
	{ "Enlf",	CS_KSC5601, "6[" },
	{ "Enla",	CS_KSC5601, "6\\" },
	{ "Enlq",	CS_KSC5601, "6]" },
	{ "Enld",	CS_KSC5601, "6^" },
	{ "Em",	CS_KSC5601, "6_" },
	{ "Emr",	CS_KSC5601, "6`" },
	{ "Ems",	CS_KSC5601, "6a" },
	{ "Eme",	CS_KSC5601, "6b" },
	{ "Emf",	CS_KSC5601, "6c" },
	{ "Ema",	CS_KSC5601, "6d" },
	{ "Emq",	CS_KSC5601, "6e" },
	{ "Emt",	CS_KSC5601, "6f" },
	{ "Eml",	CS_KSC5601, "6g" },
	{ "Emls",	CS_KSC5601, "6h" },
	{ "Emlf",	CS_KSC5601, "6i" },
	{ "Emla",	CS_KSC5601, "6j" },
	{ "Emlq",	CS_KSC5601, "6k" },
	{ "El",	CS_KSC5601, "6l" },
	{ "Els",	CS_KSC5601, "6m" },
	{ "Elf",	CS_KSC5601, "6n" },
	{ "Ela",	CS_KSC5601, "6o" },
	{ "Elq",	CS_KSC5601, "6p" },
	{ "Elt",	CS_KSC5601, "6q" },
	{ "Eld",	CS_KSC5601, "6r" },
	{ "fk",	CS_KSC5601, "6s" },
	{ "fkr",	CS_KSC5601, "6t" },
	{ "fks",	CS_KSC5601, "6u" },
	{ "fkf",	CS_KSC5601, "6v" },
	{ "fka",	CS_KSC5601, "6w" },
	{ "fkq",	CS_KSC5601, "6x" },
	{ "fkt",	CS_KSC5601, "6y" },
	{ "fkT",	CS_KSC5601, "6z" },
	{ "fkd",	CS_KSC5601, "6{" },
	{ "fkw",	CS_KSC5601, "6|" },
	{ "fkv",	CS_KSC5601, "6}" },
	{ "fkg",	CS_KSC5601, "6~" },
	{ "fo",	CS_KSC5601, "7!" },
	{ "for",	CS_KSC5601, "7\"" },
	{ "fos",	CS_KSC5601, "7#" },
	{ "fof",	CS_KSC5601, "7$" },
	{ "foa",	CS_KSC5601, "7%" },
	{ "foq",	CS_KSC5601, "7&" },
	{ "fot",	CS_KSC5601, "7\'" },
	{ "foT",	CS_KSC5601, "7(" },
	{ "fod",	CS_KSC5601, "7)" },
	{ "fi",	CS_KSC5601, "7*" },
	{ "fir",	CS_KSC5601, "7+" },
	{ "fis",	CS_KSC5601, "7," },
	{ "fit",	CS_KSC5601, "7-" },
	{ "fid",	CS_KSC5601, "7." },
	{ "fj",	CS_KSC5601, "7/" },
	{ "fjr",	CS_KSC5601, "70" },
	{ "fjs",	CS_KSC5601, "71" },
	{ "fjf",	CS_KSC5601, "72" },
	{ "fja",	CS_KSC5601, "73" },
	{ "fjq",	CS_KSC5601, "74" },
	{ "fjt",	CS_KSC5601, "75" },
	{ "fjT",	CS_KSC5601, "76" },
	{ "fjd",	CS_KSC5601, "77" },
	{ "fjg",	CS_KSC5601, "78" },
	{ "fp",	CS_KSC5601, "79" },
	{ "fpr",	CS_KSC5601, "7:" },
	{ "fps",	CS_KSC5601, "7;" },
	{ "fpf",	CS_KSC5601, "7<" },
	{ "fpa",	CS_KSC5601, "7=" },
	{ "fpq",	CS_KSC5601, "7>" },
	{ "fpt",	CS_KSC5601, "7?" },
	{ "fpd",	CS_KSC5601, "7@" },
	{ "fu",	CS_KSC5601, "7A" },
	{ "fur",	CS_KSC5601, "7B" },
	{ "fus",	CS_KSC5601, "7C" },
	{ "fuf",	CS_KSC5601, "7D" },
	{ "fua",	CS_KSC5601, "7E" },
	{ "fuq",	CS_KSC5601, "7F" },
	{ "fut",	CS_KSC5601, "7G" },
	{ "fuT",	CS_KSC5601, "7H" },
	{ "fud",	CS_KSC5601, "7I" },
	{ "fP",	CS_KSC5601, "7J" },
	{ "fPs",	CS_KSC5601, "7K" },
	{ "fPq",	CS_KSC5601, "7L" },
	{ "fPt",	CS_KSC5601, "7M" },
	{ "fh",	CS_KSC5601, "7N" },
	{ "fhr",	CS_KSC5601, "7O" },
	{ "fhs",	CS_KSC5601, "7P" },
	{ "fhf",	CS_KSC5601, "7Q" },
	{ "fha",	CS_KSC5601, "7R" },
	{ "fhq",	CS_KSC5601, "7S" },
	{ "fht",	CS_KSC5601, "7T" },
	{ "fhd",	CS_KSC5601, "7U" },
	{ "fhk",	CS_KSC5601, "7V" },
	{ "fhks",	CS_KSC5601, "7W" },
	{ "fhkd",	CS_KSC5601, "7X" },
	{ "fhoT",	CS_KSC5601, "7Y" },
	{ "fhl",	CS_KSC5601, "7Z" },
	{ "fhls",	CS_KSC5601, "7[" },
	{ "fhlf",	CS_KSC5601, "7\\" },
	{ "fhla",	CS_KSC5601, "7]" },
	{ "fhlq",	CS_KSC5601, "7^" },
	{ "fhlt",	CS_KSC5601, "7_" },
	{ "fhld",	CS_KSC5601, "7`" },
	{ "fy",	CS_KSC5601, "7a" },
	{ "fys",	CS_KSC5601, "7b" },
	{ "fyf",	CS_KSC5601, "7c" },
	{ "fyq",	CS_KSC5601, "7d" },
	{ "fyt",	CS_KSC5601, "7e" },
	{ "fyd",	CS_KSC5601, "7f" },
	{ "fn",	CS_KSC5601, "7g" },
	{ "fnr",	CS_KSC5601, "7h" },
	{ "fns",	CS_KSC5601, "7i" },
	{ "fnf",	CS_KSC5601, "7j" },
	{ "fna",	CS_KSC5601, "7k" },
	{ "fnq",	CS_KSC5601, "7l" },
	{ "fnt",	CS_KSC5601, "7m" },
	{ "fnd",	CS_KSC5601, "7n" },
	{ "fnj",	CS_KSC5601, "7o" },
	{ "fnjT",	CS_KSC5601, "7p" },
	{ "fnp",	CS_KSC5601, "7q" },
	{ "fnl",	CS_KSC5601, "7r" },
	{ "fnlr",	CS_KSC5601, "7s" },
	{ "fnls",	CS_KSC5601, "7t" },
	{ "fnlf",	CS_KSC5601, "7u" },
	{ "fnla",	CS_KSC5601, "7v" },
	{ "fnlt",	CS_KSC5601, "7w" },
	{ "fnld",	CS_KSC5601, "7x" },
	{ "fb",	CS_KSC5601, "7y" },
	{ "fbr",	CS_KSC5601, "7z" },
	{ "fbs",	CS_KSC5601, "7{" },
	{ "fbf",	CS_KSC5601, "7|" },
	{ "fba",	CS_KSC5601, "7}" },
	{ "fbq",	CS_KSC5601, "7~" },
	{ "fbt",	CS_KSC5601, "8!" },
	{ "fbd",	CS_KSC5601, "8\"" },
	{ "fm",	CS_KSC5601, "8#" },
	{ "fmr",	CS_KSC5601, "8$" },
	{ "fms",	CS_KSC5601, "8%" },
	{ "fmf",	CS_KSC5601, "8&" },
	{ "fma",	CS_KSC5601, "8\'" },
	{ "fmq",	CS_KSC5601, "8(" },
	{ "fmt",	CS_KSC5601, "8)" },
	{ "fmd",	CS_KSC5601, "8*" },
	{ "fmw",	CS_KSC5601, "8+" },
	{ "fmx",	CS_KSC5601, "8," },
	{ "fmv",	CS_KSC5601, "8-" },
	{ "fl",	CS_KSC5601, "8." },
	{ "flr",	CS_KSC5601, "8/" },
	{ "fls",	CS_KSC5601, "80" },
	{ "flf",	CS_KSC5601, "81" },
	{ "fla",	CS_KSC5601, "82" },
	{ "flq",	CS_KSC5601, "83" },
	{ "flt",	CS_KSC5601, "84" },
	{ "fld",	CS_KSC5601, "85" },
	{ "ak",	CS_KSC5601, "86" },
	{ "akr",	CS_KSC5601, "87" },
	{ "aks",	CS_KSC5601, "88" },
	{ "aksg",	CS_KSC5601, "89" },
	{ "ake",	CS_KSC5601, "8:" },
	{ "akf",	CS_KSC5601, "8;" },
	{ "akfr",	CS_KSC5601, "8<" },
	{ "akfa",	CS_KSC5601, "8=" },
	{ "aka",	CS_KSC5601, "8>" },
	{ "akq",	CS_KSC5601, "8?" },
	{ "akt",	CS_KSC5601, "8@" },
	{ "akd",	CS_KSC5601, "8A" },
	{ "akw",	CS_KSC5601, "8B" },
	{ "akx",	CS_KSC5601, "8C" },
	{ "akg",	CS_KSC5601, "8D" },
	{ "ao",	CS_KSC5601, "8E" },
	{ "aor",	CS_KSC5601, "8F" },
	{ "aos",	CS_KSC5601, "8G" },
	{ "aof",	CS_KSC5601, "8H" },
	{ "aoa",	CS_KSC5601, "8I" },
	{ "aoq",	CS_KSC5601, "8J" },
	{ "aot",	CS_KSC5601, "8K" },
	{ "aoT",	CS_KSC5601, "8L" },
	{ "aod",	CS_KSC5601, "8M" },
	{ "aow",	CS_KSC5601, "8N" },
	{ "ai",	CS_KSC5601, "8O" },
	{ "air",	CS_KSC5601, "8P" },
	{ "aif",	CS_KSC5601, "8Q" },
	{ "aid",	CS_KSC5601, "8R" },
	{ "aj",	CS_KSC5601, "8S" },
	{ "ajr",	CS_KSC5601, "8T" },
	{ "ajs",	CS_KSC5601, "8U" },
	{ "ajf",	CS_KSC5601, "8V" },
	{ "ajfa",	CS_KSC5601, "8W" },
	{ "aja",	CS_KSC5601, "8X" },
	{ "ajq",	CS_KSC5601, "8Y" },
	{ "ajt",	CS_KSC5601, "8Z" },
	{ "ajd",	CS_KSC5601, "8[" },
	{ "ajw",	CS_KSC5601, "8\\" },
	{ "ajg",	CS_KSC5601, "8]" },
	{ "ap",	CS_KSC5601, "8^" },
	{ "apr",	CS_KSC5601, "8_" },
	{ "aps",	CS_KSC5601, "8`" },
	{ "apf",	CS_KSC5601, "8a" },
	{ "apa",	CS_KSC5601, "8b" },
	{ "apq",	CS_KSC5601, "8c" },
	{ "apt",	CS_KSC5601, "8d" },
	{ "apT",	CS_KSC5601, "8e" },
	{ "apd",	CS_KSC5601, "8f" },
	{ "au",	CS_KSC5601, "8g" },
	{ "aur",	CS_KSC5601, "8h" },
	{ "aus",	CS_KSC5601, "8i" },
	{ "auf",	CS_KSC5601, "8j" },
	{ "aut",	CS_KSC5601, "8k" },
	{ "auT",	CS_KSC5601, "8l" },
	{ "aud",	CS_KSC5601, "8m" },
	{ "auc",	CS_KSC5601, "8n" },
	{ "aP",	CS_KSC5601, "8o" },
	{ "ah",	CS_KSC5601, "8p" },
	{ "ahr",	CS_KSC5601, "8q" },
	{ "ahrt",	CS_KSC5601, "8r" },
	{ "ahs",	CS_KSC5601, "8s" },
	{ "ahf",	CS_KSC5601, "8t" },
	{ "ahfa",	CS_KSC5601, "8u" },
	{ "aha",	CS_KSC5601, "8v" },
	{ "ahq",	CS_KSC5601, "8w" },
	{ "aht",	CS_KSC5601, "8x" },
	{ "ahd",	CS_KSC5601, "8y" },
	{ "ahk",	CS_KSC5601, "8z" },
	{ "ahks",	CS_KSC5601, "8{" },
	{ "ahkT",	CS_KSC5601, "8|" },
	{ "ahkd",	CS_KSC5601, "8}" },
	{ "ahl",	CS_KSC5601, "8~" },

	{ "ahls",	CS_KSC5601, "9!" },
	{ "ahlf",	CS_KSC5601, "9\"" },
	{ "ahlq",	CS_KSC5601, "9#" },
	{ "ahlt",	CS_KSC5601, "9$" },
	{ "ahld",	CS_KSC5601, "9%" },
	{ "ay",	CS_KSC5601, "9&" },
	{ "ays",	CS_KSC5601, "9\'" },
	{ "ayf",	CS_KSC5601, "9(" },
	{ "ayq",	CS_KSC5601, "9)" },
	{ "ayt",	CS_KSC5601, "9*" },
	{ "an",	CS_KSC5601, "9+" },
	{ "anr",	CS_KSC5601, "9," },
	{ "anR",	CS_KSC5601, "9-" },
	{ "ans",	CS_KSC5601, "9." },
	{ "ane",	CS_KSC5601, "9/" },
	{ "anf",	CS_KSC5601, "90" },
	{ "anfr",	CS_KSC5601, "91" },
	{ "anfa",	CS_KSC5601, "92" },
	{ "ana",	CS_KSC5601, "93" },
	{ "anq",	CS_KSC5601, "94" },
	{ "ant",	CS_KSC5601, "95" },
	{ "and",	CS_KSC5601, "96" },
	{ "anx",	CS_KSC5601, "97" },
	{ "ang",	CS_KSC5601, "98" },
	{ "anj",	CS_KSC5601, "99" },
	{ "anjs",	CS_KSC5601, "9:" },
	{ "anjf",	CS_KSC5601, "9;" },
	{ "anjq",	CS_KSC5601, "9<" },
	{ "anjt",	CS_KSC5601, "9=" },
	{ "anp",	CS_KSC5601, "9>" },
	{ "anl",	CS_KSC5601, "9?" },
	{ "anls",	CS_KSC5601, "9@" },
	{ "anlf",	CS_KSC5601, "9A" },
	{ "ab",	CS_KSC5601, "9B" },

	{ "abs",	CS_KSC5601, "9C" },
	{ "abf",	CS_KSC5601, "9D" },
	{ "aba",	CS_KSC5601, "9E" },
	{ "abt",	CS_KSC5601, "9F" },
	{ "am",	CS_KSC5601, "9G" },
	{ "ams",	CS_KSC5601, "9H" },
	{ "amf",	CS_KSC5601, "9I" },
	{ "ama",	CS_KSC5601, "9J" },
	{ "amt",	CS_KSC5601, "9K" },
	{ "al",	CS_KSC5601, "9L" },
	{ "alr",	CS_KSC5601, "9M" },
	{ "als",	CS_KSC5601, "9N" },
	{ "ale",	CS_KSC5601, "9O" },
	{ "alf",	CS_KSC5601, "9P" },
	{ "alfa",	CS_KSC5601, "9Q" },
	{ "ala",	CS_KSC5601, "9R" },
	{ "alq",	CS_KSC5601, "9S" },
	{ "alt",	CS_KSC5601, "9T" },
	{ "alT",	CS_KSC5601, "9U" },
	{ "ald",	CS_KSC5601, "9V" },
	{ "alc",	CS_KSC5601, "9W" },
	{ "alx",	CS_KSC5601, "9X" },
	{ "qk",	CS_KSC5601, "9Y" },
	{ "qkr",	CS_KSC5601, "9Z" },
	{ "qkR",	CS_KSC5601, "9[" },
	{ "qkrt",	CS_KSC5601, "9\\" },
	{ "qks",	CS_KSC5601, "9]" },
	{ "qke",	CS_KSC5601, "9^" },
	{ "qkf",	CS_KSC5601, "9_" },
	{ "qkfr",	CS_KSC5601, "9`" },
	{ "qkfa",	CS_KSC5601, "9a" },
	{ "qkfq",	CS_KSC5601, "9b" },
	{ "qka",	CS_KSC5601, "9c" },
	{ "qkq",	CS_KSC5601, "9d" },
	{ "qkt",	CS_KSC5601, "9e" },
	{ "qkd",	CS_KSC5601, "9f" },
	{ "qkx",	CS_KSC5601, "9g" },
	{ "qo",	CS_KSC5601, "9h" },
	{ "qor",	CS_KSC5601, "9i" },
	{ "qos",	CS_KSC5601, "9j" },
	{ "qof",	CS_KSC5601, "9k" },
	{ "qoa",	CS_KSC5601, "9l" },
	{ "qoq",	CS_KSC5601, "9m" },
	{ "qot",	CS_KSC5601, "9n" },
	{ "qoT",	CS_KSC5601, "9o" },
	{ "qod",	CS_KSC5601, "9p" },
	{ "qox",	CS_KSC5601, "9q" },
	{ "qi",	CS_KSC5601, "9r" },
	{ "qir",	CS_KSC5601, "9s" },
	{ "qis",	CS_KSC5601, "9t" },
	{ "qiq",	CS_KSC5601, "9u" },
	{ "qj",	CS_KSC5601, "9v" },
	{ "qjr",	CS_KSC5601, "9w" },
	{ "qjs",	CS_KSC5601, "9x" },
	{ "qje",	CS_KSC5601, "9y" },
	{ "qjf",	CS_KSC5601, "9z" },
	{ "qjfa",	CS_KSC5601, "9{" },
	{ "qja",	CS_KSC5601, "9|" },
	{ "qjq",	CS_KSC5601, "9}" },
	{ "qjt",	CS_KSC5601, "9~" },
	{ "qjd",	CS_KSC5601, ":!" },
	{ "qjw",	CS_KSC5601, ":\"" },
	{ "qp",	CS_KSC5601, ":#" },
	{ "qpr",	CS_KSC5601, ":$" },
	{ "qps",	CS_KSC5601, ":%" },
	{ "qpe",	CS_KSC5601, ":&" },
	{ "qpf",	CS_KSC5601, ":\'" },
	{ "qpa",	CS_KSC5601, ":(" },
	{ "qpq",	CS_KSC5601, ":)" },
	{ "qpt",	CS_KSC5601, ":*" },
	{ "qpT",	CS_KSC5601, ":+" },
	{ "qpd",	CS_KSC5601, ":," },
	{ "qu",	CS_KSC5601, ":-" },
	{ "qur",	CS_KSC5601, ":." },
	{ "qus",	CS_KSC5601, ":/" },
	{ "quf",	CS_KSC5601, ":0" },
	{ "quq",	CS_KSC5601, ":1" },
	{ "qut",	CS_KSC5601, ":2" },
	{ "quT",	CS_KSC5601, ":3" },
	{ "qud",	CS_KSC5601, ":4" },
	{ "qux",	CS_KSC5601, ":5" },
	{ "qP",	CS_KSC5601, ":6" },
	{ "qPs",	CS_KSC5601, ":7" },
	{ "qh",	CS_KSC5601, ":8" },
	{ "qhr",	CS_KSC5601, ":9" },
	{ "qhR",	CS_KSC5601, "::" },
	{ "qhs",	CS_KSC5601, ":;" },
	{ "qhf",	CS_KSC5601, ":<" },
	{ "qha",	CS_KSC5601, ":=" },
	{ "qhq",	CS_KSC5601, ":>" },
	{ "qht",	CS_KSC5601, ":?" },
	{ "qhd",	CS_KSC5601, ":@" },
	{ "qhk",	CS_KSC5601, ":A" },
	{ "qhks",	CS_KSC5601, ":B" },
	{ "qhkT",	CS_KSC5601, ":C" },
	{ "qho",	CS_KSC5601, ":D" },
	{ "qhoT",	CS_KSC5601, ":E" },
	{ "qhl",	CS_KSC5601, ":F" },
	{ "qhlr",	CS_KSC5601, ":G" },
	{ "qhls",	CS_KSC5601, ":H" },
	{ "qhlf",	CS_KSC5601, ":I" },
	{ "qhla",	CS_KSC5601, ":J" },
	{ "qhlq",	CS_KSC5601, ":K" },
	{ "qy",	CS_KSC5601, ":L" },
	{ "qys",	CS_KSC5601, ":M" },
	{ "qn",	CS_KSC5601, ":N" },
	{ "qnr",	CS_KSC5601, ":O" },
	{ "qns",	CS_KSC5601, ":P" },
	{ "qne",	CS_KSC5601, ":Q" },
	{ "qnf",	CS_KSC5601, ":R" },
	{ "qnfr",	CS_KSC5601, ":S" },
	{ "qnfa",	CS_KSC5601, ":T" },
	{ "qna",	CS_KSC5601, ":U" },
	{ "qnq",	CS_KSC5601, ":V" },
	{ "qnt",	CS_KSC5601, ":W" },
	{ "qnd",	CS_KSC5601, ":X" },
	{ "qnx",	CS_KSC5601, ":Y" },
	{ "qnv",	CS_KSC5601, ":Z" },
	{ "qnj",	CS_KSC5601, ":[" },
	{ "qnjf",	CS_KSC5601, ":\\" },
	{ "qnjT",	CS_KSC5601, ":]" },
	{ "qnp",	CS_KSC5601, ":^" },
	{ "qnl",	CS_KSC5601, ":_" },
	{ "qnlr",	CS_KSC5601, ":`" },
	{ "qnls",	CS_KSC5601, ":a" },
	{ "qnlf",	CS_KSC5601, ":b" },
	{ "qnld",	CS_KSC5601, ":c" },
	{ "qb",	CS_KSC5601, ":d" },
	{ "qbs",	CS_KSC5601, ":e" },
	{ "qbf",	CS_KSC5601, ":f" },
	{ "qba",	CS_KSC5601, ":g" },
	{ "qbt",	CS_KSC5601, ":h" },
	{ "qbd",	CS_KSC5601, ":i" },
	{ "qm",	CS_KSC5601, ":j" },
	{ "qmr",	CS_KSC5601, ":k" },
	{ "qms",	CS_KSC5601, ":l" },
	{ "qmf",	CS_KSC5601, ":m" },
	{ "qma",	CS_KSC5601, ":n" },
	{ "qmq",	CS_KSC5601, ":o" },
	{ "qmt",	CS_KSC5601, ":p" },
	{ "ql",	CS_KSC5601, ":q" },
	{ "qlr",	CS_KSC5601, ":r" },
	{ "qls",	CS_KSC5601, ":s" },
	{ "qlf",	CS_KSC5601, ":t" },
	{ "qlfa",	CS_KSC5601, ":u" },
	{ "qla",	CS_KSC5601, ":v" },
	{ "qlq",	CS_KSC5601, ":w" },
	{ "qlt",	CS_KSC5601, ":x" },
	{ "qld",	CS_KSC5601, ":y" },
	{ "qlw",	CS_KSC5601, ":z" },
	{ "qlc",	CS_KSC5601, ":{" },
	{ "Qk",	CS_KSC5601, ":|" },
	{ "Qkr",	CS_KSC5601, ":}" },
	{ "Qks",	CS_KSC5601, ":~" },
	{ "Qkf",	CS_KSC5601, ";!" },
	{ "Qkfa",	CS_KSC5601, ";\"" },
	{ "Qka",	CS_KSC5601, ";#" },
	{ "Qkq",	CS_KSC5601, ";$" },
	{ "Qkt",	CS_KSC5601, ";%" },
	{ "QkT",	CS_KSC5601, ";&" },
	{ "Qkd",	CS_KSC5601, ";\'" },
	{ "Qkg",	CS_KSC5601, ";(" },
	{ "Qo",	CS_KSC5601, ";)" },
	{ "Qor",	CS_KSC5601, ";*" },
	{ "Qos",	CS_KSC5601, ";+" },
	{ "Qof",	CS_KSC5601, ";," },
	{ "Qoa",	CS_KSC5601, ";-" },
	{ "Qoq",	CS_KSC5601, ";." },
	{ "Qot",	CS_KSC5601, ";/" },
	{ "QoT",	CS_KSC5601, ";0" },
	{ "Qod",	CS_KSC5601, ";1" },
	{ "Qi",	CS_KSC5601, ";2" },
	{ "Qir",	CS_KSC5601, ";3" },
	{ "Qia",	CS_KSC5601, ";4" },
	{ "Qj",	CS_KSC5601, ";5" },
	{ "Qjr",	CS_KSC5601, ";6" },
	{ "Qjs",	CS_KSC5601, ";7" },
	{ "Qje",	CS_KSC5601, ";8" },
	{ "Qjf",	CS_KSC5601, ";9" },
	{ "Qja",	CS_KSC5601, ";:" },
	{ "Qjt",	CS_KSC5601, ";;" },
	{ "QjT",	CS_KSC5601, ";<" },
	{ "Qjd",	CS_KSC5601, ";=" },
	{ "Qp",	CS_KSC5601, ";>" },
	{ "Qpd",	CS_KSC5601, ";?" },
	{ "Qu",	CS_KSC5601, ";@" },
	{ "Qur",	CS_KSC5601, ";A" },
	{ "Qua",	CS_KSC5601, ";B" },
	{ "Quq",	CS_KSC5601, ";C" },
	{ "Qut",	CS_KSC5601, ";D" },
	{ "QuT",	CS_KSC5601, ";E" },
	{ "Qud",	CS_KSC5601, ";F" },
	{ "Qh",	CS_KSC5601, ";G" },
	{ "Qhr",	CS_KSC5601, ";H" },
	{ "Qhs",	CS_KSC5601, ";I" },
	{ "Qhf",	CS_KSC5601, ";J" },
	{ "Qha",	CS_KSC5601, ";K" },
	{ "Qhq",	CS_KSC5601, ";L" },
	{ "Qhd",	CS_KSC5601, ";M" },
	{ "Qhl",	CS_KSC5601, ";N" },
	{ "Qy",	CS_KSC5601, ";O" },
	{ "Qyd",	CS_KSC5601, ";P" },
	{ "Qn",	CS_KSC5601, ";Q" },
	{ "Qnr",	CS_KSC5601, ";R" },
	{ "Qns",	CS_KSC5601, ";S" },
	{ "Qnf",	CS_KSC5601, ";T" },
	{ "Qna",	CS_KSC5601, ";U" },
	{ "Qnt",	CS_KSC5601, ";V" },
	{ "Qnd",	CS_KSC5601, ";W" },
	{ "Qb",	CS_KSC5601, ";X" },
	{ "Qbd",	CS_KSC5601, ";Y" },
	{ "Qm",	CS_KSC5601, ";Z" },
	{ "Qms",	CS_KSC5601, ";[" },
	{ "Qmf",	CS_KSC5601, ";\\" },
	{ "Qma",	CS_KSC5601, ";]" },
	{ "Qmq",	CS_KSC5601, ";^" },
	{ "Ql",	CS_KSC5601, ";_" },
	{ "Qlr",	CS_KSC5601, ";`" },
	{ "Qls",	CS_KSC5601, ";a" },
	{ "Qlf",	CS_KSC5601, ";b" },
	{ "Qla",	CS_KSC5601, ";c" },
	{ "Qlq",	CS_KSC5601, ";d" },
	{ "Qlt",	CS_KSC5601, ";e" },
	{ "Qld",	CS_KSC5601, ";f" },
	{ "tk",	CS_KSC5601, ";g" },
	{ "tkr",	CS_KSC5601, ";h" },
	{ "tkrt",	CS_KSC5601, ";i" },
	{ "tks",	CS_KSC5601, ";j" },
	{ "tke",	CS_KSC5601, ";k" },
	{ "tkf",	CS_KSC5601, ";l" },
	{ "tkfr",	CS_KSC5601, ";m" },
	{ "tkfa",	CS_KSC5601, ";n" },
	{ "tka",	CS_KSC5601, ";o" },
	{ "tkq",	CS_KSC5601, ";p" },
	{ "tkt",	CS_KSC5601, ";q" },
	{ "tkT",	CS_KSC5601, ";r" },
	{ "tkd",	CS_KSC5601, ";s" },
	{ "tkx",	CS_KSC5601, ";t" },
	{ "to",	CS_KSC5601, ";u" },
	{ "tor",	CS_KSC5601, ";v" },
	{ "tos",	CS_KSC5601, ";w" },
	{ "tof",	CS_KSC5601, ";x" },
	{ "toa",	CS_KSC5601, ";y" },
	{ "toq",	CS_KSC5601, ";z" },
	{ "tot",	CS_KSC5601, ";{" },
	{ "toT",	CS_KSC5601, ";|" },
	{ "tod",	CS_KSC5601, ";}" },
	{ "ti",	CS_KSC5601, ";~" },
	{ "tir",	CS_KSC5601, "<!" },
	{ "tis",	CS_KSC5601, "<\"" },
	{ "tif",	CS_KSC5601, "<#" },
	{ "tia",	CS_KSC5601, "<$" },
	{ "tiq",	CS_KSC5601, "<%" },
	{ "tit",	CS_KSC5601, "<&" },
	{ "tid",	CS_KSC5601, "<\'" },
	{ "tO",	CS_KSC5601, "<(" },
	{ "tOs",	CS_KSC5601, "<)" },
	{ "tOf",	CS_KSC5601, "<*" },
	{ "tOa",	CS_KSC5601, "<+" },
	{ "tOd",	CS_KSC5601, "<," },
	{ "tj",	CS_KSC5601, "<-" },
	{ "tjr",	CS_KSC5601, "<." },
	{ "tjR",	CS_KSC5601, "</" },
	{ "tjrt",	CS_KSC5601, "<0" },
	{ "tjs",	CS_KSC5601, "<1" },
	{ "tje",	CS_KSC5601, "<2" },
	{ "tjf",	CS_KSC5601, "<3" },
	{ "tjfa",	CS_KSC5601, "<4" },
	{ "tjfq",	CS_KSC5601, "<5" },
	{ "tja",	CS_KSC5601, "<6" },
	{ "tjq",	CS_KSC5601, "<7" },
	{ "tjt",	CS_KSC5601, "<8" },
	{ "tjT",	CS_KSC5601, "<9" },
	{ "tjd",	CS_KSC5601, "<:" },
	{ "tjv",	CS_KSC5601, "<;" },
	{ "tp",	CS_KSC5601, "<<" },
	{ "tpr",	CS_KSC5601, "<=" },
	{ "tps",	CS_KSC5601, "<>" },
	{ "tpf",	CS_KSC5601, "<?" },
	{ "tpa",	CS_KSC5601, "<@" },
	{ "tpq",	CS_KSC5601, "<A" },
	{ "tpt",	CS_KSC5601, "<B" },
	{ "tpT",	CS_KSC5601, "<C" },
	{ "tpd",	CS_KSC5601, "<D" },
	{ "tu",	CS_KSC5601, "<E" },
	{ "tur",	CS_KSC5601, "<F" },
	{ "tus",	CS_KSC5601, "<G" },
	{ "tuf",	CS_KSC5601, "<H" },
	{ "tua",	CS_KSC5601, "<I" },
	{ "tuq",	CS_KSC5601, "<J" },
	{ "tut",	CS_KSC5601, "<K" },
	{ "tuT",	CS_KSC5601, "<L" },
	{ "tud",	CS_KSC5601, "<M" },
	{ "tP",	CS_KSC5601, "<N" },
	{ "tPs",	CS_KSC5601, "<O" },
	{ "tPf",	CS_KSC5601, "<P" },
	{ "tPd",	CS_KSC5601, "<Q" },
	{ "th",	CS_KSC5601, "<R" },
	{ "thr",	CS_KSC5601, "<S" },
	{ "thR",	CS_KSC5601, "<T" },
	{ "ths",	CS_KSC5601, "<U" },
	{ "thf",	CS_KSC5601, "<V" },
	{ "thfa",	CS_KSC5601, "<W" },
	{ "tha",	CS_KSC5601, "<X" },
	{ "thq",	CS_KSC5601, "<Y" },
	{ "tht",	CS_KSC5601, "<Z" },
	{ "thd",	CS_KSC5601, "<[" },
	{ "thx",	CS_KSC5601, "<\\" },
	{ "thk",	CS_KSC5601, "<]" },
	{ "thkr",	CS_KSC5601, "<^" },
	{ "thks",	CS_KSC5601, "<_" },
	{ "thkf",	CS_KSC5601, "<`" },
	{ "thkd",	CS_KSC5601, "<a" },
	{ "tho",	CS_KSC5601, "<b" },
	{ "thos",	CS_KSC5601, "<c" },
	{ "thof",	CS_KSC5601, "<d" },
	{ "thoa",	CS_KSC5601, "<e" },
	{ "thot",	CS_KSC5601, "<f" },
	{ "thoT",	CS_KSC5601, "<g" },
	{ "thl",	CS_KSC5601, "<h" },
	{ "thls",	CS_KSC5601, "<i" },
	{ "thlf",	CS_KSC5601, "<j" },
	{ "thla",	CS_KSC5601, "<k" },
	{ "thlq",	CS_KSC5601, "<l" },
	{ "thlt",	CS_KSC5601, "<m" },
	{ "ty",	CS_KSC5601, "<n" },
	{ "tyr",	CS_KSC5601, "<o" },
	{ "tys",	CS_KSC5601, "<p" },
	{ "tyf",	CS_KSC5601, "<q" },
	{ "tya",	CS_KSC5601, "<r" },
	{ "tyq",	CS_KSC5601, "<s" },
	{ "tyt",	CS_KSC5601, "<t" },
	{ "tyd",	CS_KSC5601, "<u" },
	{ "tn",	CS_KSC5601, "<v" },
	{ "tnr",	CS_KSC5601, "<w" },
	{ "tns",	CS_KSC5601, "<x" },
	{ "tne",	CS_KSC5601, "<y" },
	{ "tnf",	CS_KSC5601, "<z" },
	{ "tna",	CS_KSC5601, "<{" },
	{ "tnq",	CS_KSC5601, "<|" },
	{ "tnt",	CS_KSC5601, "<}" },
	{ "tnd",	CS_KSC5601, "<~" },
	{ "tnc",	CS_KSC5601, "=!" },
	{ "tnx",	CS_KSC5601, "=\"" },
	{ "tnv",	CS_KSC5601, "=#" },
	{ "tnj",	CS_KSC5601, "=$" },
	{ "tnjT",	CS_KSC5601, "=%" },
	{ "tnp",	CS_KSC5601, "=&" },
	{ "tnpr",	CS_KSC5601, "=\'" },
	{ "tnps",	CS_KSC5601, "=(" },
	{ "tnpf",	CS_KSC5601, "=)" },
	{ "tnpa",	CS_KSC5601, "=*" },
	{ "tnpd",	CS_KSC5601, "=+" },
	{ "tnl",	CS_KSC5601, "=," },
	{ "tnlr",	CS_KSC5601, "=-" },
	{ "tnls",	CS_KSC5601, "=." },
	{ "tnlf",	CS_KSC5601, "=/" },
	{ "tnla",	CS_KSC5601, "=0" },
	{ "tnlq",	CS_KSC5601, "=1" },
	{ "tnlt",	CS_KSC5601, "=2" },
	{ "tnld",	CS_KSC5601, "=3" },
	{ "tb",	CS_KSC5601, "=4" },
	{ "tbr",	CS_KSC5601, "=5" },
	{ "tbf",	CS_KSC5601, "=6" },
	{ "tba",	CS_KSC5601, "=7" },
	{ "tbt",	CS_KSC5601, "=8" },
	{ "tbd",	CS_KSC5601, "=9" },
	{ "tm",	CS_KSC5601, "=:" },
	{ "tmr",	CS_KSC5601, "=;" },
	{ "tms",	CS_KSC5601, "=<" },
	{ "tmf",	CS_KSC5601, "==" },
	{ "tmfr",	CS_KSC5601, "=>" },
	{ "tma",	CS_KSC5601, "=?" },
	{ "tmq",	CS_KSC5601, "=@" },
	{ "tmt",	CS_KSC5601, "=A" },
	{ "tmd",	CS_KSC5601, "=B" },
	{ "tl",	CS_KSC5601, "=C" },
	{ "tlr",	CS_KSC5601, "=D" },
	{ "tls",	CS_KSC5601, "=E" },
	{ "tle",	CS_KSC5601, "=F" },
	{ "tlf",	CS_KSC5601, "=G" },
	{ "tlfg",	CS_KSC5601, "=H" },
	{ "tla",	CS_KSC5601, "=I" },
	{ "tlq",	CS_KSC5601, "=J" },
	{ "tlt",	CS_KSC5601, "=K" },
	{ "tld",	CS_KSC5601, "=L" },
	{ "tlv",	CS_KSC5601, "=M" },
	{ "Tk",	CS_KSC5601, "=N" },
	{ "Tkr",	CS_KSC5601, "=O" },
	{ "Tkrt",	CS_KSC5601, "=P" },
	{ "Tks",	CS_KSC5601, "=Q" },
	{ "Tkf",	CS_KSC5601, "=R" },
	{ "Tka",	CS_KSC5601, "=S" },
	{ "Tkq",	CS_KSC5601, "=T" },
	{ "TkT",	CS_KSC5601, "=U" },
	{ "Tkd",	CS_KSC5601, "=V" },
	{ "Tkg",	CS_KSC5601, "=W" },
	{ "To",	CS_KSC5601, "=X" },
	{ "Tor",	CS_KSC5601, "=Y" },
	{ "Tos",	CS_KSC5601, "=Z" },
	{ "Tof",	CS_KSC5601, "=[" },
	{ "Toa",	CS_KSC5601, "=\\" },
	{ "Toq",	CS_KSC5601, "=]" },
	{ "ToT",	CS_KSC5601, "=^" },
	{ "Tod",	CS_KSC5601, "=_" },
	{ "Tid",	CS_KSC5601, "=`" },
	{ "Tj",	CS_KSC5601, "=a" },
	{ "Tjr",	CS_KSC5601, "=b" },
	{ "Tjs",	CS_KSC5601, "=c" },
	{ "Tjf",	CS_KSC5601, "=d" },
	{ "Tjfa",	CS_KSC5601, "=e" },
	{ "Tja",	CS_KSC5601, "=f" },
	{ "Tjq",	CS_KSC5601, "=g" },
	{ "TjT",	CS_KSC5601, "=h" },
	{ "Tjd",	CS_KSC5601, "=i" },
	{ "Tp",	CS_KSC5601, "=j" },
	{ "Tps",	CS_KSC5601, "=k" },
	{ "Tpf",	CS_KSC5601, "=l" },
	{ "TPs",	CS_KSC5601, "=m" },
	{ "Th",	CS_KSC5601, "=n" },
	{ "Thr",	CS_KSC5601, "=o" },
	{ "Ths",	CS_KSC5601, "=p" },
	{ "The",	CS_KSC5601, "=q" },
	{ "Thf",	CS_KSC5601, "=r" },
	{ "Thfa",	CS_KSC5601, "=s" },
	{ "Tha",	CS_KSC5601, "=t" },
	{ "Thq",	CS_KSC5601, "=u" },
	{ "Thd",	CS_KSC5601, "=v" },
	{ "Thk",	CS_KSC5601, "=w" },
	{ "Thkr",	CS_KSC5601, "=x" },
	{ "Thks",	CS_KSC5601, "=y" },
	{ "ThkT",	CS_KSC5601, "=z" },
	{ "Tho",	CS_KSC5601, "={" },
	{ "ThoT",	CS_KSC5601, "=|" },
	{ "Thl",	CS_KSC5601, "=}" },
	{ "Thls",	CS_KSC5601, "=~" },
	{ "Thlf",	CS_KSC5601, ">!" },
	{ "Thla",	CS_KSC5601, ">\"" },
	{ "Thlq",	CS_KSC5601, ">#" },
	{ "Ty",	CS_KSC5601, ">$" },
	{ "Tn",	CS_KSC5601, ">%" },
	{ "Tnr",	CS_KSC5601, ">&" },
	{ "Tns",	CS_KSC5601, ">\'" },
	{ "Tnf",	CS_KSC5601, ">(" },
	{ "Tna",	CS_KSC5601, ">)" },
	{ "Tnq",	CS_KSC5601, ">*" },
	{ "Tnd",	CS_KSC5601, ">+" },
	{ "Tnj",	CS_KSC5601, ">," },
	{ "TnjT",	CS_KSC5601, ">-" },
	{ "Tnp",	CS_KSC5601, ">." },
	{ "Tnl",	CS_KSC5601, ">/" },
	{ "Tnls",	CS_KSC5601, ">0" },
	{ "Tbd",	CS_KSC5601, ">1" },
	{ "Tm",	CS_KSC5601, ">2" },
	{ "Tmr",	CS_KSC5601, ">3" },
	{ "Tms",	CS_KSC5601, ">4" },
	{ "Tmf",	CS_KSC5601, ">5" },
	{ "Tmfa",	CS_KSC5601, ">6" },
	{ "Tmfg",	CS_KSC5601, ">7" },
	{ "Tma",	CS_KSC5601, ">8" },
	{ "Tmq",	CS_KSC5601, ">9" },
	{ "Tml",	CS_KSC5601, ">:" },
	{ "Tmls",	CS_KSC5601, ">;" },
	{ "Tmlf",	CS_KSC5601, "><" },
	{ "Tmla",	CS_KSC5601, ">=" },
	{ "Tl",	CS_KSC5601, ">>" },
	{ "Tlr",	CS_KSC5601, ">?" },
	{ "Tls",	CS_KSC5601, ">@" },
	{ "Tlf",	CS_KSC5601, ">A" },
	{ "Tla",	CS_KSC5601, ">B" },
	{ "Tlq",	CS_KSC5601, ">C" },
	{ "Tlt",	CS_KSC5601, ">D" },
	{ "Tld",	CS_KSC5601, ">E" },
	{ "dk",	CS_KSC5601, ">F" },
	{ "dkr",	CS_KSC5601, ">G" },
	{ "dks",	CS_KSC5601, ">H" },
	{ "dksw",	CS_KSC5601, ">I" },
	{ "dksg",	CS_KSC5601, ">J" },
	{ "dkf",	CS_KSC5601, ">K" },
	{ "dkfr",	CS_KSC5601, ">L" },
	{ "dkfa",	CS_KSC5601, ">M" },
	{ "dkfg",	CS_KSC5601, ">N" },
	{ "dka",	CS_KSC5601, ">O" },
	{ "dkq",	CS_KSC5601, ">P" },
	{ "dkt",	CS_KSC5601, ">Q" },
	{ "dkT",	CS_KSC5601, ">R" },
	{ "dkd",	CS_KSC5601, ">S" },
	{ "dkx",	CS_KSC5601, ">T" },
	{ "dkv",	CS_KSC5601, ">U" },
	{ "do",	CS_KSC5601, ">V" },
	{ "dor",	CS_KSC5601, ">W" },
	{ "dos",	CS_KSC5601, ">X" },
	{ "dof",	CS_KSC5601, ">Y" },
	{ "doa",	CS_KSC5601, ">Z" },
	{ "doq",	CS_KSC5601, ">[" },
	{ "dot",	CS_KSC5601, ">\\" },
	{ "doT",	CS_KSC5601, ">]" },
	{ "dod",	CS_KSC5601, ">^" },
	{ "di",	CS_KSC5601, ">_" },
	{ "dir",	CS_KSC5601, ">`" },
	{ "dis",	CS_KSC5601, ">a" },
	{ "dif",	CS_KSC5601, ">b" },
	{ "difq",	CS_KSC5601, ">c" },
	{ "dia",	CS_KSC5601, ">d" },
	{ "diq",	CS_KSC5601, ">e" },
	{ "dit",	CS_KSC5601, ">f" },
	{ "did",	CS_KSC5601, ">g" },
	{ "dix",	CS_KSC5601, ">h" },
	{ "dig",	CS_KSC5601, ">i" },
	{ "dO",	CS_KSC5601, ">j" },
	{ "dOs",	CS_KSC5601, ">k" },
	{ "dOf",	CS_KSC5601, ">l" },
	{ "dOq",	CS_KSC5601, ">m" },
	{ "dj",	CS_KSC5601, ">n" },
	{ "djr",	CS_KSC5601, ">o" },
	{ "djs",	CS_KSC5601, ">p" },
	{ "djsw",	CS_KSC5601, ">q" },
	{ "dje",	CS_KSC5601, ">r" },
	{ "djf",	CS_KSC5601, ">s" },
	{ "djfr",	CS_KSC5601, ">t" },
	{ "djfa",	CS_KSC5601, ">u" },
	{ "dja",	CS_KSC5601, ">v" },
	{ "djq",	CS_KSC5601, ">w" },
	{ "djqt",	CS_KSC5601, ">x" },
	{ "djt",	CS_KSC5601, ">y" },
	{ "djT",	CS_KSC5601, ">z" },
	{ "djd",	CS_KSC5601, ">{" },
	{ "djw",	CS_KSC5601, ">|" },
	{ "djz",	CS_KSC5601, ">}" },
	{ "djv",	CS_KSC5601, ">~" },
	{ "dp",	CS_KSC5601, "?!" },
	{ "dpr",	CS_KSC5601, "?\"" },
	{ "dps",	CS_KSC5601, "?#" },
	{ "dpf",	CS_KSC5601, "?$" },
	{ "dpa",	CS_KSC5601, "?%" },
	{ "dpq",	CS_KSC5601, "?&" },
	{ "dpt",	CS_KSC5601, "?\'" },
	{ "dpd",	CS_KSC5601, "?(" },
	{ "du",	CS_KSC5601, "?)" },
	{ "dur",	CS_KSC5601, "?*" },
	{ "duR",	CS_KSC5601, "?+" },
	{ "dus",	CS_KSC5601, "?," },
	{ "duf",	CS_KSC5601, "?-" },
	{ "dufa",	CS_KSC5601, "?." },
	{ "dufq",	CS_KSC5601, "?/" },
	{ "dua",	CS_KSC5601, "?0" },
	{ "duq",	CS_KSC5601, "?1" },
	{ "duqt",	CS_KSC5601, "?2" },
	{ "dut",	CS_KSC5601, "?3" },
	{ "duT",	CS_KSC5601, "?4" },
	{ "dud",	CS_KSC5601, "?5" },
	{ "dux",	CS_KSC5601, "?6" },
	{ "duv",	CS_KSC5601, "?7" },
	{ "dug",	CS_KSC5601, "?8" },
	{ "dP",	CS_KSC5601, "?9" },
	{ "dPs",	CS_KSC5601, "?:" },
	{ "dPf",	CS_KSC5601, "?;" },
	{ "dPa",	CS_KSC5601, "?<" },
	{ "dPq",	CS_KSC5601, "?=" },
	{ "dPt",	CS_KSC5601, "?>" },
	{ "dPT",	CS_KSC5601, "??" },
	{ "dh",	CS_KSC5601, "?@" },
	{ "dhr",	CS_KSC5601, "?A" },
	{ "dhs",	CS_KSC5601, "?B" },
	{ "dhf",	CS_KSC5601, "?C" },
	{ "dhfr",	CS_KSC5601, "?D" },
	{ "dhfa",	CS_KSC5601, "?E" },
	{ "dhft",	CS_KSC5601, "?F" },
	{ "dhfg",	CS_KSC5601, "?G" },
	{ "dha",	CS_KSC5601, "?H" },
	{ "dhq",	CS_KSC5601, "?I" },
	{ "dht",	CS_KSC5601, "?J" },
	{ "dhd",	CS_KSC5601, "?K" },
	{ "dhc",	CS_KSC5601, "?L" },
	{ "dhk",	CS_KSC5601, "?M" },
	{ "dhkr",	CS_KSC5601, "?N" },
	{ "dhks",	CS_KSC5601, "?O" },
	{ "dhkf",	CS_KSC5601, "?P" },
	{ "dhka",	CS_KSC5601, "?Q" },
	{ "dhkq",	CS_KSC5601, "?R" },
	{ "dhkt",	CS_KSC5601, "?S" },
	{ "dhkT",	CS_KSC5601, "?T" },
	{ "dhkd",	CS_KSC5601, "?U" },
	{ "dho",	CS_KSC5601, "?V" },
	{ "dhor",	CS_KSC5601, "?W" },
	{ "dhos",	CS_KSC5601, "?X" },
	{ "dhoa",	CS_KSC5601, "?Y" },
	{ "dhot",	CS_KSC5601, "?Z" },
	{ "dhod",	CS_KSC5601, "?[" },
	{ "dhl",	CS_KSC5601, "?\\" },
	{ "dhlr",	CS_KSC5601, "?]" },
	{ "dhls",	CS_KSC5601, "?^" },
	{ "dhlf",	CS_KSC5601, "?_" },
	{ "dhla",	CS_KSC5601, "?`" },
	{ "dhlq",	CS_KSC5601, "?a" },
	{ "dhlt",	CS_KSC5601, "?b" },
	{ "dhld",	CS_KSC5601, "?c" },
	{ "dy",	CS_KSC5601, "?d" },
	{ "dyr",	CS_KSC5601, "?e" },
	{ "dys",	CS_KSC5601, "?f" },
	{ "dyf",	CS_KSC5601, "?g" },
	{ "dya",	CS_KSC5601, "?h" },
	{ "dyq",	CS_KSC5601, "?i" },
	{ "dyt",	CS_KSC5601, "?j" },
	{ "dyd",	CS_KSC5601, "?k" },
	{ "dn",	CS_KSC5601, "?l" },
	{ "dnr",	CS_KSC5601, "?m" },
	{ "dns",	CS_KSC5601, "?n" },
	{ "dnf",	CS_KSC5601, "?o" },
	{ "dnfr",	CS_KSC5601, "?p" },
	{ "dnfa",	CS_KSC5601, "?q" },
	{ "dna",	CS_KSC5601, "?r" },
	{ "dnq",	CS_KSC5601, "?s" },
	{ "dnt",	CS_KSC5601, "?t" },
	{ "dnd",	CS_KSC5601, "?u" },
	{ "dnj",	CS_KSC5601, "?v" },
	{ "dnjr",	CS_KSC5601, "?w" },
	{ "dnjs",	CS_KSC5601, "?x" },
	{ "dnjf",	CS_KSC5601, "?y" },
	{ "dnja",	CS_KSC5601, "?z" },
	{ "dnjq",	CS_KSC5601, "?{" },
	{ "dnjT",	CS_KSC5601, "?|" },
	{ "dnjd",	CS_KSC5601, "?}" },
	{ "dnp",	CS_KSC5601, "?~" },
	{ "dnpr",	CS_KSC5601, "@!" },
	{ "dnps",	CS_KSC5601, "@\"" },
	{ "dnpf",	CS_KSC5601, "@#" },
	{ "dnpa",	CS_KSC5601, "@$" },
	{ "dnpq",	CS_KSC5601, "@%" },
	{ "dnpd",	CS_KSC5601, "@&" },
	{ "dnl",	CS_KSC5601, "@\'" },
	{ "dnlr",	CS_KSC5601, "@(" },
	{ "dnls",	CS_KSC5601, "@)" },
	{ "dnlf",	CS_KSC5601, "@*" },
	{ "dnla",	CS_KSC5601, "@+" },
	{ "dnlq",	CS_KSC5601, "@," },
	{ "dnlt",	CS_KSC5601, "@-" },
	{ "dnld",	CS_KSC5601, "@." },
	{ "db",	CS_KSC5601, "@/" },
	{ "dbr",	CS_KSC5601, "@0" },
	{ "dbs",	CS_KSC5601, "@1" },
	{ "dbf",	CS_KSC5601, "@2" },
	{ "dba",	CS_KSC5601, "@3" },
	{ "dbq",	CS_KSC5601, "@4" },
	{ "dbt",	CS_KSC5601, "@5" },
	{ "dbd",	CS_KSC5601, "@6" },
	{ "dbc",	CS_KSC5601, "@7" },
	{ "dm",	CS_KSC5601, "@8" },
	{ "dmr",	CS_KSC5601, "@9" },
	{ "dms",	CS_KSC5601, "@:" },
	{ "dmf",	CS_KSC5601, "@;" },
	{ "dmfv",	CS_KSC5601, "@<" },
	{ "dma",	CS_KSC5601, "@=" },
	{ "dmq",	CS_KSC5601, "@>" },
	{ "dmt",	CS_KSC5601, "@?" },
	{ "dmd",	CS_KSC5601, "@@" },
	{ "dmw",	CS_KSC5601, "@A" },
	{ "dmc",	CS_KSC5601, "@B" },
	{ "dmz",	CS_KSC5601, "@C" },
	{ "dmx",	CS_KSC5601, "@D" },
	{ "dmv",	CS_KSC5601, "@E" },
	{ "dmg",	CS_KSC5601, "@F" },
	{ "dml",	CS_KSC5601, "@G" },
	{ "dmls",	CS_KSC5601, "@H" },
	{ "dmlf",	CS_KSC5601, "@I" },
	{ "dmla",	CS_KSC5601, "@J" },
	{ "dmlt",	CS_KSC5601, "@K" },
	{ "dl",	CS_KSC5601, "@L" },
	{ "dlr",	CS_KSC5601, "@M" },
	{ "dls",	CS_KSC5601, "@N" },
	{ "dlf",	CS_KSC5601, "@O" },
	{ "dlfr",	CS_KSC5601, "@P" },
	{ "dlfa",	CS_KSC5601, "@Q" },
	{ "dlfg",	CS_KSC5601, "@R" },
	{ "dla",	CS_KSC5601, "@S" },
	{ "dlq",	CS_KSC5601, "@T" },
	{ "dlt",	CS_KSC5601, "@U" },
	{ "dlT",	CS_KSC5601, "@V" },
	{ "dld",	CS_KSC5601, "@W" },
	{ "dlw",	CS_KSC5601, "@X" },
	{ "dlv",	CS_KSC5601, "@Y" },
	{ "wk",	CS_KSC5601, "@Z" },
	{ "wkr",	CS_KSC5601, "@[" },
	{ "wks",	CS_KSC5601, "@\\" },
	{ "wksg",	CS_KSC5601, "@]" },
	{ "wke",	CS_KSC5601, "@^" },
	{ "wkf",	CS_KSC5601, "@_" },
	{ "wkfa",	CS_KSC5601, "@`" },
	{ "wka",	CS_KSC5601, "@a" },
	{ "wkq",	CS_KSC5601, "@b" },
	{ "wkt",	CS_KSC5601, "@c" },
	{ "wkT",	CS_KSC5601, "@d" },
	{ "wkd",	CS_KSC5601, "@e" },
	{ "wkw",	CS_KSC5601, "@f" },
	{ "Or",	CS_KSC5601, "@h" },
	{ "Os",	CS_KSC5601, "@i" },
	{ "Of",	CS_KSC5601, "@j" },
	{ "Oa",	CS_KSC5601, "@k" },
	{ "Oq",	CS_KSC5601, "@l" },
	{ "Ot",	CS_KSC5601, "@m" },
	{ "OT",	CS_KSC5601, "@n" },
	{ "Od",	CS_KSC5601, "@o" },
	{ "wo",	CS_KSC5601, "@g" },
	{ "wor",	CS_KSC5601, "@h" },
	{ "wos",	CS_KSC5601, "@i" },
	{ "wof",	CS_KSC5601, "@j" },
	{ "woa",	CS_KSC5601, "@k" },
	{ "woq",	CS_KSC5601, "@l" },
	{ "wot",	CS_KSC5601, "@m" },
	{ "woT",	CS_KSC5601, "@n" },
	{ "wod",	CS_KSC5601, "@o" },
	{ "wi",	CS_KSC5601, "@p" },
	{ "wir",	CS_KSC5601, "@q" },
	{ "wis",	CS_KSC5601, "@r" },
	{ "wisg",	CS_KSC5601, "@s" },
	{ "wif",	CS_KSC5601, "@t" },
	{ "wia",	CS_KSC5601, "@u" },
	{ "wid",	CS_KSC5601, "@v" },
	{ "wO",	CS_KSC5601, "@w" },
	{ "wOs",	CS_KSC5601, "@x" },
	{ "wOf",	CS_KSC5601, "@y" },
	{ "wj",	CS_KSC5601, "@z" },
	{ "wjr",	CS_KSC5601, "@{" },
	{ "wjs",	CS_KSC5601, "@|" },
	{ "wjf",	CS_KSC5601, "@}" },
	{ "wjfa",	CS_KSC5601, "@~" },
	{ "wja",	CS_KSC5601, "A!" },
	{ "wjq",	CS_KSC5601, "A\"" },
	{ "wjt",	CS_KSC5601, "A#" },
	{ "wjd",	CS_KSC5601, "A$" },
	{ "wjw",	CS_KSC5601, "A%" },
	{ "wp",	CS_KSC5601, "A&" },
	{ "wpr",	CS_KSC5601, "A\'" },
	{ "wps",	CS_KSC5601, "A(" },
	{ "wpf",	CS_KSC5601, "A)" },
	{ "wpa",	CS_KSC5601, "A*" },
	{ "wpq",	CS_KSC5601, "A+" },
	{ "wpt",	CS_KSC5601, "A," },
	{ "wpd",	CS_KSC5601, "A-" },
	{ "wu",	CS_KSC5601, "A." },
	{ "wus",	CS_KSC5601, "A/" },
	{ "wuf",	CS_KSC5601, "A0" },
	{ "wua",	CS_KSC5601, "A1" },
	{ "wuq",	CS_KSC5601, "A2" },
	{ "wuT",	CS_KSC5601, "A3" },
	{ "wud",	CS_KSC5601, "A4" },
	{ "wP",	CS_KSC5601, "A5" },
	{ "wh",	CS_KSC5601, "A6" },
	{ "whr",	CS_KSC5601, "A7" },
	{ "whs",	CS_KSC5601, "A8" },
	{ "whf",	CS_KSC5601, "A9" },
	{ "whfa",	CS_KSC5601, "A:" },
	{ "wha",	CS_KSC5601, "A;" },
	{ "whq",	CS_KSC5601, "A<" },
	{ "wht",	CS_KSC5601, "A=" },
	{ "whd",	CS_KSC5601, "A>" },
	{ "whw",	CS_KSC5601, "A?" },
	{ "whc",	CS_KSC5601, "A@" },
	{ "whg",	CS_KSC5601, "AA" },
	{ "whk",	CS_KSC5601, "AB" },
	{ "whkr",	CS_KSC5601, "AC" },
	{ "whkf",	CS_KSC5601, "AD" },
	{ "whkq",	CS_KSC5601, "AE" },
	{ "whkt",	CS_KSC5601, "AF" },
	{ "whkd",	CS_KSC5601, "AG" },
	{ "who",	CS_KSC5601, "AH" },
	{ "whoT",	CS_KSC5601, "AI" },
	{ "whod",	CS_KSC5601, "AJ" },
	{ "whl",	CS_KSC5601, "AK" },
	{ "whls",	CS_KSC5601, "AL" },
	{ "whlf",	CS_KSC5601, "AM" },
	{ "whla",	CS_KSC5601, "AN" },
	{ "whlq",	CS_KSC5601, "AO" },
	{ "whlt",	CS_KSC5601, "AP" },
	{ "whld",	CS_KSC5601, "AQ" },
	{ "wy",	CS_KSC5601, "AR" },
	{ "wyr",	CS_KSC5601, "AS" },
	{ "wys",	CS_KSC5601, "AT" },
	{ "wyd",	CS_KSC5601, "AU" },
	{ "wn",	CS_KSC5601, "AV" },
	{ "wnr",	CS_KSC5601, "AW" },
	{ "wns",	CS_KSC5601, "AX" },
	{ "wnf",	CS_KSC5601, "AY" },
	{ "wnfr",	CS_KSC5601, "AZ" },
	{ "wnfa",	CS_KSC5601, "A[" },
	{ "wna",	CS_KSC5601, "A\\" },
	{ "wnq",	CS_KSC5601, "A]" },
	{ "wnt",	CS_KSC5601, "A^" },
	{ "wnd",	CS_KSC5601, "A_" },
	{ "wnj",	CS_KSC5601, "A`" },
	{ "wnjT",	CS_KSC5601, "Aa" },
	{ "wnp",	CS_KSC5601, "Ab" },
	{ "wnl",	CS_KSC5601, "Ac" },
	{ "wnlr",	CS_KSC5601, "Ad" },
	{ "wnls",	CS_KSC5601, "Ae" },
	{ "wnlf",	CS_KSC5601, "Af" },
	{ "wnla",	CS_KSC5601, "Ag" },
	{ "wnlq",	CS_KSC5601, "Ah" },
	{ "wnlt",	CS_KSC5601, "Ai" },
	{ "wb",	CS_KSC5601, "Aj" },
	{ "wbs",	CS_KSC5601, "Ak" },
	{ "wbf",	CS_KSC5601, "Al" },
	{ "wba",	CS_KSC5601, "Am" },
	{ "wm",	CS_KSC5601, "An" },
	{ "wmr",	CS_KSC5601, "Ao" },
	{ "wms",	CS_KSC5601, "Ap" },
	{ "wmf",	CS_KSC5601, "Aq" },
	{ "wma",	CS_KSC5601, "Ar" },
	{ "wmq",	CS_KSC5601, "As" },
	{ "wmt",	CS_KSC5601, "At" },
	{ "wmd",	CS_KSC5601, "Au" },
	{ "wl",	CS_KSC5601, "Av" },
	{ "wlr",	CS_KSC5601, "Aw" },
	{ "wls",	CS_KSC5601, "Ax" },
	{ "wle",	CS_KSC5601, "Ay" },
	{ "wlf",	CS_KSC5601, "Az" },
	{ "wlfa",	CS_KSC5601, "A{" },
	{ "wla",	CS_KSC5601, "A|" },
	{ "wlq",	CS_KSC5601, "A}" },
	{ "wlt",	CS_KSC5601, "A~" },
	{ "wld",	CS_KSC5601, "B!" },
	{ "wlw",	CS_KSC5601, "B\"" },
	{ "wlx",	CS_KSC5601, "B#" },
	{ "wlv",	CS_KSC5601, "B$" },
	{ "Wk",	CS_KSC5601, "B%" },
	{ "Wkr",	CS_KSC5601, "B&" },
	{ "Wks",	CS_KSC5601, "B\'" },
	{ "Wksg",	CS_KSC5601, "B(" },
	{ "Wkf",	CS_KSC5601, "B)" },
	{ "Wkfq",	CS_KSC5601, "B*" },
	{ "Wka",	CS_KSC5601, "B+" },
	{ "Wkq",	CS_KSC5601, "B," },
	{ "Wkt",	CS_KSC5601, "B-" },
	{ "WkT",	CS_KSC5601, "B." },
	{ "Wkd",	CS_KSC5601, "B/" },
	{ "Wo",	CS_KSC5601, "B0" },
	{ "Wor",	CS_KSC5601, "B1" },
	{ "Wos",	CS_KSC5601, "B2" },
	{ "Wof",	CS_KSC5601, "B3" },
	{ "Woa",	CS_KSC5601, "B4" },
	{ "Woq",	CS_KSC5601, "B5" },
	{ "Wot",	CS_KSC5601, "B6" },
	{ "WoT",	CS_KSC5601, "B7" },
	{ "Wod",	CS_KSC5601, "B8" },
	{ "Wi",	CS_KSC5601, "B9" },
	{ "Wis",	CS_KSC5601, "B:" },
	{ "Wid",	CS_KSC5601, "B;" },
	{ "Wj",	CS_KSC5601, "B<" },
	{ "Wjr",	CS_KSC5601, "B=" },
	{ "Wjs",	CS_KSC5601, "B>" },
	{ "Wjf",	CS_KSC5601, "B?" },
	{ "Wja",	CS_KSC5601, "B@" },
	{ "Wjq",	CS_KSC5601, "BA" },
	{ "Wjt",	CS_KSC5601, "BB" },
	{ "WjT",	CS_KSC5601, "BC" },
	{ "Wjd",	CS_KSC5601, "BD" },
	{ "Wp",	CS_KSC5601, "BE" },
	{ "Wpd",	CS_KSC5601, "BF" },
	{ "Wu",	CS_KSC5601, "BG" },
	{ "WuT",	CS_KSC5601, "BH" },
	{ "Wh",	CS_KSC5601, "BI" },
	{ "Whr",	CS_KSC5601, "BJ" },
	{ "Whs",	CS_KSC5601, "BK" },
	{ "Whf",	CS_KSC5601, "BL" },
	{ "Wha",	CS_KSC5601, "BM" },
	{ "Whq",	CS_KSC5601, "BN" },
	{ "Wht",	CS_KSC5601, "BO" },
	{ "Whd",	CS_KSC5601, "BP" },
	{ "Whc",	CS_KSC5601, "BQ" },
	{ "Whk",	CS_KSC5601, "BR" },
	{ "Whkr",	CS_KSC5601, "BS" },
	{ "Whkf",	CS_KSC5601, "BT" },
	{ "WhkT",	CS_KSC5601, "BU" },
	{ "Who",	CS_KSC5601, "BV" },
	{ "WhoT",	CS_KSC5601, "BW" },
	{ "Whl",	CS_KSC5601, "BX" },
	{ "Whls",	CS_KSC5601, "BY" },
	{ "Whlf",	CS_KSC5601, "BZ" },
	{ "Whla",	CS_KSC5601, "B[" },
	{ "Whlq",	CS_KSC5601, "B\\" },
	{ "Wyd",	CS_KSC5601, "B]" },
	{ "Wn",	CS_KSC5601, "B^" },
	{ "Wnr",	CS_KSC5601, "B_" },
	{ "Wns",	CS_KSC5601, "B`" },
	{ "Wnf",	CS_KSC5601, "Ba" },
	{ "Wna",	CS_KSC5601, "Bb" },
	{ "Wnq",	CS_KSC5601, "Bc" },
	{ "Wnd",	CS_KSC5601, "Bd" },
	{ "Wnj",	CS_KSC5601, "Be" },
	{ "WnjT",	CS_KSC5601, "Bf" },
	{ "Wnjd",	CS_KSC5601, "Bg" },
	{ "Wnl",	CS_KSC5601, "Bh" },
	{ "Wb",	CS_KSC5601, "Bi" },
	{ "Wm",	CS_KSC5601, "Bj" },
	{ "Wma",	CS_KSC5601, "Bk" },
	{ "Wmt",	CS_KSC5601, "Bl" },
	{ "Wmd",	CS_KSC5601, "Bm" },
	{ "Wl",	CS_KSC5601, "Bn" },
	{ "Wlr",	CS_KSC5601, "Bo" },
	{ "Wls",	CS_KSC5601, "Bp" },
	{ "Wlf",	CS_KSC5601, "Bq" },
	{ "Wla",	CS_KSC5601, "Br" },
	{ "Wlq",	CS_KSC5601, "Bs" },
	{ "Wld",	CS_KSC5601, "Bt" },
	{ "Wlw",	CS_KSC5601, "Bu" },
	{ "Wlg",	CS_KSC5601, "Bv" },
	{ "ck",	CS_KSC5601, "Bw" },
	{ "ckr",	CS_KSC5601, "Bx" },
	{ "cks",	CS_KSC5601, "By" },
	{ "cksg",	CS_KSC5601, "Bz" },
	{ "ckf",	CS_KSC5601, "B{" },
	{ "cka",	CS_KSC5601, "B|" },
	{ "ckq",	CS_KSC5601, "B}" },
	{ "ckt",	CS_KSC5601, "B~" },
	{ "ckT",	CS_KSC5601, "C!" },
	{ "ckd",	CS_KSC5601, "C\"" },
	{ "ckw",	CS_KSC5601, "C#" },
	{ "co",	CS_KSC5601, "C$" },
	{ "cor",	CS_KSC5601, "C%" },
	{ "cos",	CS_KSC5601, "C&" },
	{ "cof",	CS_KSC5601, "C\'" },
	{ "coa",	CS_KSC5601, "C(" },
	{ "coq",	CS_KSC5601, "C)" },
	{ "cot",	CS_KSC5601, "C*" },
	{ "coT",	CS_KSC5601, "C+" },
	{ "cod",	CS_KSC5601, "C," },
	{ "ci",	CS_KSC5601, "C-" },
	{ "cis",	CS_KSC5601, "C." },
	{ "cisg",	CS_KSC5601, "C/" },
	{ "cif",	CS_KSC5601, "C0" },
	{ "cia",	CS_KSC5601, "C1" },
	{ "cid",	CS_KSC5601, "C2" },
	{ "cj",	CS_KSC5601, "C3" },
	{ "cjr",	CS_KSC5601, "C4" },
	{ "cjs",	CS_KSC5601, "C5" },
	{ "cjf",	CS_KSC5601, "C6" },
	{ "cja",	CS_KSC5601, "C7" },
	{ "cjq",	CS_KSC5601, "C8" },
	{ "cjt",	CS_KSC5601, "C9" },
	{ "cjT",	CS_KSC5601, "C:" },
	{ "cjd",	CS_KSC5601, "C;" },
	{ "cp",	CS_KSC5601, "C<" },
	{ "cpr",	CS_KSC5601, "C=" },
	{ "cps",	CS_KSC5601, "C>" },
	{ "cpf",	CS_KSC5601, "C?" },
	{ "cpa",	CS_KSC5601, "C@" },
	{ "cpq",	CS_KSC5601, "CA" },
	{ "cpt",	CS_KSC5601, "CB" },
	{ "cpd",	CS_KSC5601, "CC" },
	{ "cu",	CS_KSC5601, "CD" },
	{ "cus",	CS_KSC5601, "CE" },
	{ "cuT",	CS_KSC5601, "CF" },
	{ "cP",	CS_KSC5601, "CG" },
	{ "cPs",	CS_KSC5601, "CH" },
	{ "cPd",	CS_KSC5601, "CI" },
	{ "ch",	CS_KSC5601, "CJ" },
	{ "chr",	CS_KSC5601, "CK" },
	{ "chs",	CS_KSC5601, "CL" },
	{ "chf",	CS_KSC5601, "CM" },
	{ "cha",	CS_KSC5601, "CN" },
	{ "chq",	CS_KSC5601, "CO" },
	{ "cht",	CS_KSC5601, "CP" },
	{ "chd",	CS_KSC5601, "CQ" },
	{ "chk",	CS_KSC5601, "CR" },
	{ "chks",	CS_KSC5601, "CS" },
	{ "chkf",	CS_KSC5601, "CT" },
	{ "chkd",	CS_KSC5601, "CU" },
	{ "chl",	CS_KSC5601, "CV" },
	{ "chls",	CS_KSC5601, "CW" },
	{ "chlf",	CS_KSC5601, "CX" },
	{ "chla",	CS_KSC5601, "CY" },
	{ "chlq",	CS_KSC5601, "CZ" },
	{ "chlt",	CS_KSC5601, "C[" },
	{ "chld",	CS_KSC5601, "C\\" },
	{ "cy",	CS_KSC5601, "C]" },
	{ "cya",	CS_KSC5601, "C^" },
	{ "cn",	CS_KSC5601, "C_" },
	{ "cnr",	CS_KSC5601, "C`" },
	{ "cns",	CS_KSC5601, "Ca" },
	{ "cnf",	CS_KSC5601, "Cb" },
	{ "cna",	CS_KSC5601, "Cc" },
	{ "cnq",	CS_KSC5601, "Cd" },
	{ "cnt",	CS_KSC5601, "Ce" },
	{ "cnd",	CS_KSC5601, "Cf" },
	{ "cnj",	CS_KSC5601, "Cg" },
	{ "cnjT",	CS_KSC5601, "Ch" },
	{ "cnp",	CS_KSC5601, "Ci" },
	{ "cnps",	CS_KSC5601, "Cj" },
	{ "cnl",	CS_KSC5601, "Ck" },
	{ "cnls",	CS_KSC5601, "Cl" },
	{ "cnlf",	CS_KSC5601, "Cm" },
	{ "cnla",	CS_KSC5601, "Cn" },
	{ "cnlq",	CS_KSC5601, "Co" },
	{ "cnlt",	CS_KSC5601, "Cp" },
	{ "cnld",	CS_KSC5601, "Cq" },
	{ "cb",	CS_KSC5601, "Cr" },
	{ "cbs",	CS_KSC5601, "Cs" },
	{ "cbf",	CS_KSC5601, "Ct" },
	{ "cba",	CS_KSC5601, "Cu" },
	{ "cbd",	CS_KSC5601, "Cv" },
	{ "cm",	CS_KSC5601, "Cw" },
	{ "cmr",	CS_KSC5601, "Cx" },
	{ "cms",	CS_KSC5601, "Cy" },
	{ "cmf",	CS_KSC5601, "Cz" },
	{ "cma",	CS_KSC5601, "C{" },
	{ "cmq",	CS_KSC5601, "C|" },
	{ "cmt",	CS_KSC5601, "C}" },
	{ "cmd",	CS_KSC5601, "C~" },
	{ "cl",	CS_KSC5601, "D!" },
	{ "clr",	CS_KSC5601, "D\"" },
	{ "cls",	CS_KSC5601, "D#" },
	{ "cle",	CS_KSC5601, "D$" },
	{ "clf",	CS_KSC5601, "D%" },
	{ "clfr",	CS_KSC5601, "D&" },
	{ "cla",	CS_KSC5601, "D\'" },
	{ "clq",	CS_KSC5601, "D(" },
	{ "clt",	CS_KSC5601, "D)" },
	{ "cld",	CS_KSC5601, "D*" },
	{ "zk",	CS_KSC5601, "D+" },
	{ "zkr",	CS_KSC5601, "D," },
	{ "zks",	CS_KSC5601, "D-" },
	{ "zkf",	CS_KSC5601, "D." },
	{ "zka",	CS_KSC5601, "D/" },
	{ "zkq",	CS_KSC5601, "D0" },
	{ "zkt",	CS_KSC5601, "D1" },
	{ "zkd",	CS_KSC5601, "D2" },
	{ "zo",	CS_KSC5601, "D3" },
	{ "zor",	CS_KSC5601, "D4" },
	{ "zos",	CS_KSC5601, "D5" },
	{ "zof",	CS_KSC5601, "D6" },
	{ "zoa",	CS_KSC5601, "D7" },
	{ "zoq",	CS_KSC5601, "D8" },
	{ "zot",	CS_KSC5601, "D9" },
	{ "zoT",	CS_KSC5601, "D:" },
	{ "zod",	CS_KSC5601, "D;" },
	{ "zi",	CS_KSC5601, "D<" },
	{ "zir",	CS_KSC5601, "D=" },
	{ "zid",	CS_KSC5601, "D>" },
	{ "zj",	CS_KSC5601, "D?" },
	{ "zjr",	CS_KSC5601, "D@" },
	{ "zjs",	CS_KSC5601, "DA" },
	{ "zje",	CS_KSC5601, "DB" },
	{ "zjf",	CS_KSC5601, "DC" },
	{ "zja",	CS_KSC5601, "DD" },
	{ "zjq",	CS_KSC5601, "DE" },
	{ "zjt",	CS_KSC5601, "DF" },
	{ "zjT",	CS_KSC5601, "DG" },
	{ "zjd",	CS_KSC5601, "DH" },
	{ "zp",	CS_KSC5601, "DI" },
	{ "zpr",	CS_KSC5601, "DJ" },
	{ "zps",	CS_KSC5601, "DK" },
	{ "zpf",	CS_KSC5601, "DL" },
	{ "zpa",	CS_KSC5601, "DM" },
	{ "zpq",	CS_KSC5601, "DN" },
	{ "zpt",	CS_KSC5601, "DO" },
	{ "zpd",	CS_KSC5601, "DP" },
	{ "zu",	CS_KSC5601, "DQ" },
	{ "zus",	CS_KSC5601, "DR" },
	{ "zuf",	CS_KSC5601, "DS" },
	{ "zua",	CS_KSC5601, "DT" },
	{ "zuq",	CS_KSC5601, "DU" },
	{ "zut",	CS_KSC5601, "DV" },
	{ "zuT",	CS_KSC5601, "DW" },
	{ "zud",	CS_KSC5601, "DX" },
	{ "zP",	CS_KSC5601, "DY" },
	{ "zh",	CS_KSC5601, "DZ" },
	{ "zhr",	CS_KSC5601, "D[" },
	{ "zhs",	CS_KSC5601, "D\\" },
	{ "zhf",	CS_KSC5601, "D]" },
	{ "zha",	CS_KSC5601, "D^" },
	{ "zhq",	CS_KSC5601, "D_" },
	{ "zht",	CS_KSC5601, "D`" },
	{ "zhd",	CS_KSC5601, "Da" },
	{ "zhk",	CS_KSC5601, "Db" },
	{ "zhkr",	CS_KSC5601, "Dc" },
	{ "zhks",	CS_KSC5601, "Dd" },
	{ "zhkf",	CS_KSC5601, "De" },
	{ "zhka",	CS_KSC5601, "Df" },
	{ "zhkd",	CS_KSC5601, "Dg" },
	{ "zho",	CS_KSC5601, "Dh" },
	{ "zhod",	CS_KSC5601, "Di" },
	{ "zhl",	CS_KSC5601, "Dj" },
	{ "zhlf",	CS_KSC5601, "Dk" },
	{ "zy",	CS_KSC5601, "Dl" },
	{ "zn",	CS_KSC5601, "Dm" },
	{ "znr",	CS_KSC5601, "Dn" },
	{ "zns",	CS_KSC5601, "Do" },
	{ "znf",	CS_KSC5601, "Dp" },
	{ "zna",	CS_KSC5601, "Dq" },
	{ "znq",	CS_KSC5601, "Dr" },
	{ "znt",	CS_KSC5601, "Ds" },
	{ "znd",	CS_KSC5601, "Dt" },
	{ "znj",	CS_KSC5601, "Du" },
	{ "znjs",	CS_KSC5601, "Dv" },
	{ "znjf",	CS_KSC5601, "Dw" },
	{ "znjd",	CS_KSC5601, "Dx" },
	{ "znp",	CS_KSC5601, "Dy" },
	{ "znpd",	CS_KSC5601, "Dz" },
	{ "znl",	CS_KSC5601, "D{" },
	{ "znlr",	CS_KSC5601, "D|" },
	{ "znls",	CS_KSC5601, "D}" },
	{ "znlf",	CS_KSC5601, "D~" },
	{ "znla",	CS_KSC5601, "E!" },
	{ "znlq",	CS_KSC5601, "E\"" },
	{ "znlt",	CS_KSC5601, "E#" },
	{ "znld",	CS_KSC5601, "E$" },
	{ "zb",	CS_KSC5601, "E%" },
	{ "zbs",	CS_KSC5601, "E&" },
	{ "zbf",	CS_KSC5601, "E\'" },
	{ "zba",	CS_KSC5601, "E(" },
	{ "zm",	CS_KSC5601, "E)" },
	{ "zmr",	CS_KSC5601, "E*" },
	{ "zms",	CS_KSC5601, "E+" },
	{ "zmf",	CS_KSC5601, "E," },
	{ "zma",	CS_KSC5601, "E-" },
	{ "zmq",	CS_KSC5601, "E." },
	{ "zmd",	CS_KSC5601, "E/" },
	{ "zl",	CS_KSC5601, "E0" },
	{ "zlr",	CS_KSC5601, "E1" },
	{ "zls",	CS_KSC5601, "E2" },
	{ "zlf",	CS_KSC5601, "E3" },
	{ "zla",	CS_KSC5601, "E4" },
	{ "zlq",	CS_KSC5601, "E5" },
	{ "zlt",	CS_KSC5601, "E6" },
	{ "zld",	CS_KSC5601, "E7" },
	{ "xk",	CS_KSC5601, "E8" },
	{ "xkr",	CS_KSC5601, "E9" },
	{ "xks",	CS_KSC5601, "E:" },
	{ "xkf",	CS_KSC5601, "E;" },
	{ "xkfr",	CS_KSC5601, "E<" },
	{ "xka",	CS_KSC5601, "E=" },
	{ "xkq",	CS_KSC5601, "E>" },
	{ "xkt",	CS_KSC5601, "E?" },
	{ "xkT",	CS_KSC5601, "E@" },
	{ "xkd",	CS_KSC5601, "EA" },
	{ "xo",	CS_KSC5601, "EB" },
	{ "xor",	CS_KSC5601, "EC" },
	{ "xos",	CS_KSC5601, "ED" },
	{ "xof",	CS_KSC5601, "EE" },
	{ "xoa",	CS_KSC5601, "EF" },
	{ "xoq",	CS_KSC5601, "EG" },
	{ "xot",	CS_KSC5601, "EH" },
	{ "xoT",	CS_KSC5601, "EI" },
	{ "xod",	CS_KSC5601, "EJ" },
	{ "xi",	CS_KSC5601, "EK" },
	{ "xid",	CS_KSC5601, "EL" },
	{ "xj",	CS_KSC5601, "EM" },
	{ "xjr",	CS_KSC5601, "EN" },
	{ "xjs",	CS_KSC5601, "EO" },
	{ "xjf",	CS_KSC5601, "EP" },
	{ "xjfa",	CS_KSC5601, "EQ" },
	{ "xja",	CS_KSC5601, "ER" },
	{ "xjq",	CS_KSC5601, "ES" },
	{ "xjt",	CS_KSC5601, "ET" },
	{ "xjT",	CS_KSC5601, "EU" },
	{ "xjd",	CS_KSC5601, "EV" },
	{ "xp",	CS_KSC5601, "EW" },
	{ "xpr",	CS_KSC5601, "EX" },
	{ "xps",	CS_KSC5601, "EY" },
	{ "xpf",	CS_KSC5601, "EZ" },
	{ "xpa",	CS_KSC5601, "E[" },
	{ "xpq",	CS_KSC5601, "E\\" },
	{ "xpt",	CS_KSC5601, "E]" },
	{ "xpd",	CS_KSC5601, "E^" },
	{ "xu",	CS_KSC5601, "E_" },
	{ "xus",	CS_KSC5601, "E`" },
	{ "xuT",	CS_KSC5601, "Ea" },
	{ "xP",	CS_KSC5601, "Eb" },
	{ "xPs",	CS_KSC5601, "Ec" },
	{ "xh",	CS_KSC5601, "Ed" },
	{ "xhr",	CS_KSC5601, "Ee" },
	{ "xhs",	CS_KSC5601, "Ef" },
	{ "xhf",	CS_KSC5601, "Eg" },
	{ "xha",	CS_KSC5601, "Eh" },
	{ "xhq",	CS_KSC5601, "Ei" },
	{ "xht",	CS_KSC5601, "Ej" },
	{ "xhd",	CS_KSC5601, "Ek" },
	{ "xhv",	CS_KSC5601, "El" },
	{ "xhk",	CS_KSC5601, "Em" },
	{ "xhks",	CS_KSC5601, "En" },
	{ "xho",	CS_KSC5601, "Eo" },
	{ "xhl",	CS_KSC5601, "Ep" },
	{ "xhls",	CS_KSC5601, "Eq" },
	{ "xhlt",	CS_KSC5601, "Er" },
	{ "xhld",	CS_KSC5601, "Es" },
	{ "xy",	CS_KSC5601, "Et" },
	{ "xn",	CS_KSC5601, "Eu" },
	{ "xnr",	CS_KSC5601, "Ev" },
	{ "xns",	CS_KSC5601, "Ew" },
	{ "xnf",	CS_KSC5601, "Ex" },
	{ "xna",	CS_KSC5601, "Ey" },
	{ "xnq",	CS_KSC5601, "Ez" },
	{ "xnt",	CS_KSC5601, "E{" },
	{ "xnd",	CS_KSC5601, "E|" },
	{ "xnj",	CS_KSC5601, "E}" },
	{ "xnjT",	CS_KSC5601, "E~" },
	{ "xnp",	CS_KSC5601, "F!" },
	{ "xnl",	CS_KSC5601, "F\"" },
	{ "xnlr",	CS_KSC5601, "F#" },
	{ "xnls",	CS_KSC5601, "F$" },
	{ "xnlf",	CS_KSC5601, "F%" },
	{ "xnla",	CS_KSC5601, "F&" },
	{ "xnlq",	CS_KSC5601, "F\'" },
	{ "xnld",	CS_KSC5601, "F(" },
	{ "xb",	CS_KSC5601, "F)" },
	{ "xbs",	CS_KSC5601, "F*" },
	{ "xbf",	CS_KSC5601, "F+" },
	{ "xba",	CS_KSC5601, "F," },
	{ "xbd",	CS_KSC5601, "F-" },
	{ "xm",	CS_KSC5601, "F." },
	{ "xmr",	CS_KSC5601, "F/" },
	{ "xms",	CS_KSC5601, "F0" },
	{ "xme",	CS_KSC5601, "F1" },
	{ "xmf",	CS_KSC5601, "F2" },
	{ "xmfa",	CS_KSC5601, "F3" },
	{ "xma",	CS_KSC5601, "F4" },
	{ "xmq",	CS_KSC5601, "F5" },
	{ "xmt",	CS_KSC5601, "F6" },
	{ "xml",	CS_KSC5601, "F7" },
	{ "xmls",	CS_KSC5601, "F8" },
	{ "xmlf",	CS_KSC5601, "F9" },
	{ "xmla",	CS_KSC5601, "F:" },
	{ "xmlq",	CS_KSC5601, "F;" },
	{ "xl",	CS_KSC5601, "F<" },
	{ "xlr",	CS_KSC5601, "F=" },
	{ "xls",	CS_KSC5601, "F>" },
	{ "xlf",	CS_KSC5601, "F?" },
	{ "xla",	CS_KSC5601, "F@" },
	{ "xlq",	CS_KSC5601, "FA" },
	{ "xlt",	CS_KSC5601, "FB" },
	{ "xld",	CS_KSC5601, "FC" },
	{ "vk",	CS_KSC5601, "FD" },
	{ "vkr",	CS_KSC5601, "FE" },
	{ "vkR",	CS_KSC5601, "FF" },
	{ "vks",	CS_KSC5601, "FG" },
	{ "vkf",	CS_KSC5601, "FH" },
	{ "vkfa",	CS_KSC5601, "FI" },
	{ "vka",	CS_KSC5601, "FJ" },
	{ "vkq",	CS_KSC5601, "FK" },
	{ "vkt",	CS_KSC5601, "FL" },
	{ "vkT",	CS_KSC5601, "FM" },
	{ "vkd",	CS_KSC5601, "FN" },
	{ "vkx",	CS_KSC5601, "FO" },
	{ "vo",	CS_KSC5601, "FP" },
	{ "vor",	CS_KSC5601, "FQ" },
	{ "vos",	CS_KSC5601, "FR" },
	{ "vof",	CS_KSC5601, "FS" },
	{ "voa",	CS_KSC5601, "FT" },
	{ "voq",	CS_KSC5601, "FU" },
	{ "vot",	CS_KSC5601, "FV" },
	{ "voT",	CS_KSC5601, "FW" },
	{ "vod",	CS_KSC5601, "FX" },
	{ "vi",	CS_KSC5601, "FY" },
	{ "vir",	CS_KSC5601, "FZ" },
	{ "vj",	CS_KSC5601, "F[" },
	{ "vjr",	CS_KSC5601, "F\\" },
	{ "vjs",	CS_KSC5601, "F]" },
	{ "vjf",	CS_KSC5601, "F^" },
	{ "vja",	CS_KSC5601, "F_" },
	{ "vjq",	CS_KSC5601, "F`" },
	{ "vjt",	CS_KSC5601, "Fa" },
	{ "vjT",	CS_KSC5601, "Fb" },
	{ "vjd",	CS_KSC5601, "Fc" },
	{ "vp",	CS_KSC5601, "Fd" },
	{ "vpr",	CS_KSC5601, "Fe" },
	{ "vps",	CS_KSC5601, "Ff" },
	{ "vpf",	CS_KSC5601, "Fg" },
	{ "vpa",	CS_KSC5601, "Fh" },
	{ "vpq",	CS_KSC5601, "Fi" },
	{ "vpt",	CS_KSC5601, "Fj" },
	{ "vpd",	CS_KSC5601, "Fk" },
	{ "vu",	CS_KSC5601, "Fl" },
	{ "vus",	CS_KSC5601, "Fm" },
	{ "vuf",	CS_KSC5601, "Fn" },
	{ "vua",	CS_KSC5601, "Fo" },
	{ "vuq",	CS_KSC5601, "Fp" },
	{ "vuT",	CS_KSC5601, "Fq" },
	{ "vud",	CS_KSC5601, "Fr" },
	{ "vP",	CS_KSC5601, "Fs" },
	{ "vPf",	CS_KSC5601, "Ft" },
	{ "vPq",	CS_KSC5601, "Fu" },
	{ "vPt",	CS_KSC5601, "Fv" },
	{ "vh",	CS_KSC5601, "Fw" },
	{ "vhr",	CS_KSC5601, "Fx" },
	{ "vhs",	CS_KSC5601, "Fy" },
	{ "vhf",	CS_KSC5601, "Fz" },
	{ "vha",	CS_KSC5601, "F{" },
	{ "vhq",	CS_KSC5601, "F|" },
	{ "vht",	CS_KSC5601, "F}" },
	{ "vhd",	CS_KSC5601, "F~" },
	{ "vhk",	CS_KSC5601, "G!" },
	{ "vhkd",	CS_KSC5601, "G\"" },
	{ "vhl",	CS_KSC5601, "G#" },
	{ "vhls",	CS_KSC5601, "G$" },
	{ "vy",	CS_KSC5601, "G%" },
	{ "vys",	CS_KSC5601, "G&" },
	{ "vyf",	CS_KSC5601, "G\'" },
	{ "vyq",	CS_KSC5601, "G(" },
	{ "vyt",	CS_KSC5601, "G)" },
	{ "vn",	CS_KSC5601, "G*" },
	{ "vnr",	CS_KSC5601, "G+" },
	{ "vns",	CS_KSC5601, "G," },
	{ "vne",	CS_KSC5601, "G-" },
	{ "vnf",	CS_KSC5601, "G." },
	{ "vnfa",	CS_KSC5601, "G/" },
	{ "vna",	CS_KSC5601, "G0" },
	{ "vnq",	CS_KSC5601, "G1" },
	{ "vnt",	CS_KSC5601, "G2" },
	{ "vnd",	CS_KSC5601, "G3" },
	{ "vnj",	CS_KSC5601, "G4" },
	{ "vnjd",	CS_KSC5601, "G5" },
	{ "vnl",	CS_KSC5601, "G6" },
	{ "vnls",	CS_KSC5601, "G7" },
	{ "vnlf",	CS_KSC5601, "G8" },
	{ "vnla",	CS_KSC5601, "G9" },
	{ "vnlt",	CS_KSC5601, "G:" },
	{ "vb",	CS_KSC5601, "G;" },
	{ "vbs",	CS_KSC5601, "G<" },
	{ "vbf",	CS_KSC5601, "G=" },
	{ "vba",	CS_KSC5601, "G>" },
	{ "vbt",	CS_KSC5601, "G?" },
	{ "vbd",	CS_KSC5601, "G@" },
	{ "vm",	CS_KSC5601, "GA" },
	{ "vms",	CS_KSC5601, "GB" },
	{ "vmf",	CS_KSC5601, "GC" },
	{ "vma",	CS_KSC5601, "GD" },
	{ "vmq",	CS_KSC5601, "GE" },
	{ "vmt",	CS_KSC5601, "GF" },
	{ "vl",	CS_KSC5601, "GG" },
	{ "vlr",	CS_KSC5601, "GH" },
	{ "vls",	CS_KSC5601, "GI" },
	{ "vlf",	CS_KSC5601, "GJ" },
	{ "vla",	CS_KSC5601, "GK" },
	{ "vlq",	CS_KSC5601, "GL" },
	{ "vlt",	CS_KSC5601, "GM" },
	{ "vld",	CS_KSC5601, "GN" },
	{ "gk",	CS_KSC5601, "GO" },
	{ "gkr",	CS_KSC5601, "GP" },
	{ "gks",	CS_KSC5601, "GQ" },
	{ "gkf",	CS_KSC5601, "GR" },
	{ "gkfx",	CS_KSC5601, "GS" },
	{ "gka",	CS_KSC5601, "GT" },
	{ "gkq",	CS_KSC5601, "GU" },
	{ "gkt",	CS_KSC5601, "GV" },
	{ "gkd",	CS_KSC5601, "GW" },
	{ "go",	CS_KSC5601, "GX" },
	{ "gor",	CS_KSC5601, "GY" },
	{ "gos",	CS_KSC5601, "GZ" },
	{ "gof",	CS_KSC5601, "G[" },
	{ "goa",	CS_KSC5601, "G\\" },
	{ "goq",	CS_KSC5601, "G]" },
	{ "got",	CS_KSC5601, "G^" },
	{ "goT",	CS_KSC5601, "G_" },
	{ "god",	CS_KSC5601, "G`" },
	{ "gi",	CS_KSC5601, "Ga" },
	{ "gid",	CS_KSC5601, "Gb" },
	{ "gj",	CS_KSC5601, "Gc" },
	{ "gjr",	CS_KSC5601, "Gd" },
	{ "gjs",	CS_KSC5601, "Ge" },
	{ "gjf",	CS_KSC5601, "Gf" },
	{ "gjfa",	CS_KSC5601, "Gg" },
	{ "gja",	CS_KSC5601, "Gh" },
	{ "gjq",	CS_KSC5601, "Gi" },
	{ "gjt",	CS_KSC5601, "Gj" },
	{ "gjd",	CS_KSC5601, "Gk" },
	{ "gp",	CS_KSC5601, "Gl" },
	{ "gpr",	CS_KSC5601, "Gm" },
	{ "gps",	CS_KSC5601, "Gn" },
	{ "gpf",	CS_KSC5601, "Go" },
	{ "gpa",	CS_KSC5601, "Gp" },
	{ "gpq",	CS_KSC5601, "Gq" },
	{ "gpt",	CS_KSC5601, "Gr" },
	{ "gpd",	CS_KSC5601, "Gs" },
	{ "gu",	CS_KSC5601, "Gt" },
	{ "gur",	CS_KSC5601, "Gu" },
	{ "gus",	CS_KSC5601, "Gv" },
	{ "guf",	CS_KSC5601, "Gw" },
	{ "gua",	CS_KSC5601, "Gx" },
	{ "guq",	CS_KSC5601, "Gy" },
	{ "gut",	CS_KSC5601, "Gz" },
	{ "guT",	CS_KSC5601, "G{" },
	{ "gud",	CS_KSC5601, "G|" },
	{ "gP",	CS_KSC5601, "G}" },
	{ "gPs",	CS_KSC5601, "G~" },
	{ "gPf",	CS_KSC5601, "H!" },
	{ "gPq",	CS_KSC5601, "H\"" },
	{ "gh",	CS_KSC5601, "H#" },
	{ "ghr",	CS_KSC5601, "H$" },
	{ "ghs",	CS_KSC5601, "H%" },
	{ "ghf",	CS_KSC5601, "H&" },
	{ "ghfx",	CS_KSC5601, "H\'" },
	{ "gha",	CS_KSC5601, "H(" },
	{ "ghq",	CS_KSC5601, "H)" },
	{ "ght",	CS_KSC5601, "H*" },
	{ "ghd",	CS_KSC5601, "H+" },
	{ "ghx",	CS_KSC5601, "H," },
	{ "ghk",	CS_KSC5601, "H-" },
	{ "ghkr",	CS_KSC5601, "H." },
	{ "ghks",	CS_KSC5601, "H/" },
	{ "ghkf",	CS_KSC5601, "H0" },
	{ "ghkt",	CS_KSC5601, "H1" },
	{ "ghkd",	CS_KSC5601, "H2" },
	{ "gho",	CS_KSC5601, "H3" },
	{ "ghor",	CS_KSC5601, "H4" },
	{ "ghos",	CS_KSC5601, "H5" },
	{ "ghot",	CS_KSC5601, "H6" },
	{ "ghod",	CS_KSC5601, "H7" },
	{ "ghl",	CS_KSC5601, "H8" },
	{ "ghlr",	CS_KSC5601, "H9" },
	{ "ghls",	CS_KSC5601, "H:" },
	{ "ghlf",	CS_KSC5601, "H;" },
	{ "ghlq",	CS_KSC5601, "H<" },
	{ "ghlt",	CS_KSC5601, "H=" },
	{ "ghld",	CS_KSC5601, "H>" },
	{ "gy",	CS_KSC5601, "H?" },
	{ "gys",	CS_KSC5601, "H@" },
	{ "gyf",	CS_KSC5601, "HA" },
	{ "gyq",	CS_KSC5601, "HB" },
	{ "gyt",	CS_KSC5601, "HC" },
	{ "gn",	CS_KSC5601, "HD" },
	{ "gnr",	CS_KSC5601, "HE" },
	{ "gns",	CS_KSC5601, "HF" },
	{ "gnf",	CS_KSC5601, "HG" },
	{ "gnfx",	CS_KSC5601, "HH" },
	{ "gna",	CS_KSC5601, "HI" },
	{ "gnt",	CS_KSC5601, "HJ" },
	{ "gnd",	CS_KSC5601, "HK" },
	{ "gnj",	CS_KSC5601, "HL" },
	{ "gnjs",	CS_KSC5601, "HM" },
	{ "gnjf",	CS_KSC5601, "HN" },
	{ "gnja",	CS_KSC5601, "HO" },
	{ "gnjd",	CS_KSC5601, "HP" },
	{ "gnp",	CS_KSC5601, "HQ" },
	{ "gnpr",	CS_KSC5601, "HR" },
	{ "gnps",	CS_KSC5601, "HS" },
	{ "gnpf",	CS_KSC5601, "HT" },
	{ "gnpd",	CS_KSC5601, "HU" },
	{ "gnl",	CS_KSC5601, "HV" },
	{ "gnlr",	CS_KSC5601, "HW" },
	{ "gnls",	CS_KSC5601, "HX" },
	{ "gnlf",	CS_KSC5601, "HY" },
	{ "gnla",	CS_KSC5601, "HZ" },
	{ "gnlq",	CS_KSC5601, "H[" },
	{ "gnlt",	CS_KSC5601, "H\\" },
	{ "gnld",	CS_KSC5601, "H]" },
	{ "gb",	CS_KSC5601, "H^" },
	{ "gbr",	CS_KSC5601, "H_" },
	{ "gbs",	CS_KSC5601, "H`" },
	{ "gbf",	CS_KSC5601, "Ha" },
	{ "gba",	CS_KSC5601, "Hb" },
	{ "gbt",	CS_KSC5601, "Hc" },
	{ "gbd",	CS_KSC5601, "Hd" },
	{ "gm",	CS_KSC5601, "He" },
	{ "gmr",	CS_KSC5601, "Hf" },
	{ "gms",	CS_KSC5601, "Hg" },
	{ "gmsg",	CS_KSC5601, "Hh" },
	{ "gme",	CS_KSC5601, "Hi" },
	{ "gmf",	CS_KSC5601, "Hj" },
	{ "gmfr",	CS_KSC5601, "Hk" },
	{ "gma",	CS_KSC5601, "Hl" },
	{ "gmq",	CS_KSC5601, "Hm" },
	{ "gmt",	CS_KSC5601, "Hn" },
	{ "gmd",	CS_KSC5601, "Ho" },
	{ "gmx",	CS_KSC5601, "Hp" },
	{ "gml",	CS_KSC5601, "Hq" },
	{ "gmls",	CS_KSC5601, "Hr" },
	{ "gmlf",	CS_KSC5601, "Hs" },
	{ "gmla",	CS_KSC5601, "Ht" },
	{ "gmlq",	CS_KSC5601, "Hu" },
	{ "gmld",	CS_KSC5601, "Hv" },
	{ "gl",	CS_KSC5601, "Hw" },
	{ "glr",	CS_KSC5601, "Hx" },
	{ "gls",	CS_KSC5601, "Hy" },
	{ "glf",	CS_KSC5601, "Hz" },
	{ "gla",	CS_KSC5601, "H{" },
	{ "glq",	CS_KSC5601, "H|" },
	{ "glt",	CS_KSC5601, "H}" },
	{ "gld",	CS_KSC5601, "H~" },

	{ "Z!",	CS_KSC5601, "#!" },
	{ "Z\"",	CS_KSC5601, "#\"" },
	{ "Z#",	CS_KSC5601, "##" },
	{ "Z$",	CS_KSC5601, "#$" },
	{ "Z%",	CS_KSC5601, "#%" },
	{ "Z&",	CS_KSC5601, "#&" },
	{ "Z\'",	CS_KSC5601, "#\'" },
	{ "Z(",	CS_KSC5601, "#(" },
	{ "Z)",	CS_KSC5601, "#)" },
	{ "Z*",	CS_KSC5601, "#*" },
	{ "Z+",	CS_KSC5601, "#+" },
	{ "Z,",	CS_KSC5601, "#," },
	{ "Z-",	CS_KSC5601, "#-" },
	{ "Z.",	CS_KSC5601, "#." },
	{ "Z/",	CS_KSC5601, "#/" },
	{ "Z0",	CS_KSC5601, "#0" },
	{ "Z1",	CS_KSC5601, "#1" },
	{ "Z2",	CS_KSC5601, "#2" },
	{ "Z3",	CS_KSC5601, "#3" },
	{ "Z4",	CS_KSC5601, "#4" },
	{ "Z5",	CS_KSC5601, "#5" },
	{ "Z6",	CS_KSC5601, "#6" },
	{ "Z7",	CS_KSC5601, "#7" },
	{ "Z8",	CS_KSC5601, "#8" },
	{ "Z9",	CS_KSC5601, "#9" },
	{ "Z:",	CS_KSC5601, "#:" },
	{ "Z;",	CS_KSC5601, "#;" },
	{ "Z<",	CS_KSC5601, "#<" },
	{ "Z=",	CS_KSC5601, "#=" },
	{ "Z>",	CS_KSC5601, "#>" },
	{ "Z?",	CS_KSC5601, "#?" },
	{ "Z@",	CS_KSC5601, "#@" },
	{ "ZA",	CS_KSC5601, "#A" },
	{ "ZB",	CS_KSC5601, "#B" },
	{ "ZC",	CS_KSC5601, "#C" },
	{ "ZD",	CS_KSC5601, "#D" },
	{ "ZE",	CS_KSC5601, "#E" },
	{ "ZF",	CS_KSC5601, "#F" },
	{ "ZG",	CS_KSC5601, "#G" },
	{ "ZH",	CS_KSC5601, "#H" },
	{ "ZI",	CS_KSC5601, "#I" },
	{ "ZJ",	CS_KSC5601, "#J" },
	{ "ZK",	CS_KSC5601, "#K" },
	{ "ZL",	CS_KSC5601, "#L" },
	{ "ZM",	CS_KSC5601, "#M" },
	{ "ZN",	CS_KSC5601, "#N" },
	{ "ZO",	CS_KSC5601, "#O" },
	{ "ZP",	CS_KSC5601, "#P" },
	{ "ZQ",	CS_KSC5601, "#Q" },
	{ "ZR",	CS_KSC5601, "#R" },
	{ "ZS",	CS_KSC5601, "#S" },
	{ "ZT",	CS_KSC5601, "#T" },
	{ "ZU",	CS_KSC5601, "#U" },
	{ "ZV",	CS_KSC5601, "#V" },
	{ "ZW",	CS_KSC5601, "#W" },
	{ "ZX",	CS_KSC5601, "#X" },
	{ "ZY",	CS_KSC5601, "#Y" },
	{ "ZZ",	CS_KSC5601, "#Z" },
	{ "Z[",	CS_KSC5601, "#[" },
	{ "SW",	CS_KSC5601, "#\\" },
	{ "Z]",	CS_KSC5601, "#]" },
	{ "Z^",	CS_KSC5601, "#^" },
	{ "Z_",	CS_KSC5601, "#_" },
	{ "Z`",	CS_KSC5601, "#`" },
	{ "Za",	CS_KSC5601, "#a" },
	{ "Zb",	CS_KSC5601, "#b" },
	{ "Zc",	CS_KSC5601, "#c" },
	{ "Zd",	CS_KSC5601, "#d" },
	{ "Ze",	CS_KSC5601, "#e" },
	{ "Zf",	CS_KSC5601, "#f" },
	{ "Zg",	CS_KSC5601, "#g" },
	{ "Zh",	CS_KSC5601, "#h" },
	{ "Zi",	CS_KSC5601, "#i" },
	{ "Zj",	CS_KSC5601, "#j" },
	{ "Zk",	CS_KSC5601, "#k" },
	{ "Zl",	CS_KSC5601, "#l" },
	{ "Zm",	CS_KSC5601, "#m" },
	{ "Zn",	CS_KSC5601, "#n" },
	{ "Zo",	CS_KSC5601, "#o" },
	{ "Zp",	CS_KSC5601, "#p" },
	{ "Zq",	CS_KSC5601, "#q" },
	{ "Zr",	CS_KSC5601, "#r" },
	{ "Zs",	CS_KSC5601, "#s" },
	{ "Zt",	CS_KSC5601, "#t" },
	{ "Zu",	CS_KSC5601, "#u" },
	{ "Zv",	CS_KSC5601, "#v" },
	{ "Zw",	CS_KSC5601, "#w" },
	{ "Zx",	CS_KSC5601, "#x" },
	{ "Zy",	CS_KSC5601, "#y" },
	{ "Zz",	CS_KSC5601, "#z" },
	{ "Z{",	CS_KSC5601, "#{" },
	{ "Z|",	CS_KSC5601, "#|" },
	{ "Z}",	CS_KSC5601, "#}" },
	{ "Z^-",	CS_KSC5601, "#~" },

	{ "HS",	CS_KSC5601, "$U" },
	{ "Hse",	CS_KSC5601, "$V" },
	{ "Hst",	CS_KSC5601, "$W" },
	{ "HsT",	CS_KSC5601, "$X" },
	{ "Hfrt",	CS_KSC5601, "$Y" },
	{ "Hfqt",	CS_KSC5601, "$[" },
	{ "Hfe",	CS_KSC5601, "$Z" },
	{ "HfT",	CS_KSC5601, "$\\" },
	{ "HfG",	CS_KSC5601, "$]" },
	{ "Haq",	CS_KSC5601, "$^" },
	{ "Hat",	CS_KSC5601, "$_" },
	{ "HaT",	CS_KSC5601, "$`" },
	{ "Had",	CS_KSC5601, "$a" },
	{ "Hqr",	CS_KSC5601, "$b" },
	{ "Hqe",	CS_KSC5601, "$c" },
	{ "Hqtr",	CS_KSC5601, "$d" },
	{ "Hqte",	CS_KSC5601, "$e" },
	{ "Hqw",	CS_KSC5601, "$f" },
	{ "Hqx",	CS_KSC5601, "$g" },
	{ "Hqd",	CS_KSC5601, "$h" },
	{ "HQd",	CS_KSC5601, "$i" },
	{ "Htr",	CS_KSC5601, "$j" },
	{ "Hts",	CS_KSC5601, "$k" },
	{ "Hte",	CS_KSC5601, "$l" },
	{ "Htq",	CS_KSC5601, "$m" },
	{ "Htw",	CS_KSC5601, "$n" },
	{ "HT",	CS_KSC5601, "$o" },
	{ "HD",	CS_KSC5601, "$p" },
	{ "Hd",	CS_KSC5601, "$q" },
	{ "Hdw",	CS_KSC5601, "$r" },
	{ "HdT",	CS_KSC5601, "$s" },
	{ "Hvd",	CS_KSC5601, "$t" },
	{ "HG",	CS_KSC5601, "$u" },
	{ "Hg",	CS_KSC5601, "$v" },
	{ "Hyi",	CS_KSC5601, "$w" },
	{ "HyO",	CS_KSC5601, "$x" },
	{ "Hyl",	CS_KSC5601, "$y" },
	{ "Hbu",	CS_KSC5601, "$z" },
	{ "HbP",	CS_KSC5601, "${" },
	{ "Hbl",	CS_KSC5601, "$|" },
	{ "H.",	CS_KSC5601, "$}" },
	{ "H.l",	CS_KSC5601, "$~" },

	{ "SY",	CS_KSC5601, "!M" },
	{ "SP",	CS_KSC5601, "!L" },
	{ "S%",	CS_KSC5601, "\"6" },
	{ "Swn",	CS_KSC5601, "\"_" },
	{ "Sks",	CS_KSC5601, "\"^" },
	{ "SNo",	CS_KSC5601, "\"`" },
	{ "SCo",	CS_KSC5601, "\"a" },
	{ "STM",	CS_KSC5601, "\"b" },
	{ "Sam",	CS_KSC5601, "\"c" },
	{ "Spm",	CS_KSC5601, "\"d" },
	{ "STel",	CS_KSC5601, "\"e" },
	{ "SC",	CS_KSC5601, "!I" },
	{ "SA",	CS_KSC5601, "!J" },
	{ "SC/",	CS_KSC5601, "!K" },
	{ "SF",	CS_KSC5601, "\"5" },
#endif

#if 1
#endif
	{ NULL },
};

static DICT *
quail_finddict(name, len, partial)
	CHAR_T *name;
	size_t len;
	size_t *partial;
{
	DICT *p;
	DICT *q;
	size_t plen;
	size_t nmatches;
	size_t npartial;

	q = NULL;
	nmatches = 0;
	npartial = 0;
	for (p = quaildict; p->name; p++) {
		plen = strlen(p->name);
		if (plen == len && memcmp(name, p->name, plen) == 0) {
			q = p;
			nmatches++;
		} else if (plen > len && memcmp(name, p->name, len) == 0) {
			npartial++;
		}
	}

	if (partial)
		*partial = npartial;

	switch (nmatches) {
	case 0:
		if (npartial)
			return NULL;
		else
			return p;
	case 1:
		return q;
	default:
		abort();
	}
}

void
quail_keyinput(sp, e, kbuf, kbuflen, intbuf, pintbuflen, pstate, pconsumed)
	SCR *sp;
	ENCODING *e;
	CHAR_T *kbuf;
	size_t kbuflen;
	CHAR_T *intbuf;
	size_t *pintbuflen;
	int *pstate;
	size_t *pconsumed;
{
	size_t i;
	size_t j;
	size_t consumed;
	int quailmode;
	int state;


	quailmode = *pstate & (1<<20);
	state = *pstate & ~((~0) << 19);
	i = j = consumed = 0;

	if (quailmode) {
		DICT *odictent;
		DICT *dictent;
		CHAR_T *t;
		size_t partial;
		
again:
		if (kbuflen == consumed)
			goto finish;

		if (kbuflen - consumed - 1) {
			odictent = quail_finddict(kbuf + consumed,
				kbuflen - consumed - 1, NULL);
		} else
			odictent = NULL;
		dictent = quail_finddict(kbuf + consumed,
				kbuflen - consumed, &partial);

		if (!dictent) {
			/* partial matches only */
			goto finish;
		}

		if (dictent->name == NULL) {
			/* no possible match*/
			if (odictent) {
				consumed += strlen(odictent->name);
				goto again;
			} else {
				i = consumed;
				goto notquail;
			}
		}

		/*
		 * Tricky part...
		 * Say the input buffer is "abcd".
		 * 1. If there is an entry for "abc", we already
		 *    emitted some item. erase that by ctrl-H.
		 * 2. Emit the content of dict entry.
		 * 3a. If it is complete match and there's no
		 *    ambiguity, mark the input buffer "consumed".
		 * 3b. if the input buffer is not empty, do it again.
		 */
		if (odictent)
			intbuf[j++] = '\010';	/*ctrl-H*/
		if (dictent->charset != CS_NONE)
			intbuf[j++] = dictent->charset;
		for (t = dictent->str; *t; t++)
			intbuf[j++] = *t;
		
		if (partial == 0) {
			consumed += strlen(dictent->name);
			goto again;
		}

		goto finish;
	}
	
notquail:
	while (i < kbuflen) {
		if (kbuf[i] == ('O' & 0x1f)) {
			/* enter/leave quail mode */
			quailmode = quailmode ? 0 : 1;
			i++;
			consumed++;
			continue;
		}

		if (kbuf[i] & 0x80) {
			intbuf[j++] = CS_RAW0 + v_key_len(sp, kbuf[i]);
			intbuf[j++] = kbuf[i] & 0x7f;
			i++;
			consumed++;
		} else {
			intbuf[j++] = kbuf[i++];
			consumed++;
		}
	}

finish:
	*pintbuflen = j;
	*pconsumed = consumed;
	*pstate = (quailmode ? (1<<20) : 0) | state;
}
#endif /*MULTIBYTE*/
