// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tifdirect.h
// 
// Purpose:     
// 
// Created:     4 Jan 1997   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tifdirect.h,v 1.2 1997/02/12 23:13:11 jfasch Exp $
// 
// $Log: tifdirect.h,v $
// Revision 1.2  1997/02/12 23:13:11  jfasch
// moved from HgDcCommon
//
// Revision 1.1  1997/02/04 13:48:16  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_dispatch_tifdirect_h
#define hg_dispatch_tifdirect_h

#include "connect.h"
#include "tif.h"

#include <hyperg/utils/verbose.h>

class TIOINETFactoryDirect : public TIOINETFactory, public Connectable {
public:
   TIOINETFactoryDirect() ;
   virtual ~TIOINETFactoryDirect() ;
   
   virtual void start() {}
   virtual void stop() {}

   virtual TIOINETResponsePtr connect (const TIOINETRequestPtr&) ;

private:
   // Connectable part
   virtual void connected (const ConnectArgs&, const INETSocketPtr&) ;
   virtual void connectError (const ConnectArgs&) ;

   // utilities 
   TIOINETResponsePtr make_blocking_(const TIOINETRequestPtr&) ;
   TIOINETResponsePtr make_nonblocking_(const TIOINETRequestPtr&) ;

   // the cancel routine, abstractly inherited from TIOINETFactory.
   virtual void do_cancel_(const TIOINETRequest*) ;

private:
   class TIFDirectLookup* ref_req_ ;

private:
   // verboten
   TIOINETFactoryDirect (const TIOINETFactoryDirect&) {}
   TIOINETFactoryDirect& operator = (const TIOINETFactoryDirect&) { return *this; }

public:
   static Verbose verbose ;
   // link time assertion
   static const char* version1 ;
} ;
static const char* TIOINETFactoryDirect_version = TIOINETFactoryDirect::version1 ;


#endif
