/*
 * Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

#include "host.h"

/*
  kandrews 17 Feb 94
  10.1.1994: changed by H. Leitner
  reason: there is no gesthostname system-call in SYSV Rel 4
*/

#ifndef WIN32
#  if defined(sun) && OSMajorVersion >= 5
#    include <sys/utsname.h>
#    include <string.h>
#  else
extern "C" {
    int gethostname(char*, int);
}
#  endif
#else
#  include <winsock.h>
#endif /* WIN32 */


char Host::name_[100];


const char* Host::name() {
#if defined(sun) && OSMajorVersion >= 5
     struct utsname uts_name;

     if (name_[0] == '\0') {
          uname(&uts_name);
          strcpy(name_, uts_name.nodename);
     }
#else
    if (name_[0] == '\0') {
        gethostname(name_, sizeof(name_));
    }
#endif
    return name_;
}



