/*
 * Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

/*
 * X11-dependent Raster representation.
 */

#ifndef iv_xraster_h
#define iv_xraster_h

#include <InterViews/coord.h>
#include <IV-X11/Xlib.h>

#include <InterViews/_enter.h>

class Display;

class RasterRep {
public:
  enum RasterVisual {
    Pseudo8,
    True24,
    Pseudo_Other,
    True_Other
  };

  RasterRep(const Raster*);
  ~RasterRep();

  Display* display_;
  XImage* image_;
  GC gc_;
  Pixmap pixmap_;
  Pixmap clip_;               // pixmap needed for transparency
  boolean clip_valid_;        // true, if clip_ is allocated
  WindowVisual* wvis_;        // visual
  RasterVisual rvis_;         // to select correct dithering

  // scaled size
  int pwidth_;
  int pheight_;
  Coord width_;
  Coord height_;
  Coord left_;
  Coord right_;
  Coord bottom_;
  Coord top_;

  int* diffx_;               // array for scaling in x direction
  int* diffy_;               // array for scaling in y direction

  // bmarsch, 19941114: dithering algorithms
  void scaleImage() const;
  void ditherImage(boolean doDither) const;
  void trueColorDither() const;
  void noDither() const;
  void fsDither() const;
  void slownoDither() const;
  void slowfsDither() const;

  void makeTransparent() const;

private:
  static int image_byte_order_;
  static boolean colors_allocated_;
  const Raster* raster_;
};

#include <InterViews/_leave.h>

#endif
