// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// original version:
// Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
// Copyright (c) 1991 Silicon Graphics, Inc.
// 
//</copyright>


//<file>
//
// Name:        labels.h
//
// Purpose:     interface to various labels
//
// Created:      6 Sep 94   Michael Pichler
//
// Changed:     11 Oct 94   Michael Pichler
//
//
//</file>


#ifndef harmony_widgets_labels_h
#define harmony_widgets_labels_h

#include "libwidgets.h"

#include <InterViews/label.h>
#ifdef iv_nls
#include <InterViews/wlabel.h>
#include <NLS/wchar.h>
#endif

class Color;
class Font;
class WidgetKit;
class Brush;  // for UnderlinedLabel
#ifdef iv_nls
class FontSet;
#endif


//<class>
//
// Name: UnderlinedLabel
//
// Purpose: label with parts of it underlined
//
//</class>


class UnderlinedLabel: 
#ifndef iv_nls
public Label
#else
public WLabel
#endif
{
  protected:
    UnderlinedLabel (                   // constructor
      const char* str,                  //   string
#ifndef iv_nls
      const Font* font,                 //   font (non nil)
#else
      const FontSet* fontset,           //   fontset (non nil)
#endif
      const Color* color,               //   foreground color (non nil)
      int from,                         //   index of first and
      int to                            //   index behind last char to underline
    );                                  //     (or -1: up to end)
    UnderlinedLabel (
      const char* str,
#ifndef iv_nls
      const Font* font,                 //   font (non nil)
#else
      const FontSet* fontset,           //   fontset (non nil)
#endif
      const Color* color,
#ifndef iv_nls
      char underlined                   //   character to underline (if in string)
#else
      WChar undelined
#endif
    );

  public:
    virtual ~UnderlinedLabel ();

    // most often used underlined labels (use kit.font and foreground):

    static UnderlinedLabel* udlLabel (  // label, underlined as a whole
      WidgetKit& kit,                   //   kit
      const char* str,                  //   string
      const char* style = 0,            //   style name
      const char* alias = 0             //   style alias
    );

    static UnderlinedLabel* hotLabel (  // label with (first) char underlined
      WidgetKit& kit,                   //   kit
      const char* str,                  //   string
      const char* style = 0,            //   style name
      const char* alias = 0,            //   style alias
      int no = 0,                       //   which character (0 = first one)
      int num = 1                       //   no. of chars to underline
    );

    static UnderlinedLabel* hotLabel (
      WidgetKit& kit,
      const char* str,
      char underlined,
      const char* style = 0,
      const char* alias = 0
    );

    virtual void draw (Canvas*, const Allocation&) const;

  private:
    int from_;
    int to_;
    Brush* brush_;

};  // UnderlinedLabel


#endif
