\name{xmlDataViewer}
\alias{xmlDataViewer}
\title{GUI view of GGobi XML input}
\description{
  A GUI for displaying the contents of a GGobi input data
  in XML format.
  This displays a hierarchical view of the different datasets and
  their variables and the details of these such as the name,
  extrema, descriptions, etc.
}
\usage{
xmlDataViewer(fileName = "~/Projects/ggobi/ggobi/data/eies.xml",
               callback = function(obj, w) { guiShow(obj)})
}
\arguments{
  \item{fileName}{the URI of the XML input source, typically just a file
  name. This can be a string giving the XML directly or also a URL.}
\item{callback}{callback function that is invoked when the user
  selects a node in the tree view.
  This is passed to \code{\link{xmlDataTreeViewer}}}
}

\value{
  A list containing
  \item{win}{the GtkWindow created to display the hierarchy.}
  \item{tr}{the GtkTree object created in the call to \code{\link{xmlDataTreeViewer}}}
}

\references{\url{http://www.ggobi.org}
  \url{http://www.ggobi.org/RSggobi}
}
\author{Duncan Temple Lang}
\seealso{
\code{\link{readXMLColorSchemes}}
}

\examples{
  xmlDataViewer(system.file("data", "buckyball.xml", package = "Rggobi"))
}
\keyword{IO}
