<?php

/* 
 * Random help functions that don't have any place better to live
 *
 */


/*
 * guess_url_root
 * returns the best guess for what the root url of this site is.
 * examples:
 *  - thissite.org/some/file returns ''
 *  - domain.org/thissite/some/file returns '/thissite'
 * root must NOT end in /
 */

function guess_url_root() {
	# the variables we use to determine the site root change depending 
	# on if we are called for an error document, and index, or a file

	$docroot = preg_replace('#/$#','',$_SERVER[DOCUMENT_ROOT]); // trim trailing slash
	
	if (isset($_SERVER['REDIRECT_URL']))
		$path = $docroot . $_SERVER['REDIRECT_URL'];
	else
		$path = $_SERVER['PATH_TRANSLATED'];
		
	# file does not exist
	#if ($_SERVER['SCRIPT_FILENAME'] == $_SERVER['PATH_TRANSLATED']) {
	#	$uribase = preg_replace('#^(/.*?)/.*$#', '$1',$_SERVER['REQUEST_URI']);
	#	
	#}
	
	# file exists
#	else {
		# find the web site root by comparing path_translated (e.g. /var/www/root/file)
		# with the document root (e.g. /var/www/).
		return preg_replace("|^$docroot(/.*?)/.*$|", '$1', $path);
#	}
}

return;
?>
