/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.codec.util.SeekableStream;

public class ForwardSeekableStream
extends SeekableStream {
    private InputStream src;
    long pointer = 0L;
    long markPos = -1L;

    public ForwardSeekableStream(InputStream inputStream) {
        this.src = inputStream;
    }

    public final int read() throws IOException {
        int n = this.src.read();
        if (n != -1) {
            ++this.pointer;
        }
        return n;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.src.read(byArray, n, n2);
        if (n3 != -1) {
            this.pointer += (long)n3;
        }
        return n3;
    }

    public final long skip(long l) throws IOException {
        long l2 = this.src.skip(l);
        this.pointer += l2;
        return l2;
    }

    public final int available() throws IOException {
        return this.src.available();
    }

    public final void close() throws IOException {
        this.src.close();
    }

    public final synchronized void mark(int n) {
        this.markPos = this.pointer;
        this.src.mark(n);
    }

    public final synchronized void reset() throws IOException {
        if (this.markPos != -1L) {
            this.pointer = this.markPos;
        }
        this.src.reset();
    }

    public boolean markSupported() {
        return this.src.markSupported();
    }

    public final boolean canSeekBackwards() {
        return false;
    }

    public final long getFilePointer() {
        return this.pointer;
    }

    public final void seek(long l) throws IOException {
        while (l - this.pointer > 0L) {
            this.pointer += this.src.skip(l - this.pointer);
        }
    }
}

