/* Anti-Web HTTPD */
/* Hardcore Software */
/*
This software is Copyright (C) 2001-2004 By Hardcore Software and
others. The software is distributed under the terms of the GNU General
Public License. See the file 'COPYING' for more details.
*/


#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>

#include "aw3.h"



void addcgiext(char *tp) {

  struct cgiextstruct *ex;

  ex = (struct cgiextstruct *) malloc(sizeof(struct cgiextstruct));
  if (ex == NULL) {
    fprintf(stderr, "Serious memory error...\n");
    exit(0);
  }

  ex->ext = strdup(tp);
  if (ex->ext == NULL) {
    fprintf(stderr, "Serious memory error...\n");
    exit(0);
  }

  ex->next = cgiexts;
  cgiexts = ex;

  return;

}



void gensysenv(struct connstruct *cn) {

  #ifndef LIMITEDCGI

  char buf[100];

  setenv("REMOTE_ADDR", cn->ip, 1);

  snprintf(buf, sizeof(buf), "%d", numusers);
  setenv("AW_NUMUSERS", buf, 1);

  setenv("AW_VERSION", VERSION, 1);

  setenv("AW_QUOTE", quote, 1);

  return;

  #endif

}



void genenv(struct connstruct *cn) {
  char *rs[MAXCGIARGS];
  char *segs[4];
  int i;

  split(cn->cgiargs, rs, MAXCGIARGS, '&');

  for(i=0; rs[i] != NULL; i++) {

    if (strchr(rs[i], '=') != NULL) {

      split(rs[i], segs, 4, '=');

      if (segs[1] != NULL) {

        urldecode(segs[1]);
        // IMPORTANT: The 0 in setenv makes sure that
        // clients can't overwrite existing environment
        // variables, like, for instance, PATH.

        // Environment variable usage has been
        // completely disabled because of potential security
        // threats. Thanks for pointing this out go to Jeff Epler.
        #ifdef NOTIMPLEMENTED
        setenv(segs[0], segs[1], 0);
        #endif

      }
    }

  }

  gensysenv(cn);

  return;

}



void proccgi(struct connstruct *cn) {

  int tpipe[2], fv;
  char *myargs[3];
  char buf[MAXREQUESTLENGTH];

  snprintf(buf, sizeof(buf), "HTTP/1.1 200 OK\nServer: Anti-Web V%s (%s)\n%s",
                             VERSION,
                             quote, (cn->reqtype == TYPE_HEAD) ? "\n" : "");
  write(cn->networkdesc, buf, strlen(buf));

  if (cn->reqtype == TYPE_HEAD) {
    removeconnection(cn);
    return;
  }

  if (pipe(tpipe) == -1) {
    removeconnection(cn);
    return;
  }

  fv = fork();

  if (fv == -1) {
    close(tpipe[0]);
    close(tpipe[1]);
    removeconnection(cn);
    return;
  }

  if (fv == 0) {
    // Close the write descriptor
    close(tpipe[1]);
    cn->filedesc = tpipe[0];
    cn->state = STATE_WANT_TO_READ_FILE;
    return;
  }

  // The problem child...

  // Our stdout/stderr goes to the socket
  dup2(tpipe[1], 1);
  dup2(tpipe[1], 2);

  // If it was a POST request, send the socket data to our stdin
  if (cn->reqtype == TYPE_POST) dup2(cn->networkdesc, 0);

  // Otherwise we can shutdown the read side of the sock
  else shutdown(cn->networkdesc, 0);

  close(tpipe[0]);
  close(tpipe[1]);

  myargs[0] = cn->actualfile;
  myargs[1] = strdup(cn->cgiargs);
  myargs[2] = NULL;

  genenv(cn);

  execv(cn->actualfile, myargs);

  exit(0);

}
