/* Anti-Web HTTPD */
/* Hardcore Software */
/*
This software is Copyright (C) 2001-2004 By Hardcore Software and
others. The software is distributed under the terms of the GNU General
Public License. See the file 'COPYING' for more details.
*/

/* This file was written by Jon Forsberg (zzed) */
/* I slightly modified it to use a static buffer instead
   of a malloc() call
 */

#include <ctype.h>
#include <stdlib.h>

#include "aw3.h"


/* Encode funny chars -> %xx in newly allocated storage */
/* (preserves '/' !) */

/* Make sure t holds at least strlen(s)*3+1   -Doug */

void urlencode(unsigned char *s, unsigned char *t) {
  unsigned char *p, *tp;

  if(t == NULL) {
    fprintf(stderr, "Serious memory error...\n");
    exit(1);
  }

  tp=t;
  for(p=s; *p; p++) {
    if((*p > 0x00 && *p < ',') ||
       (*p > '9' && *p < 'A') ||
       (*p > 'Z' && *p < '_') ||
       (*p > '_' && *p < 'a') ||
       (*p > 'z' && *p < 0xA1)) {
        sprintf(tp, "%%%02X", *p);
        tp += 3; 
      } else {
	*tp = *p;
	tp++;
      }
  }

  *tp='\0';

  return;
}
