/*
    Copyright (C) 2003-2006 Teus Benschop.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/


#include "libraries.h"
#include "utilities.h"
#include "constants.h"


int main (int argc, char *argv[])
{
  if (argc == 1) {
    cout << "sc-message reads the book, the chapter and the verse from the commandline," << endl;
    cout << "and a message, and outputs this as a standard message, like the other checks" << endl;
    cout << "give it, in XML format." << endl;
    return 0;
  }

  if (argc < 5) {
    cerr << "Not enough arguments" << endl;
    return 1;
  }
  
  // Storage for command line arguments.
  ustring book, chapter, verse, message;
  // Process command line arguments.
  book = argv[1];
  chapter = argv[2];
  verse = argv[3];
  message = argv[4];
  output_xml_message (book, chapter, verse, message);
  
  return 0;
}
