/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include <exception>
#include <stdexcept>
#include <iostream>
#include <cstdlib>
#include <string>
#include <fstream>
#include <vector>
#include <set>
#include <sstream>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <gtk/gtk.h>
#include <cassert>
#include <signal.h>


using namespace std;


GtkWidget *splashscreen;
GtkWidget *fixed1;
GtkWidget *infolabel;
GtkWidget *progressbar1;
bool stop = false;


bool on_timeout (gpointer data)
{
  // Produce filename.  
  gchar *filename;
  filename = g_build_filename (g_get_home_dir(), ".bibledit_temp", "bibledit.splash", NULL);
  // See whether we stop.
  if (stop) {
    unlink (filename);
    gtk_main_quit ();
  }
  // Get contents of that file.  
  gchar *content;
  string contents;
  if (g_file_get_contents (filename, &content, NULL, NULL)) {
    contents = content;
    size_t position = contents.find (" ");
    if (position != string::npos) {
      // Extract fraction.
      double fraction;
      istringstream i (contents.substr (0, position));
      i >> fraction;
      fraction /= 100;
      if (fraction >= 1) {
        fraction = 1;
        stop = true;
      }
      // Set fraction.
      gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (progressbar1), fraction);
      // Set informative text.
      contents.erase (0, ++position);
      gtk_label_set_text (GTK_LABEL (infolabel), contents.c_str());
    }
  }
  // Free memory.  
  g_free (filename);
  g_free (content);
  // Next timeout.
  return true;
}


int main (int argc, char *argv[])
/*
This splashscreen is independent from bibledit.
This is because updating a splashscreen while either building a window, or
destroying it, causes an error in Gtk. An independent program solves this.
It reads a file called bibledit.splash in the temporal directory.
That file contains one line of text, e.g.
  50 Starting
This means the progressbar should points at 50 percent, and the label gives "Starting".
At 100% the splash screen deletes the file and quits.
*/
{
  // Graphical stuff.  
  gtk_set_locale ();
  gtk_init (&argc, &argv);

  splashscreen = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (splashscreen), "Bibledit");
  gtk_window_set_position (GTK_WINDOW (splashscreen), GTK_WIN_POS_CENTER);
  gtk_window_set_default_size (GTK_WINDOW (splashscreen), 300, 100);
  gtk_window_set_gravity (GTK_WINDOW (splashscreen), GDK_GRAVITY_CENTER);

  fixed1 = gtk_fixed_new ();
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (splashscreen), fixed1);

  progressbar1 = gtk_progress_bar_new ();
  gtk_widget_show (progressbar1);
  gtk_fixed_put (GTK_FIXED (fixed1), progressbar1, 8, 56);
  gtk_widget_set_size_request (progressbar1, 280, 10);

  // The text in the info label is taken from the commandline.
  infolabel = gtk_label_new (argv[1]);
  gtk_widget_show (infolabel);
  gtk_fixed_put (GTK_FIXED (fixed1), infolabel, 8, 24);
  gtk_widget_set_size_request (infolabel, 280, 17);
  gtk_label_set_justify (GTK_LABEL (infolabel), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (infolabel), 0.5, 0);

  gtk_widget_show (splashscreen);

  // Start periodic update.
  g_timeout_add (500, GSourceFunc (on_timeout), NULL);
  
  gtk_main ();
  return 0;

}
